// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the account pool.
func (c *Client) UpdateAccountPool(ctx context.Context, params *UpdateAccountPoolInput, optFns ...func(*Options)) (*UpdateAccountPoolOutput, error) {
	if params == nil {
		params = &UpdateAccountPoolInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAccountPool", params, optFns, c.addOperationUpdateAccountPoolMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAccountPoolOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAccountPoolInput struct {

	// The domain ID where the account pool that is to be updated lives.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the account pool that is to be updated.
	//
	// This member is required.
	Identifier *string

	// The source of accounts for the account pool. In the current release, it's
	// either a static list of accounts provided by the customer or a custom Amazon Web
	// Services Lambda handler.
	AccountSource types.AccountSource

	// The description of the account pool that is to be udpated.
	Description *string

	// The name of the account pool that is to be updated.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	ResolutionStrategy types.ResolutionStrategy

	noSmithyDocumentSerde
}

type UpdateAccountPoolOutput struct {

	// The source of accounts for the account pool. In the current release, it's
	// either a static list of accounts provided by the customer or a custom Amazon Web
	// Services Lambda handler.
	//
	// This member is required.
	AccountSource types.AccountSource

	// The user who created the account pool.
	//
	// This member is required.
	CreatedBy *string

	// The timestamp at which the account pool was created.
	CreatedAt *time.Time

	// The description of the account pool that is to be udpated.
	Description *string

	// The domain ID where the account pool that is to be updated lives.
	DomainId *string

	// The domain ID in which the account pool that is to be updated lives.
	DomainUnitId *string

	// The ID of the account pool that is to be updated.
	Id *string

	// The timestamp at which the account pool was last updated.
	LastUpdatedAt *time.Time

	// The name of the account pool that is to be updated.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	ResolutionStrategy types.ResolutionStrategy

	// The user who last updated the account pool.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAccountPoolMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAccountPool"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAccountPoolValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAccountPool(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAccountPool(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAccountPool",
	}
}
