// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Category of Audio Extraction
type AudioExtractionCategory struct {

	// State
	//
	// This member is required.
	State State

	// List of Audio Extraction Category Type
	Types []AudioExtractionCategoryType

	noSmithyDocumentSerde
}

// Override Configuration of Audio
type AudioOverrideConfiguration struct {

	// Configuration to enable/disable processing of modality
	ModalityProcessing *ModalityProcessingConfiguration

	noSmithyDocumentSerde
}

// Standard Extraction Configuration of Audio
type AudioStandardExtraction struct {

	// Category of Audio Extraction
	//
	// This member is required.
	Category *AudioExtractionCategory

	noSmithyDocumentSerde
}

// Standard Generative Field Configuration of Audio
type AudioStandardGenerativeField struct {

	// State
	//
	// This member is required.
	State State

	// List of Audio Standard Generative Field Type
	Types []AudioStandardGenerativeFieldType

	noSmithyDocumentSerde
}

// Standard Output Configuration of Audio
type AudioStandardOutputConfiguration struct {

	// Standard Extraction Configuration of Audio
	Extraction *AudioStandardExtraction

	// Standard Generative Field Configuration of Audio
	GenerativeField *AudioStandardGenerativeField

	noSmithyDocumentSerde
}

// Contains the information of a Blueprint.
type Blueprint struct {

	// ARN of a Blueprint
	//
	// This member is required.
	BlueprintArn *string

	// Name of the Blueprint
	//
	// This member is required.
	BlueprintName *string

	// Time Stamp
	//
	// This member is required.
	CreationTime *time.Time

	// Time Stamp
	//
	// This member is required.
	LastModifiedTime *time.Time

	// Schema of the blueprint
	//
	// This member is required.
	Schema *string

	// Type
	//
	// This member is required.
	Type Type

	// Stage of the Blueprint
	BlueprintStage BlueprintStage

	// Blueprint Version
	BlueprintVersion *string

	// KMS Encryption Context
	KmsEncryptionContext map[string]string

	// KMS Key Identifier
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Blueprint Filter
type BlueprintFilter struct {

	// ARN of a Blueprint
	//
	// This member is required.
	BlueprintArn *string

	// Stage of the Blueprint
	BlueprintStage BlueprintStage

	// Blueprint Version
	BlueprintVersion *string

	noSmithyDocumentSerde
}

// Blueprint Item
type BlueprintItem struct {

	// ARN of a Blueprint
	//
	// This member is required.
	BlueprintArn *string

	// Stage of the Blueprint
	BlueprintStage BlueprintStage

	// Blueprint Version
	BlueprintVersion *string

	noSmithyDocumentSerde
}

// Summary of a Blueprint
type BlueprintSummary struct {

	// ARN of a Blueprint
	//
	// This member is required.
	BlueprintArn *string

	// Time Stamp
	//
	// This member is required.
	CreationTime *time.Time

	// Name of the Blueprint
	BlueprintName *string

	// Stage of the Blueprint
	BlueprintStage BlueprintStage

	// Blueprint Version
	BlueprintVersion *string

	// Time Stamp
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Custom output configuration
type CustomOutputConfiguration struct {

	// List of Blueprint Item
	Blueprints []BlueprintItem

	noSmithyDocumentSerde
}

// Contains the information of a DataAutomationProject.
type DataAutomationProject struct {

	// Time Stamp
	//
	// This member is required.
	CreationTime *time.Time

	// Time Stamp
	//
	// This member is required.
	LastModifiedTime *time.Time

	// ARN of a DataAutomationProject
	//
	// This member is required.
	ProjectArn *string

	// Name of the DataAutomationProject
	//
	// This member is required.
	ProjectName *string

	// Status of Data Automation Project
	//
	// This member is required.
	Status DataAutomationProjectStatus

	// Custom output configuration
	CustomOutputConfiguration *CustomOutputConfiguration

	// KMS Encryption Context
	KmsEncryptionContext map[string]string

	// KMS Key Identifier
	KmsKeyId *string

	// Override configuration
	OverrideConfiguration *OverrideConfiguration

	// Description of the DataAutomationProject
	ProjectDescription *string

	// Stage of the Project
	ProjectStage DataAutomationProjectStage

	// Standard output configuration
	StandardOutputConfiguration *StandardOutputConfiguration

	noSmithyDocumentSerde
}

// Data Automation Project Filter
type DataAutomationProjectFilter struct {

	// ARN of a DataAutomationProject
	//
	// This member is required.
	ProjectArn *string

	// Stage of the Project
	ProjectStage DataAutomationProjectStage

	noSmithyDocumentSerde
}

// Summary of a DataAutomationProject
type DataAutomationProjectSummary struct {

	// Time Stamp
	//
	// This member is required.
	CreationTime *time.Time

	// ARN of a DataAutomationProject
	//
	// This member is required.
	ProjectArn *string

	// Name of the DataAutomationProject
	ProjectName *string

	// Stage of the Project
	ProjectStage DataAutomationProjectStage

	noSmithyDocumentSerde
}

// Bounding Box Configuration of Document Extraction
type DocumentBoundingBox struct {

	// State
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Granularity of Document Extraction
type DocumentExtractionGranularity struct {

	// List of Document Extraction Granularity Type
	Types []DocumentExtractionGranularityType

	noSmithyDocumentSerde
}

// Additional File Format of Document Output
type DocumentOutputAdditionalFileFormat struct {

	// State
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Output Format of Document
type DocumentOutputFormat struct {

	// Additional File Format of Document Output
	//
	// This member is required.
	AdditionalFileFormat *DocumentOutputAdditionalFileFormat

	// Text Format of Document Output
	//
	// This member is required.
	TextFormat *DocumentOutputTextFormat

	noSmithyDocumentSerde
}

// Text Format of Document Output
type DocumentOutputTextFormat struct {

	// List of Document Output Text Format Type
	Types []DocumentOutputTextFormatType

	noSmithyDocumentSerde
}

// Override Configuration of Document
type DocumentOverrideConfiguration struct {

	// Configuration to enable/disable processing of modality
	ModalityProcessing *ModalityProcessingConfiguration

	// Configuration of Splitter
	Splitter *SplitterConfiguration

	noSmithyDocumentSerde
}

// Standard Extraction Configuration of Document
type DocumentStandardExtraction struct {

	// Bounding Box Configuration of Document Extraction
	//
	// This member is required.
	BoundingBox *DocumentBoundingBox

	// Granularity of Document Extraction
	//
	// This member is required.
	Granularity *DocumentExtractionGranularity

	noSmithyDocumentSerde
}

// Standard Generative Field Configuration of Document
type DocumentStandardGenerativeField struct {

	// State
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Standard Output Configuration of Document
type DocumentStandardOutputConfiguration struct {

	// Standard Extraction Configuration of Document
	Extraction *DocumentStandardExtraction

	// Standard Generative Field Configuration of Document
	GenerativeField *DocumentStandardGenerativeField

	// Output Format of Document
	OutputFormat *DocumentOutputFormat

	noSmithyDocumentSerde
}

// KMS Encryption Configuration
type EncryptionConfiguration struct {

	// KMS Key Identifier
	//
	// This member is required.
	KmsKeyId *string

	// KMS Encryption Context
	KmsEncryptionContext map[string]string

	noSmithyDocumentSerde
}

// Bounding Box Configuration of Image Extraction
type ImageBoundingBox struct {

	// State
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Category of Image Extraction
type ImageExtractionCategory struct {

	// State
	//
	// This member is required.
	State State

	// List of Image Extraction Category
	Types []ImageExtractionCategoryType

	noSmithyDocumentSerde
}

// Override Configuration of Image
type ImageOverrideConfiguration struct {

	// Configuration to enable/disable processing of modality
	ModalityProcessing *ModalityProcessingConfiguration

	noSmithyDocumentSerde
}

// Standard Extraction Configuration of Image
type ImageStandardExtraction struct {

	// Bounding Box Configuration of Image Extraction
	//
	// This member is required.
	BoundingBox *ImageBoundingBox

	// Category of Image Extraction
	//
	// This member is required.
	Category *ImageExtractionCategory

	noSmithyDocumentSerde
}

// Standard Generative Field Configuration of Image
type ImageStandardGenerativeField struct {

	// State
	//
	// This member is required.
	State State

	// List of Image Standard Generative Field Type
	Types []ImageStandardGenerativeFieldType

	noSmithyDocumentSerde
}

// Standard Output Configuration of Image
type ImageStandardOutputConfiguration struct {

	// Standard Extraction Configuration of Image
	Extraction *ImageStandardExtraction

	// Standard Generative Field Configuration of Image
	GenerativeField *ImageStandardGenerativeField

	noSmithyDocumentSerde
}

// Configuration to enable/disable processing of modality
type ModalityProcessingConfiguration struct {

	// State
	State State

	noSmithyDocumentSerde
}

// Configuration for routing file type to desired modality
type ModalityRoutingConfiguration struct {

	// Desired Modality types
	Jpeg DesiredModality

	// Desired Modality types
	Mov DesiredModality

	// Desired Modality types
	Mp4 DesiredModality

	// Desired Modality types
	Png DesiredModality

	noSmithyDocumentSerde
}

// Override configuration
type OverrideConfiguration struct {

	// Override Configuration of Audio
	Audio *AudioOverrideConfiguration

	// Override Configuration of Document
	Document *DocumentOverrideConfiguration

	// Override Configuration of Image
	Image *ImageOverrideConfiguration

	// Configuration for routing file type to desired modality
	ModalityRouting *ModalityRoutingConfiguration

	// Override Configuration of Video
	Video *VideoOverrideConfiguration

	noSmithyDocumentSerde
}

// Configuration of Splitter
type SplitterConfiguration struct {

	// State
	State State

	noSmithyDocumentSerde
}

// Standard output configuration
type StandardOutputConfiguration struct {

	// Standard Output Configuration of Audio
	Audio *AudioStandardOutputConfiguration

	// Standard Output Configuration of Document
	Document *DocumentStandardOutputConfiguration

	// Standard Output Configuration of Image
	Image *ImageStandardOutputConfiguration

	// Standard Output Configuration of Video
	Video *VideoStandardOutputConfiguration

	noSmithyDocumentSerde
}

// Key value pair of a tag
type Tag struct {

	// Defines the context of the tag.
	//
	// This member is required.
	Key *string

	// Defines the value within the context. e.g. <key=reason, value=training>.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception
type ValidationExceptionField struct {

	// Non Blank String
	//
	// This member is required.
	Message *string

	// Non Blank String
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Bounding Box Configuration of Video Extraction
type VideoBoundingBox struct {

	// State
	//
	// This member is required.
	State State

	noSmithyDocumentSerde
}

// Category of Video Extraction
type VideoExtractionCategory struct {

	// State
	//
	// This member is required.
	State State

	// List of Video Extraction Category Type
	Types []VideoExtractionCategoryType

	noSmithyDocumentSerde
}

// Override Configuration of Video
type VideoOverrideConfiguration struct {

	// Configuration to enable/disable processing of modality
	ModalityProcessing *ModalityProcessingConfiguration

	noSmithyDocumentSerde
}

// Standard Extraction Configuration of Video
type VideoStandardExtraction struct {

	// Bounding Box Configuration of Video Extraction
	//
	// This member is required.
	BoundingBox *VideoBoundingBox

	// Category of Video Extraction
	//
	// This member is required.
	Category *VideoExtractionCategory

	noSmithyDocumentSerde
}

// Standard Generative Field Configuration of Video
type VideoStandardGenerativeField struct {

	// State
	//
	// This member is required.
	State State

	// List of Video Standard Generative Field Type
	Types []VideoStandardGenerativeFieldType

	noSmithyDocumentSerde
}

// Standard Output Configuration of Video
type VideoStandardOutputConfiguration struct {

	// Standard Extraction Configuration of Video
	Extraction *VideoStandardExtraction

	// Standard Generative Field Configuration of Video
	GenerativeField *VideoStandardGenerativeField

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
