// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the flow definition snapshot used for a flow execution. The snapshot
// represents the flow metadata and definition as it existed at the time the
// execution was started. Note that even if the flow is edited after an execution
// starts, the snapshot connected to the execution remains unchanged.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
func (c *Client) GetExecutionFlowSnapshot(ctx context.Context, params *GetExecutionFlowSnapshotInput, optFns ...func(*Options)) (*GetExecutionFlowSnapshotOutput, error) {
	if params == nil {
		params = &GetExecutionFlowSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetExecutionFlowSnapshot", params, optFns, c.addOperationGetExecutionFlowSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetExecutionFlowSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetExecutionFlowSnapshotInput struct {

	// The unique identifier of the flow execution.
	//
	// This member is required.
	ExecutionIdentifier *string

	// The unique identifier of the flow alias used for the flow execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	noSmithyDocumentSerde
}

type GetExecutionFlowSnapshotOutput struct {

	// The flow definition used for the flow execution, including the nodes,
	// connections, and configuration at the time when the execution started.
	//
	// The definition returns as a string that follows the structure of a [FlowDefinition] object.
	//
	// [FlowDefinition]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html
	//
	// This member is required.
	Definition *string

	// The Amazon Resource Name (ARN) of the IAM service role that's used by the flow
	// execution.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow alias used for the flow execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	// The version of the flow used for the flow execution.
	//
	// This member is required.
	FlowVersion *string

	// The Amazon Resource Name (ARN) of the customer managed KMS key that's used to
	// encrypt the flow snapshot.
	CustomerEncryptionKeyArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetExecutionFlowSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetExecutionFlowSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetExecutionFlowSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetExecutionFlowSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetExecutionFlowSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetExecutionFlowSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetExecutionFlowSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetExecutionFlowSnapshot",
	}
}
