// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmdashboards

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bcmdashboards/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateDashboard struct {
}

func (*validateOpCreateDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDashboard struct {
}

func (*validateOpDeleteDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDashboard struct {
}

func (*validateOpGetDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResourcePolicy struct {
}

func (*validateOpGetResourcePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResourcePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResourcePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResourcePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDashboard struct {
}

func (*validateOpUpdateDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDashboard{}, middleware.After)
}

func addOpDeleteDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDashboard{}, middleware.After)
}

func addOpGetDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDashboard{}, middleware.After)
}

func addOpGetResourcePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResourcePolicy{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDashboard{}, middleware.After)
}

func validateCostAndUsageQuery(v *types.CostAndUsageQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CostAndUsageQuery"}
	if v.Metrics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metrics"))
	}
	if v.TimeRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRange"))
	} else if v.TimeRange != nil {
		if err := validateDateTimeRange(v.TimeRange); err != nil {
			invalidParams.AddNested("TimeRange", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Granularity) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Granularity"))
	}
	if v.GroupBy != nil {
		if err := validateGroupDefinitions(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateExpression(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDateTimeRange(v *types.DateTimeRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DateTimeRange"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	} else if v.StartTime != nil {
		if err := validateDateTimeValue(v.StartTime); err != nil {
			invalidParams.AddNested("StartTime", err.(smithy.InvalidParamsError))
		}
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	} else if v.EndTime != nil {
		if err := validateDateTimeValue(v.EndTime); err != nil {
			invalidParams.AddNested("EndTime", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDateTimeValue(v *types.DateTimeValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DateTimeValue"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimensionValues(v *types.DimensionValues) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DimensionValues"}
	if len(v.Key) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDisplayConfig(v types.DisplayConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisplayConfig"}
	switch uv := v.(type) {
	case *types.DisplayConfigMemberGraph:
		if err := validateGraphDisplayConfigMap(uv.Value); err != nil {
			invalidParams.AddNested("[graph]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExpression(v *types.Expression) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Expression"}
	if v.Or != nil {
		if err := validateExpressions(v.Or); err != nil {
			invalidParams.AddNested("Or", err.(smithy.InvalidParamsError))
		}
	}
	if v.And != nil {
		if err := validateExpressions(v.And); err != nil {
			invalidParams.AddNested("And", err.(smithy.InvalidParamsError))
		}
	}
	if v.Not != nil {
		if err := validateExpression(v.Not); err != nil {
			invalidParams.AddNested("Not", err.(smithy.InvalidParamsError))
		}
	}
	if v.Dimensions != nil {
		if err := validateDimensionValues(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExpressions(v []types.Expression) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Expressions"}
	for i := range v {
		if err := validateExpression(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGraphDisplayConfig(v *types.GraphDisplayConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GraphDisplayConfig"}
	if len(v.VisualType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("VisualType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGraphDisplayConfigMap(v map[string]types.GraphDisplayConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GraphDisplayConfigMap"}
	for key := range v {
		value := v[key]
		if err := validateGraphDisplayConfig(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGroupDefinition(v *types.GroupDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GroupDefinition"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGroupDefinitions(v []types.GroupDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GroupDefinitions"}
	for i := range v {
		if err := validateGroupDefinition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateQueryParameters(v types.QueryParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QueryParameters"}
	switch uv := v.(type) {
	case *types.QueryParametersMemberCostAndUsage:
		if err := validateCostAndUsageQuery(&uv.Value); err != nil {
			invalidParams.AddNested("[costAndUsage]", err.(smithy.InvalidParamsError))
		}

	case *types.QueryParametersMemberReservationCoverage:
		if err := validateReservationCoverageQuery(&uv.Value); err != nil {
			invalidParams.AddNested("[reservationCoverage]", err.(smithy.InvalidParamsError))
		}

	case *types.QueryParametersMemberReservationUtilization:
		if err := validateReservationUtilizationQuery(&uv.Value); err != nil {
			invalidParams.AddNested("[reservationUtilization]", err.(smithy.InvalidParamsError))
		}

	case *types.QueryParametersMemberSavingsPlansCoverage:
		if err := validateSavingsPlansCoverageQuery(&uv.Value); err != nil {
			invalidParams.AddNested("[savingsPlansCoverage]", err.(smithy.InvalidParamsError))
		}

	case *types.QueryParametersMemberSavingsPlansUtilization:
		if err := validateSavingsPlansUtilizationQuery(&uv.Value); err != nil {
			invalidParams.AddNested("[savingsPlansUtilization]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReservationCoverageQuery(v *types.ReservationCoverageQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReservationCoverageQuery"}
	if v.TimeRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRange"))
	} else if v.TimeRange != nil {
		if err := validateDateTimeRange(v.TimeRange); err != nil {
			invalidParams.AddNested("TimeRange", err.(smithy.InvalidParamsError))
		}
	}
	if v.GroupBy != nil {
		if err := validateGroupDefinitions(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateExpression(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReservationUtilizationQuery(v *types.ReservationUtilizationQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReservationUtilizationQuery"}
	if v.TimeRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRange"))
	} else if v.TimeRange != nil {
		if err := validateDateTimeRange(v.TimeRange); err != nil {
			invalidParams.AddNested("TimeRange", err.(smithy.InvalidParamsError))
		}
	}
	if v.GroupBy != nil {
		if err := validateGroupDefinitions(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateExpression(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTag(v *types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTagList(v []types.ResourceTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTagList"}
	for i := range v {
		if err := validateResourceTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSavingsPlansCoverageQuery(v *types.SavingsPlansCoverageQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SavingsPlansCoverageQuery"}
	if v.TimeRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRange"))
	} else if v.TimeRange != nil {
		if err := validateDateTimeRange(v.TimeRange); err != nil {
			invalidParams.AddNested("TimeRange", err.(smithy.InvalidParamsError))
		}
	}
	if v.GroupBy != nil {
		if err := validateGroupDefinitions(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateExpression(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSavingsPlansUtilizationQuery(v *types.SavingsPlansUtilizationQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SavingsPlansUtilizationQuery"}
	if v.TimeRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeRange"))
	} else if v.TimeRange != nil {
		if err := validateDateTimeRange(v.TimeRange); err != nil {
			invalidParams.AddNested("TimeRange", err.(smithy.InvalidParamsError))
		}
	}
	if v.Filter != nil {
		if err := validateExpression(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWidget(v *types.Widget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Widget"}
	if v.Title == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Title"))
	}
	if v.Configs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configs"))
	} else if v.Configs != nil {
		if err := validateWidgetConfigList(v.Configs); err != nil {
			invalidParams.AddNested("Configs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWidgetConfig(v *types.WidgetConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WidgetConfig"}
	if v.QueryParameters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryParameters"))
	} else if v.QueryParameters != nil {
		if err := validateQueryParameters(v.QueryParameters); err != nil {
			invalidParams.AddNested("QueryParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.DisplayConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DisplayConfig"))
	} else if v.DisplayConfig != nil {
		if err := validateDisplayConfig(v.DisplayConfig); err != nil {
			invalidParams.AddNested("DisplayConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWidgetConfigList(v []types.WidgetConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WidgetConfigList"}
	for i := range v {
		if err := validateWidgetConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWidgetList(v []types.Widget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WidgetList"}
	for i := range v {
		if err := validateWidget(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDashboardInput(v *CreateDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDashboardInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Widgets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Widgets"))
	} else if v.Widgets != nil {
		if err := validateWidgetList(v.Widgets); err != nil {
			invalidParams.AddNested("Widgets", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDashboardInput(v *DeleteDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDashboardInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDashboardInput(v *GetDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDashboardInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResourcePolicyInput(v *GetResourcePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResourcePolicyInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.ResourceTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTags"))
	} else if v.ResourceTags != nil {
		if err := validateResourceTagList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.ResourceTagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDashboardInput(v *UpdateDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDashboardInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.Widgets != nil {
		if err := validateWidgetList(v.Widgets); err != nil {
			invalidParams.AddNested("Widgets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
