//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/visualstudio/armvisualstudio"
	"net/http"
	"net/url"
	"regexp"
)

// ProjectsServer is a fake server for instances of the armvisualstudio.ProjectsClient type.
type ProjectsServer struct {
	// BeginCreate is the fake for method ProjectsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body armvisualstudio.ProjectResource, options *armvisualstudio.ProjectsClientBeginCreateOptions) (resp azfake.PollerResponder[armvisualstudio.ProjectsClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ProjectsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	Get func(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, options *armvisualstudio.ProjectsClientGetOptions) (resp azfake.Responder[armvisualstudio.ProjectsClientGetResponse], errResp azfake.ErrorResponder)

	// GetJobStatus is the fake for method ProjectsClient.GetJobStatus
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetJobStatus func(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, subContainerName string, operation string, options *armvisualstudio.ProjectsClientGetJobStatusOptions) (resp azfake.Responder[armvisualstudio.ProjectsClientGetJobStatusResponse], errResp azfake.ErrorResponder)

	// ListByResourceGroup is the fake for method ProjectsClient.ListByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	ListByResourceGroup func(ctx context.Context, resourceGroupName string, rootResourceName string, options *armvisualstudio.ProjectsClientListByResourceGroupOptions) (resp azfake.Responder[armvisualstudio.ProjectsClientListByResourceGroupResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method ProjectsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, rootResourceName string, resourceName string, body armvisualstudio.ProjectResource, options *armvisualstudio.ProjectsClientUpdateOptions) (resp azfake.Responder[armvisualstudio.ProjectsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewProjectsServerTransport creates a new instance of ProjectsServerTransport with the provided implementation.
// The returned ProjectsServerTransport instance is connected to an instance of armvisualstudio.ProjectsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProjectsServerTransport(srv *ProjectsServer) *ProjectsServerTransport {
	return &ProjectsServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armvisualstudio.ProjectsClientCreateResponse]](),
	}
}

// ProjectsServerTransport connects instances of armvisualstudio.ProjectsClient to instances of ProjectsServer.
// Don't use this type directly, use NewProjectsServerTransport instead.
type ProjectsServerTransport struct {
	srv         *ProjectsServer
	beginCreate *tracker[azfake.PollerResponder[armvisualstudio.ProjectsClientCreateResponse]]
}

// Do implements the policy.Transporter interface for ProjectsServerTransport.
func (p *ProjectsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProjectsClient.BeginCreate":
		resp, err = p.dispatchBeginCreate(req)
	case "ProjectsClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProjectsClient.GetJobStatus":
		resp, err = p.dispatchGetJobStatus(req)
	case "ProjectsClient.ListByResourceGroup":
		resp, err = p.dispatchListByResourceGroup(req)
	case "ProjectsClient.Update":
		resp, err = p.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProjectsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := p.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<rootResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/project/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armvisualstudio.ProjectResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		rootResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("rootResourceName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		validatingUnescaped, err := url.QueryUnescape(qp.Get("validating"))
		if err != nil {
			return nil, err
		}
		validatingParam := getOptional(validatingUnescaped)
		var options *armvisualstudio.ProjectsClientBeginCreateOptions
		if validatingParam != nil {
			options = &armvisualstudio.ProjectsClientBeginCreateOptions{
				Validating: validatingParam,
			}
		}
		respr, errRespr := p.srv.BeginCreate(req.Context(), resourceGroupNameParam, rootResourceNameParam, resourceNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		p.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		p.beginCreate.remove(req)
	}

	return resp, nil
}

func (p *ProjectsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<rootResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/project/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	rootResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("rootResourceName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, rootResourceNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProjectResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProjectsServerTransport) dispatchGetJobStatus(req *http.Request) (*http.Response, error) {
	if p.srv.GetJobStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetJobStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<rootResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/project/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subContainers/(?P<subContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/status`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	rootResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("rootResourceName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	subContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subContainerName")])
	if err != nil {
		return nil, err
	}
	operationParam, err := url.QueryUnescape(qp.Get("operation"))
	if err != nil {
		return nil, err
	}
	jobIDUnescaped, err := url.QueryUnescape(qp.Get("jobId"))
	if err != nil {
		return nil, err
	}
	jobIDParam := getOptional(jobIDUnescaped)
	var options *armvisualstudio.ProjectsClientGetJobStatusOptions
	if jobIDParam != nil {
		options = &armvisualstudio.ProjectsClientGetJobStatusOptions{
			JobID: jobIDParam,
		}
	}
	respr, errRespr := p.srv.GetJobStatus(req.Context(), resourceGroupNameParam, rootResourceNameParam, resourceNameParam, subContainerNameParam, operationParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProjectResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProjectsServerTransport) dispatchListByResourceGroup(req *http.Request) (*http.Response, error) {
	if p.srv.ListByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<rootResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/project`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	rootResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("rootResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListByResourceGroup(req.Context(), resourceGroupNameParam, rootResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProjectResourceListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProjectsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<rootResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/project/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armvisualstudio.ProjectResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	rootResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("rootResourceName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), resourceGroupNameParam, rootResourceNameParam, resourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProjectResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
