//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrivateLinkResourcesList.json
func ExampleKustoPoolPrivateLinkResourcesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewKustoPoolPrivateLinkResourcesClient().NewListPager("DP-900", "synapse-ws-ebi-data", "dataexplorerpool900", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateLinkResources = armsynapse.PrivateLinkResources{
		// 	Value: []*armsynapse.KustoPoolPrivateLinkResources{
		// 		{
		// 			Name: to.Ptr("synapseWorkspaceName/dataexplorerpool900/privateLinkResources"),
		// 			Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/privateLinkResources"),
		// 			ID: to.Ptr("/subscriptions/7a587823-959d-4ad0-85bd-cf2a7cef436a/resourceGroups/DP-900/providers/Microsoft.Synapse/workspaces/synapse-ws-ebi-data/kustoPools/dataexplorerpool900/privateLinkResources"),
		// 			Properties: &armsynapse.PrivateLinkResourcesProperties{
		// 				GroupID: to.Ptr("aaaaa"),
		// 				ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
		// 				RequiredMembers: []*string{
		// 					to.Ptr("Engine"),
		// 					to.Ptr("DataManagement"),
		// 					to.Ptr("blob-ne3kstrldkustoCluster00"),
		// 					to.Ptr("queue-ne3kstrldkustoCluster00"),
		// 					to.Ptr("table-ne3kstrldkustoCluster00"),
		// 					to.Ptr("blob-qmukstrldkustoCluster01"),
		// 					to.Ptr("queue-qmukstrldkustoCluster01"),
		// 					to.Ptr("table-qmukstrldkustoCluster01")},
		// 					RequiredZoneNames: []*string{
		// 						to.Ptr("privatelink.westus2.kusto.windows.net"),
		// 						to.Ptr("privatelink.blob.core.windows.net"),
		// 						to.Ptr("privatelink.queue.core.windows.net"),
		// 						to.Ptr("privatelink.table.core.windows.net")},
		// 					},
		// 			}},
		// 		}
	}
}
