//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armsql.ClientFactory type.
type ServerFactory struct {
	AgentServer                                                            AgentServer
	BackupShortTermRetentionPoliciesServer                                 BackupShortTermRetentionPoliciesServer
	CapabilitiesServer                                                     CapabilitiesServer
	DataMaskingPoliciesServer                                              DataMaskingPoliciesServer
	DataMaskingRulesServer                                                 DataMaskingRulesServer
	DataWarehouseUserActivitiesServer                                      DataWarehouseUserActivitiesServer
	DatabaseAdvancedThreatProtectionSettingsServer                         DatabaseAdvancedThreatProtectionSettingsServer
	DatabaseAdvisorsServer                                                 DatabaseAdvisorsServer
	DatabaseAutomaticTuningServer                                          DatabaseAutomaticTuningServer
	DatabaseBlobAuditingPoliciesServer                                     DatabaseBlobAuditingPoliciesServer
	DatabaseColumnsServer                                                  DatabaseColumnsServer
	DatabaseEncryptionProtectorsServer                                     DatabaseEncryptionProtectorsServer
	DatabaseExtensionsServer                                               DatabaseExtensionsServer
	DatabaseOperationsServer                                               DatabaseOperationsServer
	DatabaseRecommendedActionsServer                                       DatabaseRecommendedActionsServer
	DatabaseSQLVulnerabilityAssessmentBaselinesServer                      DatabaseSQLVulnerabilityAssessmentBaselinesServer
	DatabaseSQLVulnerabilityAssessmentExecuteScanServer                    DatabaseSQLVulnerabilityAssessmentExecuteScanServer
	DatabaseSQLVulnerabilityAssessmentRuleBaselinesServer                  DatabaseSQLVulnerabilityAssessmentRuleBaselinesServer
	DatabaseSQLVulnerabilityAssessmentScanResultServer                     DatabaseSQLVulnerabilityAssessmentScanResultServer
	DatabaseSQLVulnerabilityAssessmentScansServer                          DatabaseSQLVulnerabilityAssessmentScansServer
	DatabaseSQLVulnerabilityAssessmentsSettingsServer                      DatabaseSQLVulnerabilityAssessmentsSettingsServer
	DatabaseSchemasServer                                                  DatabaseSchemasServer
	DatabaseSecurityAlertPoliciesServer                                    DatabaseSecurityAlertPoliciesServer
	DatabaseTablesServer                                                   DatabaseTablesServer
	DatabaseUsagesServer                                                   DatabaseUsagesServer
	DatabaseVulnerabilityAssessmentRuleBaselinesServer                     DatabaseVulnerabilityAssessmentRuleBaselinesServer
	DatabaseVulnerabilityAssessmentScansServer                             DatabaseVulnerabilityAssessmentScansServer
	DatabaseVulnerabilityAssessmentsServer                                 DatabaseVulnerabilityAssessmentsServer
	DatabasesServer                                                        DatabasesServer
	DeletedServersServer                                                   DeletedServersServer
	DistributedAvailabilityGroupsServer                                    DistributedAvailabilityGroupsServer
	ElasticPoolActivitiesServer                                            ElasticPoolActivitiesServer
	ElasticPoolDatabaseActivitiesServer                                    ElasticPoolDatabaseActivitiesServer
	ElasticPoolOperationsServer                                            ElasticPoolOperationsServer
	ElasticPoolsServer                                                     ElasticPoolsServer
	EncryptionProtectorsServer                                             EncryptionProtectorsServer
	EndpointCertificatesServer                                             EndpointCertificatesServer
	ExtendedDatabaseBlobAuditingPoliciesServer                             ExtendedDatabaseBlobAuditingPoliciesServer
	ExtendedServerBlobAuditingPoliciesServer                               ExtendedServerBlobAuditingPoliciesServer
	FailoverGroupsServer                                                   FailoverGroupsServer
	FirewallRulesServer                                                    FirewallRulesServer
	GeoBackupPoliciesServer                                                GeoBackupPoliciesServer
	IPv6FirewallRulesServer                                                IPv6FirewallRulesServer
	InstanceFailoverGroupsServer                                           InstanceFailoverGroupsServer
	InstancePoolsServer                                                    InstancePoolsServer
	JobAgentsServer                                                        JobAgentsServer
	JobCredentialsServer                                                   JobCredentialsServer
	JobExecutionsServer                                                    JobExecutionsServer
	JobPrivateEndpointsServer                                              JobPrivateEndpointsServer
	JobStepExecutionsServer                                                JobStepExecutionsServer
	JobStepsServer                                                         JobStepsServer
	JobTargetExecutionsServer                                              JobTargetExecutionsServer
	JobTargetGroupsServer                                                  JobTargetGroupsServer
	JobVersionsServer                                                      JobVersionsServer
	JobsServer                                                             JobsServer
	LedgerDigestUploadsServer                                              LedgerDigestUploadsServer
	LongTermRetentionBackupsServer                                         LongTermRetentionBackupsServer
	LongTermRetentionManagedInstanceBackupsServer                          LongTermRetentionManagedInstanceBackupsServer
	LongTermRetentionPoliciesServer                                        LongTermRetentionPoliciesServer
	MaintenanceWindowOptionsServer                                         MaintenanceWindowOptionsServer
	MaintenanceWindowsServer                                               MaintenanceWindowsServer
	ManagedBackupShortTermRetentionPoliciesServer                          ManagedBackupShortTermRetentionPoliciesServer
	ManagedDatabaseAdvancedThreatProtectionSettingsServer                  ManagedDatabaseAdvancedThreatProtectionSettingsServer
	ManagedDatabaseColumnsServer                                           ManagedDatabaseColumnsServer
	ManagedDatabaseMoveOperationsServer                                    ManagedDatabaseMoveOperationsServer
	ManagedDatabaseQueriesServer                                           ManagedDatabaseQueriesServer
	ManagedDatabaseRecommendedSensitivityLabelsServer                      ManagedDatabaseRecommendedSensitivityLabelsServer
	ManagedDatabaseRestoreDetailsServer                                    ManagedDatabaseRestoreDetailsServer
	ManagedDatabaseSchemasServer                                           ManagedDatabaseSchemasServer
	ManagedDatabaseSecurityAlertPoliciesServer                             ManagedDatabaseSecurityAlertPoliciesServer
	ManagedDatabaseSecurityEventsServer                                    ManagedDatabaseSecurityEventsServer
	ManagedDatabaseSensitivityLabelsServer                                 ManagedDatabaseSensitivityLabelsServer
	ManagedDatabaseTablesServer                                            ManagedDatabaseTablesServer
	ManagedDatabaseTransparentDataEncryptionServer                         ManagedDatabaseTransparentDataEncryptionServer
	ManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer              ManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer
	ManagedDatabaseVulnerabilityAssessmentScansServer                      ManagedDatabaseVulnerabilityAssessmentScansServer
	ManagedDatabaseVulnerabilityAssessmentsServer                          ManagedDatabaseVulnerabilityAssessmentsServer
	ManagedDatabasesServer                                                 ManagedDatabasesServer
	ManagedInstanceAdministratorsServer                                    ManagedInstanceAdministratorsServer
	ManagedInstanceAdvancedThreatProtectionSettingsServer                  ManagedInstanceAdvancedThreatProtectionSettingsServer
	ManagedInstanceAzureADOnlyAuthenticationsServer                        ManagedInstanceAzureADOnlyAuthenticationsServer
	ManagedInstanceDtcsServer                                              ManagedInstanceDtcsServer
	ManagedInstanceEncryptionProtectorsServer                              ManagedInstanceEncryptionProtectorsServer
	ManagedInstanceKeysServer                                              ManagedInstanceKeysServer
	ManagedInstanceLongTermRetentionPoliciesServer                         ManagedInstanceLongTermRetentionPoliciesServer
	ManagedInstanceOperationsServer                                        ManagedInstanceOperationsServer
	ManagedInstancePrivateEndpointConnectionsServer                        ManagedInstancePrivateEndpointConnectionsServer
	ManagedInstancePrivateLinkResourcesServer                              ManagedInstancePrivateLinkResourcesServer
	ManagedInstanceTdeCertificatesServer                                   ManagedInstanceTdeCertificatesServer
	ManagedInstanceVulnerabilityAssessmentsServer                          ManagedInstanceVulnerabilityAssessmentsServer
	ManagedInstancesServer                                                 ManagedInstancesServer
	ManagedLedgerDigestUploadsServer                                       ManagedLedgerDigestUploadsServer
	ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer
	ManagedServerDNSAliasesServer                                          ManagedServerDNSAliasesServer
	ManagedServerSecurityAlertPoliciesServer                               ManagedServerSecurityAlertPoliciesServer
	OperationsServer                                                       OperationsServer
	OutboundFirewallRulesServer                                            OutboundFirewallRulesServer
	PrivateEndpointConnectionsServer                                       PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer                                             PrivateLinkResourcesServer
	RecommendedSensitivityLabelsServer                                     RecommendedSensitivityLabelsServer
	RecoverableDatabasesServer                                             RecoverableDatabasesServer
	RecoverableManagedDatabasesServer                                      RecoverableManagedDatabasesServer
	ReplicationLinksServer                                                 ReplicationLinksServer
	RestorableDroppedDatabasesServer                                       RestorableDroppedDatabasesServer
	RestorableDroppedManagedDatabasesServer                                RestorableDroppedManagedDatabasesServer
	RestorePointsServer                                                    RestorePointsServer
	SensitivityLabelsServer                                                SensitivityLabelsServer
	ServerAdvancedThreatProtectionSettingsServer                           ServerAdvancedThreatProtectionSettingsServer
	ServerAdvisorsServer                                                   ServerAdvisorsServer
	ServerAutomaticTuningServer                                            ServerAutomaticTuningServer
	ServerAzureADAdministratorsServer                                      ServerAzureADAdministratorsServer
	ServerAzureADOnlyAuthenticationsServer                                 ServerAzureADOnlyAuthenticationsServer
	ServerBlobAuditingPoliciesServer                                       ServerBlobAuditingPoliciesServer
	ServerCommunicationLinksServer                                         ServerCommunicationLinksServer
	ServerConfigurationOptionsServer                                       ServerConfigurationOptionsServer
	ServerConnectionPoliciesServer                                         ServerConnectionPoliciesServer
	ServerDNSAliasesServer                                                 ServerDNSAliasesServer
	ServerDevOpsAuditSettingsServer                                        ServerDevOpsAuditSettingsServer
	ServerKeysServer                                                       ServerKeysServer
	ServerOperationsServer                                                 ServerOperationsServer
	ServerSecurityAlertPoliciesServer                                      ServerSecurityAlertPoliciesServer
	ServerTrustCertificatesServer                                          ServerTrustCertificatesServer
	ServerTrustGroupsServer                                                ServerTrustGroupsServer
	ServerUsagesServer                                                     ServerUsagesServer
	ServerVulnerabilityAssessmentsServer                                   ServerVulnerabilityAssessmentsServer
	ServersServer                                                          ServersServer
	ServiceObjectivesServer                                                ServiceObjectivesServer
	StartStopManagedInstanceSchedulesServer                                StartStopManagedInstanceSchedulesServer
	SubscriptionUsagesServer                                               SubscriptionUsagesServer
	SynapseLinkWorkspacesServer                                            SynapseLinkWorkspacesServer
	SyncAgentsServer                                                       SyncAgentsServer
	SyncGroupsServer                                                       SyncGroupsServer
	SyncMembersServer                                                      SyncMembersServer
	TdeCertificatesServer                                                  TdeCertificatesServer
	TimeZonesServer                                                        TimeZonesServer
	TransparentDataEncryptionsServer                                       TransparentDataEncryptionsServer
	UsagesServer                                                           UsagesServer
	VirtualClustersServer                                                  VirtualClustersServer
	VirtualNetworkRulesServer                                              VirtualNetworkRulesServer
	VulnerabilityAssessmentBaselineServer                                  VulnerabilityAssessmentBaselineServer
	VulnerabilityAssessmentBaselinesServer                                 VulnerabilityAssessmentBaselinesServer
	VulnerabilityAssessmentExecuteScanServer                               VulnerabilityAssessmentExecuteScanServer
	VulnerabilityAssessmentRuleBaselineServer                              VulnerabilityAssessmentRuleBaselineServer
	VulnerabilityAssessmentRuleBaselinesServer                             VulnerabilityAssessmentRuleBaselinesServer
	VulnerabilityAssessmentScanResultServer                                VulnerabilityAssessmentScanResultServer
	VulnerabilityAssessmentScansServer                                     VulnerabilityAssessmentScansServer
	VulnerabilityAssessmentsServer                                         VulnerabilityAssessmentsServer
	VulnerabilityAssessmentsSettingsServer                                 VulnerabilityAssessmentsSettingsServer
	WorkloadClassifiersServer                                              WorkloadClassifiersServer
	WorkloadGroupsServer                                                   WorkloadGroupsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armsql.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armsql.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                                      *ServerFactory
	trMu                                                                     sync.Mutex
	trAgentServer                                                            *AgentServerTransport
	trBackupShortTermRetentionPoliciesServer                                 *BackupShortTermRetentionPoliciesServerTransport
	trCapabilitiesServer                                                     *CapabilitiesServerTransport
	trDataMaskingPoliciesServer                                              *DataMaskingPoliciesServerTransport
	trDataMaskingRulesServer                                                 *DataMaskingRulesServerTransport
	trDataWarehouseUserActivitiesServer                                      *DataWarehouseUserActivitiesServerTransport
	trDatabaseAdvancedThreatProtectionSettingsServer                         *DatabaseAdvancedThreatProtectionSettingsServerTransport
	trDatabaseAdvisorsServer                                                 *DatabaseAdvisorsServerTransport
	trDatabaseAutomaticTuningServer                                          *DatabaseAutomaticTuningServerTransport
	trDatabaseBlobAuditingPoliciesServer                                     *DatabaseBlobAuditingPoliciesServerTransport
	trDatabaseColumnsServer                                                  *DatabaseColumnsServerTransport
	trDatabaseEncryptionProtectorsServer                                     *DatabaseEncryptionProtectorsServerTransport
	trDatabaseExtensionsServer                                               *DatabaseExtensionsServerTransport
	trDatabaseOperationsServer                                               *DatabaseOperationsServerTransport
	trDatabaseRecommendedActionsServer                                       *DatabaseRecommendedActionsServerTransport
	trDatabaseSQLVulnerabilityAssessmentBaselinesServer                      *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport
	trDatabaseSQLVulnerabilityAssessmentExecuteScanServer                    *DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport
	trDatabaseSQLVulnerabilityAssessmentRuleBaselinesServer                  *DatabaseSQLVulnerabilityAssessmentRuleBaselinesServerTransport
	trDatabaseSQLVulnerabilityAssessmentScanResultServer                     *DatabaseSQLVulnerabilityAssessmentScanResultServerTransport
	trDatabaseSQLVulnerabilityAssessmentScansServer                          *DatabaseSQLVulnerabilityAssessmentScansServerTransport
	trDatabaseSQLVulnerabilityAssessmentsSettingsServer                      *DatabaseSQLVulnerabilityAssessmentsSettingsServerTransport
	trDatabaseSchemasServer                                                  *DatabaseSchemasServerTransport
	trDatabaseSecurityAlertPoliciesServer                                    *DatabaseSecurityAlertPoliciesServerTransport
	trDatabaseTablesServer                                                   *DatabaseTablesServerTransport
	trDatabaseUsagesServer                                                   *DatabaseUsagesServerTransport
	trDatabaseVulnerabilityAssessmentRuleBaselinesServer                     *DatabaseVulnerabilityAssessmentRuleBaselinesServerTransport
	trDatabaseVulnerabilityAssessmentScansServer                             *DatabaseVulnerabilityAssessmentScansServerTransport
	trDatabaseVulnerabilityAssessmentsServer                                 *DatabaseVulnerabilityAssessmentsServerTransport
	trDatabasesServer                                                        *DatabasesServerTransport
	trDeletedServersServer                                                   *DeletedServersServerTransport
	trDistributedAvailabilityGroupsServer                                    *DistributedAvailabilityGroupsServerTransport
	trElasticPoolActivitiesServer                                            *ElasticPoolActivitiesServerTransport
	trElasticPoolDatabaseActivitiesServer                                    *ElasticPoolDatabaseActivitiesServerTransport
	trElasticPoolOperationsServer                                            *ElasticPoolOperationsServerTransport
	trElasticPoolsServer                                                     *ElasticPoolsServerTransport
	trEncryptionProtectorsServer                                             *EncryptionProtectorsServerTransport
	trEndpointCertificatesServer                                             *EndpointCertificatesServerTransport
	trExtendedDatabaseBlobAuditingPoliciesServer                             *ExtendedDatabaseBlobAuditingPoliciesServerTransport
	trExtendedServerBlobAuditingPoliciesServer                               *ExtendedServerBlobAuditingPoliciesServerTransport
	trFailoverGroupsServer                                                   *FailoverGroupsServerTransport
	trFirewallRulesServer                                                    *FirewallRulesServerTransport
	trGeoBackupPoliciesServer                                                *GeoBackupPoliciesServerTransport
	trIPv6FirewallRulesServer                                                *IPv6FirewallRulesServerTransport
	trInstanceFailoverGroupsServer                                           *InstanceFailoverGroupsServerTransport
	trInstancePoolsServer                                                    *InstancePoolsServerTransport
	trJobAgentsServer                                                        *JobAgentsServerTransport
	trJobCredentialsServer                                                   *JobCredentialsServerTransport
	trJobExecutionsServer                                                    *JobExecutionsServerTransport
	trJobPrivateEndpointsServer                                              *JobPrivateEndpointsServerTransport
	trJobStepExecutionsServer                                                *JobStepExecutionsServerTransport
	trJobStepsServer                                                         *JobStepsServerTransport
	trJobTargetExecutionsServer                                              *JobTargetExecutionsServerTransport
	trJobTargetGroupsServer                                                  *JobTargetGroupsServerTransport
	trJobVersionsServer                                                      *JobVersionsServerTransport
	trJobsServer                                                             *JobsServerTransport
	trLedgerDigestUploadsServer                                              *LedgerDigestUploadsServerTransport
	trLongTermRetentionBackupsServer                                         *LongTermRetentionBackupsServerTransport
	trLongTermRetentionManagedInstanceBackupsServer                          *LongTermRetentionManagedInstanceBackupsServerTransport
	trLongTermRetentionPoliciesServer                                        *LongTermRetentionPoliciesServerTransport
	trMaintenanceWindowOptionsServer                                         *MaintenanceWindowOptionsServerTransport
	trMaintenanceWindowsServer                                               *MaintenanceWindowsServerTransport
	trManagedBackupShortTermRetentionPoliciesServer                          *ManagedBackupShortTermRetentionPoliciesServerTransport
	trManagedDatabaseAdvancedThreatProtectionSettingsServer                  *ManagedDatabaseAdvancedThreatProtectionSettingsServerTransport
	trManagedDatabaseColumnsServer                                           *ManagedDatabaseColumnsServerTransport
	trManagedDatabaseMoveOperationsServer                                    *ManagedDatabaseMoveOperationsServerTransport
	trManagedDatabaseQueriesServer                                           *ManagedDatabaseQueriesServerTransport
	trManagedDatabaseRecommendedSensitivityLabelsServer                      *ManagedDatabaseRecommendedSensitivityLabelsServerTransport
	trManagedDatabaseRestoreDetailsServer                                    *ManagedDatabaseRestoreDetailsServerTransport
	trManagedDatabaseSchemasServer                                           *ManagedDatabaseSchemasServerTransport
	trManagedDatabaseSecurityAlertPoliciesServer                             *ManagedDatabaseSecurityAlertPoliciesServerTransport
	trManagedDatabaseSecurityEventsServer                                    *ManagedDatabaseSecurityEventsServerTransport
	trManagedDatabaseSensitivityLabelsServer                                 *ManagedDatabaseSensitivityLabelsServerTransport
	trManagedDatabaseTablesServer                                            *ManagedDatabaseTablesServerTransport
	trManagedDatabaseTransparentDataEncryptionServer                         *ManagedDatabaseTransparentDataEncryptionServerTransport
	trManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer              *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesServerTransport
	trManagedDatabaseVulnerabilityAssessmentScansServer                      *ManagedDatabaseVulnerabilityAssessmentScansServerTransport
	trManagedDatabaseVulnerabilityAssessmentsServer                          *ManagedDatabaseVulnerabilityAssessmentsServerTransport
	trManagedDatabasesServer                                                 *ManagedDatabasesServerTransport
	trManagedInstanceAdministratorsServer                                    *ManagedInstanceAdministratorsServerTransport
	trManagedInstanceAdvancedThreatProtectionSettingsServer                  *ManagedInstanceAdvancedThreatProtectionSettingsServerTransport
	trManagedInstanceAzureADOnlyAuthenticationsServer                        *ManagedInstanceAzureADOnlyAuthenticationsServerTransport
	trManagedInstanceDtcsServer                                              *ManagedInstanceDtcsServerTransport
	trManagedInstanceEncryptionProtectorsServer                              *ManagedInstanceEncryptionProtectorsServerTransport
	trManagedInstanceKeysServer                                              *ManagedInstanceKeysServerTransport
	trManagedInstanceLongTermRetentionPoliciesServer                         *ManagedInstanceLongTermRetentionPoliciesServerTransport
	trManagedInstanceOperationsServer                                        *ManagedInstanceOperationsServerTransport
	trManagedInstancePrivateEndpointConnectionsServer                        *ManagedInstancePrivateEndpointConnectionsServerTransport
	trManagedInstancePrivateLinkResourcesServer                              *ManagedInstancePrivateLinkResourcesServerTransport
	trManagedInstanceTdeCertificatesServer                                   *ManagedInstanceTdeCertificatesServerTransport
	trManagedInstanceVulnerabilityAssessmentsServer                          *ManagedInstanceVulnerabilityAssessmentsServerTransport
	trManagedInstancesServer                                                 *ManagedInstancesServerTransport
	trManagedLedgerDigestUploadsServer                                       *ManagedLedgerDigestUploadsServerTransport
	trManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport
	trManagedServerDNSAliasesServer                                          *ManagedServerDNSAliasesServerTransport
	trManagedServerSecurityAlertPoliciesServer                               *ManagedServerSecurityAlertPoliciesServerTransport
	trOperationsServer                                                       *OperationsServerTransport
	trOutboundFirewallRulesServer                                            *OutboundFirewallRulesServerTransport
	trPrivateEndpointConnectionsServer                                       *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer                                             *PrivateLinkResourcesServerTransport
	trRecommendedSensitivityLabelsServer                                     *RecommendedSensitivityLabelsServerTransport
	trRecoverableDatabasesServer                                             *RecoverableDatabasesServerTransport
	trRecoverableManagedDatabasesServer                                      *RecoverableManagedDatabasesServerTransport
	trReplicationLinksServer                                                 *ReplicationLinksServerTransport
	trRestorableDroppedDatabasesServer                                       *RestorableDroppedDatabasesServerTransport
	trRestorableDroppedManagedDatabasesServer                                *RestorableDroppedManagedDatabasesServerTransport
	trRestorePointsServer                                                    *RestorePointsServerTransport
	trSensitivityLabelsServer                                                *SensitivityLabelsServerTransport
	trServerAdvancedThreatProtectionSettingsServer                           *ServerAdvancedThreatProtectionSettingsServerTransport
	trServerAdvisorsServer                                                   *ServerAdvisorsServerTransport
	trServerAutomaticTuningServer                                            *ServerAutomaticTuningServerTransport
	trServerAzureADAdministratorsServer                                      *ServerAzureADAdministratorsServerTransport
	trServerAzureADOnlyAuthenticationsServer                                 *ServerAzureADOnlyAuthenticationsServerTransport
	trServerBlobAuditingPoliciesServer                                       *ServerBlobAuditingPoliciesServerTransport
	trServerCommunicationLinksServer                                         *ServerCommunicationLinksServerTransport
	trServerConfigurationOptionsServer                                       *ServerConfigurationOptionsServerTransport
	trServerConnectionPoliciesServer                                         *ServerConnectionPoliciesServerTransport
	trServerDNSAliasesServer                                                 *ServerDNSAliasesServerTransport
	trServerDevOpsAuditSettingsServer                                        *ServerDevOpsAuditSettingsServerTransport
	trServerKeysServer                                                       *ServerKeysServerTransport
	trServerOperationsServer                                                 *ServerOperationsServerTransport
	trServerSecurityAlertPoliciesServer                                      *ServerSecurityAlertPoliciesServerTransport
	trServerTrustCertificatesServer                                          *ServerTrustCertificatesServerTransport
	trServerTrustGroupsServer                                                *ServerTrustGroupsServerTransport
	trServerUsagesServer                                                     *ServerUsagesServerTransport
	trServerVulnerabilityAssessmentsServer                                   *ServerVulnerabilityAssessmentsServerTransport
	trServersServer                                                          *ServersServerTransport
	trServiceObjectivesServer                                                *ServiceObjectivesServerTransport
	trStartStopManagedInstanceSchedulesServer                                *StartStopManagedInstanceSchedulesServerTransport
	trSubscriptionUsagesServer                                               *SubscriptionUsagesServerTransport
	trSynapseLinkWorkspacesServer                                            *SynapseLinkWorkspacesServerTransport
	trSyncAgentsServer                                                       *SyncAgentsServerTransport
	trSyncGroupsServer                                                       *SyncGroupsServerTransport
	trSyncMembersServer                                                      *SyncMembersServerTransport
	trTdeCertificatesServer                                                  *TdeCertificatesServerTransport
	trTimeZonesServer                                                        *TimeZonesServerTransport
	trTransparentDataEncryptionsServer                                       *TransparentDataEncryptionsServerTransport
	trUsagesServer                                                           *UsagesServerTransport
	trVirtualClustersServer                                                  *VirtualClustersServerTransport
	trVirtualNetworkRulesServer                                              *VirtualNetworkRulesServerTransport
	trVulnerabilityAssessmentBaselineServer                                  *VulnerabilityAssessmentBaselineServerTransport
	trVulnerabilityAssessmentBaselinesServer                                 *VulnerabilityAssessmentBaselinesServerTransport
	trVulnerabilityAssessmentExecuteScanServer                               *VulnerabilityAssessmentExecuteScanServerTransport
	trVulnerabilityAssessmentRuleBaselineServer                              *VulnerabilityAssessmentRuleBaselineServerTransport
	trVulnerabilityAssessmentRuleBaselinesServer                             *VulnerabilityAssessmentRuleBaselinesServerTransport
	trVulnerabilityAssessmentScanResultServer                                *VulnerabilityAssessmentScanResultServerTransport
	trVulnerabilityAssessmentScansServer                                     *VulnerabilityAssessmentScansServerTransport
	trVulnerabilityAssessmentsServer                                         *VulnerabilityAssessmentsServerTransport
	trVulnerabilityAssessmentsSettingsServer                                 *VulnerabilityAssessmentsSettingsServerTransport
	trWorkloadClassifiersServer                                              *WorkloadClassifiersServerTransport
	trWorkloadGroupsServer                                                   *WorkloadGroupsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AgentClient":
		initServer(s, &s.trAgentServer, func() *AgentServerTransport { return NewAgentServerTransport(&s.srv.AgentServer) })
		resp, err = s.trAgentServer.Do(req)
	case "BackupShortTermRetentionPoliciesClient":
		initServer(s, &s.trBackupShortTermRetentionPoliciesServer, func() *BackupShortTermRetentionPoliciesServerTransport {
			return NewBackupShortTermRetentionPoliciesServerTransport(&s.srv.BackupShortTermRetentionPoliciesServer)
		})
		resp, err = s.trBackupShortTermRetentionPoliciesServer.Do(req)
	case "CapabilitiesClient":
		initServer(s, &s.trCapabilitiesServer, func() *CapabilitiesServerTransport { return NewCapabilitiesServerTransport(&s.srv.CapabilitiesServer) })
		resp, err = s.trCapabilitiesServer.Do(req)
	case "DataMaskingPoliciesClient":
		initServer(s, &s.trDataMaskingPoliciesServer, func() *DataMaskingPoliciesServerTransport {
			return NewDataMaskingPoliciesServerTransport(&s.srv.DataMaskingPoliciesServer)
		})
		resp, err = s.trDataMaskingPoliciesServer.Do(req)
	case "DataMaskingRulesClient":
		initServer(s, &s.trDataMaskingRulesServer, func() *DataMaskingRulesServerTransport {
			return NewDataMaskingRulesServerTransport(&s.srv.DataMaskingRulesServer)
		})
		resp, err = s.trDataMaskingRulesServer.Do(req)
	case "DataWarehouseUserActivitiesClient":
		initServer(s, &s.trDataWarehouseUserActivitiesServer, func() *DataWarehouseUserActivitiesServerTransport {
			return NewDataWarehouseUserActivitiesServerTransport(&s.srv.DataWarehouseUserActivitiesServer)
		})
		resp, err = s.trDataWarehouseUserActivitiesServer.Do(req)
	case "DatabaseAdvancedThreatProtectionSettingsClient":
		initServer(s, &s.trDatabaseAdvancedThreatProtectionSettingsServer, func() *DatabaseAdvancedThreatProtectionSettingsServerTransport {
			return NewDatabaseAdvancedThreatProtectionSettingsServerTransport(&s.srv.DatabaseAdvancedThreatProtectionSettingsServer)
		})
		resp, err = s.trDatabaseAdvancedThreatProtectionSettingsServer.Do(req)
	case "DatabaseAdvisorsClient":
		initServer(s, &s.trDatabaseAdvisorsServer, func() *DatabaseAdvisorsServerTransport {
			return NewDatabaseAdvisorsServerTransport(&s.srv.DatabaseAdvisorsServer)
		})
		resp, err = s.trDatabaseAdvisorsServer.Do(req)
	case "DatabaseAutomaticTuningClient":
		initServer(s, &s.trDatabaseAutomaticTuningServer, func() *DatabaseAutomaticTuningServerTransport {
			return NewDatabaseAutomaticTuningServerTransport(&s.srv.DatabaseAutomaticTuningServer)
		})
		resp, err = s.trDatabaseAutomaticTuningServer.Do(req)
	case "DatabaseBlobAuditingPoliciesClient":
		initServer(s, &s.trDatabaseBlobAuditingPoliciesServer, func() *DatabaseBlobAuditingPoliciesServerTransport {
			return NewDatabaseBlobAuditingPoliciesServerTransport(&s.srv.DatabaseBlobAuditingPoliciesServer)
		})
		resp, err = s.trDatabaseBlobAuditingPoliciesServer.Do(req)
	case "DatabaseColumnsClient":
		initServer(s, &s.trDatabaseColumnsServer, func() *DatabaseColumnsServerTransport {
			return NewDatabaseColumnsServerTransport(&s.srv.DatabaseColumnsServer)
		})
		resp, err = s.trDatabaseColumnsServer.Do(req)
	case "DatabaseEncryptionProtectorsClient":
		initServer(s, &s.trDatabaseEncryptionProtectorsServer, func() *DatabaseEncryptionProtectorsServerTransport {
			return NewDatabaseEncryptionProtectorsServerTransport(&s.srv.DatabaseEncryptionProtectorsServer)
		})
		resp, err = s.trDatabaseEncryptionProtectorsServer.Do(req)
	case "DatabaseExtensionsClient":
		initServer(s, &s.trDatabaseExtensionsServer, func() *DatabaseExtensionsServerTransport {
			return NewDatabaseExtensionsServerTransport(&s.srv.DatabaseExtensionsServer)
		})
		resp, err = s.trDatabaseExtensionsServer.Do(req)
	case "DatabaseOperationsClient":
		initServer(s, &s.trDatabaseOperationsServer, func() *DatabaseOperationsServerTransport {
			return NewDatabaseOperationsServerTransport(&s.srv.DatabaseOperationsServer)
		})
		resp, err = s.trDatabaseOperationsServer.Do(req)
	case "DatabaseRecommendedActionsClient":
		initServer(s, &s.trDatabaseRecommendedActionsServer, func() *DatabaseRecommendedActionsServerTransport {
			return NewDatabaseRecommendedActionsServerTransport(&s.srv.DatabaseRecommendedActionsServer)
		})
		resp, err = s.trDatabaseRecommendedActionsServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentBaselinesClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentBaselinesServer, func() *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentBaselinesServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentBaselinesServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentBaselinesServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentExecuteScanClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentExecuteScanServer, func() *DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentExecuteScanServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentExecuteScanServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentRuleBaselinesServer, func() *DatabaseSQLVulnerabilityAssessmentRuleBaselinesServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentRuleBaselinesServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentRuleBaselinesServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentScanResultClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentScanResultServer, func() *DatabaseSQLVulnerabilityAssessmentScanResultServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentScanResultServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentScanResultServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentScanResultServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentScansClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentScansServer, func() *DatabaseSQLVulnerabilityAssessmentScansServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentScansServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentScansServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentScansServer.Do(req)
	case "DatabaseSQLVulnerabilityAssessmentsSettingsClient":
		initServer(s, &s.trDatabaseSQLVulnerabilityAssessmentsSettingsServer, func() *DatabaseSQLVulnerabilityAssessmentsSettingsServerTransport {
			return NewDatabaseSQLVulnerabilityAssessmentsSettingsServerTransport(&s.srv.DatabaseSQLVulnerabilityAssessmentsSettingsServer)
		})
		resp, err = s.trDatabaseSQLVulnerabilityAssessmentsSettingsServer.Do(req)
	case "DatabaseSchemasClient":
		initServer(s, &s.trDatabaseSchemasServer, func() *DatabaseSchemasServerTransport {
			return NewDatabaseSchemasServerTransport(&s.srv.DatabaseSchemasServer)
		})
		resp, err = s.trDatabaseSchemasServer.Do(req)
	case "DatabaseSecurityAlertPoliciesClient":
		initServer(s, &s.trDatabaseSecurityAlertPoliciesServer, func() *DatabaseSecurityAlertPoliciesServerTransport {
			return NewDatabaseSecurityAlertPoliciesServerTransport(&s.srv.DatabaseSecurityAlertPoliciesServer)
		})
		resp, err = s.trDatabaseSecurityAlertPoliciesServer.Do(req)
	case "DatabaseTablesClient":
		initServer(s, &s.trDatabaseTablesServer, func() *DatabaseTablesServerTransport {
			return NewDatabaseTablesServerTransport(&s.srv.DatabaseTablesServer)
		})
		resp, err = s.trDatabaseTablesServer.Do(req)
	case "DatabaseUsagesClient":
		initServer(s, &s.trDatabaseUsagesServer, func() *DatabaseUsagesServerTransport {
			return NewDatabaseUsagesServerTransport(&s.srv.DatabaseUsagesServer)
		})
		resp, err = s.trDatabaseUsagesServer.Do(req)
	case "DatabaseVulnerabilityAssessmentRuleBaselinesClient":
		initServer(s, &s.trDatabaseVulnerabilityAssessmentRuleBaselinesServer, func() *DatabaseVulnerabilityAssessmentRuleBaselinesServerTransport {
			return NewDatabaseVulnerabilityAssessmentRuleBaselinesServerTransport(&s.srv.DatabaseVulnerabilityAssessmentRuleBaselinesServer)
		})
		resp, err = s.trDatabaseVulnerabilityAssessmentRuleBaselinesServer.Do(req)
	case "DatabaseVulnerabilityAssessmentScansClient":
		initServer(s, &s.trDatabaseVulnerabilityAssessmentScansServer, func() *DatabaseVulnerabilityAssessmentScansServerTransport {
			return NewDatabaseVulnerabilityAssessmentScansServerTransport(&s.srv.DatabaseVulnerabilityAssessmentScansServer)
		})
		resp, err = s.trDatabaseVulnerabilityAssessmentScansServer.Do(req)
	case "DatabaseVulnerabilityAssessmentsClient":
		initServer(s, &s.trDatabaseVulnerabilityAssessmentsServer, func() *DatabaseVulnerabilityAssessmentsServerTransport {
			return NewDatabaseVulnerabilityAssessmentsServerTransport(&s.srv.DatabaseVulnerabilityAssessmentsServer)
		})
		resp, err = s.trDatabaseVulnerabilityAssessmentsServer.Do(req)
	case "DatabasesClient":
		initServer(s, &s.trDatabasesServer, func() *DatabasesServerTransport { return NewDatabasesServerTransport(&s.srv.DatabasesServer) })
		resp, err = s.trDatabasesServer.Do(req)
	case "DeletedServersClient":
		initServer(s, &s.trDeletedServersServer, func() *DeletedServersServerTransport {
			return NewDeletedServersServerTransport(&s.srv.DeletedServersServer)
		})
		resp, err = s.trDeletedServersServer.Do(req)
	case "DistributedAvailabilityGroupsClient":
		initServer(s, &s.trDistributedAvailabilityGroupsServer, func() *DistributedAvailabilityGroupsServerTransport {
			return NewDistributedAvailabilityGroupsServerTransport(&s.srv.DistributedAvailabilityGroupsServer)
		})
		resp, err = s.trDistributedAvailabilityGroupsServer.Do(req)
	case "ElasticPoolActivitiesClient":
		initServer(s, &s.trElasticPoolActivitiesServer, func() *ElasticPoolActivitiesServerTransport {
			return NewElasticPoolActivitiesServerTransport(&s.srv.ElasticPoolActivitiesServer)
		})
		resp, err = s.trElasticPoolActivitiesServer.Do(req)
	case "ElasticPoolDatabaseActivitiesClient":
		initServer(s, &s.trElasticPoolDatabaseActivitiesServer, func() *ElasticPoolDatabaseActivitiesServerTransport {
			return NewElasticPoolDatabaseActivitiesServerTransport(&s.srv.ElasticPoolDatabaseActivitiesServer)
		})
		resp, err = s.trElasticPoolDatabaseActivitiesServer.Do(req)
	case "ElasticPoolOperationsClient":
		initServer(s, &s.trElasticPoolOperationsServer, func() *ElasticPoolOperationsServerTransport {
			return NewElasticPoolOperationsServerTransport(&s.srv.ElasticPoolOperationsServer)
		})
		resp, err = s.trElasticPoolOperationsServer.Do(req)
	case "ElasticPoolsClient":
		initServer(s, &s.trElasticPoolsServer, func() *ElasticPoolsServerTransport { return NewElasticPoolsServerTransport(&s.srv.ElasticPoolsServer) })
		resp, err = s.trElasticPoolsServer.Do(req)
	case "EncryptionProtectorsClient":
		initServer(s, &s.trEncryptionProtectorsServer, func() *EncryptionProtectorsServerTransport {
			return NewEncryptionProtectorsServerTransport(&s.srv.EncryptionProtectorsServer)
		})
		resp, err = s.trEncryptionProtectorsServer.Do(req)
	case "EndpointCertificatesClient":
		initServer(s, &s.trEndpointCertificatesServer, func() *EndpointCertificatesServerTransport {
			return NewEndpointCertificatesServerTransport(&s.srv.EndpointCertificatesServer)
		})
		resp, err = s.trEndpointCertificatesServer.Do(req)
	case "ExtendedDatabaseBlobAuditingPoliciesClient":
		initServer(s, &s.trExtendedDatabaseBlobAuditingPoliciesServer, func() *ExtendedDatabaseBlobAuditingPoliciesServerTransport {
			return NewExtendedDatabaseBlobAuditingPoliciesServerTransport(&s.srv.ExtendedDatabaseBlobAuditingPoliciesServer)
		})
		resp, err = s.trExtendedDatabaseBlobAuditingPoliciesServer.Do(req)
	case "ExtendedServerBlobAuditingPoliciesClient":
		initServer(s, &s.trExtendedServerBlobAuditingPoliciesServer, func() *ExtendedServerBlobAuditingPoliciesServerTransport {
			return NewExtendedServerBlobAuditingPoliciesServerTransport(&s.srv.ExtendedServerBlobAuditingPoliciesServer)
		})
		resp, err = s.trExtendedServerBlobAuditingPoliciesServer.Do(req)
	case "FailoverGroupsClient":
		initServer(s, &s.trFailoverGroupsServer, func() *FailoverGroupsServerTransport {
			return NewFailoverGroupsServerTransport(&s.srv.FailoverGroupsServer)
		})
		resp, err = s.trFailoverGroupsServer.Do(req)
	case "FirewallRulesClient":
		initServer(s, &s.trFirewallRulesServer, func() *FirewallRulesServerTransport {
			return NewFirewallRulesServerTransport(&s.srv.FirewallRulesServer)
		})
		resp, err = s.trFirewallRulesServer.Do(req)
	case "GeoBackupPoliciesClient":
		initServer(s, &s.trGeoBackupPoliciesServer, func() *GeoBackupPoliciesServerTransport {
			return NewGeoBackupPoliciesServerTransport(&s.srv.GeoBackupPoliciesServer)
		})
		resp, err = s.trGeoBackupPoliciesServer.Do(req)
	case "IPv6FirewallRulesClient":
		initServer(s, &s.trIPv6FirewallRulesServer, func() *IPv6FirewallRulesServerTransport {
			return NewIPv6FirewallRulesServerTransport(&s.srv.IPv6FirewallRulesServer)
		})
		resp, err = s.trIPv6FirewallRulesServer.Do(req)
	case "InstanceFailoverGroupsClient":
		initServer(s, &s.trInstanceFailoverGroupsServer, func() *InstanceFailoverGroupsServerTransport {
			return NewInstanceFailoverGroupsServerTransport(&s.srv.InstanceFailoverGroupsServer)
		})
		resp, err = s.trInstanceFailoverGroupsServer.Do(req)
	case "InstancePoolsClient":
		initServer(s, &s.trInstancePoolsServer, func() *InstancePoolsServerTransport {
			return NewInstancePoolsServerTransport(&s.srv.InstancePoolsServer)
		})
		resp, err = s.trInstancePoolsServer.Do(req)
	case "JobAgentsClient":
		initServer(s, &s.trJobAgentsServer, func() *JobAgentsServerTransport { return NewJobAgentsServerTransport(&s.srv.JobAgentsServer) })
		resp, err = s.trJobAgentsServer.Do(req)
	case "JobCredentialsClient":
		initServer(s, &s.trJobCredentialsServer, func() *JobCredentialsServerTransport {
			return NewJobCredentialsServerTransport(&s.srv.JobCredentialsServer)
		})
		resp, err = s.trJobCredentialsServer.Do(req)
	case "JobExecutionsClient":
		initServer(s, &s.trJobExecutionsServer, func() *JobExecutionsServerTransport {
			return NewJobExecutionsServerTransport(&s.srv.JobExecutionsServer)
		})
		resp, err = s.trJobExecutionsServer.Do(req)
	case "JobPrivateEndpointsClient":
		initServer(s, &s.trJobPrivateEndpointsServer, func() *JobPrivateEndpointsServerTransport {
			return NewJobPrivateEndpointsServerTransport(&s.srv.JobPrivateEndpointsServer)
		})
		resp, err = s.trJobPrivateEndpointsServer.Do(req)
	case "JobStepExecutionsClient":
		initServer(s, &s.trJobStepExecutionsServer, func() *JobStepExecutionsServerTransport {
			return NewJobStepExecutionsServerTransport(&s.srv.JobStepExecutionsServer)
		})
		resp, err = s.trJobStepExecutionsServer.Do(req)
	case "JobStepsClient":
		initServer(s, &s.trJobStepsServer, func() *JobStepsServerTransport { return NewJobStepsServerTransport(&s.srv.JobStepsServer) })
		resp, err = s.trJobStepsServer.Do(req)
	case "JobTargetExecutionsClient":
		initServer(s, &s.trJobTargetExecutionsServer, func() *JobTargetExecutionsServerTransport {
			return NewJobTargetExecutionsServerTransport(&s.srv.JobTargetExecutionsServer)
		})
		resp, err = s.trJobTargetExecutionsServer.Do(req)
	case "JobTargetGroupsClient":
		initServer(s, &s.trJobTargetGroupsServer, func() *JobTargetGroupsServerTransport {
			return NewJobTargetGroupsServerTransport(&s.srv.JobTargetGroupsServer)
		})
		resp, err = s.trJobTargetGroupsServer.Do(req)
	case "JobVersionsClient":
		initServer(s, &s.trJobVersionsServer, func() *JobVersionsServerTransport { return NewJobVersionsServerTransport(&s.srv.JobVersionsServer) })
		resp, err = s.trJobVersionsServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "LedgerDigestUploadsClient":
		initServer(s, &s.trLedgerDigestUploadsServer, func() *LedgerDigestUploadsServerTransport {
			return NewLedgerDigestUploadsServerTransport(&s.srv.LedgerDigestUploadsServer)
		})
		resp, err = s.trLedgerDigestUploadsServer.Do(req)
	case "LongTermRetentionBackupsClient":
		initServer(s, &s.trLongTermRetentionBackupsServer, func() *LongTermRetentionBackupsServerTransport {
			return NewLongTermRetentionBackupsServerTransport(&s.srv.LongTermRetentionBackupsServer)
		})
		resp, err = s.trLongTermRetentionBackupsServer.Do(req)
	case "LongTermRetentionManagedInstanceBackupsClient":
		initServer(s, &s.trLongTermRetentionManagedInstanceBackupsServer, func() *LongTermRetentionManagedInstanceBackupsServerTransport {
			return NewLongTermRetentionManagedInstanceBackupsServerTransport(&s.srv.LongTermRetentionManagedInstanceBackupsServer)
		})
		resp, err = s.trLongTermRetentionManagedInstanceBackupsServer.Do(req)
	case "LongTermRetentionPoliciesClient":
		initServer(s, &s.trLongTermRetentionPoliciesServer, func() *LongTermRetentionPoliciesServerTransport {
			return NewLongTermRetentionPoliciesServerTransport(&s.srv.LongTermRetentionPoliciesServer)
		})
		resp, err = s.trLongTermRetentionPoliciesServer.Do(req)
	case "MaintenanceWindowOptionsClient":
		initServer(s, &s.trMaintenanceWindowOptionsServer, func() *MaintenanceWindowOptionsServerTransport {
			return NewMaintenanceWindowOptionsServerTransport(&s.srv.MaintenanceWindowOptionsServer)
		})
		resp, err = s.trMaintenanceWindowOptionsServer.Do(req)
	case "MaintenanceWindowsClient":
		initServer(s, &s.trMaintenanceWindowsServer, func() *MaintenanceWindowsServerTransport {
			return NewMaintenanceWindowsServerTransport(&s.srv.MaintenanceWindowsServer)
		})
		resp, err = s.trMaintenanceWindowsServer.Do(req)
	case "ManagedBackupShortTermRetentionPoliciesClient":
		initServer(s, &s.trManagedBackupShortTermRetentionPoliciesServer, func() *ManagedBackupShortTermRetentionPoliciesServerTransport {
			return NewManagedBackupShortTermRetentionPoliciesServerTransport(&s.srv.ManagedBackupShortTermRetentionPoliciesServer)
		})
		resp, err = s.trManagedBackupShortTermRetentionPoliciesServer.Do(req)
	case "ManagedDatabaseAdvancedThreatProtectionSettingsClient":
		initServer(s, &s.trManagedDatabaseAdvancedThreatProtectionSettingsServer, func() *ManagedDatabaseAdvancedThreatProtectionSettingsServerTransport {
			return NewManagedDatabaseAdvancedThreatProtectionSettingsServerTransport(&s.srv.ManagedDatabaseAdvancedThreatProtectionSettingsServer)
		})
		resp, err = s.trManagedDatabaseAdvancedThreatProtectionSettingsServer.Do(req)
	case "ManagedDatabaseColumnsClient":
		initServer(s, &s.trManagedDatabaseColumnsServer, func() *ManagedDatabaseColumnsServerTransport {
			return NewManagedDatabaseColumnsServerTransport(&s.srv.ManagedDatabaseColumnsServer)
		})
		resp, err = s.trManagedDatabaseColumnsServer.Do(req)
	case "ManagedDatabaseMoveOperationsClient":
		initServer(s, &s.trManagedDatabaseMoveOperationsServer, func() *ManagedDatabaseMoveOperationsServerTransport {
			return NewManagedDatabaseMoveOperationsServerTransport(&s.srv.ManagedDatabaseMoveOperationsServer)
		})
		resp, err = s.trManagedDatabaseMoveOperationsServer.Do(req)
	case "ManagedDatabaseQueriesClient":
		initServer(s, &s.trManagedDatabaseQueriesServer, func() *ManagedDatabaseQueriesServerTransport {
			return NewManagedDatabaseQueriesServerTransport(&s.srv.ManagedDatabaseQueriesServer)
		})
		resp, err = s.trManagedDatabaseQueriesServer.Do(req)
	case "ManagedDatabaseRecommendedSensitivityLabelsClient":
		initServer(s, &s.trManagedDatabaseRecommendedSensitivityLabelsServer, func() *ManagedDatabaseRecommendedSensitivityLabelsServerTransport {
			return NewManagedDatabaseRecommendedSensitivityLabelsServerTransport(&s.srv.ManagedDatabaseRecommendedSensitivityLabelsServer)
		})
		resp, err = s.trManagedDatabaseRecommendedSensitivityLabelsServer.Do(req)
	case "ManagedDatabaseRestoreDetailsClient":
		initServer(s, &s.trManagedDatabaseRestoreDetailsServer, func() *ManagedDatabaseRestoreDetailsServerTransport {
			return NewManagedDatabaseRestoreDetailsServerTransport(&s.srv.ManagedDatabaseRestoreDetailsServer)
		})
		resp, err = s.trManagedDatabaseRestoreDetailsServer.Do(req)
	case "ManagedDatabaseSchemasClient":
		initServer(s, &s.trManagedDatabaseSchemasServer, func() *ManagedDatabaseSchemasServerTransport {
			return NewManagedDatabaseSchemasServerTransport(&s.srv.ManagedDatabaseSchemasServer)
		})
		resp, err = s.trManagedDatabaseSchemasServer.Do(req)
	case "ManagedDatabaseSecurityAlertPoliciesClient":
		initServer(s, &s.trManagedDatabaseSecurityAlertPoliciesServer, func() *ManagedDatabaseSecurityAlertPoliciesServerTransport {
			return NewManagedDatabaseSecurityAlertPoliciesServerTransport(&s.srv.ManagedDatabaseSecurityAlertPoliciesServer)
		})
		resp, err = s.trManagedDatabaseSecurityAlertPoliciesServer.Do(req)
	case "ManagedDatabaseSecurityEventsClient":
		initServer(s, &s.trManagedDatabaseSecurityEventsServer, func() *ManagedDatabaseSecurityEventsServerTransport {
			return NewManagedDatabaseSecurityEventsServerTransport(&s.srv.ManagedDatabaseSecurityEventsServer)
		})
		resp, err = s.trManagedDatabaseSecurityEventsServer.Do(req)
	case "ManagedDatabaseSensitivityLabelsClient":
		initServer(s, &s.trManagedDatabaseSensitivityLabelsServer, func() *ManagedDatabaseSensitivityLabelsServerTransport {
			return NewManagedDatabaseSensitivityLabelsServerTransport(&s.srv.ManagedDatabaseSensitivityLabelsServer)
		})
		resp, err = s.trManagedDatabaseSensitivityLabelsServer.Do(req)
	case "ManagedDatabaseTablesClient":
		initServer(s, &s.trManagedDatabaseTablesServer, func() *ManagedDatabaseTablesServerTransport {
			return NewManagedDatabaseTablesServerTransport(&s.srv.ManagedDatabaseTablesServer)
		})
		resp, err = s.trManagedDatabaseTablesServer.Do(req)
	case "ManagedDatabaseTransparentDataEncryptionClient":
		initServer(s, &s.trManagedDatabaseTransparentDataEncryptionServer, func() *ManagedDatabaseTransparentDataEncryptionServerTransport {
			return NewManagedDatabaseTransparentDataEncryptionServerTransport(&s.srv.ManagedDatabaseTransparentDataEncryptionServer)
		})
		resp, err = s.trManagedDatabaseTransparentDataEncryptionServer.Do(req)
	case "ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient":
		initServer(s, &s.trManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer, func() *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesServerTransport {
			return NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesServerTransport(&s.srv.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer)
		})
		resp, err = s.trManagedDatabaseVulnerabilityAssessmentRuleBaselinesServer.Do(req)
	case "ManagedDatabaseVulnerabilityAssessmentScansClient":
		initServer(s, &s.trManagedDatabaseVulnerabilityAssessmentScansServer, func() *ManagedDatabaseVulnerabilityAssessmentScansServerTransport {
			return NewManagedDatabaseVulnerabilityAssessmentScansServerTransport(&s.srv.ManagedDatabaseVulnerabilityAssessmentScansServer)
		})
		resp, err = s.trManagedDatabaseVulnerabilityAssessmentScansServer.Do(req)
	case "ManagedDatabaseVulnerabilityAssessmentsClient":
		initServer(s, &s.trManagedDatabaseVulnerabilityAssessmentsServer, func() *ManagedDatabaseVulnerabilityAssessmentsServerTransport {
			return NewManagedDatabaseVulnerabilityAssessmentsServerTransport(&s.srv.ManagedDatabaseVulnerabilityAssessmentsServer)
		})
		resp, err = s.trManagedDatabaseVulnerabilityAssessmentsServer.Do(req)
	case "ManagedDatabasesClient":
		initServer(s, &s.trManagedDatabasesServer, func() *ManagedDatabasesServerTransport {
			return NewManagedDatabasesServerTransport(&s.srv.ManagedDatabasesServer)
		})
		resp, err = s.trManagedDatabasesServer.Do(req)
	case "ManagedInstanceAdministratorsClient":
		initServer(s, &s.trManagedInstanceAdministratorsServer, func() *ManagedInstanceAdministratorsServerTransport {
			return NewManagedInstanceAdministratorsServerTransport(&s.srv.ManagedInstanceAdministratorsServer)
		})
		resp, err = s.trManagedInstanceAdministratorsServer.Do(req)
	case "ManagedInstanceAdvancedThreatProtectionSettingsClient":
		initServer(s, &s.trManagedInstanceAdvancedThreatProtectionSettingsServer, func() *ManagedInstanceAdvancedThreatProtectionSettingsServerTransport {
			return NewManagedInstanceAdvancedThreatProtectionSettingsServerTransport(&s.srv.ManagedInstanceAdvancedThreatProtectionSettingsServer)
		})
		resp, err = s.trManagedInstanceAdvancedThreatProtectionSettingsServer.Do(req)
	case "ManagedInstanceAzureADOnlyAuthenticationsClient":
		initServer(s, &s.trManagedInstanceAzureADOnlyAuthenticationsServer, func() *ManagedInstanceAzureADOnlyAuthenticationsServerTransport {
			return NewManagedInstanceAzureADOnlyAuthenticationsServerTransport(&s.srv.ManagedInstanceAzureADOnlyAuthenticationsServer)
		})
		resp, err = s.trManagedInstanceAzureADOnlyAuthenticationsServer.Do(req)
	case "ManagedInstanceDtcsClient":
		initServer(s, &s.trManagedInstanceDtcsServer, func() *ManagedInstanceDtcsServerTransport {
			return NewManagedInstanceDtcsServerTransport(&s.srv.ManagedInstanceDtcsServer)
		})
		resp, err = s.trManagedInstanceDtcsServer.Do(req)
	case "ManagedInstanceEncryptionProtectorsClient":
		initServer(s, &s.trManagedInstanceEncryptionProtectorsServer, func() *ManagedInstanceEncryptionProtectorsServerTransport {
			return NewManagedInstanceEncryptionProtectorsServerTransport(&s.srv.ManagedInstanceEncryptionProtectorsServer)
		})
		resp, err = s.trManagedInstanceEncryptionProtectorsServer.Do(req)
	case "ManagedInstanceKeysClient":
		initServer(s, &s.trManagedInstanceKeysServer, func() *ManagedInstanceKeysServerTransport {
			return NewManagedInstanceKeysServerTransport(&s.srv.ManagedInstanceKeysServer)
		})
		resp, err = s.trManagedInstanceKeysServer.Do(req)
	case "ManagedInstanceLongTermRetentionPoliciesClient":
		initServer(s, &s.trManagedInstanceLongTermRetentionPoliciesServer, func() *ManagedInstanceLongTermRetentionPoliciesServerTransport {
			return NewManagedInstanceLongTermRetentionPoliciesServerTransport(&s.srv.ManagedInstanceLongTermRetentionPoliciesServer)
		})
		resp, err = s.trManagedInstanceLongTermRetentionPoliciesServer.Do(req)
	case "ManagedInstanceOperationsClient":
		initServer(s, &s.trManagedInstanceOperationsServer, func() *ManagedInstanceOperationsServerTransport {
			return NewManagedInstanceOperationsServerTransport(&s.srv.ManagedInstanceOperationsServer)
		})
		resp, err = s.trManagedInstanceOperationsServer.Do(req)
	case "ManagedInstancePrivateEndpointConnectionsClient":
		initServer(s, &s.trManagedInstancePrivateEndpointConnectionsServer, func() *ManagedInstancePrivateEndpointConnectionsServerTransport {
			return NewManagedInstancePrivateEndpointConnectionsServerTransport(&s.srv.ManagedInstancePrivateEndpointConnectionsServer)
		})
		resp, err = s.trManagedInstancePrivateEndpointConnectionsServer.Do(req)
	case "ManagedInstancePrivateLinkResourcesClient":
		initServer(s, &s.trManagedInstancePrivateLinkResourcesServer, func() *ManagedInstancePrivateLinkResourcesServerTransport {
			return NewManagedInstancePrivateLinkResourcesServerTransport(&s.srv.ManagedInstancePrivateLinkResourcesServer)
		})
		resp, err = s.trManagedInstancePrivateLinkResourcesServer.Do(req)
	case "ManagedInstanceTdeCertificatesClient":
		initServer(s, &s.trManagedInstanceTdeCertificatesServer, func() *ManagedInstanceTdeCertificatesServerTransport {
			return NewManagedInstanceTdeCertificatesServerTransport(&s.srv.ManagedInstanceTdeCertificatesServer)
		})
		resp, err = s.trManagedInstanceTdeCertificatesServer.Do(req)
	case "ManagedInstanceVulnerabilityAssessmentsClient":
		initServer(s, &s.trManagedInstanceVulnerabilityAssessmentsServer, func() *ManagedInstanceVulnerabilityAssessmentsServerTransport {
			return NewManagedInstanceVulnerabilityAssessmentsServerTransport(&s.srv.ManagedInstanceVulnerabilityAssessmentsServer)
		})
		resp, err = s.trManagedInstanceVulnerabilityAssessmentsServer.Do(req)
	case "ManagedInstancesClient":
		initServer(s, &s.trManagedInstancesServer, func() *ManagedInstancesServerTransport {
			return NewManagedInstancesServerTransport(&s.srv.ManagedInstancesServer)
		})
		resp, err = s.trManagedInstancesServer.Do(req)
	case "ManagedLedgerDigestUploadsClient":
		initServer(s, &s.trManagedLedgerDigestUploadsServer, func() *ManagedLedgerDigestUploadsServerTransport {
			return NewManagedLedgerDigestUploadsServerTransport(&s.srv.ManagedLedgerDigestUploadsServer)
		})
		resp, err = s.trManagedLedgerDigestUploadsServer.Do(req)
	case "ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient":
		initServer(s, &s.trManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer, func() *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport {
			return NewManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServerTransport(&s.srv.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer)
		})
		resp, err = s.trManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesServer.Do(req)
	case "ManagedServerDNSAliasesClient":
		initServer(s, &s.trManagedServerDNSAliasesServer, func() *ManagedServerDNSAliasesServerTransport {
			return NewManagedServerDNSAliasesServerTransport(&s.srv.ManagedServerDNSAliasesServer)
		})
		resp, err = s.trManagedServerDNSAliasesServer.Do(req)
	case "ManagedServerSecurityAlertPoliciesClient":
		initServer(s, &s.trManagedServerSecurityAlertPoliciesServer, func() *ManagedServerSecurityAlertPoliciesServerTransport {
			return NewManagedServerSecurityAlertPoliciesServerTransport(&s.srv.ManagedServerSecurityAlertPoliciesServer)
		})
		resp, err = s.trManagedServerSecurityAlertPoliciesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OutboundFirewallRulesClient":
		initServer(s, &s.trOutboundFirewallRulesServer, func() *OutboundFirewallRulesServerTransport {
			return NewOutboundFirewallRulesServerTransport(&s.srv.OutboundFirewallRulesServer)
		})
		resp, err = s.trOutboundFirewallRulesServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "RecommendedSensitivityLabelsClient":
		initServer(s, &s.trRecommendedSensitivityLabelsServer, func() *RecommendedSensitivityLabelsServerTransport {
			return NewRecommendedSensitivityLabelsServerTransport(&s.srv.RecommendedSensitivityLabelsServer)
		})
		resp, err = s.trRecommendedSensitivityLabelsServer.Do(req)
	case "RecoverableDatabasesClient":
		initServer(s, &s.trRecoverableDatabasesServer, func() *RecoverableDatabasesServerTransport {
			return NewRecoverableDatabasesServerTransport(&s.srv.RecoverableDatabasesServer)
		})
		resp, err = s.trRecoverableDatabasesServer.Do(req)
	case "RecoverableManagedDatabasesClient":
		initServer(s, &s.trRecoverableManagedDatabasesServer, func() *RecoverableManagedDatabasesServerTransport {
			return NewRecoverableManagedDatabasesServerTransport(&s.srv.RecoverableManagedDatabasesServer)
		})
		resp, err = s.trRecoverableManagedDatabasesServer.Do(req)
	case "ReplicationLinksClient":
		initServer(s, &s.trReplicationLinksServer, func() *ReplicationLinksServerTransport {
			return NewReplicationLinksServerTransport(&s.srv.ReplicationLinksServer)
		})
		resp, err = s.trReplicationLinksServer.Do(req)
	case "RestorableDroppedDatabasesClient":
		initServer(s, &s.trRestorableDroppedDatabasesServer, func() *RestorableDroppedDatabasesServerTransport {
			return NewRestorableDroppedDatabasesServerTransport(&s.srv.RestorableDroppedDatabasesServer)
		})
		resp, err = s.trRestorableDroppedDatabasesServer.Do(req)
	case "RestorableDroppedManagedDatabasesClient":
		initServer(s, &s.trRestorableDroppedManagedDatabasesServer, func() *RestorableDroppedManagedDatabasesServerTransport {
			return NewRestorableDroppedManagedDatabasesServerTransport(&s.srv.RestorableDroppedManagedDatabasesServer)
		})
		resp, err = s.trRestorableDroppedManagedDatabasesServer.Do(req)
	case "RestorePointsClient":
		initServer(s, &s.trRestorePointsServer, func() *RestorePointsServerTransport {
			return NewRestorePointsServerTransport(&s.srv.RestorePointsServer)
		})
		resp, err = s.trRestorePointsServer.Do(req)
	case "SensitivityLabelsClient":
		initServer(s, &s.trSensitivityLabelsServer, func() *SensitivityLabelsServerTransport {
			return NewSensitivityLabelsServerTransport(&s.srv.SensitivityLabelsServer)
		})
		resp, err = s.trSensitivityLabelsServer.Do(req)
	case "ServerAdvancedThreatProtectionSettingsClient":
		initServer(s, &s.trServerAdvancedThreatProtectionSettingsServer, func() *ServerAdvancedThreatProtectionSettingsServerTransport {
			return NewServerAdvancedThreatProtectionSettingsServerTransport(&s.srv.ServerAdvancedThreatProtectionSettingsServer)
		})
		resp, err = s.trServerAdvancedThreatProtectionSettingsServer.Do(req)
	case "ServerAdvisorsClient":
		initServer(s, &s.trServerAdvisorsServer, func() *ServerAdvisorsServerTransport {
			return NewServerAdvisorsServerTransport(&s.srv.ServerAdvisorsServer)
		})
		resp, err = s.trServerAdvisorsServer.Do(req)
	case "ServerAutomaticTuningClient":
		initServer(s, &s.trServerAutomaticTuningServer, func() *ServerAutomaticTuningServerTransport {
			return NewServerAutomaticTuningServerTransport(&s.srv.ServerAutomaticTuningServer)
		})
		resp, err = s.trServerAutomaticTuningServer.Do(req)
	case "ServerAzureADAdministratorsClient":
		initServer(s, &s.trServerAzureADAdministratorsServer, func() *ServerAzureADAdministratorsServerTransport {
			return NewServerAzureADAdministratorsServerTransport(&s.srv.ServerAzureADAdministratorsServer)
		})
		resp, err = s.trServerAzureADAdministratorsServer.Do(req)
	case "ServerAzureADOnlyAuthenticationsClient":
		initServer(s, &s.trServerAzureADOnlyAuthenticationsServer, func() *ServerAzureADOnlyAuthenticationsServerTransport {
			return NewServerAzureADOnlyAuthenticationsServerTransport(&s.srv.ServerAzureADOnlyAuthenticationsServer)
		})
		resp, err = s.trServerAzureADOnlyAuthenticationsServer.Do(req)
	case "ServerBlobAuditingPoliciesClient":
		initServer(s, &s.trServerBlobAuditingPoliciesServer, func() *ServerBlobAuditingPoliciesServerTransport {
			return NewServerBlobAuditingPoliciesServerTransport(&s.srv.ServerBlobAuditingPoliciesServer)
		})
		resp, err = s.trServerBlobAuditingPoliciesServer.Do(req)
	case "ServerCommunicationLinksClient":
		initServer(s, &s.trServerCommunicationLinksServer, func() *ServerCommunicationLinksServerTransport {
			return NewServerCommunicationLinksServerTransport(&s.srv.ServerCommunicationLinksServer)
		})
		resp, err = s.trServerCommunicationLinksServer.Do(req)
	case "ServerConfigurationOptionsClient":
		initServer(s, &s.trServerConfigurationOptionsServer, func() *ServerConfigurationOptionsServerTransport {
			return NewServerConfigurationOptionsServerTransport(&s.srv.ServerConfigurationOptionsServer)
		})
		resp, err = s.trServerConfigurationOptionsServer.Do(req)
	case "ServerConnectionPoliciesClient":
		initServer(s, &s.trServerConnectionPoliciesServer, func() *ServerConnectionPoliciesServerTransport {
			return NewServerConnectionPoliciesServerTransport(&s.srv.ServerConnectionPoliciesServer)
		})
		resp, err = s.trServerConnectionPoliciesServer.Do(req)
	case "ServerDNSAliasesClient":
		initServer(s, &s.trServerDNSAliasesServer, func() *ServerDNSAliasesServerTransport {
			return NewServerDNSAliasesServerTransport(&s.srv.ServerDNSAliasesServer)
		})
		resp, err = s.trServerDNSAliasesServer.Do(req)
	case "ServerDevOpsAuditSettingsClient":
		initServer(s, &s.trServerDevOpsAuditSettingsServer, func() *ServerDevOpsAuditSettingsServerTransport {
			return NewServerDevOpsAuditSettingsServerTransport(&s.srv.ServerDevOpsAuditSettingsServer)
		})
		resp, err = s.trServerDevOpsAuditSettingsServer.Do(req)
	case "ServerKeysClient":
		initServer(s, &s.trServerKeysServer, func() *ServerKeysServerTransport { return NewServerKeysServerTransport(&s.srv.ServerKeysServer) })
		resp, err = s.trServerKeysServer.Do(req)
	case "ServerOperationsClient":
		initServer(s, &s.trServerOperationsServer, func() *ServerOperationsServerTransport {
			return NewServerOperationsServerTransport(&s.srv.ServerOperationsServer)
		})
		resp, err = s.trServerOperationsServer.Do(req)
	case "ServerSecurityAlertPoliciesClient":
		initServer(s, &s.trServerSecurityAlertPoliciesServer, func() *ServerSecurityAlertPoliciesServerTransport {
			return NewServerSecurityAlertPoliciesServerTransport(&s.srv.ServerSecurityAlertPoliciesServer)
		})
		resp, err = s.trServerSecurityAlertPoliciesServer.Do(req)
	case "ServerTrustCertificatesClient":
		initServer(s, &s.trServerTrustCertificatesServer, func() *ServerTrustCertificatesServerTransport {
			return NewServerTrustCertificatesServerTransport(&s.srv.ServerTrustCertificatesServer)
		})
		resp, err = s.trServerTrustCertificatesServer.Do(req)
	case "ServerTrustGroupsClient":
		initServer(s, &s.trServerTrustGroupsServer, func() *ServerTrustGroupsServerTransport {
			return NewServerTrustGroupsServerTransport(&s.srv.ServerTrustGroupsServer)
		})
		resp, err = s.trServerTrustGroupsServer.Do(req)
	case "ServerUsagesClient":
		initServer(s, &s.trServerUsagesServer, func() *ServerUsagesServerTransport { return NewServerUsagesServerTransport(&s.srv.ServerUsagesServer) })
		resp, err = s.trServerUsagesServer.Do(req)
	case "ServerVulnerabilityAssessmentsClient":
		initServer(s, &s.trServerVulnerabilityAssessmentsServer, func() *ServerVulnerabilityAssessmentsServerTransport {
			return NewServerVulnerabilityAssessmentsServerTransport(&s.srv.ServerVulnerabilityAssessmentsServer)
		})
		resp, err = s.trServerVulnerabilityAssessmentsServer.Do(req)
	case "ServersClient":
		initServer(s, &s.trServersServer, func() *ServersServerTransport { return NewServersServerTransport(&s.srv.ServersServer) })
		resp, err = s.trServersServer.Do(req)
	case "ServiceObjectivesClient":
		initServer(s, &s.trServiceObjectivesServer, func() *ServiceObjectivesServerTransport {
			return NewServiceObjectivesServerTransport(&s.srv.ServiceObjectivesServer)
		})
		resp, err = s.trServiceObjectivesServer.Do(req)
	case "StartStopManagedInstanceSchedulesClient":
		initServer(s, &s.trStartStopManagedInstanceSchedulesServer, func() *StartStopManagedInstanceSchedulesServerTransport {
			return NewStartStopManagedInstanceSchedulesServerTransport(&s.srv.StartStopManagedInstanceSchedulesServer)
		})
		resp, err = s.trStartStopManagedInstanceSchedulesServer.Do(req)
	case "SubscriptionUsagesClient":
		initServer(s, &s.trSubscriptionUsagesServer, func() *SubscriptionUsagesServerTransport {
			return NewSubscriptionUsagesServerTransport(&s.srv.SubscriptionUsagesServer)
		})
		resp, err = s.trSubscriptionUsagesServer.Do(req)
	case "SynapseLinkWorkspacesClient":
		initServer(s, &s.trSynapseLinkWorkspacesServer, func() *SynapseLinkWorkspacesServerTransport {
			return NewSynapseLinkWorkspacesServerTransport(&s.srv.SynapseLinkWorkspacesServer)
		})
		resp, err = s.trSynapseLinkWorkspacesServer.Do(req)
	case "SyncAgentsClient":
		initServer(s, &s.trSyncAgentsServer, func() *SyncAgentsServerTransport { return NewSyncAgentsServerTransport(&s.srv.SyncAgentsServer) })
		resp, err = s.trSyncAgentsServer.Do(req)
	case "SyncGroupsClient":
		initServer(s, &s.trSyncGroupsServer, func() *SyncGroupsServerTransport { return NewSyncGroupsServerTransport(&s.srv.SyncGroupsServer) })
		resp, err = s.trSyncGroupsServer.Do(req)
	case "SyncMembersClient":
		initServer(s, &s.trSyncMembersServer, func() *SyncMembersServerTransport { return NewSyncMembersServerTransport(&s.srv.SyncMembersServer) })
		resp, err = s.trSyncMembersServer.Do(req)
	case "TdeCertificatesClient":
		initServer(s, &s.trTdeCertificatesServer, func() *TdeCertificatesServerTransport {
			return NewTdeCertificatesServerTransport(&s.srv.TdeCertificatesServer)
		})
		resp, err = s.trTdeCertificatesServer.Do(req)
	case "TimeZonesClient":
		initServer(s, &s.trTimeZonesServer, func() *TimeZonesServerTransport { return NewTimeZonesServerTransport(&s.srv.TimeZonesServer) })
		resp, err = s.trTimeZonesServer.Do(req)
	case "TransparentDataEncryptionsClient":
		initServer(s, &s.trTransparentDataEncryptionsServer, func() *TransparentDataEncryptionsServerTransport {
			return NewTransparentDataEncryptionsServerTransport(&s.srv.TransparentDataEncryptionsServer)
		})
		resp, err = s.trTransparentDataEncryptionsServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "VirtualClustersClient":
		initServer(s, &s.trVirtualClustersServer, func() *VirtualClustersServerTransport {
			return NewVirtualClustersServerTransport(&s.srv.VirtualClustersServer)
		})
		resp, err = s.trVirtualClustersServer.Do(req)
	case "VirtualNetworkRulesClient":
		initServer(s, &s.trVirtualNetworkRulesServer, func() *VirtualNetworkRulesServerTransport {
			return NewVirtualNetworkRulesServerTransport(&s.srv.VirtualNetworkRulesServer)
		})
		resp, err = s.trVirtualNetworkRulesServer.Do(req)
	case "VulnerabilityAssessmentBaselineClient":
		initServer(s, &s.trVulnerabilityAssessmentBaselineServer, func() *VulnerabilityAssessmentBaselineServerTransport {
			return NewVulnerabilityAssessmentBaselineServerTransport(&s.srv.VulnerabilityAssessmentBaselineServer)
		})
		resp, err = s.trVulnerabilityAssessmentBaselineServer.Do(req)
	case "VulnerabilityAssessmentBaselinesClient":
		initServer(s, &s.trVulnerabilityAssessmentBaselinesServer, func() *VulnerabilityAssessmentBaselinesServerTransport {
			return NewVulnerabilityAssessmentBaselinesServerTransport(&s.srv.VulnerabilityAssessmentBaselinesServer)
		})
		resp, err = s.trVulnerabilityAssessmentBaselinesServer.Do(req)
	case "VulnerabilityAssessmentExecuteScanClient":
		initServer(s, &s.trVulnerabilityAssessmentExecuteScanServer, func() *VulnerabilityAssessmentExecuteScanServerTransport {
			return NewVulnerabilityAssessmentExecuteScanServerTransport(&s.srv.VulnerabilityAssessmentExecuteScanServer)
		})
		resp, err = s.trVulnerabilityAssessmentExecuteScanServer.Do(req)
	case "VulnerabilityAssessmentRuleBaselineClient":
		initServer(s, &s.trVulnerabilityAssessmentRuleBaselineServer, func() *VulnerabilityAssessmentRuleBaselineServerTransport {
			return NewVulnerabilityAssessmentRuleBaselineServerTransport(&s.srv.VulnerabilityAssessmentRuleBaselineServer)
		})
		resp, err = s.trVulnerabilityAssessmentRuleBaselineServer.Do(req)
	case "VulnerabilityAssessmentRuleBaselinesClient":
		initServer(s, &s.trVulnerabilityAssessmentRuleBaselinesServer, func() *VulnerabilityAssessmentRuleBaselinesServerTransport {
			return NewVulnerabilityAssessmentRuleBaselinesServerTransport(&s.srv.VulnerabilityAssessmentRuleBaselinesServer)
		})
		resp, err = s.trVulnerabilityAssessmentRuleBaselinesServer.Do(req)
	case "VulnerabilityAssessmentScanResultClient":
		initServer(s, &s.trVulnerabilityAssessmentScanResultServer, func() *VulnerabilityAssessmentScanResultServerTransport {
			return NewVulnerabilityAssessmentScanResultServerTransport(&s.srv.VulnerabilityAssessmentScanResultServer)
		})
		resp, err = s.trVulnerabilityAssessmentScanResultServer.Do(req)
	case "VulnerabilityAssessmentScansClient":
		initServer(s, &s.trVulnerabilityAssessmentScansServer, func() *VulnerabilityAssessmentScansServerTransport {
			return NewVulnerabilityAssessmentScansServerTransport(&s.srv.VulnerabilityAssessmentScansServer)
		})
		resp, err = s.trVulnerabilityAssessmentScansServer.Do(req)
	case "VulnerabilityAssessmentsClient":
		initServer(s, &s.trVulnerabilityAssessmentsServer, func() *VulnerabilityAssessmentsServerTransport {
			return NewVulnerabilityAssessmentsServerTransport(&s.srv.VulnerabilityAssessmentsServer)
		})
		resp, err = s.trVulnerabilityAssessmentsServer.Do(req)
	case "VulnerabilityAssessmentsSettingsClient":
		initServer(s, &s.trVulnerabilityAssessmentsSettingsServer, func() *VulnerabilityAssessmentsSettingsServerTransport {
			return NewVulnerabilityAssessmentsSettingsServerTransport(&s.srv.VulnerabilityAssessmentsSettingsServer)
		})
		resp, err = s.trVulnerabilityAssessmentsSettingsServer.Do(req)
	case "WorkloadClassifiersClient":
		initServer(s, &s.trWorkloadClassifiersServer, func() *WorkloadClassifiersServerTransport {
			return NewWorkloadClassifiersServerTransport(&s.srv.WorkloadClassifiersServer)
		})
		resp, err = s.trWorkloadClassifiersServer.Do(req)
	case "WorkloadGroupsClient":
		initServer(s, &s.trWorkloadGroupsServer, func() *WorkloadGroupsServerTransport {
			return NewWorkloadGroupsServerTransport(&s.srv.WorkloadGroupsServer)
		})
		resp, err = s.trWorkloadGroupsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
