//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DataWarehouseUserActivitiesServer is a fake server for instances of the armsql.DataWarehouseUserActivitiesClient type.
type DataWarehouseUserActivitiesServer struct {
	// Get is the fake for method DataWarehouseUserActivitiesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, dataWarehouseUserActivityName armsql.DataWarehouseUserActivityName, options *armsql.DataWarehouseUserActivitiesClientGetOptions) (resp azfake.Responder[armsql.DataWarehouseUserActivitiesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method DataWarehouseUserActivitiesClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, serverName string, databaseName string, options *armsql.DataWarehouseUserActivitiesClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.DataWarehouseUserActivitiesClientListByDatabaseResponse])
}

// NewDataWarehouseUserActivitiesServerTransport creates a new instance of DataWarehouseUserActivitiesServerTransport with the provided implementation.
// The returned DataWarehouseUserActivitiesServerTransport instance is connected to an instance of armsql.DataWarehouseUserActivitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataWarehouseUserActivitiesServerTransport(srv *DataWarehouseUserActivitiesServer) *DataWarehouseUserActivitiesServerTransport {
	return &DataWarehouseUserActivitiesServerTransport{
		srv:                    srv,
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.DataWarehouseUserActivitiesClientListByDatabaseResponse]](),
	}
}

// DataWarehouseUserActivitiesServerTransport connects instances of armsql.DataWarehouseUserActivitiesClient to instances of DataWarehouseUserActivitiesServer.
// Don't use this type directly, use NewDataWarehouseUserActivitiesServerTransport instead.
type DataWarehouseUserActivitiesServerTransport struct {
	srv                    *DataWarehouseUserActivitiesServer
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.DataWarehouseUserActivitiesClientListByDatabaseResponse]]
}

// Do implements the policy.Transporter interface for DataWarehouseUserActivitiesServerTransport.
func (d *DataWarehouseUserActivitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataWarehouseUserActivitiesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataWarehouseUserActivitiesClient.NewListByDatabasePager":
		resp, err = d.dispatchNewListByDatabasePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataWarehouseUserActivitiesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataWarehouseUserActivities/(?P<dataWarehouseUserActivityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	dataWarehouseUserActivityNameParam, err := parseWithCast(matches[regex.SubexpIndex("dataWarehouseUserActivityName")], func(v string) (armsql.DataWarehouseUserActivityName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.DataWarehouseUserActivityName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, dataWarehouseUserActivityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataWarehouseUserActivities, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataWarehouseUserActivitiesServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := d.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataWarehouseUserActivities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByDatabasePager(resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		newListByDatabasePager = &resp
		d.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.DataWarehouseUserActivitiesClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		d.newListByDatabasePager.remove(req)
	}
	return resp, nil
}
