//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedapplications

import "time"

// AllowedUpgradePlansResult - The array of plan.
type AllowedUpgradePlansResult struct {
	// The array of plans.
	Value []*Plan
}

// Application - Information about managed application.
type Application struct {
	// REQUIRED; The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string

	// REQUIRED; The managed application properties.
	Properties *ApplicationProperties

	// The identity of the resource.
	Identity *Identity

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The plan information.
	Plan *Plan

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationArtifact - Managed application artifact.
type ApplicationArtifact struct {
	// REQUIRED; The managed application artifact name.
	Name *ApplicationArtifactName

	// REQUIRED; The managed application artifact type.
	Type *ApplicationArtifactType

	// REQUIRED; The managed application artifact blob uri.
	URI *string
}

// ApplicationAuthorization - The managed application provider authorization.
type ApplicationAuthorization struct {
	// REQUIRED; The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the
	// managed application resources.
	PrincipalID *string

	// REQUIRED; The provider's role definition identifier. This role will define all the permissions that the provider must have
	// on the managed application's container resource group. This role definition cannot have
	// permission to delete the resource group.
	RoleDefinitionID *string
}

// ApplicationBillingDetailsDefinition - Managed application billing details definition.
type ApplicationBillingDetailsDefinition struct {
	// The managed application resource usage Id.
	ResourceUsageID *string
}

// ApplicationClientDetails - The application client details to track the entity creating/updating the managed app resource.
type ApplicationClientDetails struct {
	// The client application Id.
	ApplicationID *string

	// The client Oid.
	Oid *string

	// The client Puid
	Puid *string
}

// ApplicationDefinition - Information about managed application definition.
type ApplicationDefinition struct {
	// REQUIRED; The managed application definition properties.
	Properties *ApplicationDefinitionProperties

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationDefinitionArtifact - Application definition artifact.
type ApplicationDefinitionArtifact struct {
	// REQUIRED; The managed application definition artifact name.
	Name *ApplicationDefinitionArtifactName

	// REQUIRED; The managed application definition artifact type.
	Type *ApplicationArtifactType

	// REQUIRED; The managed application definition artifact blob uri.
	URI *string
}

// ApplicationDefinitionListResult - List of managed application definitions.
type ApplicationDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of managed application definitions.
	Value []*ApplicationDefinition
}

// ApplicationDefinitionPatchable - Information about an application definition request.
type ApplicationDefinitionPatchable struct {
	// Application definition tags
	Tags map[string]*string
}

// ApplicationDefinitionProperties - The managed application definition properties.
type ApplicationDefinitionProperties struct {
	// REQUIRED; The managed application lock level.
	LockLevel *ApplicationLockLevel

	// The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the
	// user experience of creating a managed application from a managed application
	// definition.
	Artifacts []*ApplicationDefinitionArtifact

	// The managed application provider authorizations.
	Authorizations []*ApplicationAuthorization

	// The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject
	// or well-formed JSON string.
	CreateUIDefinition any

	// The managed application deployment policy.
	DeploymentPolicy *ApplicationDeploymentPolicy

	// The managed application definition description.
	Description *string

	// The managed application definition display name.
	DisplayName *string

	// A value indicating whether the package is enabled or not.
	IsEnabled *bool

	// The managed application locking policy.
	LockingPolicy *ApplicationPackageLockingPolicyDefinition

	// The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
	MainTemplate any

	// The managed application management policy that determines publisher's access to the managed resource group.
	ManagementPolicy *ApplicationManagementPolicy

	// The managed application notification policy.
	NotificationPolicy *ApplicationNotificationPolicy

	// The managed application definition package file Uri. Use this element
	PackageFileURI *string

	// The managed application provider policies.
	Policies []*ApplicationPolicy

	// The storage account id for bring your own storage scenario.
	StorageAccountID *string
}

// ApplicationDeploymentPolicy - Managed application deployment policy.
type ApplicationDeploymentPolicy struct {
	// REQUIRED; The managed application deployment mode.
	DeploymentMode *DeploymentMode
}

// ApplicationJitAccessPolicy - Managed application Jit access policy.
type ApplicationJitAccessPolicy struct {
	// REQUIRED; Whether the JIT access is enabled.
	JitAccessEnabled *bool

	// JIT approval mode.
	JitApprovalMode *JitApprovalMode

	// The JIT approvers
	JitApprovers []*JitApproverDefinition

	// The maximum duration JIT access is granted. This is an ISO8601 time period value.
	MaximumJitAccessDuration *string
}

// ApplicationListResult - List of managed applications.
type ApplicationListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of managed applications.
	Value []*Application
}

// ApplicationManagementPolicy - Managed application management policy.
type ApplicationManagementPolicy struct {
	// The managed application management mode.
	Mode *ApplicationManagementMode
}

// ApplicationNotificationEndpoint - Managed application notification endpoint.
type ApplicationNotificationEndpoint struct {
	// REQUIRED; The managed application notification endpoint uri.
	URI *string
}

// ApplicationNotificationPolicy - Managed application notification policy.
type ApplicationNotificationPolicy struct {
	// REQUIRED; The managed application notification endpoint.
	NotificationEndpoints []*ApplicationNotificationEndpoint
}

// ApplicationPackageContact - The application package contact information.
type ApplicationPackageContact struct {
	// REQUIRED; The contact email.
	Email *string

	// REQUIRED; The contact phone number.
	Phone *string

	// The contact name.
	ContactName *string
}

// ApplicationPackageLockingPolicyDefinition - Managed application locking policy.
type ApplicationPackageLockingPolicyDefinition struct {
	// The deny assignment excluded actions.
	AllowedActions []*string

	// The deny assignment excluded data actions.
	AllowedDataActions []*string
}

// ApplicationPackageSupportUrls - The appliance package support URLs.
type ApplicationPackageSupportUrls struct {
	// The government cloud support URL.
	GovernmentCloud *string

	// The public azure support URL.
	PublicAzure *string
}

// ApplicationPatchable - Information about managed application.
type ApplicationPatchable struct {
	// The identity of the resource.
	Identity *Identity

	// The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string

	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The plan information.
	Plan *PlanPatchable

	// The managed application properties.
	Properties *ApplicationProperties

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationPolicy - Managed application policy.
type ApplicationPolicy struct {
	// The policy name
	Name *string

	// The policy parameters.
	Parameters *string

	// The policy definition Id.
	PolicyDefinitionID *string
}

// ApplicationProperties - The managed application properties.
type ApplicationProperties struct {
	// The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string

	// The managed application Jit access policy.
	JitAccessPolicy *ApplicationJitAccessPolicy

	// The managed resource group Id.
	ManagedResourceGroupID *string

	// Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters any

	// READ-ONLY; The collection of managed application artifacts.
	Artifacts []*ApplicationArtifact

	// READ-ONLY; The read-only authorizations property that is retrieved from the application package.
	Authorizations []*ApplicationAuthorization

	// READ-ONLY; The managed application billing details.
	BillingDetails *ApplicationBillingDetailsDefinition

	// READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails

	// READ-ONLY; The read-only customer support property that is retrieved from the application package.
	CustomerSupport *ApplicationPackageContact

	// READ-ONLY; The managed application management mode.
	ManagementMode *ApplicationManagementMode

	// READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs any

	// READ-ONLY; The managed application provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher tenant Id.
	PublisherTenantID *string

	// READ-ONLY; The read-only support URLs property that is retrieved from the application package.
	SupportUrls *ApplicationPackageSupportUrls

	// READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// GenericResource - Resource information.
type GenericResource struct {
	// Resource location
	Location *string

	// ID of the resource that manages this resource.
	ManagedBy *string

	// The SKU of the resource.
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedResourceIdentity

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// JitApproverDefinition - JIT approver definition.
type JitApproverDefinition struct {
	// REQUIRED; The approver service principal Id.
	ID *string

	// The approver display name.
	DisplayName *string

	// The approver type.
	Type *JitApproverType
}

// JitAuthorizationPolicies - The JIT authorization policies.
type JitAuthorizationPolicies struct {
	// REQUIRED; The the principal id that will be granted JIT access.
	PrincipalID *string

	// REQUIRED; The role definition id that will be granted to the Principal.
	RoleDefinitionID *string
}

// JitRequestDefinition - Information about JIT request definition.
type JitRequestDefinition struct {
	// Resource location
	Location *string

	// The JIT request properties.
	Properties *JitRequestProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// JitRequestDefinitionListResult - List of JIT requests.
type JitRequestDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of Jit request definition.
	Value []*JitRequestDefinition
}

// JitRequestMetadata - The JIT request metadata.
type JitRequestMetadata struct {
	// The origin request id.
	OriginRequestID *string

	// The requestor id.
	RequestorID *string

	// The subject display name.
	SubjectDisplayName *string

	// The publisher's tenant name.
	TenantDisplayName *string
}

// JitRequestPatchable - Information about JIT request.
type JitRequestPatchable struct {
	// Jit request tags
	Tags map[string]*string
}

// JitRequestProperties - Information about JIT request properties
type JitRequestProperties struct {
	// REQUIRED; The parent application id.
	ApplicationResourceID *string

	// REQUIRED; The JIT authorization policies.
	JitAuthorizationPolicies []*JitAuthorizationPolicies

	// REQUIRED; The JIT request properties.
	JitSchedulingPolicy *JitSchedulingPolicy

	// READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails

	// READ-ONLY; The JIT request state.
	JitRequestState *JitRequestState

	// READ-ONLY; The JIT request provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher tenant id.
	PublisherTenantID *string

	// READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails
}

// JitSchedulingPolicy - The JIT scheduling policies.
type JitSchedulingPolicy struct {
	// REQUIRED; The required duration of the JIT request.
	Duration *string

	// REQUIRED; The start time of the request.
	StartTime *time.Time

	// REQUIRED; The type of JIT schedule.
	Type *JitSchedulingType
}

// ListTokenRequest - List token request body.
type ListTokenRequest struct {
	// The authorization audience.
	AuthorizationAudience *string

	// The user assigned identities.
	UserAssignedIdentities []*string
}

// ManagedIdentityToken - The managed identity token for the managed app resource.
type ManagedIdentityToken struct {
	// The requested access token.
	AccessToken *string

	// The aud (audience) the access token was request for. This is the same as what was provided in the listTokens request.
	AuthorizationAudience *string

	// The number of seconds the access token will be valid.
	ExpiresIn *string

	// The timespan when the access token expires. This is represented as the number of seconds from epoch.
	ExpiresOn *string

	// The timespan when the access token takes effect. This is represented as the number of seconds from epoch.
	NotBefore *string

	// The Azure resource ID for the issued token. This is either the managed application ID or the user-assigned identity ID.
	ResourceID *string

	// The type of the token.
	TokenType *string
}

// ManagedIdentityTokenResult - The array of managed identity tokens.
type ManagedIdentityTokenResult struct {
	// The array of managed identity tokens.
	Value []*ManagedIdentityToken
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// Plan for the managed application.
type Plan struct {
	// REQUIRED; The plan name.
	Name *string

	// REQUIRED; The product code.
	Product *string

	// REQUIRED; The publisher ID.
	Publisher *string

	// REQUIRED; The plan's version.
	Version *string

	// The promotion code.
	PromotionCode *string
}

// PlanPatchable - Plan for the managed application.
type PlanPatchable struct {
	// The plan name.
	Name *string

	// The product code.
	Product *string

	// The promotion code.
	PromotionCode *string

	// The publisher ID.
	Publisher *string

	// The plan's version.
	Version *string
}

// Resource information.
type Resource struct {
	// Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// SKU for the resource.
type SKU struct {
	// REQUIRED; The SKU name.
	Name *string

	// The SKU capacity.
	Capacity *int32

	// The SKU family.
	Family *string

	// The SKU model.
	Model *string

	// The SKU size.
	Size *string

	// The SKU tier.
	Tier *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpdateAccessDefinition - Update access request definition.
type UpdateAccessDefinition struct {
	// REQUIRED; The JIT request metadata.
	Metadata *JitRequestMetadata

	// REQUIRED; The JIT status.
	Status *Status

	// REQUIRED; The JIT status.
	SubStatus *Substatus

	// The approver name.
	Approver *string
}

// UserAssignedResourceIdentity - Represents the user assigned identity that is contained within the UserAssignedIdentities
// dictionary on ResourceIdentity
type UserAssignedResourceIdentity struct {
	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string

	// READ-ONLY; The tenant id of user assigned identity.
	TenantID *string
}
