//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"regexp"
)

// MdeOnboardingsServer is a fake server for instances of the armsecurity.MdeOnboardingsClient type.
type MdeOnboardingsServer struct {
	// Get is the fake for method MdeOnboardingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armsecurity.MdeOnboardingsClientGetOptions) (resp azfake.Responder[armsecurity.MdeOnboardingsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method MdeOnboardingsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsecurity.MdeOnboardingsClientListOptions) (resp azfake.Responder[armsecurity.MdeOnboardingsClientListResponse], errResp azfake.ErrorResponder)
}

// NewMdeOnboardingsServerTransport creates a new instance of MdeOnboardingsServerTransport with the provided implementation.
// The returned MdeOnboardingsServerTransport instance is connected to an instance of armsecurity.MdeOnboardingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMdeOnboardingsServerTransport(srv *MdeOnboardingsServer) *MdeOnboardingsServerTransport {
	return &MdeOnboardingsServerTransport{srv: srv}
}

// MdeOnboardingsServerTransport connects instances of armsecurity.MdeOnboardingsClient to instances of MdeOnboardingsServer.
// Don't use this type directly, use NewMdeOnboardingsServerTransport instead.
type MdeOnboardingsServerTransport struct {
	srv *MdeOnboardingsServer
}

// Do implements the policy.Transporter interface for MdeOnboardingsServerTransport.
func (m *MdeOnboardingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MdeOnboardingsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MdeOnboardingsClient.List":
		resp, err = m.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MdeOnboardingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/mdeOnboardings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := m.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MdeOnboardingData, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MdeOnboardingsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if m.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/mdeOnboardings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := m.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MdeOnboardingDataList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
