//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// DiscoveredSecuritySolutionsServer is a fake server for instances of the armsecurity.DiscoveredSecuritySolutionsClient type.
type DiscoveredSecuritySolutionsServer struct {
	// Get is the fake for method DiscoveredSecuritySolutionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, ascLocation string, discoveredSecuritySolutionName string, options *armsecurity.DiscoveredSecuritySolutionsClientGetOptions) (resp azfake.Responder[armsecurity.DiscoveredSecuritySolutionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DiscoveredSecuritySolutionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.DiscoveredSecuritySolutionsClientListOptions) (resp azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListResponse])

	// NewListByHomeRegionPager is the fake for method DiscoveredSecuritySolutionsClient.NewListByHomeRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByHomeRegionPager func(ascLocation string, options *armsecurity.DiscoveredSecuritySolutionsClientListByHomeRegionOptions) (resp azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListByHomeRegionResponse])
}

// NewDiscoveredSecuritySolutionsServerTransport creates a new instance of DiscoveredSecuritySolutionsServerTransport with the provided implementation.
// The returned DiscoveredSecuritySolutionsServerTransport instance is connected to an instance of armsecurity.DiscoveredSecuritySolutionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiscoveredSecuritySolutionsServerTransport(srv *DiscoveredSecuritySolutionsServer) *DiscoveredSecuritySolutionsServerTransport {
	return &DiscoveredSecuritySolutionsServerTransport{
		srv:                      srv,
		newListPager:             newTracker[azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListResponse]](),
		newListByHomeRegionPager: newTracker[azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListByHomeRegionResponse]](),
	}
}

// DiscoveredSecuritySolutionsServerTransport connects instances of armsecurity.DiscoveredSecuritySolutionsClient to instances of DiscoveredSecuritySolutionsServer.
// Don't use this type directly, use NewDiscoveredSecuritySolutionsServerTransport instead.
type DiscoveredSecuritySolutionsServerTransport struct {
	srv                      *DiscoveredSecuritySolutionsServer
	newListPager             *tracker[azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListResponse]]
	newListByHomeRegionPager *tracker[azfake.PagerResponder[armsecurity.DiscoveredSecuritySolutionsClientListByHomeRegionResponse]]
}

// Do implements the policy.Transporter interface for DiscoveredSecuritySolutionsServerTransport.
func (d *DiscoveredSecuritySolutionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiscoveredSecuritySolutionsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DiscoveredSecuritySolutionsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DiscoveredSecuritySolutionsClient.NewListByHomeRegionPager":
		resp, err = d.dispatchNewListByHomeRegionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiscoveredSecuritySolutionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discoveredSecuritySolutions/(?P<discoveredSecuritySolutionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	discoveredSecuritySolutionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("discoveredSecuritySolutionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, ascLocationParam, discoveredSecuritySolutionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiscoveredSecuritySolution, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiscoveredSecuritySolutionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/discoveredSecuritySolutions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListPager(nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.DiscoveredSecuritySolutionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DiscoveredSecuritySolutionsServerTransport) dispatchNewListByHomeRegionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByHomeRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByHomeRegionPager not implemented")}
	}
	newListByHomeRegionPager := d.newListByHomeRegionPager.get(req)
	if newListByHomeRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discoveredSecuritySolutions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByHomeRegionPager(ascLocationParam, nil)
		newListByHomeRegionPager = &resp
		d.newListByHomeRegionPager.add(req, newListByHomeRegionPager)
		server.PagerResponderInjectNextLinks(newListByHomeRegionPager, req, func(page *armsecurity.DiscoveredSecuritySolutionsClientListByHomeRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByHomeRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByHomeRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByHomeRegionPager) {
		d.newListByHomeRegionPager.remove(req)
	}
	return resp, nil
}
