//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsubscriptions_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armsubscriptions"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4f4073bdb028bc84bc3e6405c1cbaf8e89b83caf/specification/resources/resource-manager/Microsoft.Resources/stable/2022-12-01/examples/GetLocations.json
func ExampleClient_NewListLocationsPager_getLocationsWithASubscriptionId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsubscriptions.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListLocationsPager("a1ffc958-d2c7-493e-9f1e-125a0477f536", &armsubscriptions.ClientListLocationsOptions{IncludeExtendedLocations: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LocationListResult = armsubscriptions.LocationListResult{
		// 	Value: []*armsubscriptions.Location{
		// 		{
		// 			Name: to.Ptr("eastus"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeRegion),
		// 			AvailabilityZoneMappings: []*armsubscriptions.AvailabilityZoneMappings{
		// 				{
		// 					LogicalZone: to.Ptr("1"),
		// 					PhysicalZone: to.Ptr("eastus-az1"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("2"),
		// 					PhysicalZone: to.Ptr("eastus-az3"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("3"),
		// 					PhysicalZone: to.Ptr("eastus-az2"),
		// 			}},
		// 			DisplayName: to.Ptr("East US"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/eastus"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("37.3719"),
		// 				Longitude: to.Ptr("-79.8164"),
		// 				PairedRegion: []*armsubscriptions.PairedRegion{
		// 					{
		// 						Name: to.Ptr("westus"),
		// 						ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/westus"),
		// 				}},
		// 				PhysicalLocation: to.Ptr("Virginia"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryRecommended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) East US"),
		// 		},
		// 		{
		// 			Name: to.Ptr("eastus2"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeRegion),
		// 			AvailabilityZoneMappings: []*armsubscriptions.AvailabilityZoneMappings{
		// 				{
		// 					LogicalZone: to.Ptr("1"),
		// 					PhysicalZone: to.Ptr("eastus2-az1"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("2"),
		// 					PhysicalZone: to.Ptr("eastus2-az3"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("3"),
		// 					PhysicalZone: to.Ptr("eastus2-az2"),
		// 			}},
		// 			DisplayName: to.Ptr("East US 2"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/eastus2"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("36.6681"),
		// 				Longitude: to.Ptr("-78.3889"),
		// 				PairedRegion: []*armsubscriptions.PairedRegion{
		// 					{
		// 						Name: to.Ptr("centralus"),
		// 						ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/centralus"),
		// 				}},
		// 				PhysicalLocation: to.Ptr("Virginia"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryRecommended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) East US 2"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4f4073bdb028bc84bc3e6405c1cbaf8e89b83caf/specification/resources/resource-manager/Microsoft.Resources/stable/2022-12-01/examples/GetLocationsWithExtendedLocations.json
func ExampleClient_NewListLocationsPager_getLocationsWithExtendedLocations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsubscriptions.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListLocationsPager("a1ffc958-d2c7-493e-9f1e-125a0477f536", &armsubscriptions.ClientListLocationsOptions{IncludeExtendedLocations: to.Ptr(true)})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LocationListResult = armsubscriptions.LocationListResult{
		// 	Value: []*armsubscriptions.Location{
		// 		{
		// 			Name: to.Ptr("eastus"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeRegion),
		// 			AvailabilityZoneMappings: []*armsubscriptions.AvailabilityZoneMappings{
		// 				{
		// 					LogicalZone: to.Ptr("1"),
		// 					PhysicalZone: to.Ptr("eastus-az1"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("2"),
		// 					PhysicalZone: to.Ptr("eastus-az3"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("3"),
		// 					PhysicalZone: to.Ptr("eastus-az2"),
		// 			}},
		// 			DisplayName: to.Ptr("East US"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/eastus"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("37.3719"),
		// 				Longitude: to.Ptr("-79.8164"),
		// 				PairedRegion: []*armsubscriptions.PairedRegion{
		// 					{
		// 						Name: to.Ptr("westus"),
		// 						ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/westus"),
		// 				}},
		// 				PhysicalLocation: to.Ptr("Virginia"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryRecommended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) East US"),
		// 		},
		// 		{
		// 			Name: to.Ptr("eastus2"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeRegion),
		// 			AvailabilityZoneMappings: []*armsubscriptions.AvailabilityZoneMappings{
		// 				{
		// 					LogicalZone: to.Ptr("1"),
		// 					PhysicalZone: to.Ptr("eastus2-az1"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("2"),
		// 					PhysicalZone: to.Ptr("eastus2-az3"),
		// 				},
		// 				{
		// 					LogicalZone: to.Ptr("3"),
		// 					PhysicalZone: to.Ptr("eastus2-az2"),
		// 			}},
		// 			DisplayName: to.Ptr("East US 2"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/eastus2"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("36.6681"),
		// 				Longitude: to.Ptr("-78.3889"),
		// 				PairedRegion: []*armsubscriptions.PairedRegion{
		// 					{
		// 						Name: to.Ptr("centralus"),
		// 						ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/centralus"),
		// 				}},
		// 				PhysicalLocation: to.Ptr("Virginia"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryRecommended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) East US 2"),
		// 		},
		// 		{
		// 			Name: to.Ptr("ezecustomerlabboston1"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeEdgeZone),
		// 			DisplayName: to.Ptr("EZE Customer Lab Boston 1"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/eastus/edgeZones/ezecustomerlabboston1"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("42.301218"),
		// 				Longitude: to.Ptr("-71.219038"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryExtended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) EZE Customer Lab Boston 1"),
		// 		},
		// 		{
		// 			Name: to.Ptr("ezecustomerlabhouston1"),
		// 			Type: to.Ptr(armsubscriptions.LocationTypeEdgeZone),
		// 			DisplayName: to.Ptr("EZE Customer Lab Houston 1"),
		// 			ID: to.Ptr("/subscriptions/a1ffc958-d2c7-493e-9f1e-125a0477f536/locations/southcentralus/edgeZones/ezecustomerlabhouston1"),
		// 			Metadata: &armsubscriptions.LocationMetadata{
		// 				Geography: to.Ptr("United States"),
		// 				GeographyGroup: to.Ptr("US"),
		// 				Latitude: to.Ptr("29.9411"),
		// 				Longitude: to.Ptr("-95.41452"),
		// 				RegionCategory: to.Ptr(armsubscriptions.RegionCategoryExtended),
		// 				RegionType: to.Ptr(armsubscriptions.RegionTypePhysical),
		// 			},
		// 			RegionalDisplayName: to.Ptr("(US) EZE Customer Lab Houston 1"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4f4073bdb028bc84bc3e6405c1cbaf8e89b83caf/specification/resources/resource-manager/Microsoft.Resources/stable/2022-12-01/examples/GetSubscription.json
func ExampleClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsubscriptions.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "291bba3f-e0a5-47bc-a099-3bdcb2a50a05", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Subscription = armsubscriptions.Subscription{
	// 	AuthorizationSource: to.Ptr("Bypassed"),
	// 	DisplayName: to.Ptr("Example Subscription"),
	// 	ID: to.Ptr("/subscriptions/291bba3f-e0a5-47bc-a099-3bdcb2a50a05"),
	// 	ManagedByTenants: []*armsubscriptions.ManagedByTenant{
	// 		{
	// 			TenantID: to.Ptr("8f70baf1-1f6e-46a2-a1ff-238dac1ebfb7"),
	// 	}},
	// 	State: to.Ptr(armsubscriptions.SubscriptionStateEnabled),
	// 	SubscriptionID: to.Ptr("291bba3f-e0a5-47bc-a099-3bdcb2a50a05"),
	// 	SubscriptionPolicies: &armsubscriptions.SubscriptionPolicies{
	// 		LocationPlacementID: to.Ptr("Internal_2014-09-01"),
	// 		QuotaID: to.Ptr("Internal_2014-09-01"),
	// 		SpendingLimit: to.Ptr(armsubscriptions.SpendingLimitOff),
	// 	},
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("tagValue1"),
	// 		"tagKey2": to.Ptr("tagValue2"),
	// 	},
	// 	TenantID: to.Ptr("31c75423-32d6-4322-88b7-c478bdde4858"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4f4073bdb028bc84bc3e6405c1cbaf8e89b83caf/specification/resources/resource-manager/Microsoft.Resources/stable/2022-12-01/examples/GetSubscriptions.json
func ExampleClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsubscriptions.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionListResult = armsubscriptions.SubscriptionListResult{
		// 	Value: []*armsubscriptions.Subscription{
		// 		{
		// 			AuthorizationSource: to.Ptr("RoleBased"),
		// 			DisplayName: to.Ptr("Example Subscription"),
		// 			ID: to.Ptr("/subscriptions/291bba3f-e0a5-47bc-a099-3bdcb2a50a05"),
		// 			ManagedByTenants: []*armsubscriptions.ManagedByTenant{
		// 				{
		// 					TenantID: to.Ptr("8f70baf1-1f6e-46a2-a1ff-238dac1ebfb7"),
		// 			}},
		// 			State: to.Ptr(armsubscriptions.SubscriptionStateEnabled),
		// 			SubscriptionID: to.Ptr("291bba3f-e0a5-47bc-a099-3bdcb2a50a05"),
		// 			SubscriptionPolicies: &armsubscriptions.SubscriptionPolicies{
		// 				LocationPlacementID: to.Ptr("Internal_2014-09-01"),
		// 				QuotaID: to.Ptr("Internal_2014-09-01"),
		// 				SpendingLimit: to.Ptr(armsubscriptions.SpendingLimitOff),
		// 			},
		// 			Tags: map[string]*string{
		// 				"tagKey1": to.Ptr("tagValue1"),
		// 				"tagKey2": to.Ptr("tagValue2"),
		// 			},
		// 			TenantID: to.Ptr("31c75423-32d6-4322-88b7-c478bdde4858"),
		// 		},
		// 		{
		// 			AuthorizationSource: to.Ptr("RoleBased"),
		// 			DisplayName: to.Ptr("Example Subscription2"),
		// 			ID: to.Ptr("/subscriptions/72ac930a-f34e-42d8-b06d-dc2a9e12ed71"),
		// 			ManagedByTenants: []*armsubscriptions.ManagedByTenant{
		// 				{
		// 					TenantID: to.Ptr("8f70baf1-1f6e-46a2-a1ff-238dac1ebfb7"),
		// 				},
		// 				{
		// 					TenantID: to.Ptr("f7fb6af2-321d-47c8-9c0f-b0239eaad39a"),
		// 			}},
		// 			State: to.Ptr(armsubscriptions.SubscriptionStateEnabled),
		// 			SubscriptionID: to.Ptr("72ac930a-f34e-42d8-b06d-dc2a9e12ed71"),
		// 			SubscriptionPolicies: &armsubscriptions.SubscriptionPolicies{
		// 				LocationPlacementID: to.Ptr("Internal_2014-09-01"),
		// 				QuotaID: to.Ptr("Internal_2014-09-01"),
		// 				SpendingLimit: to.Ptr(armsubscriptions.SpendingLimitOff),
		// 			},
		// 			Tags: map[string]*string{
		// 				"tagKey1": to.Ptr("tagValue1"),
		// 				"tagKey2": to.Ptr("tagValue2"),
		// 			},
		// 			TenantID: to.Ptr("2a0ff0de-96b2-4859-bb7c-a430d07a3e0c"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4f4073bdb028bc84bc3e6405c1cbaf8e89b83caf/specification/resources/resource-manager/Microsoft.Resources/stable/2022-12-01/examples/PostCheckZonePeers.json
func ExampleClient_CheckZonePeers() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsubscriptions.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().CheckZonePeers(ctx, "8d65815f-a5b6-402f-9298-045155da7d74", armsubscriptions.CheckZonePeersRequest{
		Location: to.Ptr("eastus"),
		SubscriptionIDs: []*string{
			to.Ptr("subscriptions/11111111-1111-1111-1111-111111111111")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckZonePeersResult = armsubscriptions.CheckZonePeersResult{
	// 	AvailabilityZonePeers: []*armsubscriptions.AvailabilityZonePeers{
	// 		{
	// 			AvailabilityZone: to.Ptr("1"),
	// 			Peers: []*armsubscriptions.Peers{
	// 				{
	// 					AvailabilityZone: to.Ptr("3"),
	// 					SubscriptionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 			}},
	// 		},
	// 		{
	// 			AvailabilityZone: to.Ptr("2"),
	// 			Peers: []*armsubscriptions.Peers{
	// 				{
	// 					AvailabilityZone: to.Ptr("2"),
	// 					SubscriptionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 			}},
	// 		},
	// 		{
	// 			AvailabilityZone: to.Ptr("3"),
	// 			Peers: []*armsubscriptions.Peers{
	// 				{
	// 					AvailabilityZone: to.Ptr("1"),
	// 					SubscriptionID: to.Ptr("11111111-1111-1111-1111-111111111111"),
	// 			}},
	// 	}},
	// 	Location: to.Ptr("eastus2"),
	// 	SubscriptionID: to.Ptr("8d65815f-a5b6-402f-9298-045155da7d74"),
	// }
}
