//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
	"net/http"
	"net/url"
	"regexp"
)

// VariableValuesServer is a fake server for instances of the armpolicy.VariableValuesClient type.
type VariableValuesServer struct {
	// CreateOrUpdate is the fake for method VariableValuesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, variableName string, variableValueName string, parameters armpolicy.VariableValue, options *armpolicy.VariableValuesClientCreateOrUpdateOptions) (resp azfake.Responder[armpolicy.VariableValuesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtManagementGroup is the fake for method VariableValuesClient.CreateOrUpdateAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtManagementGroup func(ctx context.Context, managementGroupID string, variableName string, variableValueName string, parameters armpolicy.VariableValue, options *armpolicy.VariableValuesClientCreateOrUpdateAtManagementGroupOptions) (resp azfake.Responder[armpolicy.VariableValuesClientCreateOrUpdateAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method VariableValuesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, variableName string, variableValueName string, options *armpolicy.VariableValuesClientDeleteOptions) (resp azfake.Responder[armpolicy.VariableValuesClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteAtManagementGroup is the fake for method VariableValuesClient.DeleteAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtManagementGroup func(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *armpolicy.VariableValuesClientDeleteAtManagementGroupOptions) (resp azfake.Responder[armpolicy.VariableValuesClientDeleteAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VariableValuesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, variableName string, variableValueName string, options *armpolicy.VariableValuesClientGetOptions) (resp azfake.Responder[armpolicy.VariableValuesClientGetResponse], errResp azfake.ErrorResponder)

	// GetAtManagementGroup is the fake for method VariableValuesClient.GetAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtManagementGroup func(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *armpolicy.VariableValuesClientGetAtManagementGroupOptions) (resp azfake.Responder[armpolicy.VariableValuesClientGetAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VariableValuesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(variableName string, options *armpolicy.VariableValuesClientListOptions) (resp azfake.PagerResponder[armpolicy.VariableValuesClientListResponse])

	// NewListForManagementGroupPager is the fake for method VariableValuesClient.NewListForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForManagementGroupPager func(managementGroupID string, variableName string, options *armpolicy.VariableValuesClientListForManagementGroupOptions) (resp azfake.PagerResponder[armpolicy.VariableValuesClientListForManagementGroupResponse])
}

// NewVariableValuesServerTransport creates a new instance of VariableValuesServerTransport with the provided implementation.
// The returned VariableValuesServerTransport instance is connected to an instance of armpolicy.VariableValuesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVariableValuesServerTransport(srv *VariableValuesServer) *VariableValuesServerTransport {
	return &VariableValuesServerTransport{
		srv:                            srv,
		newListPager:                   newTracker[azfake.PagerResponder[armpolicy.VariableValuesClientListResponse]](),
		newListForManagementGroupPager: newTracker[azfake.PagerResponder[armpolicy.VariableValuesClientListForManagementGroupResponse]](),
	}
}

// VariableValuesServerTransport connects instances of armpolicy.VariableValuesClient to instances of VariableValuesServer.
// Don't use this type directly, use NewVariableValuesServerTransport instead.
type VariableValuesServerTransport struct {
	srv                            *VariableValuesServer
	newListPager                   *tracker[azfake.PagerResponder[armpolicy.VariableValuesClientListResponse]]
	newListForManagementGroupPager *tracker[azfake.PagerResponder[armpolicy.VariableValuesClientListForManagementGroupResponse]]
}

// Do implements the policy.Transporter interface for VariableValuesServerTransport.
func (v *VariableValuesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VariableValuesClient.CreateOrUpdate":
		resp, err = v.dispatchCreateOrUpdate(req)
	case "VariableValuesClient.CreateOrUpdateAtManagementGroup":
		resp, err = v.dispatchCreateOrUpdateAtManagementGroup(req)
	case "VariableValuesClient.Delete":
		resp, err = v.dispatchDelete(req)
	case "VariableValuesClient.DeleteAtManagementGroup":
		resp, err = v.dispatchDeleteAtManagementGroup(req)
	case "VariableValuesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VariableValuesClient.GetAtManagementGroup":
		resp, err = v.dispatchGetAtManagementGroup(req)
	case "VariableValuesClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "VariableValuesClient.NewListForManagementGroupPager":
		resp, err = v.dispatchNewListForManagementGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.VariableValue](req)
	if err != nil {
		return nil, err
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdate(req.Context(), variableNameParam, variableValueNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VariableValue, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchCreateOrUpdateAtManagementGroup(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdateAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.VariableValue](req)
	if err != nil {
		return nil, err
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdateAtManagementGroup(req.Context(), managementGroupIDParam, variableNameParam, variableValueNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VariableValue, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if v.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Delete(req.Context(), variableNameParam, variableValueNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchDeleteAtManagementGroup(req *http.Request) (*http.Response, error) {
	if v.srv.DeleteAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.DeleteAtManagementGroup(req.Context(), managementGroupIDParam, variableNameParam, variableValueNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), variableNameParam, variableValueNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VariableValue, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchGetAtManagementGroup(req *http.Request) (*http.Response, error) {
	if v.srv.GetAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values/(?P<variableValueName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
	if err != nil {
		return nil, err
	}
	variableValueNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableValueName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.GetAtManagementGroup(req.Context(), managementGroupIDParam, variableNameParam, variableValueNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VariableValue, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(variableNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpolicy.VariableValuesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *VariableValuesServerTransport) dispatchNewListForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForManagementGroupPager not implemented")}
	}
	newListForManagementGroupPager := v.newListForManagementGroupPager.get(req)
	if newListForManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/variables/(?P<variableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/values`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		variableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("variableName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListForManagementGroupPager(managementGroupIDParam, variableNameParam, nil)
		newListForManagementGroupPager = &resp
		v.newListForManagementGroupPager.add(req, newListForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListForManagementGroupPager, req, func(page *armpolicy.VariableValuesClientListForManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForManagementGroupPager) {
		v.newListForManagementGroupPager.remove(req)
	}
	return resp, nil
}
