//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armfeatures"
	"net/http"
)

// FeatureServer is a fake server for instances of the armfeatures.FeatureClient type.
type FeatureServer struct {
	// NewListOperationsPager is the fake for method FeatureClient.NewListOperationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOperationsPager func(options *armfeatures.FeatureClientListOperationsOptions) (resp azfake.PagerResponder[armfeatures.FeatureClientListOperationsResponse])
}

// NewFeatureServerTransport creates a new instance of FeatureServerTransport with the provided implementation.
// The returned FeatureServerTransport instance is connected to an instance of armfeatures.FeatureClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFeatureServerTransport(srv *FeatureServer) *FeatureServerTransport {
	return &FeatureServerTransport{
		srv:                    srv,
		newListOperationsPager: newTracker[azfake.PagerResponder[armfeatures.FeatureClientListOperationsResponse]](),
	}
}

// FeatureServerTransport connects instances of armfeatures.FeatureClient to instances of FeatureServer.
// Don't use this type directly, use NewFeatureServerTransport instead.
type FeatureServerTransport struct {
	srv                    *FeatureServer
	newListOperationsPager *tracker[azfake.PagerResponder[armfeatures.FeatureClientListOperationsResponse]]
}

// Do implements the policy.Transporter interface for FeatureServerTransport.
func (f *FeatureServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FeatureClient.NewListOperationsPager":
		resp, err = f.dispatchNewListOperationsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FeatureServerTransport) dispatchNewListOperationsPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListOperationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOperationsPager not implemented")}
	}
	newListOperationsPager := f.newListOperationsPager.get(req)
	if newListOperationsPager == nil {
		resp := f.srv.NewListOperationsPager(nil)
		newListOperationsPager = &resp
		f.newListOperationsPager.add(req, newListOperationsPager)
		server.PagerResponderInjectNextLinks(newListOperationsPager, req, func(page *armfeatures.FeatureClientListOperationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOperationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListOperationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOperationsPager) {
		f.newListOperationsPager.remove(req)
	}
	return resp, nil
}
