//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
	"net/http"
	"net/url"
	"regexp"
)

// QuotaServer is a fake server for instances of the armreservations.QuotaClient type.
type QuotaServer struct {
	// BeginCreateOrUpdate is the fake for method QuotaClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, subscriptionID string, providerID string, location string, resourceName string, createQuotaRequest armreservations.CurrentQuotaLimitBase, options *armreservations.QuotaClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armreservations.QuotaClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method QuotaClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, subscriptionID string, providerID string, location string, resourceName string, options *armreservations.QuotaClientGetOptions) (resp azfake.Responder[armreservations.QuotaClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method QuotaClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(subscriptionID string, providerID string, location string, options *armreservations.QuotaClientListOptions) (resp azfake.PagerResponder[armreservations.QuotaClientListResponse])

	// BeginUpdate is the fake for method QuotaClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, subscriptionID string, providerID string, location string, resourceName string, createQuotaRequest armreservations.CurrentQuotaLimitBase, options *armreservations.QuotaClientBeginUpdateOptions) (resp azfake.PollerResponder[armreservations.QuotaClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewQuotaServerTransport creates a new instance of QuotaServerTransport with the provided implementation.
// The returned QuotaServerTransport instance is connected to an instance of armreservations.QuotaClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewQuotaServerTransport(srv *QuotaServer) *QuotaServerTransport {
	return &QuotaServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armreservations.QuotaClientCreateOrUpdateResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armreservations.QuotaClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armreservations.QuotaClientUpdateResponse]](),
	}
}

// QuotaServerTransport connects instances of armreservations.QuotaClient to instances of QuotaServer.
// Don't use this type directly, use NewQuotaServerTransport instead.
type QuotaServerTransport struct {
	srv                 *QuotaServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armreservations.QuotaClientCreateOrUpdateResponse]]
	newListPager        *tracker[azfake.PagerResponder[armreservations.QuotaClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armreservations.QuotaClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for QuotaServerTransport.
func (q *QuotaServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "QuotaClient.BeginCreateOrUpdate":
		resp, err = q.dispatchBeginCreateOrUpdate(req)
	case "QuotaClient.Get":
		resp, err = q.dispatchGet(req)
	case "QuotaClient.NewListPager":
		resp, err = q.dispatchNewListPager(req)
	case "QuotaClient.BeginUpdate":
		resp, err = q.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (q *QuotaServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if q.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := q.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimits/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armreservations.CurrentQuotaLimitBase](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := q.srv.BeginCreateOrUpdate(req.Context(), subscriptionIDParam, providerIDParam, locationParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		q.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		q.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		q.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (q *QuotaServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if q.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimits/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.Get(req.Context(), subscriptionIDParam, providerIDParam, locationParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CurrentQuotaLimitBase, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (q *QuotaServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if q.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := q.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimits`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := q.srv.NewListPager(subscriptionIDParam, providerIDParam, locationParam, nil)
		newListPager = &resp
		q.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armreservations.QuotaClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		q.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		q.newListPager.remove(req)
	}
	return resp, nil
}

func (q *QuotaServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if q.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := q.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimits/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armreservations.CurrentQuotaLimitBase](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := q.srv.BeginUpdate(req.Context(), subscriptionIDParam, providerIDParam, locationParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		q.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		q.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		q.beginUpdate.remove(req)
	}

	return resp, nil
}
