//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlflexibleservers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FlexibleServerClient contains the methods for the FlexibleServer group.
// Don't use this type directly, use NewFlexibleServerClient() instead.
type FlexibleServerClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFlexibleServerClient creates a new instance of FlexibleServerClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFlexibleServerClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FlexibleServerClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FlexibleServerClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginStartLtrBackup - Start the Long Term Retention Backup operation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serverName - The name of the server.
//   - parameters - Request body for operation
//   - options - FlexibleServerClientBeginStartLtrBackupOptions contains the optional parameters for the FlexibleServerClient.BeginStartLtrBackup
//     method.
func (client *FlexibleServerClient) BeginStartLtrBackup(ctx context.Context, resourceGroupName string, serverName string, parameters LtrBackupRequest, options *FlexibleServerClientBeginStartLtrBackupOptions) (*runtime.Poller[FlexibleServerClientStartLtrBackupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.startLtrBackup(ctx, resourceGroupName, serverName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FlexibleServerClientStartLtrBackupResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FlexibleServerClientStartLtrBackupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// StartLtrBackup - Start the Long Term Retention Backup operation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
func (client *FlexibleServerClient) startLtrBackup(ctx context.Context, resourceGroupName string, serverName string, parameters LtrBackupRequest, options *FlexibleServerClientBeginStartLtrBackupOptions) (*http.Response, error) {
	var err error
	const operationName = "FlexibleServerClient.BeginStartLtrBackup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.startLtrBackupCreateRequest(ctx, resourceGroupName, serverName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// startLtrBackupCreateRequest creates the StartLtrBackup request.
func (client *FlexibleServerClient) startLtrBackupCreateRequest(ctx context.Context, resourceGroupName string, serverName string, parameters LtrBackupRequest, options *FlexibleServerClientBeginStartLtrBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/startLtrBackup"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// TriggerLtrPreBackup - PreBackup operation performs all the checks that are needed for the subsequent long term retention
// backup operation to succeed.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serverName - The name of the server.
//   - parameters - Request body for operation
//   - options - FlexibleServerClientTriggerLtrPreBackupOptions contains the optional parameters for the FlexibleServerClient.TriggerLtrPreBackup
//     method.
func (client *FlexibleServerClient) TriggerLtrPreBackup(ctx context.Context, resourceGroupName string, serverName string, parameters LtrPreBackupRequest, options *FlexibleServerClientTriggerLtrPreBackupOptions) (FlexibleServerClientTriggerLtrPreBackupResponse, error) {
	var err error
	const operationName = "FlexibleServerClient.TriggerLtrPreBackup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.triggerLtrPreBackupCreateRequest(ctx, resourceGroupName, serverName, parameters, options)
	if err != nil {
		return FlexibleServerClientTriggerLtrPreBackupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FlexibleServerClientTriggerLtrPreBackupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FlexibleServerClientTriggerLtrPreBackupResponse{}, err
	}
	resp, err := client.triggerLtrPreBackupHandleResponse(httpResp)
	return resp, err
}

// triggerLtrPreBackupCreateRequest creates the TriggerLtrPreBackup request.
func (client *FlexibleServerClient) triggerLtrPreBackupCreateRequest(ctx context.Context, resourceGroupName string, serverName string, parameters LtrPreBackupRequest, options *FlexibleServerClientTriggerLtrPreBackupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/ltrPreBackup"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// triggerLtrPreBackupHandleResponse handles the TriggerLtrPreBackup response.
func (client *FlexibleServerClient) triggerLtrPreBackupHandleResponse(resp *http.Response) (FlexibleServerClientTriggerLtrPreBackupResponse, error) {
	result := FlexibleServerClientTriggerLtrPreBackupResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.LtrPreBackupResponse); err != nil {
		return FlexibleServerClientTriggerLtrPreBackupResponse{}, err
	}
	return result, nil
}
