//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/orbital/armorbital/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ContactsServer is a fake server for instances of the armorbital.ContactsClient type.
type ContactsServer struct {
	// BeginCreate is the fake for method ContactsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, spacecraftName string, contactName string, parameters armorbital.Contact, options *armorbital.ContactsClientBeginCreateOptions) (resp azfake.PollerResponder[armorbital.ContactsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ContactsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, spacecraftName string, contactName string, options *armorbital.ContactsClientBeginDeleteOptions) (resp azfake.PollerResponder[armorbital.ContactsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ContactsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, spacecraftName string, contactName string, options *armorbital.ContactsClientGetOptions) (resp azfake.Responder[armorbital.ContactsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ContactsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, spacecraftName string, options *armorbital.ContactsClientListOptions) (resp azfake.PagerResponder[armorbital.ContactsClientListResponse])
}

// NewContactsServerTransport creates a new instance of ContactsServerTransport with the provided implementation.
// The returned ContactsServerTransport instance is connected to an instance of armorbital.ContactsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewContactsServerTransport(srv *ContactsServer) *ContactsServerTransport {
	return &ContactsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armorbital.ContactsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armorbital.ContactsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armorbital.ContactsClientListResponse]](),
	}
}

// ContactsServerTransport connects instances of armorbital.ContactsClient to instances of ContactsServer.
// Don't use this type directly, use NewContactsServerTransport instead.
type ContactsServerTransport struct {
	srv          *ContactsServer
	beginCreate  *tracker[azfake.PollerResponder[armorbital.ContactsClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armorbital.ContactsClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armorbital.ContactsClientListResponse]]
}

// Do implements the policy.Transporter interface for ContactsServerTransport.
func (c *ContactsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ContactsClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "ContactsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ContactsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ContactsClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ContactsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Orbital/spacecrafts/(?P<spacecraftName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/contacts/(?P<contactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armorbital.Contact](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		spacecraftNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spacecraftName")])
		if err != nil {
			return nil, err
		}
		contactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("contactName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, spacecraftNameParam, contactNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *ContactsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Orbital/spacecrafts/(?P<spacecraftName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/contacts/(?P<contactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		spacecraftNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spacecraftName")])
		if err != nil {
			return nil, err
		}
		contactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("contactName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, spacecraftNameParam, contactNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ContactsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Orbital/spacecrafts/(?P<spacecraftName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/contacts/(?P<contactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spacecraftNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spacecraftName")])
	if err != nil {
		return nil, err
	}
	contactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("contactName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, spacecraftNameParam, contactNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Contact, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContactsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Orbital/spacecrafts/(?P<spacecraftName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/contacts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		spacecraftNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spacecraftName")])
		if err != nil {
			return nil, err
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armorbital.ContactsClientListOptions
		if skiptokenParam != nil {
			options = &armorbital.ContactsClientListOptions{
				Skiptoken: skiptokenParam,
			}
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, spacecraftNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armorbital.ContactsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
