//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkfunction

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CollectorPoliciesClient contains the methods for the CollectorPolicies group.
// Don't use this type directly, use NewCollectorPoliciesClient() instead.
type CollectorPoliciesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewCollectorPoliciesClient creates a new instance of CollectorPoliciesClient with the specified values.
//   - subscriptionID - Azure Subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewCollectorPoliciesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*CollectorPoliciesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &CollectorPoliciesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates a Collector Policy resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - resourceGroupName - The name of the resource group.
//   - azureTrafficCollectorName - Azure Traffic Collector name
//   - collectorPolicyName - Collector Policy Name
//   - parameters - The parameters to provide for the created Collector Policy.
//   - options - CollectorPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the CollectorPoliciesClient.BeginCreateOrUpdate
//     method.
func (client *CollectorPoliciesClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters CollectorPolicy, options *CollectorPoliciesClientBeginCreateOrUpdateOptions) (*runtime.Poller[CollectorPoliciesClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[CollectorPoliciesClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[CollectorPoliciesClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates a Collector Policy resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
func (client *CollectorPoliciesClient) createOrUpdate(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters CollectorPolicy, options *CollectorPoliciesClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "CollectorPoliciesClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *CollectorPoliciesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters CollectorPolicy, options *CollectorPoliciesClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if azureTrafficCollectorName == "" {
		return nil, errors.New("parameter azureTrafficCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureTrafficCollectorName}", url.PathEscape(azureTrafficCollectorName))
	if collectorPolicyName == "" {
		return nil, errors.New("parameter collectorPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectorPolicyName}", url.PathEscape(collectorPolicyName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a specified Collector Policy resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - resourceGroupName - The name of the resource group.
//   - azureTrafficCollectorName - Azure Traffic Collector name
//   - collectorPolicyName - Collector Policy Name
//   - options - CollectorPoliciesClientBeginDeleteOptions contains the optional parameters for the CollectorPoliciesClient.BeginDelete
//     method.
func (client *CollectorPoliciesClient) BeginDelete(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *CollectorPoliciesClientBeginDeleteOptions) (*runtime.Poller[CollectorPoliciesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[CollectorPoliciesClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[CollectorPoliciesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a specified Collector Policy resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
func (client *CollectorPoliciesClient) deleteOperation(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *CollectorPoliciesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "CollectorPoliciesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *CollectorPoliciesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *CollectorPoliciesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if azureTrafficCollectorName == "" {
		return nil, errors.New("parameter azureTrafficCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureTrafficCollectorName}", url.PathEscape(azureTrafficCollectorName))
	if collectorPolicyName == "" {
		return nil, errors.New("parameter collectorPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectorPolicyName}", url.PathEscape(collectorPolicyName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the collector policy in a specified Traffic Collector
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - resourceGroupName - The name of the resource group.
//   - azureTrafficCollectorName - Azure Traffic Collector name
//   - collectorPolicyName - Collector Policy Name
//   - options - CollectorPoliciesClientGetOptions contains the optional parameters for the CollectorPoliciesClient.Get method.
func (client *CollectorPoliciesClient) Get(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *CollectorPoliciesClientGetOptions) (CollectorPoliciesClientGetResponse, error) {
	var err error
	const operationName = "CollectorPoliciesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, options)
	if err != nil {
		return CollectorPoliciesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CollectorPoliciesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CollectorPoliciesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *CollectorPoliciesClient) getCreateRequest(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *CollectorPoliciesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if azureTrafficCollectorName == "" {
		return nil, errors.New("parameter azureTrafficCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureTrafficCollectorName}", url.PathEscape(azureTrafficCollectorName))
	if collectorPolicyName == "" {
		return nil, errors.New("parameter collectorPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectorPolicyName}", url.PathEscape(collectorPolicyName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *CollectorPoliciesClient) getHandleResponse(resp *http.Response) (CollectorPoliciesClientGetResponse, error) {
	result := CollectorPoliciesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CollectorPolicy); err != nil {
		return CollectorPoliciesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Return list of Collector policies in a Azure Traffic Collector
//
// Generated from API version 2022-11-01
//   - resourceGroupName - The name of the resource group.
//   - azureTrafficCollectorName - Azure Traffic Collector name
//   - options - CollectorPoliciesClientListOptions contains the optional parameters for the CollectorPoliciesClient.NewListPager
//     method.
func (client *CollectorPoliciesClient) NewListPager(resourceGroupName string, azureTrafficCollectorName string, options *CollectorPoliciesClientListOptions) *runtime.Pager[CollectorPoliciesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[CollectorPoliciesClientListResponse]{
		More: func(page CollectorPoliciesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *CollectorPoliciesClientListResponse) (CollectorPoliciesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "CollectorPoliciesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, azureTrafficCollectorName, options)
			}, nil)
			if err != nil {
				return CollectorPoliciesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *CollectorPoliciesClient) listCreateRequest(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, options *CollectorPoliciesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if azureTrafficCollectorName == "" {
		return nil, errors.New("parameter azureTrafficCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureTrafficCollectorName}", url.PathEscape(azureTrafficCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *CollectorPoliciesClient) listHandleResponse(resp *http.Response) (CollectorPoliciesClientListResponse, error) {
	result := CollectorPoliciesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CollectorPolicyListResult); err != nil {
		return CollectorPoliciesClientListResponse{}, err
	}
	return result, nil
}

// UpdateTags - Updates the specified Collector Policy tags.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - resourceGroupName - The name of the resource group.
//   - azureTrafficCollectorName - Azure Traffic Collector name
//   - collectorPolicyName - Collector Policy Name
//   - parameters - Parameters supplied to update Collector Policy tags.
//   - options - CollectorPoliciesClientUpdateTagsOptions contains the optional parameters for the CollectorPoliciesClient.UpdateTags
//     method.
func (client *CollectorPoliciesClient) UpdateTags(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters TagsObject, options *CollectorPoliciesClientUpdateTagsOptions) (CollectorPoliciesClientUpdateTagsResponse, error) {
	var err error
	const operationName = "CollectorPoliciesClient.UpdateTags"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateTagsCreateRequest(ctx, resourceGroupName, azureTrafficCollectorName, collectorPolicyName, parameters, options)
	if err != nil {
		return CollectorPoliciesClientUpdateTagsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CollectorPoliciesClientUpdateTagsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CollectorPoliciesClientUpdateTagsResponse{}, err
	}
	resp, err := client.updateTagsHandleResponse(httpResp)
	return resp, err
}

// updateTagsCreateRequest creates the UpdateTags request.
func (client *CollectorPoliciesClient) updateTagsCreateRequest(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters TagsObject, options *CollectorPoliciesClientUpdateTagsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if azureTrafficCollectorName == "" {
		return nil, errors.New("parameter azureTrafficCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureTrafficCollectorName}", url.PathEscape(azureTrafficCollectorName))
	if collectorPolicyName == "" {
		return nil, errors.New("parameter collectorPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectorPolicyName}", url.PathEscape(collectorPolicyName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateTagsHandleResponse handles the UpdateTags response.
func (client *CollectorPoliciesClient) updateTagsHandleResponse(resp *http.Response) (CollectorPoliciesClientUpdateTagsResponse, error) {
	result := CollectorPoliciesClientUpdateTagsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CollectorPolicy); err != nil {
		return CollectorPoliciesClientUpdateTagsResponse{}, err
	}
	return result, nil
}
