//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysql"
	"net/http"
	"net/url"
	"regexp"
)

// RecommendedActionsServer is a fake server for instances of the armmysql.RecommendedActionsClient type.
type RecommendedActionsServer struct {
	// Get is the fake for method RecommendedActionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, advisorName string, recommendedActionName string, options *armmysql.RecommendedActionsClientGetOptions) (resp azfake.Responder[armmysql.RecommendedActionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method RecommendedActionsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, advisorName string, options *armmysql.RecommendedActionsClientListByServerOptions) (resp azfake.PagerResponder[armmysql.RecommendedActionsClientListByServerResponse])
}

// NewRecommendedActionsServerTransport creates a new instance of RecommendedActionsServerTransport with the provided implementation.
// The returned RecommendedActionsServerTransport instance is connected to an instance of armmysql.RecommendedActionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRecommendedActionsServerTransport(srv *RecommendedActionsServer) *RecommendedActionsServerTransport {
	return &RecommendedActionsServerTransport{
		srv:                  srv,
		newListByServerPager: newTracker[azfake.PagerResponder[armmysql.RecommendedActionsClientListByServerResponse]](),
	}
}

// RecommendedActionsServerTransport connects instances of armmysql.RecommendedActionsClient to instances of RecommendedActionsServer.
// Don't use this type directly, use NewRecommendedActionsServerTransport instead.
type RecommendedActionsServerTransport struct {
	srv                  *RecommendedActionsServer
	newListByServerPager *tracker[azfake.PagerResponder[armmysql.RecommendedActionsClientListByServerResponse]]
}

// Do implements the policy.Transporter interface for RecommendedActionsServerTransport.
func (r *RecommendedActionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RecommendedActionsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RecommendedActionsClient.NewListByServerPager":
		resp, err = r.dispatchNewListByServerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RecommendedActionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advisors/(?P<advisorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendedActions/(?P<recommendedActionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	advisorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("advisorName")])
	if err != nil {
		return nil, err
	}
	recommendedActionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("recommendedActionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, advisorNameParam, recommendedActionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecommendationAction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendedActionsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := r.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/advisors/(?P<advisorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendedActions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		advisorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("advisorName")])
		if err != nil {
			return nil, err
		}
		sessionIDUnescaped, err := url.QueryUnescape(qp.Get("sessionId"))
		if err != nil {
			return nil, err
		}
		sessionIDParam := getOptional(sessionIDUnescaped)
		var options *armmysql.RecommendedActionsClientListByServerOptions
		if sessionIDParam != nil {
			options = &armmysql.RecommendedActionsClientListByServerOptions{
				SessionID: sessionIDParam,
			}
		}
		resp := r.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, advisorNameParam, options)
		newListByServerPager = &resp
		r.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armmysql.RecommendedActionsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		r.newListByServerPager.remove(req)
	}
	return resp, nil
}
