//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlabservices

import "time"

// AutoShutdownProfile - Profile for how to handle shutting down virtual machines.
type AutoShutdownProfile struct {
	// The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
	DisconnectDelay *string

	// The amount of time a VM will idle before it is shutdown if this behavior is enabled.
	IdleDelay *string

	// The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
	NoConnectDelay *string

	// Whether shutdown on disconnect is enabled
	ShutdownOnDisconnect *EnableState

	// Whether a VM will get shutdown when it has idled for a period of time.
	ShutdownOnIdle *ShutdownOnIdleMode

	// Whether a VM will get shutdown when it hasn't been connected to after a period of time.
	ShutdownWhenNotConnected *EnableState
}

// ConnectionProfile - Connection profile for how users connect to lab virtual machines.
type ConnectionProfile struct {
	// The enabled access level for Client Access over RDP.
	ClientRdpAccess *ConnectionType

	// The enabled access level for Client Access over SSH.
	ClientSSHAccess *ConnectionType

	// The enabled access level for Web Access over RDP.
	WebRdpAccess *ConnectionType

	// The enabled access level for Web Access over SSH.
	WebSSHAccess *ConnectionType
}

// Credentials for a user on a lab VM.
type Credentials struct {
	// REQUIRED; The username to use when signing in to lab VMs.
	Username *string

	// The password for the user. This is required for the TemplateVM createOption.
	Password *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// Image - Lab services virtual machine image
type Image struct {
	// REQUIRED; Image resource properties
	Properties *ImageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the image.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ImageProperties - Properties of an image resource.
type ImageProperties struct {
	// The available regions of the image in the shared gallery.
	AvailableRegions []*string

	// Is the image enabled
	EnabledState *EnableState

	// READ-ONLY; The image author.
	Author *string

	// READ-ONLY; A description of the image.
	Description *string

	// READ-ONLY; The image display name.
	DisplayName *string

	// READ-ONLY; URL of the image icon.
	IconURL *string

	// READ-ONLY; The OS State of the image.
	OSState *OsState

	// READ-ONLY; The OS Type of the image.
	OSType *OsType

	// READ-ONLY; The ID of an offer associated with the image.
	Offer *string

	// READ-ONLY; The ID of marketplace plan associated with the image (optional).
	Plan *string

	// READ-ONLY; Current provisioning state of the image.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The ID of the publisher of the image.
	Publisher *string

	// READ-ONLY; The image SKU.
	SKU *string

	// READ-ONLY; The ID for the image in the shared gallery.
	SharedGalleryID *string

	// READ-ONLY; The status of image terms of use (enabled = accepted, disabled = not accepted).
	TermsStatus *EnableState

	// READ-ONLY; The image version.
	Version *string
}

// ImageReference - Image reference information. Used in the virtual machine profile.
type ImageReference struct {
	// Image resource ID
	ID *string

	// The image offer if applicable.
	Offer *string

	// The image publisher
	Publisher *string

	// The image SKU
	SKU *string

	// The image version specified on creation.
	Version *string

	// READ-ONLY; The actual version of the image after use.
	ExactVersion *string
}

// ImageUpdate - Lab services virtual machine image for updates.
type ImageUpdate struct {
	// Image resource properties
	Properties *ImageUpdateProperties
}

// ImageUpdateProperties - Properties of an image resource update
type ImageUpdateProperties struct {
	// Is the image enabled
	EnabledState *EnableState
}

// InviteBody - Body for a user invite request
type InviteBody struct {
	// Custom text for the invite email.
	Text *string
}

// Lab - The lab resource.
type Lab struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Lab resource properties
	Properties *LabProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the lab.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LabNetworkProfile - Profile for how to handle networking for Labs.
type LabNetworkProfile struct {
	// The external load balancer resource id
	LoadBalancerID *string

	// The external public IP resource id
	PublicIPID *string

	// The external subnet resource id
	SubnetID *string
}

// LabPlan - Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide
// a set of default configurations that will apply at the time of creating a lab, but these
// defaults can still be overwritten.
type LabPlan struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Lab plan resource properties
	Properties *LabPlanProperties

	// Managed Identity Information
	Identity *Identity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the lab plan.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LabPlanNetworkProfile - Profile for how to handle networking for Lab Plans.
type LabPlanNetworkProfile struct {
	// The external subnet resource id
	SubnetID *string
}

// LabPlanProperties - Lab plan resource properties
type LabPlanProperties struct {
	// The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions []*string

	// The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile

	// The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile

	// The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there
	// are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile

	// Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string

	// Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it
	// will be persisted in this gallery. Shared images from the gallery can be made
	// available to use when creating new labs.
	SharedGalleryID *string

	// Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and
	// virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo

	// READ-ONLY; Current provisioning state of the lab plan.
	ProvisioningState *ProvisioningState
}

// LabPlanUpdate - Contains lab configuration and default settings. This variant is used for PATCH.
type LabPlanUpdate struct {
	// Managed Identity Information
	Identity *Identity

	// Lab plan resource update properties
	Properties *LabPlanUpdateProperties

	// Resource tags.
	Tags []*string
}

// LabPlanUpdateProperties - Lab plan resource properties for updates
type LabPlanUpdateProperties struct {
	// The allowed regions for the lab creator to use when creating labs using this lab plan.
	AllowedRegions []*string

	// The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
	DefaultAutoShutdownProfile *AutoShutdownProfile

	// The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
	DefaultConnectionProfile *ConnectionProfile

	// The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there
	// are existing labs associated with this lab plan.
	DefaultNetworkProfile *LabPlanNetworkProfile

	// Base Url of the lms instance this lab plan can link lab rosters against.
	LinkedLmsInstance *string

	// Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it
	// will be persisted in this gallery. Shared images from the gallery can be made
	// available to use when creating new labs.
	SharedGalleryID *string

	// Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and
	// virtual machine users for all labs in the lab plan.
	SupportInfo *SupportInfo
}

// LabProperties - Properties of a lab resource.
type LabProperties struct {
	// The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting
	// idle.
	AutoShutdownProfile *AutoShutdownProfile

	// The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports
	// are open.
	ConnectionProfile *ConnectionProfile

	// The description of the lab.
	Description *string

	// The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating
	// a lab via labs.azure.com. Setting a labPlanId on an existing lab provides
	// organization..
	LabPlanID *string

	// The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been
	// created.
	NetworkProfile *LabNetworkProfile

	// The lab user list management profile.
	RosterProfile *RosterProfile

	// The lab security profile.
	SecurityProfile *SecurityProfile

	// The title of the lab.
	Title *string

	// The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile

	// READ-ONLY; Current provisioning state of the lab.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The lab state.
	State *LabState
}

// LabUpdate - The lab resource for updates.
type LabUpdate struct {
	// Lab resource properties
	Properties *LabUpdateProperties

	// Resource tags.
	Tags []*string
}

// LabUpdateProperties - Properties of a lab resource used for updates.
type LabUpdateProperties struct {
	// The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting
	// idle.
	AutoShutdownProfile *AutoShutdownProfile

	// The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports
	// are open.
	ConnectionProfile *ConnectionProfile

	// The description of the lab.
	Description *string

	// The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating
	// a lab via labs.azure.com. Setting a labPlanId on an existing lab provides
	// organization..
	LabPlanID *string

	// The lab user list management profile.
	RosterProfile *RosterProfile

	// The lab security profile.
	SecurityProfile *SecurityProfile

	// The title of the lab.
	Title *string

	// The profile used for creating lab virtual machines.
	VirtualMachineProfile *VirtualMachineProfile
}

// ListUsagesResult - List of Core Usages.
type ListUsagesResult struct {
	// The array page of Usages.
	Value []*Usage

	// READ-ONLY; The link to get the next page of Usage result.
	NextLink *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationResult - A long running operation result
type OperationResult struct {
	// REQUIRED; The operation status
	Status *OperationStatus

	// End time
	EndTime *time.Time

	// The error for a failure if the operation failed.
	Error *ErrorDetail

	// Percent completion
	PercentComplete *float32

	// Start time
	StartTime *time.Time

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string
}

// PagedImages - Paged list of Lab services virtual machine images.
type PagedImages struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string

	// READ-ONLY; The array page of virtual machine images.
	Value []*Image
}

// PagedLabPlans - Paged list of lab plans.
type PagedLabPlans struct {
	// READ-ONLY; The link to get the next page of lab plan results.
	NextLink *string

	// READ-ONLY; The array page of lab plans.
	Value []*LabPlan
}

// PagedLabs - Paged list of labs.
type PagedLabs struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string

	// READ-ONLY; The array page of lab results.
	Value []*Lab
}

// PagedSKUInfos - Paged list of lab services skus.
type PagedSKUInfos struct {
	// READ-ONLY; The link to get the next page of sku results.
	NextLink *string

	// READ-ONLY; The array page of sku results.
	Value []*SKUInfo
}

// PagedSchedules - Paged list of schedules.
type PagedSchedules struct {
	// READ-ONLY; The link to get the next page of schedule results.
	NextLink *string

	// READ-ONLY; The array page of schedule results.
	Value []*Schedule
}

// PagedUsers - Paged list of users.
type PagedUsers struct {
	// READ-ONLY; The link to get the next page of image results.
	NextLink *string

	// READ-ONLY; The array page of user results.
	Value []*User
}

// PagedVirtualMachines - Paged list of lab services virtual machines.
type PagedVirtualMachines struct {
	// READ-ONLY; The link to get the next page of virtual machine results.
	NextLink *string

	// READ-ONLY; The array page of virtual machine results.
	Value []*VirtualMachine
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecurrencePattern - Recurrence pattern of a lab schedule.
type RecurrencePattern struct {
	// REQUIRED; When the recurrence will expire. This date is inclusive.
	ExpirationDate *time.Time

	// REQUIRED; The frequency of the recurrence.
	Frequency *RecurrenceFrequency

	// The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days.
	// When no interval is supplied, an interval of 1 is used.
	Interval *int32

	// The week days the schedule runs. Used for when the Frequency is set to Weekly.
	WeekDays []*WeekDay
}

// ResetPasswordBody - Body of a reset password request.
type ResetPasswordBody struct {
	// REQUIRED; The password
	Password *string

	// REQUIRED; The user whose password is being reset
	Username *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RosterProfile - The lab user list management profile.
type RosterProfile struct {
	// The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
	ActiveDirectoryGroupID *string

	// The base URI identifying the lms instance.
	LmsInstance *string

	// The unique id of the azure lab services tool in the lms.
	LtiClientID *string

	// The unique context identifier for the lab in the lms.
	LtiContextID *string

	// The uri of the names and roles service endpoint on the lms for the class attached to this lab.
	LtiRosterEndpoint *string
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SKUCapabilities - The array of capabilities of a lab services SKU.
type SKUCapabilities struct {
	// READ-ONLY; The name of the capability for a SKU.
	Name *string

	// READ-ONLY; The value of the capability for a SKU.
	Value *string
}

// SKUCapacity - The scale out/in options of the SKU.
type SKUCapacity struct {
	// READ-ONLY; The default capacity for this resource.
	Default *int64

	// READ-ONLY; The highest permitted capacity for this resource.
	Maximum *int64

	// READ-ONLY; The lowest permitted capacity for this resource.
	Minimum *int64

	// READ-ONLY; The localized name of the resource.
	ScaleType *ScaleType
}

// SKUCost - The array of costs of a lab services SKU.
type SKUCost struct {
	// READ-ONLY; The extended unit.
	ExtendedUnit *string

	// READ-ONLY; The meter id.
	MeterID *string

	// READ-ONLY; The quantity of units charged.
	Quantity *float32
}

// SKUInfo - Azure Lab Services resource SKUs
type SKUInfo struct {
	// The scale out/in options of the SKU.
	Capacity *SKUCapacity

	// READ-ONLY; The capabilities of the SKU.
	Capabilities []*SKUCapabilities

	// READ-ONLY; Metadata for retrieving price info of a lab services SKUs.
	Costs []*SKUCost

	// READ-ONLY; The family of the SKU.
	Family *string

	// READ-ONLY; List of locations that are available for a size.
	Locations []*string

	// READ-ONLY; The name of the SKU.
	Name *string

	// READ-ONLY; The lab services resource type.
	ResourceType *string

	// READ-ONLY; Restrictions of a lab services SKUs.
	Restrictions []*SKURestrictions

	// READ-ONLY; The SKU size.
	Size *string

	// READ-ONLY; The tier of the SKU.
	Tier *LabServicesSKUTier
}

// SKURestrictions - The restriction details.
type SKURestrictions struct {
	// READ-ONLY; The reason for the restriction.
	ReasonCode *RestrictionReasonCode

	// READ-ONLY; The type of restriction.
	Type *RestrictionType

	// READ-ONLY; The values of the restriction.
	Values []*string
}

// SaveImageBody - Body for the save image POST
type SaveImageBody struct {
	// The ID of the lab virtual machine you want to save an image from.
	LabVirtualMachineID *string

	// The name for the image we create.
	Name *string
}

// Schedule for automatically turning virtual machines in a lab on and off at specified times.
type Schedule struct {
	// REQUIRED; Schedule resource properties
	Properties *ScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the schedule.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScheduleProperties - Schedule resource properties
type ScheduleProperties struct {
	// Notes for this schedule.
	Notes *string

	// The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern

	// When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *time.Time

	// When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *time.Time

	// The IANA timezone id for the schedule.
	TimeZoneID *string

	// READ-ONLY; Current provisioning state of the schedule.
	ProvisioningState *ProvisioningState
}

// ScheduleUpdate - Schedule for automatically turning virtual machines in a lab on and off at specified times. Used for updates.
type ScheduleUpdate struct {
	// Schedule resource properties
	Properties *ScheduleUpdateProperties
}

// ScheduleUpdateProperties - Schedule resource properties used for updates.
type ScheduleUpdateProperties struct {
	// Notes for this schedule.
	Notes *string

	// The recurrence pattern of the scheduled actions.
	RecurrencePattern *RecurrencePattern

	// When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
	StartAt *time.Time

	// When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
	StopAt *time.Time

	// The IANA timezone id for the schedule.
	TimeZoneID *string
}

// SecurityProfile - The lab security profile.
type SecurityProfile struct {
	// Whether any user or only specified users can register to a lab.
	OpenAccess *EnableState

	// READ-ONLY; The registration code for the lab.
	RegistrationCode *string
}

// SupportInfo - Support contact information and instructions.
type SupportInfo struct {
	// Support contact email address.
	Email *string

	// Support instructions.
	Instructions *string

	// Support contact phone number.
	Phone *string

	// Support web address.
	URL *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrackedResourceUpdate - Base tracked resource type for all PATCH updates.
type TrackedResourceUpdate struct {
	// Resource tags.
	Tags []*string
}

// Usage - The core usage details.
type Usage struct {
	// The current usage.
	CurrentValue *int64

	// The fully qualified arm resource id.
	ID *string

	// The limit integer.
	Limit *int64

	// The name.
	Name *UsageName

	// The unit details.
	Unit *UsageUnit
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string

	// The instances of the resource.
	SKUInstances []*string

	// The name of the resource.
	Value *string
}

// User of a lab that can register for and use virtual machines within the lab.
type User struct {
	// REQUIRED; User resource properties
	Properties *UserProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the user resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UserProperties - User resource properties
type UserProperties struct {
	// REQUIRED; Email address of the user.
	Email *string

	// The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string

	// READ-ONLY; Display name of the user, for example user's full name.
	DisplayName *string

	// READ-ONLY; Date and time when the invitation message was sent to the user.
	InvitationSent *time.Time

	// READ-ONLY; State of the invitation message for the user.
	InvitationState *InvitationState

	// READ-ONLY; Current provisioning state of the user resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; State of the user's registration within the lab.
	RegistrationState *RegistrationState

	// READ-ONLY; How long the user has used their virtual machines in this lab.
	TotalUsage *string
}

// UserUpdate - User of a lab that can register for and use virtual machines within the lab. Used for updates.
type UserUpdate struct {
	// User resource properties
	Properties *UserUpdateProperties
}

// UserUpdateProperties - User resource properties used for updates.
type UserUpdateProperties struct {
	// The amount of usage quota time the user gets in addition to the lab usage quota.
	AdditionalUsageQuota *string
}

// VirtualMachine - A lab virtual machine resource.
type VirtualMachine struct {
	// REQUIRED; Virtual machine resource properties
	Properties *VirtualMachineProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; System data of the Lab virtual machine.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualMachineAdditionalCapabilities - The additional capabilities for a lab VM.
type VirtualMachineAdditionalCapabilities struct {
	// Flag to pre-install dedicated GPU drivers.
	InstallGpuDrivers *EnableState
}

// VirtualMachineConnectionProfile - The connection information for the virtual machine
type VirtualMachineConnectionProfile struct {
	// READ-ONLY; The username used to log on to the virtual machine as admin.
	AdminUsername *string

	// READ-ONLY; The username used to log on to the virtual machine as non-admin, if one exists.
	NonAdminUsername *string

	// READ-ONLY; The private IP address of the virtual machine.
	PrivateIPAddress *string

	// READ-ONLY; Port and host name separated by semicolon for connecting via RDP protocol to the virtual machine.
	RdpAuthority *string

	// READ-ONLY; URL for connecting via RDP protocol to the virtual machine in browser.
	RdpInBrowserURL *string

	// READ-ONLY; Port and host name separated by semicolon for connecting via SSH protocol to the virtual machine.
	SSHAuthority *string

	// READ-ONLY; URL for connecting via SSH protocol to the virtual machine in browser.
	SSHInBrowserURL *string
}

// VirtualMachineProfile - The base virtual machine configuration for a lab.
type VirtualMachineProfile struct {
	// REQUIRED; Credentials for the admin user on the VM.
	AdminUser *Credentials

	// REQUIRED; Indicates what lab virtual machines are created from.
	CreateOption *CreateOption

	// REQUIRED; The image configuration for lab virtual machines.
	ImageReference *ImageReference

	// REQUIRED; The SKU for the lab. Defines the type of virtual machines used in the lab.
	SKU *SKU

	// REQUIRED; The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
	UsageQuota *string

	// Additional VM capabilities.
	AdditionalCapabilities *VirtualMachineAdditionalCapabilities

	// Credentials for the non-admin user on the VM, if one exists.
	NonAdminUser *Credentials

	// Enabling this option will use the same password for all user VMs.
	UseSharedPassword *EnableState

	// READ-ONLY; The OS type of the image
	OSType *OsType
}

// VirtualMachineProperties - Virtual machine resource properties
type VirtualMachineProperties struct {
	// READ-ONLY; The lab user ID (not the PUID!) of who claimed the virtual machine.
	ClaimedByUserID *string

	// READ-ONLY; Profile for information about connecting to the virtual machine.
	ConnectionProfile *VirtualMachineConnectionProfile

	// READ-ONLY; Current provisioning state of the virtual machine.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The current state of the virtual machine
	State *VirtualMachineState

	// READ-ONLY; The type of this VM resource
	VMType *VirtualMachineType
}
