//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type BinaryHardeningFeatures.
func (b BinaryHardeningFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", b.Canary)
	populate(objectMap, "nx", b.Nx)
	populate(objectMap, "pie", b.Pie)
	populate(objectMap, "relro", b.Relro)
	populate(objectMap, "stripped", b.Stripped)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryHardeningFeatures.
func (b *BinaryHardeningFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &b.Canary)
			delete(rawMsg, key)
		case "nx":
			err = unpopulate(val, "Nx", &b.Nx)
			delete(rawMsg, key)
		case "pie":
			err = unpopulate(val, "Pie", &b.Pie)
			delete(rawMsg, key)
		case "relro":
			err = unpopulate(val, "Relro", &b.Relro)
			delete(rawMsg, key)
		case "stripped":
			err = unpopulate(val, "Stripped", &b.Stripped)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryHardeningListResult.
func (b BinaryHardeningListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryHardeningListResult.
func (b *BinaryHardeningListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryHardeningResource.
func (b BinaryHardeningResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryHardeningResource.
func (b *BinaryHardeningResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryHardeningResult.
func (b BinaryHardeningResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "architecture", b.Architecture)
	populate(objectMap, "binaryHardeningId", b.BinaryHardeningID)
	populate(objectMap, "class", b.Class)
	populate(objectMap, "features", b.Features)
	populate(objectMap, "filePath", b.FilePath)
	populate(objectMap, "rpath", b.Rpath)
	populate(objectMap, "runpath", b.Runpath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryHardeningResult.
func (b *BinaryHardeningResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "architecture":
			err = unpopulate(val, "Architecture", &b.Architecture)
			delete(rawMsg, key)
		case "binaryHardeningId":
			err = unpopulate(val, "BinaryHardeningID", &b.BinaryHardeningID)
			delete(rawMsg, key)
		case "class":
			err = unpopulate(val, "Class", &b.Class)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &b.Features)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &b.FilePath)
			delete(rawMsg, key)
		case "rpath":
			err = unpopulate(val, "Rpath", &b.Rpath)
			delete(rawMsg, key)
		case "runpath":
			err = unpopulate(val, "Runpath", &b.Runpath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryHardeningSummaryResource.
func (b BinaryHardeningSummaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", b.Canary)
	populate(objectMap, "nx", b.Nx)
	populate(objectMap, "pie", b.Pie)
	populate(objectMap, "relro", b.Relro)
	populate(objectMap, "stripped", b.Stripped)
	objectMap["summaryType"] = SummaryTypeBinaryHardening
	populate(objectMap, "totalFiles", b.TotalFiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryHardeningSummaryResource.
func (b *BinaryHardeningSummaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &b.Canary)
			delete(rawMsg, key)
		case "nx":
			err = unpopulate(val, "Nx", &b.Nx)
			delete(rawMsg, key)
		case "pie":
			err = unpopulate(val, "Pie", &b.Pie)
			delete(rawMsg, key)
		case "relro":
			err = unpopulate(val, "Relro", &b.Relro)
			delete(rawMsg, key)
		case "stripped":
			err = unpopulate(val, "Stripped", &b.Stripped)
			delete(rawMsg, key)
		case "summaryType":
			err = unpopulate(val, "SummaryType", &b.SummaryType)
			delete(rawMsg, key)
		case "totalFiles":
			err = unpopulate(val, "TotalFiles", &b.TotalFiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoCertificate.
func (c CryptoCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cryptoCertId", c.CryptoCertID)
	populate(objectMap, "encoding", c.Encoding)
	populateDateTimeRFC3339(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "filePaths", c.FilePaths)
	populate(objectMap, "fingerprint", c.Fingerprint)
	populate(objectMap, "isExpired", c.IsExpired)
	populate(objectMap, "isSelfSigned", c.IsSelfSigned)
	populate(objectMap, "isShortKeySize", c.IsShortKeySize)
	populate(objectMap, "isWeakSignature", c.IsWeakSignature)
	populateDateTimeRFC3339(objectMap, "issuedDate", c.IssuedDate)
	populate(objectMap, "issuer", c.Issuer)
	populate(objectMap, "keyAlgorithm", c.KeyAlgorithm)
	populate(objectMap, "keySize", c.KeySize)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "pairedKey", c.PairedKey)
	populate(objectMap, "role", c.Role)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "signatureAlgorithm", c.SignatureAlgorithm)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "usage", c.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoCertificate.
func (c *CryptoCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cryptoCertId":
			err = unpopulate(val, "CryptoCertID", &c.CryptoCertID)
			delete(rawMsg, key)
		case "encoding":
			err = unpopulate(val, "Encoding", &c.Encoding)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "filePaths":
			err = unpopulate(val, "FilePaths", &c.FilePaths)
			delete(rawMsg, key)
		case "fingerprint":
			err = unpopulate(val, "Fingerprint", &c.Fingerprint)
			delete(rawMsg, key)
		case "isExpired":
			err = unpopulate(val, "IsExpired", &c.IsExpired)
			delete(rawMsg, key)
		case "isSelfSigned":
			err = unpopulate(val, "IsSelfSigned", &c.IsSelfSigned)
			delete(rawMsg, key)
		case "isShortKeySize":
			err = unpopulate(val, "IsShortKeySize", &c.IsShortKeySize)
			delete(rawMsg, key)
		case "isWeakSignature":
			err = unpopulate(val, "IsWeakSignature", &c.IsWeakSignature)
			delete(rawMsg, key)
		case "issuedDate":
			err = unpopulateDateTimeRFC3339(val, "IssuedDate", &c.IssuedDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &c.Issuer)
			delete(rawMsg, key)
		case "keyAlgorithm":
			err = unpopulate(val, "KeyAlgorithm", &c.KeyAlgorithm)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &c.KeySize)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "pairedKey":
			err = unpopulate(val, "PairedKey", &c.PairedKey)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &c.Role)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "signatureAlgorithm":
			err = unpopulate(val, "SignatureAlgorithm", &c.SignatureAlgorithm)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &c.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoCertificateEntity.
func (c CryptoCertificateEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commonName", c.CommonName)
	populate(objectMap, "country", c.Country)
	populate(objectMap, "organization", c.Organization)
	populate(objectMap, "organizationalUnit", c.OrganizationalUnit)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoCertificateEntity.
func (c *CryptoCertificateEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commonName":
			err = unpopulate(val, "CommonName", &c.CommonName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &c.Country)
			delete(rawMsg, key)
		case "organization":
			err = unpopulate(val, "Organization", &c.Organization)
			delete(rawMsg, key)
		case "organizationalUnit":
			err = unpopulate(val, "OrganizationalUnit", &c.OrganizationalUnit)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoCertificateListResult.
func (c CryptoCertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoCertificateListResult.
func (c *CryptoCertificateListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoCertificateResource.
func (c CryptoCertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoCertificateResource.
func (c *CryptoCertificateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoCertificateSummaryResource.
func (c CryptoCertificateSummaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expired", c.Expired)
	populate(objectMap, "expiringSoon", c.ExpiringSoon)
	populate(objectMap, "pairedKeys", c.PairedKeys)
	populate(objectMap, "selfSigned", c.SelfSigned)
	populate(objectMap, "shortKeySize", c.ShortKeySize)
	objectMap["summaryType"] = SummaryTypeCryptoCertificate
	populate(objectMap, "totalCertificates", c.TotalCertificates)
	populate(objectMap, "weakSignature", c.WeakSignature)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoCertificateSummaryResource.
func (c *CryptoCertificateSummaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expired":
			err = unpopulate(val, "Expired", &c.Expired)
			delete(rawMsg, key)
		case "expiringSoon":
			err = unpopulate(val, "ExpiringSoon", &c.ExpiringSoon)
			delete(rawMsg, key)
		case "pairedKeys":
			err = unpopulate(val, "PairedKeys", &c.PairedKeys)
			delete(rawMsg, key)
		case "selfSigned":
			err = unpopulate(val, "SelfSigned", &c.SelfSigned)
			delete(rawMsg, key)
		case "shortKeySize":
			err = unpopulate(val, "ShortKeySize", &c.ShortKeySize)
			delete(rawMsg, key)
		case "summaryType":
			err = unpopulate(val, "SummaryType", &c.SummaryType)
			delete(rawMsg, key)
		case "totalCertificates":
			err = unpopulate(val, "TotalCertificates", &c.TotalCertificates)
			delete(rawMsg, key)
		case "weakSignature":
			err = unpopulate(val, "WeakSignature", &c.WeakSignature)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoKey.
func (c CryptoKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cryptoKeyId", c.CryptoKeyID)
	populate(objectMap, "filePaths", c.FilePaths)
	populate(objectMap, "isShortKeySize", c.IsShortKeySize)
	populate(objectMap, "keyAlgorithm", c.KeyAlgorithm)
	populate(objectMap, "keySize", c.KeySize)
	populate(objectMap, "keyType", c.KeyType)
	populate(objectMap, "pairedKey", c.PairedKey)
	populate(objectMap, "usage", c.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoKey.
func (c *CryptoKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cryptoKeyId":
			err = unpopulate(val, "CryptoKeyID", &c.CryptoKeyID)
			delete(rawMsg, key)
		case "filePaths":
			err = unpopulate(val, "FilePaths", &c.FilePaths)
			delete(rawMsg, key)
		case "isShortKeySize":
			err = unpopulate(val, "IsShortKeySize", &c.IsShortKeySize)
			delete(rawMsg, key)
		case "keyAlgorithm":
			err = unpopulate(val, "KeyAlgorithm", &c.KeyAlgorithm)
			delete(rawMsg, key)
		case "keySize":
			err = unpopulate(val, "KeySize", &c.KeySize)
			delete(rawMsg, key)
		case "keyType":
			err = unpopulate(val, "KeyType", &c.KeyType)
			delete(rawMsg, key)
		case "pairedKey":
			err = unpopulate(val, "PairedKey", &c.PairedKey)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &c.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoKeyListResult.
func (c CryptoKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoKeyListResult.
func (c *CryptoKeyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoKeyResource.
func (c CryptoKeyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoKeyResource.
func (c *CryptoKeyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CryptoKeySummaryResource.
func (c CryptoKeySummaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pairedKeys", c.PairedKeys)
	populate(objectMap, "privateKeys", c.PrivateKeys)
	populate(objectMap, "publicKeys", c.PublicKeys)
	populate(objectMap, "shortKeySize", c.ShortKeySize)
	objectMap["summaryType"] = SummaryTypeCryptoKey
	populate(objectMap, "totalKeys", c.TotalKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CryptoKeySummaryResource.
func (c *CryptoKeySummaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pairedKeys":
			err = unpopulate(val, "PairedKeys", &c.PairedKeys)
			delete(rawMsg, key)
		case "privateKeys":
			err = unpopulate(val, "PrivateKeys", &c.PrivateKeys)
			delete(rawMsg, key)
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &c.PublicKeys)
			delete(rawMsg, key)
		case "shortKeySize":
			err = unpopulate(val, "ShortKeySize", &c.ShortKeySize)
			delete(rawMsg, key)
		case "summaryType":
			err = unpopulate(val, "SummaryType", &c.SummaryType)
			delete(rawMsg, key)
		case "totalKeys":
			err = unpopulate(val, "TotalKeys", &c.TotalKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveComponent.
func (c CveComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", c.ComponentID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveComponent.
func (c *CveComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &c.ComponentID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveLink.
func (c CveLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "href", c.Href)
	populate(objectMap, "label", c.Label)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveLink.
func (c *CveLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "href":
			err = unpopulate(val, "Href", &c.Href)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &c.Label)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveListResult.
func (c CveListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveListResult.
func (c *CveListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveResource.
func (c CveResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveResource.
func (c *CveResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveResult.
func (c CveResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "component", c.Component)
	populate(objectMap, "cveId", c.CveID)
	populate(objectMap, "cvssScore", c.CvssScore)
	populate(objectMap, "cvssV2Score", c.CvssV2Score)
	populate(objectMap, "cvssV3Score", c.CvssV3Score)
	populate(objectMap, "cvssVersion", c.CvssVersion)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "severity", c.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveResult.
func (c *CveResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "component":
			err = unpopulate(val, "Component", &c.Component)
			delete(rawMsg, key)
		case "cveId":
			err = unpopulate(val, "CveID", &c.CveID)
			delete(rawMsg, key)
		case "cvssScore":
			err = unpopulate(val, "CvssScore", &c.CvssScore)
			delete(rawMsg, key)
		case "cvssV2Score":
			err = unpopulate(val, "CvssV2Score", &c.CvssV2Score)
			delete(rawMsg, key)
		case "cvssV3Score":
			err = unpopulate(val, "CvssV3Score", &c.CvssV3Score)
			delete(rawMsg, key)
		case "cvssVersion":
			err = unpopulate(val, "CvssVersion", &c.CvssVersion)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &c.Links)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CveSummary.
func (c CveSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "critical", c.Critical)
	populate(objectMap, "high", c.High)
	populate(objectMap, "low", c.Low)
	populate(objectMap, "medium", c.Medium)
	objectMap["summaryType"] = SummaryTypeCVE
	populate(objectMap, "unknown", c.Unknown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CveSummary.
func (c *CveSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "critical":
			err = unpopulate(val, "Critical", &c.Critical)
			delete(rawMsg, key)
		case "high":
			err = unpopulate(val, "High", &c.High)
			delete(rawMsg, key)
		case "low":
			err = unpopulate(val, "Low", &c.Low)
			delete(rawMsg, key)
		case "medium":
			err = unpopulate(val, "Medium", &c.Medium)
			delete(rawMsg, key)
		case "summaryType":
			err = unpopulate(val, "SummaryType", &c.SummaryType)
			delete(rawMsg, key)
		case "unknown":
			err = unpopulate(val, "Unknown", &c.Unknown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Firmware.
func (f Firmware) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Firmware.
func (f *Firmware) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirmwareList.
func (f FirmwareList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirmwareList.
func (f *FirmwareList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirmwareProperties.
func (f FirmwareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "fileName", f.FileName)
	populate(objectMap, "fileSize", f.FileSize)
	populate(objectMap, "model", f.Model)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "status", f.Status)
	populate(objectMap, "statusMessages", f.StatusMessages)
	populate(objectMap, "vendor", f.Vendor)
	populate(objectMap, "version", f.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirmwareProperties.
func (f *FirmwareProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "fileSize":
			err = unpopulate(val, "FileSize", &f.FileSize)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &f.Model)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		case "statusMessages":
			err = unpopulate(val, "StatusMessages", &f.StatusMessages)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &f.Vendor)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &f.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirmwareSummary.
func (f FirmwareSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analysisTimeSeconds", f.AnalysisTimeSeconds)
	populate(objectMap, "binaryCount", f.BinaryCount)
	populate(objectMap, "componentCount", f.ComponentCount)
	populate(objectMap, "extractedFileCount", f.ExtractedFileCount)
	populate(objectMap, "extractedSize", f.ExtractedSize)
	populate(objectMap, "fileSize", f.FileSize)
	populate(objectMap, "rootFileSystems", f.RootFileSystems)
	objectMap["summaryType"] = SummaryTypeFirmware
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirmwareSummary.
func (f *FirmwareSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisTimeSeconds":
			err = unpopulate(val, "AnalysisTimeSeconds", &f.AnalysisTimeSeconds)
			delete(rawMsg, key)
		case "binaryCount":
			err = unpopulate(val, "BinaryCount", &f.BinaryCount)
			delete(rawMsg, key)
		case "componentCount":
			err = unpopulate(val, "ComponentCount", &f.ComponentCount)
			delete(rawMsg, key)
		case "extractedFileCount":
			err = unpopulate(val, "ExtractedFileCount", &f.ExtractedFileCount)
			delete(rawMsg, key)
		case "extractedSize":
			err = unpopulate(val, "ExtractedSize", &f.ExtractedSize)
			delete(rawMsg, key)
		case "fileSize":
			err = unpopulate(val, "FileSize", &f.FileSize)
			delete(rawMsg, key)
		case "rootFileSystems":
			err = unpopulate(val, "RootFileSystems", &f.RootFileSystems)
			delete(rawMsg, key)
		case "summaryType":
			err = unpopulate(val, "SummaryType", &f.SummaryType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirmwareUpdateDefinition.
func (f FirmwareUpdateDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirmwareUpdateDefinition.
func (f *FirmwareUpdateDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateUploadURLRequest.
func (g GenerateUploadURLRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "firmwareId", g.FirmwareID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateUploadURLRequest.
func (g *GenerateUploadURLRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firmwareId":
			err = unpopulate(val, "FirmwareID", &g.FirmwareID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PairedKey.
func (p PairedKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PairedKey.
func (p *PairedKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PasswordHash.
func (p PasswordHash) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "algorithm", p.Algorithm)
	populate(objectMap, "context", p.Context)
	populate(objectMap, "filePath", p.FilePath)
	populate(objectMap, "hash", p.Hash)
	populate(objectMap, "passwordHashId", p.PasswordHashID)
	populate(objectMap, "salt", p.Salt)
	populate(objectMap, "username", p.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PasswordHash.
func (p *PasswordHash) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &p.Algorithm)
			delete(rawMsg, key)
		case "context":
			err = unpopulate(val, "Context", &p.Context)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &p.FilePath)
			delete(rawMsg, key)
		case "hash":
			err = unpopulate(val, "Hash", &p.Hash)
			delete(rawMsg, key)
		case "passwordHashId":
			err = unpopulate(val, "PasswordHashID", &p.PasswordHashID)
			delete(rawMsg, key)
		case "salt":
			err = unpopulate(val, "Salt", &p.Salt)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &p.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PasswordHashListResult.
func (p PasswordHashListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PasswordHashListResult.
func (p *PasswordHashListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PasswordHashResource.
func (p PasswordHashResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PasswordHashResource.
func (p *PasswordHashResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SbomComponent.
func (s SbomComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", s.ComponentID)
	populate(objectMap, "componentName", s.ComponentName)
	populate(objectMap, "filePaths", s.FilePaths)
	populate(objectMap, "license", s.License)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SbomComponent.
func (s *SbomComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &s.ComponentID)
			delete(rawMsg, key)
		case "componentName":
			err = unpopulate(val, "ComponentName", &s.ComponentName)
			delete(rawMsg, key)
		case "filePaths":
			err = unpopulate(val, "FilePaths", &s.FilePaths)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &s.License)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SbomComponentListResult.
func (s SbomComponentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SbomComponentListResult.
func (s *SbomComponentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SbomComponentResource.
func (s SbomComponentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SbomComponentResource.
func (s *SbomComponentResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusMessage.
func (s StatusMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", s.ErrorCode)
	populate(objectMap, "message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusMessage.
func (s *StatusMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummaryListResult.
func (s SummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummaryListResult.
func (s *SummaryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummaryResource.
func (s SummaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummaryResource.
func (s *SummaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalSummaryResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummaryResourceProperties.
func (s SummaryResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["summaryType"] = s.SummaryType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummaryResourceProperties.
func (s *SummaryResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "summaryType":
			err = unpopulate(val, "SummaryType", &s.SummaryType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLToken.
func (u URLToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "url", u.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLToken.
func (u *URLToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "url":
			err = unpopulate(val, "URL", &u.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workspace.
func (w *Workspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceList.
func (w WorkspaceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceList.
func (w *WorkspaceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceProperties.
func (w *WorkspaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceUpdateDefinition.
func (w WorkspaceUpdateDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceUpdateDefinition.
func (w *WorkspaceUpdateDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
