//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsightcontainers

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAvailableClusterPoolVersionsClient creates a new instance of AvailableClusterPoolVersionsClient.
func (c *ClientFactory) NewAvailableClusterPoolVersionsClient() *AvailableClusterPoolVersionsClient {
	return &AvailableClusterPoolVersionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewAvailableClusterVersionsClient creates a new instance of AvailableClusterVersionsClient.
func (c *ClientFactory) NewAvailableClusterVersionsClient() *AvailableClusterVersionsClient {
	return &AvailableClusterVersionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClusterAvailableUpgradesClient creates a new instance of ClusterAvailableUpgradesClient.
func (c *ClientFactory) NewClusterAvailableUpgradesClient() *ClusterAvailableUpgradesClient {
	return &ClusterAvailableUpgradesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClusterJobsClient creates a new instance of ClusterJobsClient.
func (c *ClientFactory) NewClusterJobsClient() *ClusterJobsClient {
	return &ClusterJobsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClusterPoolAvailableUpgradesClient creates a new instance of ClusterPoolAvailableUpgradesClient.
func (c *ClientFactory) NewClusterPoolAvailableUpgradesClient() *ClusterPoolAvailableUpgradesClient {
	return &ClusterPoolAvailableUpgradesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClusterPoolsClient creates a new instance of ClusterPoolsClient.
func (c *ClientFactory) NewClusterPoolsClient() *ClusterPoolsClient {
	return &ClusterPoolsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	return &ClustersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	return &LocationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}
