//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhardwaresecuritymodules_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hardwaresecuritymodules/armhardwaresecuritymodules/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmClusterPrivateEndpointConnection_ListByCloudHsmCluster_MaximumSet_Gen.json
func ExamplePrivateEndpointConnectionsClient_NewListByCloudHsmClusterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateEndpointConnectionsClient().NewListByCloudHsmClusterPager("rgcloudhsm", "chsm1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateEndpointConnectionListResult = armhardwaresecuritymodules.PrivateEndpointConnectionListResult{
		// 	Value: []*armhardwaresecuritymodules.PrivateEndpointConnection{
		// 		{
		// 			Name: to.Ptr("chsm1"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters/privateEndpointConnections"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1/privateEndpointConnections/sample-pec1"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("User1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("User2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.PrivateEndpointConnectionProperties{
		// 				PrivateEndpoint: &armhardwaresecuritymodules.PrivateEndpoint{
		// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.Network/privateEndpoints/sample-pec1"),
		// 				},
		// 				PrivateLinkServiceConnectionState: &armhardwaresecuritymodules.PrivateLinkServiceConnectionState{
		// 					Description: to.Ptr("This was automatically approved by user1234@contoso.com"),
		// 					ActionsRequired: to.Ptr("None"),
		// 					Status: to.Ptr(armhardwaresecuritymodules.PrivateEndpointServiceConnectionStatusApproved),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.PrivateEndpointConnectionProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("chsm2"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters/privateEndpointConnections"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm2/privateEndpointConnections/sample-pec2"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("User1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("User2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.PrivateEndpointConnectionProperties{
		// 				PrivateEndpoint: &armhardwaresecuritymodules.PrivateEndpoint{
		// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.Network/privateEndpoints/sample-pec2"),
		// 				},
		// 				PrivateLinkServiceConnectionState: &armhardwaresecuritymodules.PrivateLinkServiceConnectionState{
		// 					Description: to.Ptr("This was automatically approved by user1234@contoso.com"),
		// 					ActionsRequired: to.Ptr("None"),
		// 					Status: to.Ptr(armhardwaresecuritymodules.PrivateEndpointServiceConnectionStatusApproved),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.PrivateEndpointConnectionProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}
