//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhardwaresecuritymodules_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hardwaresecuritymodules/armhardwaresecuritymodules/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_CreateOrUpdate_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudHsmClustersClient().BeginCreateOrUpdate(ctx, "rgcloudhsm", "chsm1", armhardwaresecuritymodules.CloudHsmCluster{
		Location: to.Ptr("eastus2"),
		Tags: map[string]*string{
			"Dept":        to.Ptr("hsm"),
			"Environment": to.Ptr("dogfood"),
		},
		Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
			Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": {},
			},
		},
		SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
			Name:   to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
			Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
		},
		Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
			BackupProperties: &armhardwaresecuritymodules.BackupProperties{
				AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
			},
			PublicNetworkAccess: to.Ptr("Disabled"),
			SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
				FipsState: to.Ptr[int32](2),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CloudHsmCluster = armhardwaresecuritymodules.CloudHsmCluster{
	// 	Name: to.Ptr("chsm1"),
	// 	Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1"),
	// 	SystemData: &armhardwaresecuritymodules.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("CHsmUser1"),
	// 		CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("CHsmUser2"),
	// 		LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 		"Dept": to.Ptr("hsm"),
	// 		"Environment": to.Ptr("dogfood"),
	// 	},
	// 	Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
	// 		Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": &armhardwaresecuritymodules.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
	// 		Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
	// 		Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
	// 	},
	// 	Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
	// 		BackupProperties: &armhardwaresecuritymodules.BackupProperties{
	// 			AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
	// 			LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
	// 			LastBackupStatus: to.Ptr("Status Of last backup"),
	// 		},
	// 		ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr("Disabled"),
	// 		SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
	// 			ActivationStatus: to.Ptr("null"),
	// 			FipsState: to.Ptr[int32](2),
	// 		},
	// 		StatusMessage: to.Ptr("This is a status message"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_Update_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudHsmClustersClient().BeginUpdate(ctx, "rgcloudhsm", "chsm1", armhardwaresecuritymodules.CloudHsmClusterPatchParameters{
		Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
			Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": {},
			},
		},
		Properties: &armhardwaresecuritymodules.CloudHsmClusterPatchParametersProperties{
			BackupProperties: &armhardwaresecuritymodules.BackupProperties{
				AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
			},
		},
		Tags: map[string]*string{
			"Dept":        to.Ptr("hsm"),
			"Environment": to.Ptr("dogfood"),
			"Slice":       to.Ptr("A"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CloudHsmCluster = armhardwaresecuritymodules.CloudHsmCluster{
	// 	Name: to.Ptr("chsm1"),
	// 	Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1"),
	// 	SystemData: &armhardwaresecuritymodules.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("CHsmUser1"),
	// 		CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("CHsmUser2"),
	// 		LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 		"Dept": to.Ptr("hsm"),
	// 		"Environment": to.Ptr("dogfood"),
	// 		"Slice": to.Ptr("A"),
	// 	},
	// 	Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
	// 		Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": &armhardwaresecuritymodules.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
	// 		Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
	// 		Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
	// 	},
	// 	Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
	// 		BackupProperties: &armhardwaresecuritymodules.BackupProperties{
	// 			AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
	// 			LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
	// 			LastBackupStatus: to.Ptr("Status Of last backup"),
	// 		},
	// 		ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr("Disabled"),
	// 		SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
	// 			ActivationStatus: to.Ptr("null"),
	// 			FipsState: to.Ptr[int32](2),
	// 		},
	// 		StatusMessage: to.Ptr("This is a status message"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_Get_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCloudHsmClustersClient().Get(ctx, "rgcloudhsm", "chsm1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CloudHsmCluster = armhardwaresecuritymodules.CloudHsmCluster{
	// 	Name: to.Ptr("chsm1"),
	// 	Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1"),
	// 	SystemData: &armhardwaresecuritymodules.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("CHsmUser1"),
	// 		CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("CHsmUser2"),
	// 		LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 		"Dept": to.Ptr("hsm"),
	// 		"Environment": to.Ptr("dogfood"),
	// 	},
	// 	Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
	// 		Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": &armhardwaresecuritymodules.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
	// 		Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
	// 		Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
	// 	},
	// 	Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
	// 		BackupProperties: &armhardwaresecuritymodules.BackupProperties{
	// 			AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
	// 			LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
	// 			LastBackupStatus: to.Ptr("Status Of last backup"),
	// 		},
	// 		ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr("Disabled"),
	// 		SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
	// 			ActivationStatus: to.Ptr("null"),
	// 			FipsState: to.Ptr[int32](2),
	// 		},
	// 		StatusMessage: to.Ptr("This is a status message"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_Delete_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCloudHsmClustersClient().BeginDelete(ctx, "rgcloudhsm", "chsm1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_ListByResourceGroup_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCloudHsmClustersClient().NewListByResourceGroupPager("rgcloudhsm", &armhardwaresecuritymodules.CloudHsmClustersClientListByResourceGroupOptions{Skiptoken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CloudHsmClusterListResult = armhardwaresecuritymodules.CloudHsmClusterListResult{
		// 	Value: []*armhardwaresecuritymodules.CloudHsmCluster{
		// 		{
		// 			Name: to.Ptr("chsm1"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("CHsmUser1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("CHsmUser2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 				"Dept": to.Ptr("hsm"),
		// 				"Environment": to.Ptr("dogfood"),
		// 			},
		// 			Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
		// 				Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": &armhardwaresecuritymodules.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
		// 				Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
		// 				Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
		// 				BackupProperties: &armhardwaresecuritymodules.BackupProperties{
		// 					AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
		// 					LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
		// 					LastBackupStatus: to.Ptr("Status Of last backup"),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr("Disabled"),
		// 				SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
		// 					ActivationStatus: to.Ptr("null"),
		// 					FipsState: to.Ptr[int32](2),
		// 				},
		// 				StatusMessage: to.Ptr("This is a status message"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("chsm2"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm2"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("CHsmUser1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("CHsmUser2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 				"Dept": to.Ptr("hsm"),
		// 				"Environment": to.Ptr("dogfood"),
		// 			},
		// 			Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
		// 				Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-2": &armhardwaresecuritymodules.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
		// 				Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
		// 				Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
		// 				BackupProperties: &armhardwaresecuritymodules.BackupProperties{
		// 					AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
		// 					LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
		// 					LastBackupStatus: to.Ptr("Status Of last backup"),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr("Disabled"),
		// 				SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
		// 					ActivationStatus: to.Ptr("null"),
		// 					FipsState: to.Ptr[int32](2),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/18b5c820705ab69735b7e1e2e0da5e37ca6e1969/specification/hardwaresecuritymodules/resource-manager/Microsoft.HardwareSecurityModules/preview/2023-12-10-preview/examples/CloudHsmCluster_ListBySubscription_MaximumSet_Gen.json
func ExampleCloudHsmClustersClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhardwaresecuritymodules.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCloudHsmClustersClient().NewListBySubscriptionPager(&armhardwaresecuritymodules.CloudHsmClustersClientListBySubscriptionOptions{Skiptoken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CloudHsmClusterListResult = armhardwaresecuritymodules.CloudHsmClusterListResult{
		// 	Value: []*armhardwaresecuritymodules.CloudHsmCluster{
		// 		{
		// 			Name: to.Ptr("chsm1"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm1"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("CHsmUser1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("CHsmUser2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 				"Dept": to.Ptr("hsm"),
		// 				"Environment": to.Ptr("dogfood"),
		// 			},
		// 			Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
		// 				Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-1": &armhardwaresecuritymodules.UserAssignedIdentity{
		// 					},
		// 				},
		// 			},
		// 			SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
		// 				Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
		// 				Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
		// 				BackupProperties: &armhardwaresecuritymodules.BackupProperties{
		// 					AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
		// 					LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
		// 					LastBackupStatus: to.Ptr("Status Of last backup"),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr("Disabled"),
		// 				SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
		// 					ActivationStatus: to.Ptr("null"),
		// 					FipsState: to.Ptr[int32](2),
		// 				},
		// 				StatusMessage: to.Ptr("This is a status message"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("chsm2"),
		// 			Type: to.Ptr("Microsoft.HardwareSecurityModules/cloudHsmClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgcloudhsm/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/chsm2"),
		// 			SystemData: &armhardwaresecuritymodules.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("CHsmUser1"),
		// 				CreatedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-12T12:00:00.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("CHsmUser2"),
		// 				LastModifiedByType: to.Ptr(armhardwaresecuritymodules.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus2"),
		// 			Tags: map[string]*string{
		// 				"Dept": to.Ptr("hsm"),
		// 				"Environment": to.Ptr("dogfood"),
		// 			},
		// 			Identity: &armhardwaresecuritymodules.ManagedServiceIdentity{
		// 				Type: to.Ptr(armhardwaresecuritymodules.ManagedServiceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armhardwaresecuritymodules.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-2": &armhardwaresecuritymodules.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armhardwaresecuritymodules.CloudHsmClusterSKU{
		// 				Name: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUNameStandardB1),
		// 				Family: to.Ptr(armhardwaresecuritymodules.CloudHsmClusterSKUFamilyB),
		// 			},
		// 			Properties: &armhardwaresecuritymodules.CloudHsmClusterProperties{
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr("TenantReuse"),
		// 				BackupProperties: &armhardwaresecuritymodules.BackupProperties{
		// 					AzureStorageResourceURI: to.Ptr("testStorageResourceUri"),
		// 					LastBackupDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-09T12:00:00.000Z"); return t}()),
		// 					LastBackupStatus: to.Ptr("Status Of last backup"),
		// 				},
		// 				ProvisioningState: to.Ptr(armhardwaresecuritymodules.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr("Disabled"),
		// 				SecurityDomain: &armhardwaresecuritymodules.CloudHsmClusterSecurityDomainProperties{
		// 					ActivationStatus: to.Ptr("null"),
		// 					FipsState: to.Ptr[int32](2),
		// 				},
		// 				StatusMessage: to.Ptr("This is a status message"),
		// 			},
		// 	}},
		// }
	}
}
