//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdigitaltwins

import "time"

// AzureDataExplorerConnectionProperties - Properties of a time series database connection to Azure Data Explorer with data
// being sent via an EventHub.
type AzureDataExplorerConnectionProperties struct {
	// REQUIRED; The name of the Azure Data Explorer database.
	AdxDatabaseName *string

	// REQUIRED; The URI of the Azure Data Explorer endpoint.
	AdxEndpointURI *string

	// REQUIRED; The resource ID of the Azure Data Explorer cluster.
	AdxResourceID *string

	// REQUIRED; The type of time series connection resource.
	ConnectionType *ConnectionType

	// REQUIRED; The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
	EventHubEndpointURI *string

	// REQUIRED; The EventHub name in the EventHub namespace for identity-based authentication.
	EventHubEntityPath *string

	// REQUIRED; The resource ID of the EventHub namespace.
	EventHubNamespaceResourceID *string

	// The name of the Azure Data Explorer table used for recording relationship lifecycle events. The table will not be created
	// if this property is left unspecified.
	AdxRelationshipLifecycleEventsTableName *string

	// The name of the Azure Data Explorer table used for storing updates to properties of twins and relationships. Defaults to
	// AdtPropertyEvents.
	AdxTableName *string

	// The name of the Azure Data Explorer table used for recording twin lifecycle events. The table will not be created if this
	// property is left unspecified.
	AdxTwinLifecycleEventsTableName *string

	// The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
	EventHubConsumerGroup *string

	// Managed identity properties for the time series database connection resource.
	Identity *ManagedIdentityReference

	// Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed
	// values (such as map entries, array elements, etc.). This feature is
	// de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the
	// property events table in ADX.
	RecordPropertyAndItemRemovals *RecordPropertyAndItemRemovals

	// READ-ONLY; The provisioning state.
	ProvisioningState *TimeSeriesDatabaseConnectionState
}

// GetTimeSeriesDatabaseConnectionProperties implements the TimeSeriesDatabaseConnectionPropertiesClassification interface
// for type AzureDataExplorerConnectionProperties.
func (a *AzureDataExplorerConnectionProperties) GetTimeSeriesDatabaseConnectionProperties() *TimeSeriesDatabaseConnectionProperties {
	return &TimeSeriesDatabaseConnectionProperties{
		ConnectionType:    a.ConnectionType,
		Identity:          a.Identity,
		ProvisioningState: a.ProvisioningState,
	}
}

// CheckNameRequest - The result returned from a database check name availability request.
type CheckNameRequest struct {
	// REQUIRED; Resource name.
	Name *string

	// CONSTANT; The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances.
	// Field has constant value "Microsoft.DigitalTwins/digitalTwinsInstances", any specified value is ignored.
	Type *string
}

// CheckNameResult - The result returned from a check name availability request.
type CheckNameResult struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string

	// Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool

	// Message providing the reason why the given name is invalid.
	Reason *Reason
}

// ConnectionProperties - The properties of a private endpoint connection.
type ConnectionProperties struct {
	// The list of group ids for the private endpoint connection.
	GroupIDs []*string

	// The private endpoint.
	PrivateEndpoint *PrivateEndpoint

	// The connection state.
	PrivateLinkServiceConnectionState *ConnectionPropertiesPrivateLinkServiceConnectionState

	// READ-ONLY; The provisioning state.
	ProvisioningState *ConnectionPropertiesProvisioningState
}

// ConnectionPropertiesPrivateLinkServiceConnectionState - The connection state.
type ConnectionPropertiesPrivateLinkServiceConnectionState struct {
	// REQUIRED; The description for the current state of a private endpoint connection.
	Description *string

	// REQUIRED; The status of a private endpoint connection.
	Status *PrivateLinkServiceConnectionStatus

	// Actions required for a private endpoint connection.
	ActionsRequired *string
}

// ConnectionState - The current state of a private endpoint connection.
type ConnectionState struct {
	// REQUIRED; The description for the current state of a private endpoint connection.
	Description *string

	// REQUIRED; The status of a private endpoint connection.
	Status *PrivateLinkServiceConnectionStatus

	// Actions required for a private endpoint connection.
	ActionsRequired *string
}

// Description - The description of the DigitalTwins service.
type Description struct {
	// REQUIRED; The resource location.
	Location *string

	// The managed identity for the DigitalTwinsInstance.
	Identity *Identity

	// DigitalTwins instance properties.
	Properties *Properties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the DigitalTwinsInstance.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// DescriptionListResult - A list of DigitalTwins description objects with a next link.
type DescriptionListResult struct {
	// The link used to get the next page of DigitalTwins description objects.
	NextLink *string

	// A list of DigitalTwins description objects.
	Value []*Description
}

// EndpointResource - DigitalTwinsInstance endpoint resource.
type EndpointResource struct {
	// REQUIRED; DigitalTwinsInstance endpoint resource properties.
	Properties EndpointResourcePropertiesClassification

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; Extension resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// EndpointResourceListResult - A list of DigitalTwinsInstance Endpoints with a next link.
type EndpointResourceListResult struct {
	// The link used to get the next page of DigitalTwinsInstance Endpoints.
	NextLink *string

	// A list of DigitalTwinsInstance Endpoints.
	Value []*EndpointResource
}

// EndpointResourceProperties - Properties related to Digital Twins Endpoint
type EndpointResourceProperties struct {
	// REQUIRED; The type of Digital Twins endpoint
	EndpointType *EndpointType

	// Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected,
	// a connection string must be specified (at least the primary connection
	// string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
	AuthenticationType *AuthenticationType

	// Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string

	// Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string

	// Managed identity properties for the endpoint.
	Identity *ManagedIdentityReference

	// READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *EndpointProvisioningState
}

// GetEndpointResourceProperties implements the EndpointResourcePropertiesClassification interface for type EndpointResourceProperties.
func (e *EndpointResourceProperties) GetEndpointResourceProperties() *EndpointResourceProperties {
	return e
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// Error description
	Error *ErrorDefinition
}

// EventGrid - Properties related to EventGrid.
type EventGrid struct {
	// REQUIRED; EventGrid secondary accesskey. Will be obfuscated during read.
	AccessKey1 *string

	// REQUIRED; The type of Digital Twins endpoint
	EndpointType *EndpointType

	// REQUIRED; EventGrid Topic Endpoint.
	TopicEndpoint *string

	// EventGrid secondary accesskey. Will be obfuscated during read.
	AccessKey2 *string

	// Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected,
	// a connection string must be specified (at least the primary connection
	// string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
	AuthenticationType *AuthenticationType

	// Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string

	// Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string

	// Managed identity properties for the endpoint.
	Identity *ManagedIdentityReference

	// READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *EndpointProvisioningState
}

// GetEndpointResourceProperties implements the EndpointResourcePropertiesClassification interface for type EventGrid.
func (e *EventGrid) GetEndpointResourceProperties() *EndpointResourceProperties {
	return &EndpointResourceProperties{
		AuthenticationType: e.AuthenticationType,
		CreatedTime:        e.CreatedTime,
		DeadLetterSecret:   e.DeadLetterSecret,
		DeadLetterURI:      e.DeadLetterURI,
		EndpointType:       e.EndpointType,
		Identity:           e.Identity,
		ProvisioningState:  e.ProvisioningState,
	}
}

// EventHub - Properties related to EventHub.
type EventHub struct {
	// REQUIRED; The type of Digital Twins endpoint
	EndpointType *EndpointType

	// Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected,
	// a connection string must be specified (at least the primary connection
	// string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
	AuthenticationType *AuthenticationType

	// PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	ConnectionStringPrimaryKey *string

	// SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	ConnectionStringSecondaryKey *string

	// Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string

	// Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string

	// The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
	EndpointURI *string

	// The EventHub name in the EventHub namespace for identity-based authentication.
	EntityPath *string

	// Managed identity properties for the endpoint.
	Identity *ManagedIdentityReference

	// READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *EndpointProvisioningState
}

// GetEndpointResourceProperties implements the EndpointResourcePropertiesClassification interface for type EventHub.
func (e *EventHub) GetEndpointResourceProperties() *EndpointResourceProperties {
	return &EndpointResourceProperties{
		AuthenticationType: e.AuthenticationType,
		CreatedTime:        e.CreatedTime,
		DeadLetterSecret:   e.DeadLetterSecret,
		DeadLetterURI:      e.DeadLetterURI,
		EndpointType:       e.EndpointType,
		Identity:           e.Identity,
		ProvisioningState:  e.ProvisioningState,
	}
}

// ExternalResource - Definition of a resource.
type ExternalResource struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; Extension resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// GroupIDInformation - The group information for creating a private endpoint on Digital Twin.
type GroupIDInformation struct {
	// REQUIRED; The group information properties.
	Properties *GroupIDInformationProperties

	// The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// GroupIDInformationProperties - The properties for a group information object.
type GroupIDInformationProperties struct {
	// The group id.
	GroupID *string

	// The required members for a specific group id.
	RequiredMembers []*string

	// The required DNS zones for a specific group id.
	RequiredZoneNames []*string
}

// GroupIDInformationResponse - The available private link resources for a Digital Twin.
type GroupIDInformationResponse struct {
	// The list of available private link resources for a Digital Twin.
	Value []*GroupIDInformation
}

// Identity - The managed identity for the DigitalTwinsInstance.
type Identity struct {
	// The type of Managed Identity used by the DigitalTwinsInstance.
	Type *DigitalTwinsIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	// .
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id
	// header in the PUT request if the resource has a systemAssigned(implicit)
	// identity
	PrincipalID *string

	// READ-ONLY; The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id
	// header in the PUT request if the resource has a systemAssigned(implicit) identity
	TenantID *string
}

// ManagedIdentityReference - The properties of the Managed Identity.
type ManagedIdentityReference struct {
	// The type of managed identity used.
	Type *IdentityType

	// The user identity ARM resource id if the managed identity type is 'UserAssigned'.
	UserAssignedIdentity *string
}

// Operation - DigitalTwins service REST API operation
type Operation struct {
	// Operation properties display
	Display *OperationDisplay

	// READ-ONLY; If the operation is a data action (for data plane rbac).
	IsDataAction *bool

	// READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *string

	// READ-ONLY; Operation properties.
	Properties map[string]any
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly description for the operation.
	Description *string

	// READ-ONLY; Name of the operation.
	Operation *string

	// READ-ONLY; Service provider: Microsoft DigitalTwins.
	Provider *string

	// READ-ONLY; Resource Type: DigitalTwinsInstances.
	Resource *string
}

// OperationListResult - A list of DigitalTwins service operations. It contains a list of operations and a URL link to get
// the next set of results.
type OperationListResult struct {
	// The link used to get the next page of DigitalTwins description objects.
	NextLink *string

	// READ-ONLY; A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource provider.
	Value []*Operation
}

// PatchDescription - The description of the DigitalTwins service.
type PatchDescription struct {
	// The managed identity for the DigitalTwinsInstance.
	Identity *Identity

	// Properties for the DigitalTwinsInstance.
	Properties *PatchProperties

	// Instance patch properties
	Tags map[string]*string
}

// PatchProperties - The properties of a DigitalTwinsInstance.
type PatchProperties struct {
	// Public network access for the DigitalTwinsInstance.
	PublicNetworkAccess *PublicNetworkAccess
}

// PrivateEndpoint - The private endpoint property of a private endpoint connection.
type PrivateEndpoint struct {
	// READ-ONLY; The resource identifier.
	ID *string
}

// PrivateEndpointConnection - The private endpoint connection of a Digital Twin.
type PrivateEndpointConnection struct {
	// REQUIRED; The connection properties.
	Properties *ConnectionProperties

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the private endpoint connection.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateEndpointConnectionsResponse - The available private link connections for a Digital Twin.
type PrivateEndpointConnectionsResponse struct {
	// The list of available private link connections for a Digital Twin.
	Value []*PrivateEndpointConnection
}

// Properties - The properties of a DigitalTwinsInstance.
type Properties struct {
	// The private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// Public network access for the DigitalTwinsInstance.
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; Time when DigitalTwinsInstance was created.
	CreatedTime *time.Time

	// READ-ONLY; Api endpoint to work with DigitalTwinsInstance.
	HostName *string

	// READ-ONLY; Time when DigitalTwinsInstance was updated.
	LastUpdatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState
}

// Resource - The common properties of a DigitalTwinsInstance.
type Resource struct {
	// REQUIRED; The resource location.
	Location *string

	// The managed identity for the DigitalTwinsInstance.
	Identity *Identity

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the DigitalTwinsInstance.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// ServiceBus - Properties related to ServiceBus.
type ServiceBus struct {
	// REQUIRED; The type of Digital Twins endpoint
	EndpointType *EndpointType

	// Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected,
	// a connection string must be specified (at least the primary connection
	// string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
	AuthenticationType *AuthenticationType

	// Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string

	// Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string

	// The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
	EndpointURI *string

	// The ServiceBus Topic name for identity-based authentication.
	EntityPath *string

	// Managed identity properties for the endpoint.
	Identity *ManagedIdentityReference

	// PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	PrimaryConnectionString *string

	// SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	SecondaryConnectionString *string

	// READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *EndpointProvisioningState
}

// GetEndpointResourceProperties implements the EndpointResourcePropertiesClassification interface for type ServiceBus.
func (s *ServiceBus) GetEndpointResourceProperties() *EndpointResourceProperties {
	return &EndpointResourceProperties{
		AuthenticationType: s.AuthenticationType,
		CreatedTime:        s.CreatedTime,
		DeadLetterSecret:   s.DeadLetterSecret,
		DeadLetterURI:      s.DeadLetterURI,
		EndpointType:       s.EndpointType,
		Identity:           s.Identity,
		ProvisioningState:  s.ProvisioningState,
	}
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TimeSeriesDatabaseConnection - Describes a time series database connection resource.
type TimeSeriesDatabaseConnection struct {
	// Properties of a specific time series database connection.
	Properties TimeSeriesDatabaseConnectionPropertiesClassification

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; Extension resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// TimeSeriesDatabaseConnectionListResult - A pageable list of time series database connection resources.
type TimeSeriesDatabaseConnectionListResult struct {
	// The link used to get the next page of results.
	NextLink *string

	// A list of time series database connection resources.
	Value []*TimeSeriesDatabaseConnection
}

// TimeSeriesDatabaseConnectionProperties - Properties of a time series database connection resource.
type TimeSeriesDatabaseConnectionProperties struct {
	// REQUIRED; The type of time series connection resource.
	ConnectionType *ConnectionType

	// Managed identity properties for the time series database connection resource.
	Identity *ManagedIdentityReference

	// READ-ONLY; The provisioning state.
	ProvisioningState *TimeSeriesDatabaseConnectionState
}

// GetTimeSeriesDatabaseConnectionProperties implements the TimeSeriesDatabaseConnectionPropertiesClassification interface
// for type TimeSeriesDatabaseConnectionProperties.
func (t *TimeSeriesDatabaseConnectionProperties) GetTimeSeriesDatabaseConnectionProperties() *TimeSeriesDatabaseConnectionProperties {
	return t
}

// UserAssignedIdentity - The information about the user assigned identity.
type UserAssignedIdentity struct {
	// READ-ONLY; The client id of the User Assigned Identity Resource.
	ClientID *string

	// READ-ONLY; The object id of the User Assigned Identity Resource.
	PrincipalID *string
}
