//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdeviceprovisioningservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/deviceprovisioningservices/armdeviceprovisioningservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGet.json
func ExampleIotDpsResourceClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().Get(ctx, "myFirstProvisioningService", "myResourceGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisioningServiceDescription = armdeviceprovisioningservices.ProvisioningServiceDescription{
	// 	Name: to.Ptr("myFirstProvisioningService"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
	// 	Location: to.Ptr("eastus"),
	// 	Resourcegroup: to.Ptr("myResourceGroup"),
	// 	Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAAADGk="),
	// 	Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("aa80bd74-a3f0-4f14-b9da-99c5351cf9d5"),
	// 		TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
	// 		UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
	// 			"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdeviceprovisioningservices.UserAssignedIdentity{
	// 				ClientID: to.Ptr("c38f618d-47f6-4260-8b3d-1dd8c130f323"),
	// 				PrincipalID: to.Ptr("f1b0b133-10dc-4985-966f-a98a04675fe9"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
	// 		AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
	// 		AuthorizationPolicies: []*armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleAccessRightsDescription{
	// 		},
	// 		DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
	// 		IDScope: to.Ptr("0ne00000012"),
	// 		PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
	// 		ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
	// 		State: to.Ptr(armdeviceprovisioningservices.StateActive),
	// 	},
	// 	SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
	// 		Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
	// 		Capacity: to.Ptr[int64](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSCreate.json
func ExampleIotDpsResourceClient_BeginCreateOrUpdate_dpsCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myFirstProvisioningService", armdeviceprovisioningservices.ProvisioningServiceDescription{
		Location: to.Ptr("East US"),
		Tags:     map[string]*string{},
		Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
			EnableDataResidency: to.Ptr(false),
		},
		SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
			Name:     to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
			Capacity: to.Ptr[int64](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisioningServiceDescription = armdeviceprovisioningservices.ProvisioningServiceDescription{
	// 	Name: to.Ptr("myFirstProvisioningService"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups//providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
	// 	Location: to.Ptr("eastus"),
	// 	Resourcegroup: to.Ptr("myResourceGroup"),
	// 	Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAAADGk="),
	// 	Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
	// 		AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
	// 		AuthorizationPolicies: []*armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleAccessRightsDescription{
	// 		},
	// 		DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
	// 		EnableDataResidency: to.Ptr(false),
	// 		IDScope: to.Ptr("0ne00000012"),
	// 		PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
	// 		ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
	// 		State: to.Ptr(armdeviceprovisioningservices.StateActive),
	// 	},
	// 	SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
	// 		Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
	// 		Capacity: to.Ptr[int64](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSUpdate.json
func ExampleIotDpsResourceClient_BeginCreateOrUpdate_dpsUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myFirstProvisioningService", armdeviceprovisioningservices.ProvisioningServiceDescription{
		Location: to.Ptr("East US"),
		Tags:     map[string]*string{},
		Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
			Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
				"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": {},
			},
		},
		Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
			EnableDataResidency: to.Ptr(false),
		},
		SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
			Name:     to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
			Capacity: to.Ptr[int64](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisioningServiceDescription = armdeviceprovisioningservices.ProvisioningServiceDescription{
	// 	Name: to.Ptr("myFirstProvisioningService"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups//providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
	// 	Location: to.Ptr("eastus"),
	// 	Resourcegroup: to.Ptr("myResourceGroup"),
	// 	Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAAADGk="),
	// 	Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("aa80bd74-a3f0-4f14-b9da-99c5351cf9d5"),
	// 		TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
	// 		UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
	// 			"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdeviceprovisioningservices.UserAssignedIdentity{
	// 				ClientID: to.Ptr("c38f618d-47f6-4260-8b3d-1dd8c130f323"),
	// 				PrincipalID: to.Ptr("f1b0b133-10dc-4985-966f-a98a04675fe9"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
	// 		AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
	// 		AuthorizationPolicies: []*armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleAccessRightsDescription{
	// 		},
	// 		DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
	// 		EnableDataResidency: to.Ptr(false),
	// 		IDScope: to.Ptr("0ne00000012"),
	// 		PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
	// 		ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
	// 		State: to.Ptr(armdeviceprovisioningservices.StateActive),
	// 	},
	// 	SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
	// 		Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
	// 		Capacity: to.Ptr[int64](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSPatch.json
func ExampleIotDpsResourceClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginUpdate(ctx, "myResourceGroup", "myFirstProvisioningService", armdeviceprovisioningservices.TagsResource{
		Tags: map[string]*string{
			"foo": to.Ptr("bar"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProvisioningServiceDescription = armdeviceprovisioningservices.ProvisioningServiceDescription{
	// 	Name: to.Ptr("myFirstProvisioningService"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
	// 	Location: to.Ptr("eastus"),
	// 	Resourcegroup: to.Ptr("myResourceGroup"),
	// 	Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
	// 	Tags: map[string]*string{
	// 		"foo": to.Ptr("bar"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAADGk="),
	// 	Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("aa80bd74-a3f0-4f14-b9da-99c5351cf9d5"),
	// 		TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
	// 		UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
	// 			"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdeviceprovisioningservices.UserAssignedIdentity{
	// 				ClientID: to.Ptr("c38f618d-47f6-4260-8b3d-1dd8c130f323"),
	// 				PrincipalID: to.Ptr("f1b0b133-10dc-4985-966f-a98a04675fe9"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
	// 		AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
	// 		DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
	// 		IDScope: to.Ptr("0ne00000012"),
	// 		PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
	// 		ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
	// 		State: to.Ptr(armdeviceprovisioningservices.StateActive),
	// 	},
	// 	SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
	// 		Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
	// 		Capacity: to.Ptr[int64](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSDelete.json
func ExampleIotDpsResourceClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginDelete(ctx, "myFirstProvisioningService", "myResourceGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSListBySubscription.json
func ExampleIotDpsResourceClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotDpsResourceClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProvisioningServiceDescriptionListResult = armdeviceprovisioningservices.ProvisioningServiceDescriptionListResult{
		// 	Value: []*armdeviceprovisioningservices.ProvisioningServiceDescription{
		// 		{
		// 			Name: to.Ptr("myFirstProvisioningService"),
		// 			Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
		// 			Location: to.Ptr("eastus"),
		// 			Resourcegroup: to.Ptr("myResourceGroup"),
		// 			Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAAADGk="),
		// 			Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("aa80bd74-a3f0-4f14-b9da-99c5351cf9d5"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
		// 					"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdeviceprovisioningservices.UserAssignedIdentity{
		// 						ClientID: to.Ptr("c38f618d-47f6-4260-8b3d-1dd8c130f323"),
		// 						PrincipalID: to.Ptr("f1b0b133-10dc-4985-966f-a98a04675fe9"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
		// 				AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
		// 				DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
		// 				IDScope: to.Ptr("0ne00000012"),
		// 				PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
		// 				ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
		// 				State: to.Ptr(armdeviceprovisioningservices.StateActive),
		// 			},
		// 			SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
		// 				Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
		// 				Capacity: to.Ptr[int64](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySecondProvisioningService"),
		// 			Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/mySecondProvisioningService"),
		// 			Location: to.Ptr("eastus"),
		// 			Resourcegroup: to.Ptr("myResourceGroup"),
		// 			Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAAADGk="),
		// 			Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("01341f2b-d497-4117-b5c1-1f1d50b25444"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
		// 					"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity2": &armdeviceprovisioningservices.UserAssignedIdentity{
		// 						ClientID: to.Ptr("8cd6d250-17dd-4c1b-9847-225237b94c55"),
		// 						PrincipalID: to.Ptr("8785a11f-848a-4d5d-a55b-e381b9e15512"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
		// 				AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
		// 				DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
		// 				IDScope: to.Ptr("0ne00000012"),
		// 				PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
		// 				ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
		// 				State: to.Ptr(armdeviceprovisioningservices.StateActive),
		// 			},
		// 			SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
		// 				Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
		// 				Capacity: to.Ptr[int64](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSListByResourceGroup.json
func ExampleIotDpsResourceClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotDpsResourceClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProvisioningServiceDescriptionListResult = armdeviceprovisioningservices.ProvisioningServiceDescriptionListResult{
		// 	Value: []*armdeviceprovisioningservices.ProvisioningServiceDescription{
		// 		{
		// 			Name: to.Ptr("myFirstProvisioningService"),
		// 			Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService"),
		// 			Location: to.Ptr("eastus"),
		// 			Resourcegroup: to.Ptr("myResourceGroup"),
		// 			Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAAADGk="),
		// 			Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("aa80bd74-a3f0-4f14-b9da-99c5351cf9d5"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
		// 					"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdeviceprovisioningservices.UserAssignedIdentity{
		// 						ClientID: to.Ptr("c38f618d-47f6-4260-8b3d-1dd8c130f323"),
		// 						PrincipalID: to.Ptr("f1b0b133-10dc-4985-966f-a98a04675fe9"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
		// 				AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
		// 				DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
		// 				IDScope: to.Ptr("0ne00000012"),
		// 				PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
		// 				ServiceOperationsHostName: to.Ptr("myFirstProvisioningService.azure-devices-provisioning.net"),
		// 				State: to.Ptr(armdeviceprovisioningservices.StateActive),
		// 			},
		// 			SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
		// 				Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
		// 				Capacity: to.Ptr[int64](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySecondProvisioningService"),
		// 			Type: to.Ptr("Microsoft.Devices/ProvisioningServices"),
		// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/mySecondProvisioningService"),
		// 			Location: to.Ptr("eastus"),
		// 			Resourcegroup: to.Ptr("myResourceGroup"),
		// 			Subscriptionid: to.Ptr("91d12660-3dec-467a-be2a-213b5544ddc0"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("AAAAAAAADGk="),
		// 			Identity: &armdeviceprovisioningservices.ManagedServiceIdentity{
		// 				Type: to.Ptr(armdeviceprovisioningservices.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("01341f2b-d497-4117-b5c1-1f1d50b25444"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armdeviceprovisioningservices.UserAssignedIdentity{
		// 					"/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourcegroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity2": &armdeviceprovisioningservices.UserAssignedIdentity{
		// 						ClientID: to.Ptr("8cd6d250-17dd-4c1b-9847-225237b94c55"),
		// 						PrincipalID: to.Ptr("8785a11f-848a-4d5d-a55b-e381b9e15512"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armdeviceprovisioningservices.IotDpsPropertiesDescription{
		// 				AllocationPolicy: to.Ptr(armdeviceprovisioningservices.AllocationPolicyHashed),
		// 				DeviceProvisioningHostName: to.Ptr("global.azure-devices-provisioning.net"),
		// 				IDScope: to.Ptr("0ne00000012"),
		// 				PortalOperationsHostName: to.Ptr("myFirstProvisioningService.services.azure-devices-provisioning.net"),
		// 				ServiceOperationsHostName: to.Ptr("mySecondProvisioningService.azure-devices-provisioning.net"),
		// 				State: to.Ptr(armdeviceprovisioningservices.StateActive),
		// 			},
		// 			SKU: &armdeviceprovisioningservices.IotDpsSKUInfo{
		// 				Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
		// 				Capacity: to.Ptr[int64](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGetOperationResult.json
func ExampleIotDpsResourceClient_GetOperationResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().GetOperationResult(ctx, "MTY5OTNmZDctODI5Yy00N2E2LTkxNDQtMDU1NGIyYzY1ZjRl", "myResourceGroup", "myFirstProvisioningService", "1508265712453", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationResult = armdeviceprovisioningservices.AsyncOperationResult{
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGetValidSku.json
func ExampleIotDpsResourceClient_NewListValidSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotDpsResourceClient().NewListValidSKUsPager("myFirstProvisioningService", "myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IotDpsSKUDefinitionListResult = armdeviceprovisioningservices.IotDpsSKUDefinitionListResult{
		// 	Value: []*armdeviceprovisioningservices.IotDpsSKUDefinition{
		// 		{
		// 			Name: to.Ptr(armdeviceprovisioningservices.IotDpsSKUS1),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSCheckNameAvailability.json
func ExampleIotDpsResourceClient_CheckProvisioningServiceNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().CheckProvisioningServiceNameAvailability(ctx, armdeviceprovisioningservices.OperationInputs{
		Name: to.Ptr("test213123"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityInfo = armdeviceprovisioningservices.NameAvailabilityInfo{
	// 	Message: to.Ptr("name is valid"),
	// 	NameAvailable: to.Ptr(true),
	// 	Reason: to.Ptr(armdeviceprovisioningservices.NameUnavailabilityReasonInvalid),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSListKeys.json
func ExampleIotDpsResourceClient_NewListKeysPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotDpsResourceClient().NewListKeysPager("myFirstProvisioningService", "myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SharedAccessSignatureAuthorizationRuleListResult = armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleListResult{
		// 	Value: []*armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleAccessRightsDescription{
		// 		{
		// 			KeyName: to.Ptr("key1"),
		// 			PrimaryKey: to.Ptr("#####################################"),
		// 			Rights: to.Ptr(armdeviceprovisioningservices.AccessRightsDescriptionServiceConfig),
		// 			SecondaryKey: to.Ptr("###################################"),
		// 		},
		// 		{
		// 			KeyName: to.Ptr("key2"),
		// 			PrimaryKey: to.Ptr("#######################################"),
		// 			Rights: to.Ptr(armdeviceprovisioningservices.AccessRightsDescriptionServiceConfig),
		// 			SecondaryKey: to.Ptr("####################################="),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGetKey.json
func ExampleIotDpsResourceClient_ListKeysForKeyName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().ListKeysForKeyName(ctx, "myFirstProvisioningService", "testKey", "myResourceGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SharedAccessSignatureAuthorizationRuleAccessRightsDescription = armdeviceprovisioningservices.SharedAccessSignatureAuthorizationRuleAccessRightsDescription{
	// 	KeyName: to.Ptr("testKey"),
	// 	PrimaryKey: to.Ptr("##################################"),
	// 	Rights: to.Ptr(armdeviceprovisioningservices.AccessRightsDescriptionRegistrationStatusWrite),
	// 	SecondaryKey: to.Ptr("################################"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSListPrivateLinkResources.json
func ExampleIotDpsResourceClient_ListPrivateLinkResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().ListPrivateLinkResources(ctx, "myResourceGroup", "myFirstProvisioningService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateLinkResources = armdeviceprovisioningservices.PrivateLinkResources{
	// 	Value: []*armdeviceprovisioningservices.GroupIDInformation{
	// 		{
	// 			Name: to.Ptr("iotDps"),
	// 			Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateLinkResources"),
	// 			ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateLinkResources/iotDps"),
	// 			Properties: &armdeviceprovisioningservices.GroupIDInformationProperties{
	// 				GroupID: to.Ptr("iotDps"),
	// 				RequiredMembers: []*string{
	// 					to.Ptr("iotDps")},
	// 					RequiredZoneNames: []*string{
	// 						to.Ptr("privatelink.azure-devices-provisioning.net")},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGetPrivateLinkResources.json
func ExampleIotDpsResourceClient_GetPrivateLinkResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().GetPrivateLinkResources(ctx, "myResourceGroup", "myFirstProvisioningService", "iotDps", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GroupIDInformation = armdeviceprovisioningservices.GroupIDInformation{
	// 	Name: to.Ptr("iotDps"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateLinkResources"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateLinkResources/iotDps"),
	// 	Properties: &armdeviceprovisioningservices.GroupIDInformationProperties{
	// 		GroupID: to.Ptr("iotDps"),
	// 		RequiredMembers: []*string{
	// 			to.Ptr("iotDps")},
	// 			RequiredZoneNames: []*string{
	// 				to.Ptr("privatelink.azure-devices-provisioning.net")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSListPrivateEndpointConnections.json
func ExampleIotDpsResourceClient_ListPrivateEndpointConnections() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().ListPrivateEndpointConnections(ctx, "myResourceGroup", "myFirstProvisioningService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateEndpointConnectionArray = []*armdeviceprovisioningservices.PrivateEndpointConnection{
	// 	{
	// 		Name: to.Ptr("myPrivateEndpointConnection"),
	// 		Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateEndpointConnections"),
	// 		ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateEndpointConnections/myPrivateEndpointConnection"),
	// 		Properties: &armdeviceprovisioningservices.PrivateEndpointConnectionProperties{
	// 			PrivateEndpoint: &armdeviceprovisioningservices.PrivateEndpoint{
	// 				ID: to.Ptr("/subscriptions/a9eba280-4734-4d49-878f-b5549d1d0453/resourceGroups/networkResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 			},
	// 			PrivateLinkServiceConnectionState: &armdeviceprovisioningservices.PrivateLinkServiceConnectionState{
	// 				Description: to.Ptr("Please approve my request!"),
	// 				ActionsRequired: to.Ptr("None"),
	// 				Status: to.Ptr(armdeviceprovisioningservices.PrivateLinkServiceConnectionStatusPending),
	// 			},
	// 		},
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSGetPrivateEndpointConnection.json
func ExampleIotDpsResourceClient_GetPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotDpsResourceClient().GetPrivateEndpointConnection(ctx, "myResourceGroup", "myFirstProvisioningService", "myPrivateEndpointConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateEndpointConnection = armdeviceprovisioningservices.PrivateEndpointConnection{
	// 	Name: to.Ptr("myPrivateEndpointConnection"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateEndpointConnections"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateEndpointConnections/myPrivateEndpointConnection"),
	// 	Properties: &armdeviceprovisioningservices.PrivateEndpointConnectionProperties{
	// 		PrivateEndpoint: &armdeviceprovisioningservices.PrivateEndpoint{
	// 			ID: to.Ptr("/subscriptions/a9eba280-4734-4d49-878f-b5549d1d0453/resourceGroups/networkResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armdeviceprovisioningservices.PrivateLinkServiceConnectionState{
	// 			Description: to.Ptr("Please approve my request!"),
	// 			ActionsRequired: to.Ptr("None"),
	// 			Status: to.Ptr(armdeviceprovisioningservices.PrivateLinkServiceConnectionStatusPending),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSCreateOrUpdatePrivateEndpointConnection.json
func ExampleIotDpsResourceClient_BeginCreateOrUpdatePrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginCreateOrUpdatePrivateEndpointConnection(ctx, "myResourceGroup", "myFirstProvisioningService", "myPrivateEndpointConnection", armdeviceprovisioningservices.PrivateEndpointConnection{
		Properties: &armdeviceprovisioningservices.PrivateEndpointConnectionProperties{
			PrivateLinkServiceConnectionState: &armdeviceprovisioningservices.PrivateLinkServiceConnectionState{
				Description: to.Ptr("Approved by johndoe@contoso.com"),
				Status:      to.Ptr(armdeviceprovisioningservices.PrivateLinkServiceConnectionStatusApproved),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateEndpointConnection = armdeviceprovisioningservices.PrivateEndpointConnection{
	// 	Name: to.Ptr("myPrivateEndpointConnection"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateEndpointConnections"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateEndpointConnections/myPrivateEndpointConnection"),
	// 	Properties: &armdeviceprovisioningservices.PrivateEndpointConnectionProperties{
	// 		PrivateEndpoint: &armdeviceprovisioningservices.PrivateEndpoint{
	// 			ID: to.Ptr("/subscriptions/a9eba280-4734-4d49-878f-b5549d1d0453/resourceGroups/networkResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armdeviceprovisioningservices.PrivateLinkServiceConnectionState{
	// 			Description: to.Ptr("Approved by johndoe@contoso.com"),
	// 			ActionsRequired: to.Ptr("None"),
	// 			Status: to.Ptr(armdeviceprovisioningservices.PrivateLinkServiceConnectionStatusApproved),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/deviceprovisioningservices/resource-manager/Microsoft.Devices/preview/2023-03-01-preview/examples/DPSDeletePrivateEndpointConnection.json
func ExampleIotDpsResourceClient_BeginDeletePrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeviceprovisioningservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIotDpsResourceClient().BeginDeletePrivateEndpointConnection(ctx, "myResourceGroup", "myFirstProvisioningService", "myPrivateEndpointConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateEndpointConnection = armdeviceprovisioningservices.PrivateEndpointConnection{
	// 	Name: to.Ptr("myPrivateEndpointConnection"),
	// 	Type: to.Ptr("Microsoft.Devices/ProvisioningServices/PrivateEndpointConnections"),
	// 	ID: to.Ptr("/subscriptions/91d12660-3dec-467a-be2a-213b5544ddc0/resourceGroups/myResourceGroup/providers/Microsoft.Devices/ProvisioningServices/myFirstProvisioningService/PrivateEndpointConnections/myPrivateEndpointConnection"),
	// 	Properties: &armdeviceprovisioningservices.PrivateEndpointConnectionProperties{
	// 		PrivateEndpoint: &armdeviceprovisioningservices.PrivateEndpoint{
	// 			ID: to.Ptr("/subscriptions/a9eba280-4734-4d49-878f-b5549d1d0453/resourceGroups/networkResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armdeviceprovisioningservices.PrivateLinkServiceConnectionState{
	// 			Description: to.Ptr("Deleted"),
	// 			ActionsRequired: to.Ptr("None"),
	// 			Status: to.Ptr(armdeviceprovisioningservices.PrivateLinkServiceConnectionStatusDisconnected),
	// 		},
	// 	},
	// }
}
