//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdataprotection_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/dataprotection/resource-manager/Microsoft.DataProtection/stable/2023-11-01/examples/JobCRUD/ListJobs.json
func ExampleJobsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataprotection.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobsClient().NewListPager("BugBash1", "BugBashVaultForCCYv11", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AzureBackupJobResourceList = armdataprotection.AzureBackupJobResourceList{
		// 	Value: []*armdataprotection.AzureBackupJobResource{
		// 		{
		// 			Name: to.Ptr("8989416e-7573-4836-8cf1-0e90954f1002"),
		// 			Type: to.Ptr("Microsoft.DataProtection/Backupvaults/backupJobs"),
		// 			ID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/Backupvaults/BugBashVaultForCCYv11/backupJobs/8989416e-7573-4836-8cf1-0e90954f1002"),
		// 			Properties: &armdataprotection.AzureBackupJob{
		// 				ActivityID: to.Ptr("932925c4-3d81-4550-8105-c7f7b0a934c5"),
		// 				BackupInstanceFriendlyName: to.Ptr("mabtestingccybasicv11\\bugbashdb4"),
		// 				BackupInstanceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupInstances/3048870f-b1b7-44c4-b078-368da3fd000e"),
		// 				DataSourceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/DppPostgresTestingCcy/providers/Microsoft.DBforPostgreSQL/servers/mabtestingccybasicv11/databases/bugbashdb4"),
		// 				DataSourceLocation: to.Ptr("centraluseuap"),
		// 				DataSourceName: to.Ptr("bugbashdb4"),
		// 				DataSourceSetName: to.Ptr("mabtestingccybasicv11"),
		// 				DataSourceType: to.Ptr("Microsoft.DBforPostgreSQL/servers/databases"),
		// 				Duration: to.Ptr("00:00:00"),
		// 				IsUserTriggered: to.Ptr(false),
		// 				Operation: to.Ptr("Backup"),
		// 				OperationCategory: to.Ptr("Backup"),
		// 				PolicyID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupPolicies/jakavetPolicy2"),
		// 				PolicyName: to.Ptr("jakavetPolicy2"),
		// 				ProgressEnabled: to.Ptr(false),
		// 				SourceResourceGroup: to.Ptr("DppPostgresTestingCcy"),
		// 				SourceSubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-16T05:00:08.174Z"); return t}()),
		// 				Status: to.Ptr("Started"),
		// 				SubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				SupportedActions: []*string{
		// 				},
		// 				VaultName: to.Ptr("BugBashVaultForCCYv11"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ad218c05-242a-47c2-b7b7-c16bd0f8870c"),
		// 			Type: to.Ptr("Microsoft.DataProtection/Backupvaults/backupJobs"),
		// 			ID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/Backupvaults/BugBashVaultForCCYv11/backupJobs/ad218c05-242a-47c2-b7b7-c16bd0f8870c"),
		// 			Properties: &armdataprotection.AzureBackupJob{
		// 				ActivityID: to.Ptr("b4f32e03-ded0-46fc-9afc-91853878efcd"),
		// 				BackupInstanceFriendlyName: to.Ptr("mabtestingccybasicv11\\bugbashdb5"),
		// 				BackupInstanceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupInstances/943c60db-c033-4d93-bb00-66048474e00e"),
		// 				DataSourceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/DppPostgresTestingCcy/providers/Microsoft.DBforPostgreSQL/servers/mabtestingccybasicv11/databases/bugbashdb5"),
		// 				DataSourceLocation: to.Ptr("centraluseuap"),
		// 				DataSourceName: to.Ptr("bugbashdb5"),
		// 				DataSourceSetName: to.Ptr("mabtestingccybasicv11"),
		// 				DataSourceType: to.Ptr("Microsoft.DBforPostgreSQL/servers/databases"),
		// 				Duration: to.Ptr("00:00:00"),
		// 				IsUserTriggered: to.Ptr(false),
		// 				Operation: to.Ptr("Backup"),
		// 				OperationCategory: to.Ptr("Backup"),
		// 				PolicyID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupPolicies/jakavetPolicy3"),
		// 				PolicyName: to.Ptr("jakavetPolicy3"),
		// 				ProgressEnabled: to.Ptr(false),
		// 				SourceResourceGroup: to.Ptr("DppPostgresTestingCcy"),
		// 				SourceSubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-16T18:00:03.666Z"); return t}()),
		// 				Status: to.Ptr("Started"),
		// 				SubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				SupportedActions: []*string{
		// 				},
		// 				VaultName: to.Ptr("BugBashVaultForCCYv11"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("3c60cb49-63e8-4b21-b9bd-26277b3fdfae"),
		// 			Type: to.Ptr("Microsoft.DataProtection/Backupvaults/backupJobs"),
		// 			ID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/Backupvaults/BugBashVaultForCCYv11/backupJobs/3c60cb49-63e8-4b21-b9bd-26277b3fdfae"),
		// 			Properties: &armdataprotection.AzureBackupJob{
		// 				ActivityID: to.Ptr("c4344fb4-7c11-43a4-8307-7ae7c7fb09b9"),
		// 				BackupInstanceFriendlyName: to.Ptr("mabtestingccybasicv11\\bugbashdb2"),
		// 				BackupInstanceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupInstances/28460a9d-707a-45f3-ace6-b16284c2900e"),
		// 				DataSourceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/DppPostgresTestingCcy/providers/Microsoft.DBforPostgreSQL/servers/mabtestingccybasicv11/databases/bugbashdb2"),
		// 				DataSourceLocation: to.Ptr("centraluseuap"),
		// 				DataSourceName: to.Ptr("bugbashdb2"),
		// 				DataSourceSetName: to.Ptr("mabtestingccybasicv11"),
		// 				DataSourceType: to.Ptr("Microsoft.DBforPostgreSQL/servers/databases"),
		// 				Duration: to.Ptr("00:00:00"),
		// 				IsUserTriggered: to.Ptr(false),
		// 				Operation: to.Ptr("Backup"),
		// 				OperationCategory: to.Ptr("Backup"),
		// 				PolicyID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupPolicies/jakavetdailypolicy"),
		// 				PolicyName: to.Ptr("jakavetdailypolicy"),
		// 				ProgressEnabled: to.Ptr(false),
		// 				SourceResourceGroup: to.Ptr("DppPostgresTestingCcy"),
		// 				SourceSubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T03:00:03.760Z"); return t}()),
		// 				Status: to.Ptr("Started"),
		// 				SubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				SupportedActions: []*string{
		// 				},
		// 				VaultName: to.Ptr("BugBashVaultForCCYv11"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("43252662-1b43-44fd-a856-0055665cb097"),
		// 			Type: to.Ptr("Microsoft.DataProtection/Backupvaults/backupJobs"),
		// 			ID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/Backupvaults/BugBashVaultForCCYv11/backupJobs/43252662-1b43-44fd-a856-0055665cb097"),
		// 			Properties: &armdataprotection.AzureBackupJob{
		// 				ActivityID: to.Ptr("94052cf1-a47f-4c1b-93e7-79e07b2bd008-Tue Mar 17 2021 11:11:48 GMT+0530 (India Standard Time)-Ibz"),
		// 				BackupInstanceFriendlyName: to.Ptr("mabtestingccybasicv11\\bugbashdb3"),
		// 				BackupInstanceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupInstances/0b247869-b8be-4885-b832-8ac4cdf5b00e"),
		// 				DataSourceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/DppPostgresTestingCcy/providers/Microsoft.DBforPostgreSQL/servers/mabtestingccybasicv11/databases/bugbashdb3"),
		// 				DataSourceLocation: to.Ptr("centraluseuap"),
		// 				DataSourceName: to.Ptr("bugbashdb3"),
		// 				DataSourceSetName: to.Ptr("mabtestingccybasicv11"),
		// 				DataSourceType: to.Ptr("Microsoft.DBforPostgreSQL/servers/databases"),
		// 				Duration: to.Ptr("00:02:11.9724387"),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T11:14:02.531Z"); return t}()),
		// 				IsUserTriggered: to.Ptr(true),
		// 				Operation: to.Ptr("Backup"),
		// 				OperationCategory: to.Ptr("Backup"),
		// 				PolicyID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupPolicies/jakavetPolicy1"),
		// 				PolicyName: to.Ptr("jakavetPolicy1"),
		// 				ProgressEnabled: to.Ptr(false),
		// 				SourceResourceGroup: to.Ptr("DppPostgresTestingCcy"),
		// 				SourceSubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T11:11:50.559Z"); return t}()),
		// 				Status: to.Ptr("Succeeded"),
		// 				SubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
		// 				SupportedActions: []*string{
		// 					to.Ptr("")},
		// 					VaultName: to.Ptr("BugBashVaultForCCYv11"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/dataprotection/resource-manager/Microsoft.DataProtection/stable/2023-11-01/examples/JobCRUD/GetJob.json
func ExampleJobsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdataprotection.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Get(ctx, "BugBash1", "BugBashVaultForCCYv11", "3c60cb49-63e8-4b21-b9bd-26277b3fdfae", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureBackupJobResource = armdataprotection.AzureBackupJobResource{
	// 	Name: to.Ptr("3c60cb49-63e8-4b21-b9bd-26277b3fdfae"),
	// 	Type: to.Ptr("Microsoft.DataProtection/Backupvaults/backupJobs"),
	// 	ID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/Backupvaults/BugBashVaultForCCYv11/backupJobs/3c60cb49-63e8-4b21-b9bd-26277b3fdfae"),
	// 	Properties: &armdataprotection.AzureBackupJob{
	// 		ActivityID: to.Ptr("c4344fb4-7c11-43a4-8307-7ae7c7fb09b9"),
	// 		BackupInstanceFriendlyName: to.Ptr("mabtestingccybasicv11\\bugbashdb2"),
	// 		BackupInstanceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupInstances/28460a9d-707a-45f3-ace6-b16284c2900e"),
	// 		DataSourceID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/DppPostgresTestingCcy/providers/Microsoft.DBforPostgreSQL/servers/mabtestingccybasicv11/databases/bugbashdb2"),
	// 		DataSourceLocation: to.Ptr("centraluseuap"),
	// 		DataSourceName: to.Ptr("bugbashdb2"),
	// 		DataSourceSetName: to.Ptr("mabtestingccybasicv11"),
	// 		DataSourceType: to.Ptr("Microsoft.DBforPostgreSQL/servers/databases"),
	// 		Duration: to.Ptr("00:00:00"),
	// 		ExtendedInfo: &armdataprotection.JobExtendedInfo{
	// 			AdditionalDetails: map[string]*string{
	// 				"PolicyRuleName": to.Ptr("BackupWeekly"),
	// 				"RetentionTag": to.Ptr("Default"),
	// 				"TaskId": to.Ptr("c4344fb4-7c11-43a4-8307-7ae7c7fb09b9"),
	// 			},
	// 			SubTasks: []*armdataprotection.JobSubTask{
	// 				{
	// 					TaskID: to.Ptr[int32](1),
	// 					TaskName: to.Ptr("Trigger Backup"),
	// 					TaskStatus: to.Ptr("Started"),
	// 			}},
	// 		},
	// 		IsUserTriggered: to.Ptr(false),
	// 		Operation: to.Ptr("Backup"),
	// 		OperationCategory: to.Ptr("Backup"),
	// 		PolicyID: to.Ptr("/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/BugBash1/providers/Microsoft.DataProtection/backupVaults/BugBashVaultForCCYv11/backupPolicies/jakavetdailypolicy"),
	// 		PolicyName: to.Ptr("jakavetdailypolicy"),
	// 		ProgressEnabled: to.Ptr(false),
	// 		SourceResourceGroup: to.Ptr("DppPostgresTestingCcy"),
	// 		SourceSubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-17T03:00:03.760Z"); return t}()),
	// 		Status: to.Ptr("Started"),
	// 		SubscriptionID: to.Ptr("62b829ee-7936-40c9-a1c9-47a93f9f3965"),
	// 		SupportedActions: []*string{
	// 		},
	// 		VaultName: to.Ptr("BugBashVaultForCCYv11"),
	// 	},
	// }
}
