//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datamigration/armdatamigration"
)

func unmarshalCommandPropertiesClassification(rawMsg json.RawMessage) (armdatamigration.CommandPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armdatamigration.CommandPropertiesClassification
	switch m["commandType"] {
	case "Migrate.SqlServer.AzureDbSqlMi.Complete":
		b = &armdatamigration.MigrateMISyncCompleteCommandProperties{}
	case "Migrate.Sync.Complete.Database":
		b = &armdatamigration.MigrateSyncCompleteCommandProperties{}
	case "cancel":
		b = &armdatamigration.MongoDbCancelCommand{}
	case "finish":
		b = &armdatamigration.MongoDbFinishCommand{}
	case "restart":
		b = &armdatamigration.MongoDbRestartCommand{}
	default:
		b = &armdatamigration.CommandProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
