//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdashboard_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dashboard/armdashboard"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_List.json
func ExampleGrafanaClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGrafanaClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedGrafanaListResponse = armdashboard.ManagedGrafanaListResponse{
		// 	Value: []*armdashboard.ManagedGrafana{
		// 		{
		// 			Name: to.Ptr("myWorkspace"),
		// 			Type: to.Ptr("Microsoft.Dashboard/grafana"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/grafana/myWorkspace"),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdashboard.ManagedGrafanaProperties{
		// 				APIKey: to.Ptr(armdashboard.APIKeyEnabled),
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr(armdashboard.AutoGeneratedDomainNameLabelScopeTenantReuse),
		// 				DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
		// 				Endpoint: to.Ptr("https://myworkspace-abcdefghijklmnop.wus.grafana.azure.com"),
		// 				EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
		// 					MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
		// 					MarketplacePlanID: to.Ptr("myPlanId"),
		// 				},
		// 				GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
		// 					SMTP: &armdashboard.SMTP{
		// 						Enabled: to.Ptr(true),
		// 						FromAddress: to.Ptr("test@sendemail.com"),
		// 						FromName: to.Ptr("emailsender"),
		// 						Host: to.Ptr("smtp.sendemail.com:587"),
		// 						SkipVerify: to.Ptr(true),
		// 						StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
		// 						User: to.Ptr("username"),
		// 					},
		// 				},
		// 				GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
		// 					AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
		// 						{
		// 							AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
		// 					}},
		// 				},
		// 				GrafanaMajorVersion: to.Ptr("9"),
		// 				GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
		// 					"sample-plugin-id": &armdashboard.GrafanaPlugin{
		// 						PluginID: to.Ptr("sample-plugin-id"),
		// 					},
		// 				},
		// 				GrafanaVersion: to.Ptr("9.4.5"),
		// 				OutboundIPs: []*string{
		// 					to.Ptr("192.168.0.1"),
		// 					to.Ptr("192.168.0.2")},
		// 					ProvisioningState: to.Ptr(armdashboard.ProvisioningStateSucceeded),
		// 					PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
		// 					ZoneRedundancy: to.Ptr(armdashboard.ZoneRedundancyEnabled),
		// 				},
		// 				SKU: &armdashboard.ResourceSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 				Tags: map[string]*string{
		// 					"Environment": to.Ptr("Dev"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_ListByResourceGroup.json
func ExampleGrafanaClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGrafanaClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedGrafanaListResponse = armdashboard.ManagedGrafanaListResponse{
		// 	Value: []*armdashboard.ManagedGrafana{
		// 		{
		// 			Name: to.Ptr("myWorkspace"),
		// 			Type: to.Ptr("Microsoft.Dashboard/grafana"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/grafana/myWorkspace"),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdashboard.ManagedGrafanaProperties{
		// 				APIKey: to.Ptr(armdashboard.APIKeyEnabled),
		// 				AutoGeneratedDomainNameLabelScope: to.Ptr(armdashboard.AutoGeneratedDomainNameLabelScopeTenantReuse),
		// 				DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
		// 				Endpoint: to.Ptr("https://myworkspace-abcdefghijklmnop.wus.grafana.azure.com"),
		// 				EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
		// 					MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
		// 					MarketplacePlanID: to.Ptr("myPlanId"),
		// 				},
		// 				GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
		// 					SMTP: &armdashboard.SMTP{
		// 						Enabled: to.Ptr(true),
		// 						FromAddress: to.Ptr("test@sendemail.com"),
		// 						FromName: to.Ptr("emailsender"),
		// 						Host: to.Ptr("smtp.sendemail.com:587"),
		// 						SkipVerify: to.Ptr(true),
		// 						StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
		// 						User: to.Ptr("username"),
		// 					},
		// 				},
		// 				GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
		// 					AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
		// 						{
		// 							AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
		// 					}},
		// 				},
		// 				GrafanaMajorVersion: to.Ptr("9"),
		// 				GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
		// 					"sample-plugin-id": &armdashboard.GrafanaPlugin{
		// 						PluginID: to.Ptr("sample-plugin-id"),
		// 					},
		// 				},
		// 				GrafanaVersion: to.Ptr("9.4.5"),
		// 				OutboundIPs: []*string{
		// 					to.Ptr("192.168.0.1"),
		// 					to.Ptr("192.168.0.2")},
		// 					ProvisioningState: to.Ptr(armdashboard.ProvisioningStateSucceeded),
		// 					PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
		// 					ZoneRedundancy: to.Ptr(armdashboard.ZoneRedundancyEnabled),
		// 				},
		// 				SKU: &armdashboard.ResourceSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 				Tags: map[string]*string{
		// 					"Environment": to.Ptr("Dev"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_Get.json
func ExampleGrafanaClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGrafanaClient().Get(ctx, "myResourceGroup", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedGrafana = armdashboard.ManagedGrafana{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Dashboard/grafana"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/grafana/myWorkspace"),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdashboard.ManagedGrafanaProperties{
	// 		APIKey: to.Ptr(armdashboard.APIKeyEnabled),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armdashboard.AutoGeneratedDomainNameLabelScopeTenantReuse),
	// 		DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
	// 		Endpoint: to.Ptr("https://myworkspace-abcdefghijklmnop.wus.grafana.azure.com"),
	// 		EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
	// 			MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
	// 			MarketplacePlanID: to.Ptr("myPlanId"),
	// 		},
	// 		GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
	// 			SMTP: &armdashboard.SMTP{
	// 				Enabled: to.Ptr(true),
	// 				FromAddress: to.Ptr("test@sendemail.com"),
	// 				FromName: to.Ptr("emailsender"),
	// 				Host: to.Ptr("smtp.sendemail.com:587"),
	// 				SkipVerify: to.Ptr(true),
	// 				StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
	// 				User: to.Ptr("username"),
	// 			},
	// 		},
	// 		GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
	// 			AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
	// 				{
	// 					AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
	// 			}},
	// 		},
	// 		GrafanaMajorVersion: to.Ptr("9"),
	// 		GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
	// 			"sample-plugin-id": &armdashboard.GrafanaPlugin{
	// 				PluginID: to.Ptr("sample-plugin-id"),
	// 			},
	// 		},
	// 		GrafanaVersion: to.Ptr("9.4.5"),
	// 		OutboundIPs: []*string{
	// 			to.Ptr("192.168.0.1"),
	// 			to.Ptr("192.168.0.2")},
	// 			ProvisioningState: to.Ptr(armdashboard.ProvisioningStateSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
	// 			ZoneRedundancy: to.Ptr(armdashboard.ZoneRedundancyEnabled),
	// 		},
	// 		SKU: &armdashboard.ResourceSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 		SystemData: &armdashboard.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armdashboard.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armdashboard.CreatedByTypeUser),
	// 		},
	// 		Tags: map[string]*string{
	// 			"Environment": to.Ptr("Dev"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_Create.json
func ExampleGrafanaClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGrafanaClient().BeginCreate(ctx, "myResourceGroup", "myWorkspace", armdashboard.ManagedGrafana{
		Identity: &armdashboard.ManagedServiceIdentity{
			Type: to.Ptr(armdashboard.ManagedServiceIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("West US"),
		Properties: &armdashboard.ManagedGrafanaProperties{
			APIKey:                  to.Ptr(armdashboard.APIKeyEnabled),
			DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
			EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
				MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
				MarketplacePlanID:    to.Ptr("myPlanId"),
			},
			GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
				SMTP: &armdashboard.SMTP{
					Enabled:        to.Ptr(true),
					FromAddress:    to.Ptr("test@sendemail.com"),
					FromName:       to.Ptr("emailsender"),
					Host:           to.Ptr("smtp.sendemail.com:587"),
					Password:       to.Ptr("<password>"),
					SkipVerify:     to.Ptr(true),
					StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
					User:           to.Ptr("username"),
				},
			},
			GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
				AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
					{
						AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
					}},
			},
			GrafanaMajorVersion: to.Ptr("9"),
			GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
				"sample-plugin-id": {},
			},
			PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
			ZoneRedundancy:      to.Ptr(armdashboard.ZoneRedundancyEnabled),
		},
		SKU: &armdashboard.ResourceSKU{
			Name: to.Ptr("Standard"),
		},
		Tags: map[string]*string{
			"Environment": to.Ptr("Dev"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedGrafana = armdashboard.ManagedGrafana{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Dashboard/grafana"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/grafana/myWorkspace"),
	// 	Identity: &armdashboard.ManagedServiceIdentity{
	// 		Type: to.Ptr(armdashboard.ManagedServiceIdentityTypeSystemAssigned),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdashboard.ManagedGrafanaProperties{
	// 		APIKey: to.Ptr(armdashboard.APIKeyEnabled),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armdashboard.AutoGeneratedDomainNameLabelScopeTenantReuse),
	// 		DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
	// 		Endpoint: to.Ptr("https://myworkspace-abcdefghijklmnop.wus.grafana.azure.com"),
	// 		EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
	// 			MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
	// 			MarketplacePlanID: to.Ptr("myPlanId"),
	// 		},
	// 		GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
	// 			SMTP: &armdashboard.SMTP{
	// 				Enabled: to.Ptr(true),
	// 				FromAddress: to.Ptr("test@sendemail.com"),
	// 				FromName: to.Ptr("emailsender"),
	// 				Host: to.Ptr("smtp.sendemail.com:587"),
	// 				SkipVerify: to.Ptr(true),
	// 				StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
	// 				User: to.Ptr("username"),
	// 			},
	// 		},
	// 		GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
	// 			AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
	// 				{
	// 					AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
	// 			}},
	// 		},
	// 		GrafanaMajorVersion: to.Ptr("9"),
	// 		GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
	// 			"sample-plugin-id": &armdashboard.GrafanaPlugin{
	// 				PluginID: to.Ptr("sample-plugin-id"),
	// 			},
	// 		},
	// 		GrafanaVersion: to.Ptr("9.4.5"),
	// 		OutboundIPs: []*string{
	// 			to.Ptr("192.168.0.1"),
	// 			to.Ptr("192.168.0.2")},
	// 			ProvisioningState: to.Ptr(armdashboard.ProvisioningStateSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
	// 			ZoneRedundancy: to.Ptr(armdashboard.ZoneRedundancyEnabled),
	// 		},
	// 		SKU: &armdashboard.ResourceSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 		SystemData: &armdashboard.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armdashboard.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armdashboard.CreatedByTypeUser),
	// 		},
	// 		Tags: map[string]*string{
	// 			"Environment": to.Ptr("Dev"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_Update.json
func ExampleGrafanaClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGrafanaClient().Update(ctx, "myResourceGroup", "myWorkspace", armdashboard.ManagedGrafanaUpdateParameters{
		Properties: &armdashboard.ManagedGrafanaPropertiesUpdateParameters{
			APIKey:                  to.Ptr(armdashboard.APIKeyEnabled),
			DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
			EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
				MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
				MarketplacePlanID:    to.Ptr("myPlanId"),
			},
			GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
				SMTP: &armdashboard.SMTP{
					Enabled:        to.Ptr(true),
					FromAddress:    to.Ptr("test@sendemail.com"),
					FromName:       to.Ptr("emailsender"),
					Host:           to.Ptr("smtp.sendemail.com:587"),
					Password:       to.Ptr("<password>"),
					SkipVerify:     to.Ptr(true),
					StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
					User:           to.Ptr("username"),
				},
			},
			GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
				AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
					{
						AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
					}},
			},
			GrafanaMajorVersion: to.Ptr("9"),
			GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
				"sample-plugin-id": {},
			},
		},
		SKU: &armdashboard.ResourceSKU{
			Name: to.Ptr("Standard"),
		},
		Tags: map[string]*string{
			"Environment": to.Ptr("Dev 2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedGrafana = armdashboard.ManagedGrafana{
	// 	Name: to.Ptr("myWorkspace"),
	// 	Type: to.Ptr("Microsoft.Dashboard/grafana"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/grafana/myWorkspace"),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdashboard.ManagedGrafanaProperties{
	// 		APIKey: to.Ptr(armdashboard.APIKeyEnabled),
	// 		AutoGeneratedDomainNameLabelScope: to.Ptr(armdashboard.AutoGeneratedDomainNameLabelScopeTenantReuse),
	// 		DeterministicOutboundIP: to.Ptr(armdashboard.DeterministicOutboundIPEnabled),
	// 		Endpoint: to.Ptr("https://myworkspace-abcdefghijklmnop.wus.grafana.azure.com"),
	// 		EnterpriseConfigurations: &armdashboard.EnterpriseConfigurations{
	// 			MarketplaceAutoRenew: to.Ptr(armdashboard.MarketplaceAutoRenewEnabled),
	// 			MarketplacePlanID: to.Ptr("myPlanId"),
	// 		},
	// 		GrafanaConfigurations: &armdashboard.GrafanaConfigurations{
	// 			SMTP: &armdashboard.SMTP{
	// 				Enabled: to.Ptr(true),
	// 				FromAddress: to.Ptr("test@sendemail.com"),
	// 				FromName: to.Ptr("emailsender"),
	// 				Host: to.Ptr("smtp.sendemail.com:587"),
	// 				SkipVerify: to.Ptr(true),
	// 				StartTLSPolicy: to.Ptr(armdashboard.StartTLSPolicyOpportunisticStartTLS),
	// 				User: to.Ptr("username"),
	// 			},
	// 		},
	// 		GrafanaIntegrations: &armdashboard.GrafanaIntegrations{
	// 			AzureMonitorWorkspaceIntegrations: []*armdashboard.AzureMonitorWorkspaceIntegration{
	// 				{
	// 					AzureMonitorWorkspaceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
	// 			}},
	// 		},
	// 		GrafanaMajorVersion: to.Ptr("9"),
	// 		GrafanaPlugins: map[string]*armdashboard.GrafanaPlugin{
	// 			"sample-plugin-id": &armdashboard.GrafanaPlugin{
	// 				PluginID: to.Ptr("sample-plugin-id"),
	// 			},
	// 		},
	// 		GrafanaVersion: to.Ptr("9.4.5"),
	// 		OutboundIPs: []*string{
	// 			to.Ptr("192.168.0.1"),
	// 			to.Ptr("192.168.0.2")},
	// 			ProvisioningState: to.Ptr(armdashboard.ProvisioningStateSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armdashboard.PublicNetworkAccessEnabled),
	// 			ZoneRedundancy: to.Ptr(armdashboard.ZoneRedundancyEnabled),
	// 		},
	// 		SKU: &armdashboard.ResourceSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 		Tags: map[string]*string{
	// 			"Environment": to.Ptr("Dev 2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_Delete.json
func ExampleGrafanaClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGrafanaClient().BeginDelete(ctx, "myResourceGroup", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/EnterpriseDetails_Post.json
func ExampleGrafanaClient_CheckEnterpriseDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGrafanaClient().CheckEnterpriseDetails(ctx, "myResourceGroup", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnterpriseDetails = armdashboard.EnterpriseDetails{
	// 	MarketplaceTrialQuota: &armdashboard.MarketplaceTrialQuota{
	// 		AvailablePromotion: to.Ptr(armdashboard.AvailablePromotionNone),
	// 		GrafanaResourceID: to.Ptr("/subscriptions/e1e3b30d-e7ec-4e25-8587-db037bcb9a4d/resourcegroups/amg-local-script-test-rg/providers/microsoft.dashboard/grafana/eus2-enterprise-1001-07"),
	// 		TrialEndAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-03T01:06:00.447Z"); return t}()),
	// 		TrialStartAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-04T01:06:00.447Z"); return t}()),
	// 	},
	// 	SaasSubscriptionDetails: &armdashboard.SaasSubscriptionDetails{
	// 		OfferID: to.Ptr("amg_test"),
	// 		PlanID: to.Ptr("amg_globalplan"),
	// 		PublisherID: to.Ptr("isvtestuklegacy"),
	// 		Term: &armdashboard.SubscriptionTerm{
	// 			EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-03T00:00:00.000Z"); return t}()),
	// 			StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-10-04T00:00:00.000Z"); return t}()),
	// 			TermUnit: to.Ptr("P1M"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/78eac0bd58633028293cb1ec1709baa200bed9e2/specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/Grafana_FetchAvailablePlugins.json
func ExampleGrafanaClient_FetchAvailablePlugins() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdashboard.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGrafanaClient().FetchAvailablePlugins(ctx, "myResourceGroup", "myWorkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GrafanaAvailablePluginListResponse = armdashboard.GrafanaAvailablePluginListResponse{
	// 	Value: []*armdashboard.GrafanaAvailablePlugin{
	// 		{
	// 			Name: to.Ptr("Plugin A"),
	// 			PluginID: to.Ptr("plugin-a"),
	// 		},
	// 		{
	// 			Name: to.Ptr("Plugin B"),
	// 			PluginID: to.Ptr("plugin-b"),
	// 	}},
	// }
}
