//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcustomerinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerinsights/armcustomerinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ProfilesCreateOrUpdate.json
func ExampleProfilesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProfilesClient().BeginCreateOrUpdate(ctx, "TestHubRG", "sdkTestHub", "TestProfileType396", armcustomerinsights.ProfileResourceFormat{
		Properties: &armcustomerinsights.ProfileTypeDefinition{
			LargeImage:       to.Ptr("\\\\Images\\\\LargeImage"),
			MediumImage:      to.Ptr("\\\\Images\\\\MediumImage"),
			SmallImage:       to.Ptr("\\\\Images\\\\smallImage"),
			APIEntitySetName: to.Ptr("TestProfileType396"),
			Fields: []*armcustomerinsights.PropertyDefinition{
				{
					FieldName:  to.Ptr("Id"),
					FieldType:  to.Ptr("Edm.String"),
					IsArray:    to.Ptr(false),
					IsRequired: to.Ptr(true),
				},
				{
					FieldName:  to.Ptr("ProfileId"),
					FieldType:  to.Ptr("Edm.String"),
					IsArray:    to.Ptr(false),
					IsRequired: to.Ptr(true),
				},
				{
					FieldName:  to.Ptr("LastName"),
					FieldType:  to.Ptr("Edm.String"),
					IsArray:    to.Ptr(false),
					IsRequired: to.Ptr(true),
				},
				{
					FieldName:  to.Ptr("TestProfileType396"),
					FieldType:  to.Ptr("Edm.String"),
					IsArray:    to.Ptr(false),
					IsRequired: to.Ptr(true),
				},
				{
					FieldName:  to.Ptr("SavingAccountBalance"),
					FieldType:  to.Ptr("Edm.Int32"),
					IsArray:    to.Ptr(false),
					IsRequired: to.Ptr(true),
				}},
			SchemaItemTypeLink: to.Ptr("SchemaItemTypeLink"),
			StrongIDs: []*armcustomerinsights.StrongID{
				{
					KeyPropertyNames: []*string{
						to.Ptr("Id"),
						to.Ptr("SavingAccountBalance")},
					StrongIDName: to.Ptr("Id"),
				},
				{
					KeyPropertyNames: []*string{
						to.Ptr("ProfileId"),
						to.Ptr("LastName")},
					StrongIDName: to.Ptr("ProfileId"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProfileResourceFormat = armcustomerinsights.ProfileResourceFormat{
	// 	Name: to.Ptr("azSdkTestHub/TestProfileType396"),
	// 	Type: to.Ptr("Microsoft.CustomerInsights/hubs/profiles"),
	// 	ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/profiles/TestProfileType396"),
	// 	Properties: &armcustomerinsights.ProfileTypeDefinition{
	// 		LargeImage: to.Ptr("\\\\Images\\\\LargeImage"),
	// 		MediumImage: to.Ptr("\\\\Images\\\\MediumImage"),
	// 		SmallImage: to.Ptr("\\\\Images\\\\smallImage"),
	// 		APIEntitySetName: to.Ptr("TestProfileType396"),
	// 		EntityType: to.Ptr(armcustomerinsights.EntityTypesProfile),
	// 		Fields: []*armcustomerinsights.PropertyDefinition{
	// 			{
	// 				FieldName: to.Ptr("Id"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("ProfileId"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("LastName"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("TestProfileType396"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("SavingAccountBalance"),
	// 				FieldType: to.Ptr("Edm.Int32"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 		}},
	// 		InstancesCount: to.Ptr[int32](0),
	// 		ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
	// 		SchemaItemTypeLink: to.Ptr("SchemaItemTypeLink"),
	// 		TenantID: to.Ptr("azsdktesthub"),
	// 		TypeName: to.Ptr("TestProfileType396"),
	// 		StrongIDs: []*armcustomerinsights.StrongID{
	// 			{
	// 				KeyPropertyNames: []*string{
	// 					to.Ptr("Id"),
	// 					to.Ptr("savingAccountBalance")},
	// 					StrongIDName: to.Ptr("Id"),
	// 				},
	// 				{
	// 					KeyPropertyNames: []*string{
	// 						to.Ptr("ProfileId"),
	// 						to.Ptr("LastName")},
	// 						StrongIDName: to.Ptr("ProfileId"),
	// 					},
	// 					{
	// 						KeyPropertyNames: []*string{
	// 							to.Ptr("ProfileId")},
	// 							StrongIDName: to.Ptr("ProfileId"),
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ProfilesGet.json
func ExampleProfilesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "TestHubRG", "sdkTestHub", "TestProfileType396", &armcustomerinsights.ProfilesClientGetOptions{LocaleCode: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProfileResourceFormat = armcustomerinsights.ProfileResourceFormat{
	// 	Name: to.Ptr("azSdkTestHub/TestProfileType396"),
	// 	Type: to.Ptr("Microsoft.CustomerInsights/hubs/profiles"),
	// 	ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/profiles/TestProfileType396"),
	// 	Properties: &armcustomerinsights.ProfileTypeDefinition{
	// 		LargeImage: to.Ptr("\\\\Images\\\\LargeImage"),
	// 		MediumImage: to.Ptr("\\\\Images\\\\MediumImage"),
	// 		SmallImage: to.Ptr("\\\\Images\\\\smallImage"),
	// 		APIEntitySetName: to.Ptr("TestProfileType396"),
	// 		EntityType: to.Ptr(armcustomerinsights.EntityTypesProfile),
	// 		Fields: []*armcustomerinsights.PropertyDefinition{
	// 			{
	// 				FieldName: to.Ptr("Id"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("ProfileId"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("LastName"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("TestProfileType396"),
	// 				FieldType: to.Ptr("Edm.String"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 			},
	// 			{
	// 				FieldName: to.Ptr("SavingAccountBalance"),
	// 				FieldType: to.Ptr("Edm.Int32"),
	// 				IsArray: to.Ptr(false),
	// 				IsEnum: to.Ptr(false),
	// 				IsFlagEnum: to.Ptr(false),
	// 				IsImage: to.Ptr(false),
	// 				IsLocalizedString: to.Ptr(false),
	// 				IsName: to.Ptr(false),
	// 				IsRequired: to.Ptr(true),
	// 				PropertyID: to.Ptr("id1"),
	// 		}},
	// 		InstancesCount: to.Ptr[int32](0),
	// 		ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
	// 		SchemaItemTypeLink: to.Ptr("SchemaItemTypeLink"),
	// 		TenantID: to.Ptr("azsdktesthub"),
	// 		TypeName: to.Ptr("TestProfileType396"),
	// 		StrongIDs: []*armcustomerinsights.StrongID{
	// 			{
	// 				KeyPropertyNames: []*string{
	// 					to.Ptr("Id"),
	// 					to.Ptr("savingAccountBalance")},
	// 					StrongIDName: to.Ptr("Id"),
	// 				},
	// 				{
	// 					KeyPropertyNames: []*string{
	// 						to.Ptr("ProfileId"),
	// 						to.Ptr("LastName")},
	// 						StrongIDName: to.Ptr("ProfileId"),
	// 					},
	// 					{
	// 						KeyPropertyNames: []*string{
	// 							to.Ptr("ProfileId")},
	// 							StrongIDName: to.Ptr("ProfileId"),
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ProfilesDelete.json
func ExampleProfilesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProfilesClient().BeginDelete(ctx, "TestHubRG", "sdkTestHub", "TestProfileType396", &armcustomerinsights.ProfilesClientBeginDeleteOptions{LocaleCode: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ProfilesListByHub.json
func ExampleProfilesClient_NewListByHubPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProfilesClient().NewListByHubPager("TestHubRG", "sdkTestHub", &armcustomerinsights.ProfilesClientListByHubOptions{LocaleCode: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProfileListResult = armcustomerinsights.ProfileListResult{
		// 	Value: []*armcustomerinsights.ProfileResourceFormat{
		// 		{
		// 			Name: to.Ptr("azSdkTestHub/TestProfileType396"),
		// 			Type: to.Ptr("Microsoft.CustomerInsights/hubs/profiles"),
		// 			ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/profiles/TestProfileType396"),
		// 			Properties: &armcustomerinsights.ProfileTypeDefinition{
		// 				LargeImage: to.Ptr("\\\\Images\\\\LargeImage"),
		// 				MediumImage: to.Ptr("\\\\Images\\\\MediumImage"),
		// 				SmallImage: to.Ptr("\\\\Images\\\\smallImage"),
		// 				APIEntitySetName: to.Ptr("TestProfileType396"),
		// 				EntityType: to.Ptr(armcustomerinsights.EntityTypesProfile),
		// 				Fields: []*armcustomerinsights.PropertyDefinition{
		// 					{
		// 						FieldName: to.Ptr("Id"),
		// 						FieldType: to.Ptr("Edm.String"),
		// 						IsArray: to.Ptr(false),
		// 						IsEnum: to.Ptr(false),
		// 						IsFlagEnum: to.Ptr(false),
		// 						IsImage: to.Ptr(false),
		// 						IsLocalizedString: to.Ptr(false),
		// 						IsName: to.Ptr(false),
		// 						IsRequired: to.Ptr(true),
		// 						PropertyID: to.Ptr("id1"),
		// 					},
		// 					{
		// 						FieldName: to.Ptr("ProfileId"),
		// 						FieldType: to.Ptr("Edm.String"),
		// 						IsArray: to.Ptr(false),
		// 						IsEnum: to.Ptr(false),
		// 						IsFlagEnum: to.Ptr(false),
		// 						IsImage: to.Ptr(false),
		// 						IsLocalizedString: to.Ptr(false),
		// 						IsName: to.Ptr(false),
		// 						IsRequired: to.Ptr(true),
		// 						PropertyID: to.Ptr("id1"),
		// 					},
		// 					{
		// 						FieldName: to.Ptr("LastName"),
		// 						FieldType: to.Ptr("Edm.String"),
		// 						IsArray: to.Ptr(false),
		// 						IsEnum: to.Ptr(false),
		// 						IsFlagEnum: to.Ptr(false),
		// 						IsImage: to.Ptr(false),
		// 						IsLocalizedString: to.Ptr(false),
		// 						IsName: to.Ptr(false),
		// 						IsRequired: to.Ptr(true),
		// 						PropertyID: to.Ptr("id1"),
		// 					},
		// 					{
		// 						FieldName: to.Ptr("TestProfileType396"),
		// 						FieldType: to.Ptr("Edm.String"),
		// 						IsArray: to.Ptr(false),
		// 						IsEnum: to.Ptr(false),
		// 						IsFlagEnum: to.Ptr(false),
		// 						IsImage: to.Ptr(false),
		// 						IsLocalizedString: to.Ptr(false),
		// 						IsName: to.Ptr(false),
		// 						IsRequired: to.Ptr(true),
		// 						PropertyID: to.Ptr("id1"),
		// 					},
		// 					{
		// 						FieldName: to.Ptr("SavingAccountBalance"),
		// 						FieldType: to.Ptr("Edm.Int32"),
		// 						IsArray: to.Ptr(false),
		// 						IsEnum: to.Ptr(false),
		// 						IsFlagEnum: to.Ptr(false),
		// 						IsImage: to.Ptr(false),
		// 						IsLocalizedString: to.Ptr(false),
		// 						IsName: to.Ptr(false),
		// 						IsRequired: to.Ptr(true),
		// 						PropertyID: to.Ptr("id1"),
		// 				}},
		// 				InstancesCount: to.Ptr[int32](0),
		// 				ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
		// 				SchemaItemTypeLink: to.Ptr("SchemaItemTypeLink"),
		// 				TenantID: to.Ptr("azsdktesthub"),
		// 				TypeName: to.Ptr("TestProfileType396"),
		// 				StrongIDs: []*armcustomerinsights.StrongID{
		// 					{
		// 						KeyPropertyNames: []*string{
		// 							to.Ptr("Id"),
		// 							to.Ptr("savingAccountBalance")},
		// 							StrongIDName: to.Ptr("Id"),
		// 						},
		// 						{
		// 							KeyPropertyNames: []*string{
		// 								to.Ptr("ProfileId"),
		// 								to.Ptr("LastName")},
		// 								StrongIDName: to.Ptr("ProfileId"),
		// 							},
		// 							{
		// 								KeyPropertyNames: []*string{
		// 									to.Ptr("ProfileId")},
		// 									StrongIDName: to.Ptr("ProfileId"),
		// 							}},
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/ProfileGetEnrichingKpis.json
func ExampleProfilesClient_GetEnrichingKpis() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().GetEnrichingKpis(ctx, "TestHubRG", "sdkTestHub", "TestProfileType396", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KpiDefinitionArray = []*armcustomerinsights.KpiDefinition{
	// 	{
	// 		Description: map[string]*string{
	// 			"en-us": to.Ptr("MonthlyDeposits"),
	// 		},
	// 		CalculationWindow: to.Ptr(armcustomerinsights.CalculationWindowTypesMonth),
	// 		CalculationWindowFieldName: to.Ptr(""),
	// 		EntityType: to.Ptr(armcustomerinsights.EntityTypesInteraction),
	// 		EntityTypeName: to.Ptr("Deposit"),
	// 		Expression: to.Ptr("Amount"),
	// 		Filter: to.Ptr(""),
	// 		Function: to.Ptr(armcustomerinsights.KpiFunctionsSum),
	// 		GroupBy: []*string{
	// 			to.Ptr("AccountType"),
	// 			to.Ptr("BranchId"),
	// 			to.Ptr("ContactId"),
	// 			to.Ptr("Location"),
	// 			to.Ptr("Type")},
	// 			GroupByMetadata: []*armcustomerinsights.KpiGroupByMetadata{
	// 				{
	// 					DisplayName: map[string]*string{
	// 						"en-us": to.Ptr("AccountType"),
	// 					},
	// 					FieldName: to.Ptr("AccountType"),
	// 					FieldType: to.Ptr("Edm.String"),
	// 				},
	// 				{
	// 					DisplayName: map[string]*string{
	// 						"en-us": to.Ptr("BranchId"),
	// 					},
	// 					FieldName: to.Ptr("BranchId"),
	// 					FieldType: to.Ptr("Edm.Int32"),
	// 				},
	// 				{
	// 					DisplayName: map[string]*string{
	// 						"en-us": to.Ptr("ContactId"),
	// 					},
	// 					FieldName: to.Ptr("ContactId"),
	// 					FieldType: to.Ptr("Edm.Int32"),
	// 				},
	// 				{
	// 					DisplayName: map[string]*string{
	// 						"en-us": to.Ptr("Location"),
	// 					},
	// 					FieldName: to.Ptr("Location"),
	// 					FieldType: to.Ptr("Edm.String"),
	// 				},
	// 				{
	// 					DisplayName: map[string]*string{
	// 						"en-us": to.Ptr("Type"),
	// 					},
	// 					FieldName: to.Ptr("Type"),
	// 					FieldType: to.Ptr("Edm.String"),
	// 			}},
	// 			KpiName: to.Ptr("MonthlyDeposits"),
	// 			ParticipantProfilesMetadata: []*armcustomerinsights.KpiParticipantProfilesMetadata{
	// 			},
	// 			ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
	// 			TenantID: to.Ptr("sdkTestHub"),
	// 			ThresHolds: &armcustomerinsights.KpiThresholds{
	// 				IncreasingKpi: to.Ptr(true),
	// 				LowerLimit: to.Ptr[float64](0),
	// 				UpperLimit: to.Ptr[float64](0),
	// 			},
	// 			Unit: to.Ptr(""),
	// 	}}
}
