//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerregistry_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerregistry/armcontainerregistry"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/ImportImageByManifestDigest.json
func ExampleRegistriesClient_BeginImportImage_importImageByManifestDigest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginImportImage(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.ImportImageParameters{
		Mode: to.Ptr(armcontainerregistry.ImportModeForce),
		Source: &armcontainerregistry.ImportSource{
			ResourceID:  to.Ptr("/subscriptions/10000000-0000-0000-0000-000000000000/resourceGroups/sourceResourceGroup/providers/Microsoft.ContainerRegistry/registries/sourceRegistry"),
			SourceImage: to.Ptr("sourceRepository@sha256:0000000000000000000000000000000000000000000000000000000000000000"),
		},
		TargetTags: []*string{
			to.Ptr("targetRepository:targetTag")},
		UntaggedTargetRepositories: []*string{
			to.Ptr("targetRepository1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/ImportImageByTag.json
func ExampleRegistriesClient_BeginImportImage_importImageByTag() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginImportImage(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.ImportImageParameters{
		Mode: to.Ptr(armcontainerregistry.ImportModeForce),
		Source: &armcontainerregistry.ImportSource{
			ResourceID:  to.Ptr("/subscriptions/10000000-0000-0000-0000-000000000000/resourceGroups/sourceResourceGroup/providers/Microsoft.ContainerRegistry/registries/sourceRegistry"),
			SourceImage: to.Ptr("sourceRepository:sourceTag"),
		},
		TargetTags: []*string{
			to.Ptr("targetRepository:targetTag")},
		UntaggedTargetRepositories: []*string{
			to.Ptr("targetRepository1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/ImportImageFromPublicRegistry.json
func ExampleRegistriesClient_BeginImportImage_importImageFromPublicRegistry() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginImportImage(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.ImportImageParameters{
		Mode: to.Ptr(armcontainerregistry.ImportModeForce),
		Source: &armcontainerregistry.ImportSource{
			RegistryURI: to.Ptr("registry.hub.docker.com"),
			SourceImage: to.Ptr("library/hello-world"),
		},
		TargetTags: []*string{
			to.Ptr("targetRepository:targetTag")},
		UntaggedTargetRepositories: []*string{
			to.Ptr("targetRepository1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryCheckNameAvailable.json
func ExampleRegistriesClient_CheckNameAvailability_registryCheckNameAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().CheckNameAvailability(ctx, armcontainerregistry.RegistryNameCheckRequest{
		Name: to.Ptr("myRegistry"),
		Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryNameStatus = armcontainerregistry.RegistryNameStatus{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryCheckNameNotAvailable.json
func ExampleRegistriesClient_CheckNameAvailability_registryCheckNameNotAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().CheckNameAvailability(ctx, armcontainerregistry.RegistryNameCheckRequest{
		Name: to.Ptr("myRegistry"),
		Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryNameStatus = armcontainerregistry.RegistryNameStatus{
	// 	Message: to.Ptr("The registry myRegistry is already in use."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryList.json
func ExampleRegistriesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistriesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RegistryListResult = armcontainerregistry.RegistryListResult{
		// 	Value: []*armcontainerregistry.Registry{
		// 		{
		// 			Name: to.Ptr("myRegistry"),
		// 			Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armcontainerregistry.RegistryProperties{
		// 				AdminUserEnabled: to.Ptr(false),
		// 				AnonymousPullEnabled: to.Ptr(false),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
		// 				DataEndpointEnabled: to.Ptr(false),
		// 				DataEndpointHostNames: []*string{
		// 				},
		// 				Encryption: &armcontainerregistry.EncryptionProperty{
		// 					Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
		// 				},
		// 				LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
		// 				MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
		// 				NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
		// 				NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
		// 					DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
		// 					IPRules: []*armcontainerregistry.IPRule{
		// 					},
		// 				},
		// 				Policies: &armcontainerregistry.Policies{
		// 					ExportPolicy: &armcontainerregistry.ExportPolicy{
		// 						Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
		// 					},
		// 					QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 					RetentionPolicy: &armcontainerregistry.RetentionPolicy{
		// 						Days: to.Ptr[int32](7),
		// 						LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 					TrustPolicy: &armcontainerregistry.TrustPolicy{
		// 						Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 				},
		// 				PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
		// 				},
		// 				ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
		// 				ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyDisabled),
		// 			},
		// 			SKU: &armcontainerregistry.SKU{
		// 				Name: to.Ptr(armcontainerregistry.SKUNameStandard),
		// 				Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryListByResourceGroup.json
func ExampleRegistriesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistriesClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RegistryListResult = armcontainerregistry.RegistryListResult{
		// 	Value: []*armcontainerregistry.Registry{
		// 		{
		// 			Name: to.Ptr("myRegistry"),
		// 			Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armcontainerregistry.RegistryProperties{
		// 				AdminUserEnabled: to.Ptr(false),
		// 				AnonymousPullEnabled: to.Ptr(false),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
		// 				DataEndpointEnabled: to.Ptr(false),
		// 				DataEndpointHostNames: []*string{
		// 				},
		// 				Encryption: &armcontainerregistry.EncryptionProperty{
		// 					Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
		// 				},
		// 				LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
		// 				MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
		// 				NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
		// 				NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
		// 					DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
		// 					IPRules: []*armcontainerregistry.IPRule{
		// 					},
		// 				},
		// 				Policies: &armcontainerregistry.Policies{
		// 					ExportPolicy: &armcontainerregistry.ExportPolicy{
		// 						Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
		// 					},
		// 					QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 					RetentionPolicy: &armcontainerregistry.RetentionPolicy{
		// 						Days: to.Ptr[int32](7),
		// 						LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 					TrustPolicy: &armcontainerregistry.TrustPolicy{
		// 						Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
		// 						Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
		// 					},
		// 				},
		// 				PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
		// 				},
		// 				ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
		// 				ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyDisabled),
		// 			},
		// 			SKU: &armcontainerregistry.SKU{
		// 				Name: to.Ptr(armcontainerregistry.SKUNameStandard),
		// 				Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryGet.json
func ExampleRegistriesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().Get(ctx, "myResourceGroup", "myRegistry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Registry = armcontainerregistry.Registry{
	// 	Name: to.Ptr("myRegistry"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armcontainerregistry.RegistryProperties{
	// 		AdminUserEnabled: to.Ptr(false),
	// 		AnonymousPullEnabled: to.Ptr(false),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
	// 		DataEndpointEnabled: to.Ptr(false),
	// 		DataEndpointHostNames: []*string{
	// 		},
	// 		Encryption: &armcontainerregistry.EncryptionProperty{
	// 			Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
	// 		},
	// 		LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
	// 		MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
	// 		NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
	// 		NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
	// 			DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
	// 			IPRules: []*armcontainerregistry.IPRule{
	// 			},
	// 		},
	// 		Policies: &armcontainerregistry.Policies{
	// 			ExportPolicy: &armcontainerregistry.ExportPolicy{
	// 				Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
	// 			},
	// 			QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			RetentionPolicy: &armcontainerregistry.RetentionPolicy{
	// 				Days: to.Ptr[int32](7),
	// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			TrustPolicy: &armcontainerregistry.TrustPolicy{
	// 				Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 		},
	// 		PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
	// 		ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyDisabled),
	// 	},
	// 	SKU: &armcontainerregistry.SKU{
	// 		Name: to.Ptr(armcontainerregistry.SKUNameStandard),
	// 		Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryCreate.json
func ExampleRegistriesClient_BeginCreate_registryCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginCreate(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.Registry{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"key": to.Ptr("value"),
		},
		Properties: &armcontainerregistry.RegistryProperties{
			AdminUserEnabled: to.Ptr(true),
		},
		SKU: &armcontainerregistry.SKU{
			Name: to.Ptr(armcontainerregistry.SKUNameStandard),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Registry = armcontainerregistry.Registry{
	// 	Name: to.Ptr("myRegistry"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armcontainerregistry.RegistryProperties{
	// 		AdminUserEnabled: to.Ptr(true),
	// 		AnonymousPullEnabled: to.Ptr(false),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
	// 		DataEndpointEnabled: to.Ptr(false),
	// 		DataEndpointHostNames: []*string{
	// 		},
	// 		Encryption: &armcontainerregistry.EncryptionProperty{
	// 			Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
	// 		},
	// 		LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
	// 		MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
	// 		NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
	// 		NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
	// 			DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
	// 			IPRules: []*armcontainerregistry.IPRule{
	// 			},
	// 		},
	// 		Policies: &armcontainerregistry.Policies{
	// 			ExportPolicy: &armcontainerregistry.ExportPolicy{
	// 				Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
	// 			},
	// 			QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			RetentionPolicy: &armcontainerregistry.RetentionPolicy{
	// 				Days: to.Ptr[int32](7),
	// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			TrustPolicy: &armcontainerregistry.TrustPolicy{
	// 				Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 		},
	// 		PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
	// 		ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyDisabled),
	// 	},
	// 	SKU: &armcontainerregistry.SKU{
	// 		Name: to.Ptr(armcontainerregistry.SKUNameStandard),
	// 		Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryCreateZoneRedundant.json
func ExampleRegistriesClient_BeginCreate_registryCreateZoneRedundant() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginCreate(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.Registry{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"key": to.Ptr("value"),
		},
		Properties: &armcontainerregistry.RegistryProperties{
			ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyEnabled),
		},
		SKU: &armcontainerregistry.SKU{
			Name: to.Ptr(armcontainerregistry.SKUNameStandard),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Registry = armcontainerregistry.Registry{
	// 	Name: to.Ptr("myRegistry"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armcontainerregistry.RegistryProperties{
	// 		AdminUserEnabled: to.Ptr(false),
	// 		AnonymousPullEnabled: to.Ptr(false),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
	// 		DataEndpointEnabled: to.Ptr(false),
	// 		DataEndpointHostNames: []*string{
	// 		},
	// 		Encryption: &armcontainerregistry.EncryptionProperty{
	// 			Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
	// 		},
	// 		LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
	// 		MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
	// 		NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
	// 		NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
	// 			DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
	// 			IPRules: []*armcontainerregistry.IPRule{
	// 			},
	// 		},
	// 		Policies: &armcontainerregistry.Policies{
	// 			ExportPolicy: &armcontainerregistry.ExportPolicy{
	// 				Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
	// 			},
	// 			QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			RetentionPolicy: &armcontainerregistry.RetentionPolicy{
	// 				Days: to.Ptr[int32](7),
	// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			TrustPolicy: &armcontainerregistry.TrustPolicy{
	// 				Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 		},
	// 		PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
	// 		ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyEnabled),
	// 	},
	// 	SKU: &armcontainerregistry.SKU{
	// 		Name: to.Ptr(armcontainerregistry.SKUNameStandard),
	// 		Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryDelete.json
func ExampleRegistriesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginDelete(ctx, "myResourceGroup", "myRegistry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryUpdate.json
func ExampleRegistriesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginUpdate(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.RegistryUpdateParameters{
		Properties: &armcontainerregistry.RegistryPropertiesUpdateParameters{
			AdminUserEnabled: to.Ptr(true),
		},
		SKU: &armcontainerregistry.SKU{
			Name: to.Ptr(armcontainerregistry.SKUNameStandard),
		},
		Tags: map[string]*string{
			"key": to.Ptr("value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Registry = armcontainerregistry.Registry{
	// 	Name: to.Ptr("myRegistry"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armcontainerregistry.RegistryProperties{
	// 		AdminUserEnabled: to.Ptr(true),
	// 		AnonymousPullEnabled: to.Ptr(false),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:38:26.153Z"); return t}()),
	// 		DataEndpointEnabled: to.Ptr(false),
	// 		DataEndpointHostNames: []*string{
	// 		},
	// 		Encryption: &armcontainerregistry.EncryptionProperty{
	// 			Status: to.Ptr(armcontainerregistry.EncryptionStatusDisabled),
	// 		},
	// 		LoginServer: to.Ptr("myRegistry.azurecr-test.io"),
	// 		MetadataSearch: to.Ptr(armcontainerregistry.MetadataSearchDisabled),
	// 		NetworkRuleBypassOptions: to.Ptr(armcontainerregistry.NetworkRuleBypassOptionsAzureServices),
	// 		NetworkRuleSet: &armcontainerregistry.NetworkRuleSet{
	// 			DefaultAction: to.Ptr(armcontainerregistry.DefaultActionAllow),
	// 			IPRules: []*armcontainerregistry.IPRule{
	// 			},
	// 		},
	// 		Policies: &armcontainerregistry.Policies{
	// 			ExportPolicy: &armcontainerregistry.ExportPolicy{
	// 				Status: to.Ptr(armcontainerregistry.ExportPolicyStatusEnabled),
	// 			},
	// 			QuarantinePolicy: &armcontainerregistry.QuarantinePolicy{
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			RetentionPolicy: &armcontainerregistry.RetentionPolicy{
	// 				Days: to.Ptr[int32](7),
	// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T21:40:12.850Z"); return t}()),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 			TrustPolicy: &armcontainerregistry.TrustPolicy{
	// 				Type: to.Ptr(armcontainerregistry.TrustPolicyTypeNotary),
	// 				Status: to.Ptr(armcontainerregistry.PolicyStatusDisabled),
	// 			},
	// 		},
	// 		PrivateEndpointConnections: []*armcontainerregistry.PrivateEndpointConnection{
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armcontainerregistry.PublicNetworkAccessEnabled),
	// 		ZoneRedundancy: to.Ptr(armcontainerregistry.ZoneRedundancyDisabled),
	// 	},
	// 	SKU: &armcontainerregistry.SKU{
	// 		Name: to.Ptr(armcontainerregistry.SKUNameStandard),
	// 		Tier: to.Ptr(armcontainerregistry.SKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryListUsages.json
func ExampleRegistriesClient_ListUsages() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().ListUsages(ctx, "myResourceGroup", "myRegistry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryUsageListResult = armcontainerregistry.RegistryUsageListResult{
	// 	Value: []*armcontainerregistry.RegistryUsage{
	// 		{
	// 			Name: to.Ptr("Size"),
	// 			CurrentValue: to.Ptr[int64](12345678),
	// 			Limit: to.Ptr[int64](107374182400),
	// 			Unit: to.Ptr(armcontainerregistry.RegistryUsageUnitBytes),
	// 		},
	// 		{
	// 			Name: to.Ptr("Webhooks"),
	// 			CurrentValue: to.Ptr[int64](2),
	// 			Limit: to.Ptr[int64](10),
	// 			Unit: to.Ptr(armcontainerregistry.RegistryUsageUnitCount),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryListPrivateLinkResources.json
func ExampleRegistriesClient_NewListPrivateLinkResourcesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistriesClient().NewListPrivateLinkResourcesPager("myResourceGroup", "myRegistry", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateLinkResourceListResult = armcontainerregistry.PrivateLinkResourceListResult{
		// 	Value: []*armcontainerregistry.PrivateLinkResource{
		// 		{
		// 			Name: to.Ptr("registry"),
		// 			Type: to.Ptr("Microsoft.ContainerRegistry/registries/privateLinkResources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/privateLinkResources/registry"),
		// 			Properties: &armcontainerregistry.PrivateLinkResourceProperties{
		// 				GroupID: to.Ptr("registry"),
		// 				RequiredMembers: []*string{
		// 					to.Ptr("registry"),
		// 					to.Ptr("registry_data_myregion")},
		// 					RequiredZoneNames: []*string{
		// 						to.Ptr("privatelink.azurecr.io")},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryGetPrivateLinkResource.json
func ExampleRegistriesClient_GetPrivateLinkResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().GetPrivateLinkResource(ctx, "myResourceGroup", "myRegistry", "registry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateLinkResource = armcontainerregistry.PrivateLinkResource{
	// 	Name: to.Ptr("registry"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/privateLinkResources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/privateLinkResources/registry"),
	// 	Properties: &armcontainerregistry.PrivateLinkResourceProperties{
	// 		GroupID: to.Ptr("registry"),
	// 		RequiredMembers: []*string{
	// 			to.Ptr("registry"),
	// 			to.Ptr("registry_data_myregion")},
	// 			RequiredZoneNames: []*string{
	// 				to.Ptr("privatelink.azurecr.io")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryListCredentials.json
func ExampleRegistriesClient_ListCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().ListCredentials(ctx, "myResourceGroup", "myRegistry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryListCredentialsResult = armcontainerregistry.RegistryListCredentialsResult{
	// 	Passwords: []*armcontainerregistry.RegistryPassword{
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.PasswordNamePassword),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 		},
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.PasswordNamePassword2),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 	}},
	// 	Username: to.Ptr("myRegistry"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryRegenerateCredential.json
func ExampleRegistriesClient_RegenerateCredential() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().RegenerateCredential(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.RegenerateCredentialParameters{
		Name: to.Ptr(armcontainerregistry.PasswordNamePassword),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistryListCredentialsResult = armcontainerregistry.RegistryListCredentialsResult{
	// 	Passwords: []*armcontainerregistry.RegistryPassword{
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.PasswordNamePassword),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 		},
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.PasswordNamePassword2),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 	}},
	// 	Username: to.Ptr("myRegistry"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2023-11-01-preview/examples/RegistryGenerateCredentials.json
func ExampleRegistriesClient_BeginGenerateCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginGenerateCredentials(ctx, "myResourceGroup", "myRegistry", armcontainerregistry.GenerateCredentialsParameters{
		Expiry:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-31T15:59:59.070Z"); return t }()),
		TokenID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/myToken"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GenerateCredentialsResult = armcontainerregistry.GenerateCredentialsResult{
	// 	Passwords: []*armcontainerregistry.TokenPassword{
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.TokenPasswordNamePassword1),
	// 			Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-31T15:59:59.070Z"); return t}()),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 		},
	// 		{
	// 			Name: to.Ptr(armcontainerregistry.TokenPasswordNamePassword2),
	// 			Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-31T15:59:59.070Z"); return t}()),
	// 			Value: to.Ptr("00000000000000000000000000000000"),
	// 	}},
	// 	Username: to.Ptr("myToken"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRun() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.DockerBuildRequest{
		Type:             to.Ptr("DockerBuildRequest"),
		IsArchiveEnabled: to.Ptr(true),
		AgentConfiguration: &armcontainerregistry.AgentProperties{
			CPU: to.Ptr[int32](2),
		},
		Arguments: []*armcontainerregistry.Argument{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
		DockerFilePath: to.Ptr("DockerFile"),
		ImageNames: []*string{
			to.Ptr("azurerest:testtag")},
		IsPushEnabled: to.Ptr(true),
		NoCache:       to.Ptr(true),
		Platform: &armcontainerregistry.PlatformProperties{
			Architecture: to.Ptr(armcontainerregistry.ArchitectureAmd64),
			OS:           to.Ptr(armcontainerregistry.OSLinux),
		},
		SourceLocation: to.Ptr("https://myaccount.blob.core.windows.net/sascontainer/source.zip?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_EncodedTaskRun.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunEncodedTaskRun() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.EncodedTaskRunRequest{
		Type: to.Ptr("EncodedTaskRunRequest"),
		AgentConfiguration: &armcontainerregistry.AgentProperties{
			CPU: to.Ptr[int32](2),
		},
		EncodedTaskContent:   to.Ptr("c3RlcHM6Cnt7IGlmIFZhbHVlcy5lbnZpcm9ubWVudCA9PSAncHJvZCcgfX0KICAtIHJ1bjogcHJvZCBzZXR1cAp7eyBlbHNlIGlmIFZhbHVlcy5lbnZpcm9ubWVudCA9PSAnc3RhZ2luZycgfX0KICAtIHJ1bjogc3RhZ2luZyBzZXR1cAp7eyBlbHNlIH19CiAgLSBydW46IGRlZmF1bHQgc2V0dXAKe3sgZW5kIH19CgogIC0gcnVuOiBidWlsZCAtdCBGYW5jeVRoaW5nOnt7LlZhbHVlcy5lbnZpcm9ubWVudH19LXt7LlZhbHVlcy52ZXJzaW9ufX0gLgoKcHVzaDogWydGYW5jeVRoaW5nOnt7LlZhbHVlcy5lbnZpcm9ubWVudH19LXt7LlZhbHVlcy52ZXJzaW9ufX0nXQ=="),
		EncodedValuesContent: to.Ptr("ZW52aXJvbm1lbnQ6IHByb2QKdmVyc2lvbjogMQ=="),
		Platform: &armcontainerregistry.PlatformProperties{
			OS: to.Ptr(armcontainerregistry.OSLinux),
		},
		Values: []*armcontainerregistry.SetValue{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_FileTaskRun.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunFileTaskRun() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.FileTaskRunRequest{
		Type: to.Ptr("FileTaskRunRequest"),
		AgentConfiguration: &armcontainerregistry.AgentProperties{
			CPU: to.Ptr[int32](2),
		},
		Platform: &armcontainerregistry.PlatformProperties{
			OS: to.Ptr(armcontainerregistry.OSLinux),
		},
		SourceLocation: to.Ptr("https://myaccount.blob.core.windows.net/sascontainer/source.zip?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D"),
		TaskFilePath:   to.Ptr("acb.yaml"),
		Values: []*armcontainerregistry.SetValue{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
		ValuesFilePath: to.Ptr("prod-values.yaml"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_Task.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunTask() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.TaskRunRequest{
		Type: to.Ptr("TaskRunRequest"),
		OverrideTaskStepProperties: &armcontainerregistry.OverrideTaskStepProperties{
			Arguments: []*armcontainerregistry.Argument{
				{
					Name:     to.Ptr("mytestargument"),
					IsSecret: to.Ptr(false),
					Value:    to.Ptr("mytestvalue"),
				},
				{
					Name:     to.Ptr("mysecrettestargument"),
					IsSecret: to.Ptr(true),
					Value:    to.Ptr("mysecrettestvalue"),
				}},
			File:               to.Ptr("overriddenDockerfile"),
			Target:             to.Ptr("build"),
			UpdateTriggerToken: to.Ptr("aGVsbG8gd29ybGQ="),
			Values: []*armcontainerregistry.SetValue{
				{
					Name:     to.Ptr("mytestname"),
					IsSecret: to.Ptr(false),
					Value:    to.Ptr("mytestvalue"),
				},
				{
					Name:     to.Ptr("mysecrettestname"),
					IsSecret: to.Ptr(true),
					Value:    to.Ptr("mysecrettestvalue"),
				}},
		},
		TaskID: to.Ptr("myTask"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_FileTask_WithCustomCredentials.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunTaskWithCustomCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.FileTaskRunRequest{
		Type: to.Ptr("FileTaskRunRequest"),
		Credentials: &armcontainerregistry.Credentials{
			CustomRegistries: map[string]*armcontainerregistry.CustomRegistryCredentials{
				"myregistry.azurecr.io": {
					Password: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("***"),
					},
					UserName: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("reg1"),
					},
				},
			},
			SourceRegistry: &armcontainerregistry.SourceRegistryCredentials{
				LoginMode: to.Ptr(armcontainerregistry.SourceRegistryLoginModeDefault),
			},
		},
		Platform: &armcontainerregistry.PlatformProperties{
			OS: to.Ptr(armcontainerregistry.OSLinux),
		},
		TaskFilePath: to.Ptr("acb.yaml"),
		Values: []*armcontainerregistry.SetValue{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_WithCustomCredentials.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunWithCustomCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.DockerBuildRequest{
		Type:             to.Ptr("DockerBuildRequest"),
		IsArchiveEnabled: to.Ptr(true),
		AgentConfiguration: &armcontainerregistry.AgentProperties{
			CPU: to.Ptr[int32](2),
		},
		Arguments: []*armcontainerregistry.Argument{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
		Credentials: &armcontainerregistry.Credentials{
			CustomRegistries: map[string]*armcontainerregistry.CustomRegistryCredentials{
				"myregistry.azurecr.io": {
					Password: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("***"),
					},
					UserName: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("reg1"),
					},
				},
				"myregistry2.azurecr.io": {
					Password: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("***"),
					},
					UserName: &armcontainerregistry.SecretObject{
						Type:  to.Ptr(armcontainerregistry.SecretObjectTypeOpaque),
						Value: to.Ptr("reg2"),
					},
				},
			},
			SourceRegistry: &armcontainerregistry.SourceRegistryCredentials{
				LoginMode: to.Ptr(armcontainerregistry.SourceRegistryLoginModeDefault),
			},
		},
		DockerFilePath: to.Ptr("DockerFile"),
		ImageNames: []*string{
			to.Ptr("azurerest:testtag")},
		IsPushEnabled: to.Ptr(true),
		NoCache:       to.Ptr(true),
		Platform: &armcontainerregistry.PlatformProperties{
			Architecture: to.Ptr(armcontainerregistry.ArchitectureAmd64),
			OS:           to.Ptr(armcontainerregistry.OSLinux),
		},
		SourceLocation: to.Ptr("https://myaccount.blob.core.windows.net/sascontainer/source.zip?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D"),
		Target:         to.Ptr("stage1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesScheduleRun_WithLogTemplate.json
func ExampleRegistriesClient_BeginScheduleRun_registriesScheduleRunWithLogTemplate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistriesClient().BeginScheduleRun(ctx, "myResourceGroup", "myRegistry", &armcontainerregistry.DockerBuildRequest{
		Type:             to.Ptr("DockerBuildRequest"),
		IsArchiveEnabled: to.Ptr(true),
		LogTemplate:      to.Ptr("acr/tasks:{{.Run.OS}}"),
		AgentConfiguration: &armcontainerregistry.AgentProperties{
			CPU: to.Ptr[int32](2),
		},
		Arguments: []*armcontainerregistry.Argument{
			{
				Name:     to.Ptr("mytestargument"),
				IsSecret: to.Ptr(false),
				Value:    to.Ptr("mytestvalue"),
			},
			{
				Name:     to.Ptr("mysecrettestargument"),
				IsSecret: to.Ptr(true),
				Value:    to.Ptr("mysecrettestvalue"),
			}},
		DockerFilePath: to.Ptr("DockerFile"),
		ImageNames: []*string{
			to.Ptr("azurerest:testtag")},
		IsPushEnabled: to.Ptr(true),
		NoCache:       to.Ptr(true),
		Platform: &armcontainerregistry.PlatformProperties{
			Architecture: to.Ptr(armcontainerregistry.ArchitectureAmd64),
			OS:           to.Ptr(armcontainerregistry.OSLinux),
		},
		SourceLocation: to.Ptr("https://myaccount.blob.core.windows.net/sascontainer/source.zip?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Run = armcontainerregistry.Run{
	// 	Name: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Type: to.Ptr("Microsoft.ContainerRegistry/registries/run"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/runs/0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 	Properties: &armcontainerregistry.RunProperties{
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-25T05:13:51.617Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armcontainerregistry.ProvisioningStateSucceeded),
	// 		RunID: to.Ptr("0accec26-d6de-4757-8e74-d080f38eaaab"),
	// 		Status: to.Ptr(armcontainerregistry.RunStatusSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/containerregistry/resource-manager/Microsoft.ContainerRegistry/preview/2019-06-01-preview/examples/RegistriesGetBuildSourceUploadUrl.json
func ExampleRegistriesClient_GetBuildSourceUploadURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerregistry.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistriesClient().GetBuildSourceUploadURL(ctx, "myResourceGroup", "myRegistry", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SourceUploadDefinition = armcontainerregistry.SourceUploadDefinition{
	// 	RelativePath: to.Ptr("source/201802130000/b52f12d8-c3d6-4d75-9107-220f0bfc681d.tar.gz"),
	// 	UploadURL: to.Ptr("https://registrystorageaccount.blob.core.windows.net/registrycontainer/source/201802130000/b52f12d8-c3d6-4d75-9107-220f0bfc681d.tar.gz?sv=2015-04-05&st=2015-04-29T22%3A18%3A26Z&se=2015-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=Z%2FRHIX5Xcg0Mq2rqI3OlWTjEg2tYkboXr1P9ZUXDtkk%3D"),
	// }
}
