//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blockchain/armblockchain"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MembersServer is a fake server for instances of the armblockchain.MembersClient type.
type MembersServer struct {
	// BeginCreate is the fake for method MembersClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientBeginCreateOptions) (resp azfake.PollerResponder[armblockchain.MembersClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MembersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientBeginDeleteOptions) (resp azfake.PollerResponder[armblockchain.MembersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MembersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientGetOptions) (resp azfake.Responder[armblockchain.MembersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MembersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armblockchain.MembersClientListOptions) (resp azfake.PagerResponder[armblockchain.MembersClientListResponse])

	// ListAPIKeys is the fake for method MembersClient.ListAPIKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListAPIKeys func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientListAPIKeysOptions) (resp azfake.Responder[armblockchain.MembersClientListAPIKeysResponse], errResp azfake.ErrorResponder)

	// NewListAllPager is the fake for method MembersClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armblockchain.MembersClientListAllOptions) (resp azfake.PagerResponder[armblockchain.MembersClientListAllResponse])

	// NewListConsortiumMembersPager is the fake for method MembersClient.NewListConsortiumMembersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConsortiumMembersPager func(blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientListConsortiumMembersOptions) (resp azfake.PagerResponder[armblockchain.MembersClientListConsortiumMembersResponse])

	// ListRegenerateAPIKeys is the fake for method MembersClient.ListRegenerateAPIKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListRegenerateAPIKeys func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientListRegenerateAPIKeysOptions) (resp azfake.Responder[armblockchain.MembersClientListRegenerateAPIKeysResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method MembersClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, blockchainMemberName string, resourceGroupName string, options *armblockchain.MembersClientUpdateOptions) (resp azfake.Responder[armblockchain.MembersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMembersServerTransport creates a new instance of MembersServerTransport with the provided implementation.
// The returned MembersServerTransport instance is connected to an instance of armblockchain.MembersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMembersServerTransport(srv *MembersServer) *MembersServerTransport {
	return &MembersServerTransport{
		srv:                           srv,
		beginCreate:                   newTracker[azfake.PollerResponder[armblockchain.MembersClientCreateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armblockchain.MembersClientDeleteResponse]](),
		newListPager:                  newTracker[azfake.PagerResponder[armblockchain.MembersClientListResponse]](),
		newListAllPager:               newTracker[azfake.PagerResponder[armblockchain.MembersClientListAllResponse]](),
		newListConsortiumMembersPager: newTracker[azfake.PagerResponder[armblockchain.MembersClientListConsortiumMembersResponse]](),
	}
}

// MembersServerTransport connects instances of armblockchain.MembersClient to instances of MembersServer.
// Don't use this type directly, use NewMembersServerTransport instead.
type MembersServerTransport struct {
	srv                           *MembersServer
	beginCreate                   *tracker[azfake.PollerResponder[armblockchain.MembersClientCreateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armblockchain.MembersClientDeleteResponse]]
	newListPager                  *tracker[azfake.PagerResponder[armblockchain.MembersClientListResponse]]
	newListAllPager               *tracker[azfake.PagerResponder[armblockchain.MembersClientListAllResponse]]
	newListConsortiumMembersPager *tracker[azfake.PagerResponder[armblockchain.MembersClientListConsortiumMembersResponse]]
}

// Do implements the policy.Transporter interface for MembersServerTransport.
func (m *MembersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MembersClient.BeginCreate":
		resp, err = m.dispatchBeginCreate(req)
	case "MembersClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MembersClient.Get":
		resp, err = m.dispatchGet(req)
	case "MembersClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MembersClient.ListAPIKeys":
		resp, err = m.dispatchListAPIKeys(req)
	case "MembersClient.NewListAllPager":
		resp, err = m.dispatchNewListAllPager(req)
	case "MembersClient.NewListConsortiumMembersPager":
		resp, err = m.dispatchNewListConsortiumMembersPager(req)
	case "MembersClient.ListRegenerateAPIKeys":
		resp, err = m.dispatchListRegenerateAPIKeys(req)
	case "MembersClient.Update":
		resp, err = m.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MembersServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := m.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armblockchain.Member](req)
		if err != nil {
			return nil, err
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		var options *armblockchain.MembersClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armblockchain.MembersClientBeginCreateOptions{
				BlockchainMember: &body,
			}
		}
		respr, errRespr := m.srv.BeginCreate(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		m.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		m.beginCreate.remove(req)
	}

	return resp, nil
}

func (m *MembersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MembersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Member, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblockchain.MembersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchListAPIKeys(req *http.Request) (*http.Response, error) {
	if m.srv.ListAPIKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAPIKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listApiKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ListAPIKeys(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKeyCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := m.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListAllPager(nil)
		newListAllPager = &resp
		m.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armblockchain.MembersClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		m.newListAllPager.remove(req)
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchNewListConsortiumMembersPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListConsortiumMembersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConsortiumMembersPager not implemented")}
	}
	newListConsortiumMembersPager := m.newListConsortiumMembersPager.get(req)
	if newListConsortiumMembersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/consortiumMembers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListConsortiumMembersPager(blockchainMemberNameParam, resourceGroupNameParam, nil)
		newListConsortiumMembersPager = &resp
		m.newListConsortiumMembersPager.add(req, newListConsortiumMembersPager)
		server.PagerResponderInjectNextLinks(newListConsortiumMembersPager, req, func(page *armblockchain.MembersClientListConsortiumMembersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConsortiumMembersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListConsortiumMembersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConsortiumMembersPager) {
		m.newListConsortiumMembersPager.remove(req)
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchListRegenerateAPIKeys(req *http.Request) (*http.Response, error) {
	if m.srv.ListRegenerateAPIKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRegenerateAPIKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateApiKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblockchain.APIKey](req)
	if err != nil {
		return nil, err
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	var options *armblockchain.MembersClientListRegenerateAPIKeysOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armblockchain.MembersClientListRegenerateAPIKeysOptions{
			APIKey: &body,
		}
	}
	respr, errRespr := m.srv.ListRegenerateAPIKeys(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKeyCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MembersServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblockchain.MemberUpdate](req)
	if err != nil {
		return nil, err
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	var options *armblockchain.MembersClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armblockchain.MembersClientUpdateOptions{
			BlockchainMember: &body,
		}
	}
	respr, errRespr := m.srv.Update(req.Context(), blockchainMemberNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Member, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
