//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbillingbenefits

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SavingsPlanOrderClient contains the methods for the SavingsPlanOrder group.
// Don't use this type directly, use NewSavingsPlanOrderClient() instead.
type SavingsPlanOrderClient struct {
	internal *arm.Client
}

// NewSavingsPlanOrderClient creates a new instance of SavingsPlanOrderClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSavingsPlanOrderClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SavingsPlanOrderClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SavingsPlanOrderClient{
		internal: cl,
	}
	return client, nil
}

// Elevate - Elevate as owner on savings plan order based on billing permissions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - savingsPlanOrderID - Order ID of the savings plan
//   - options - SavingsPlanOrderClientElevateOptions contains the optional parameters for the SavingsPlanOrderClient.Elevate
//     method.
func (client *SavingsPlanOrderClient) Elevate(ctx context.Context, savingsPlanOrderID string, options *SavingsPlanOrderClientElevateOptions) (SavingsPlanOrderClientElevateResponse, error) {
	var err error
	const operationName = "SavingsPlanOrderClient.Elevate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.elevateCreateRequest(ctx, savingsPlanOrderID, options)
	if err != nil {
		return SavingsPlanOrderClientElevateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SavingsPlanOrderClientElevateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SavingsPlanOrderClientElevateResponse{}, err
	}
	resp, err := client.elevateHandleResponse(httpResp)
	return resp, err
}

// elevateCreateRequest creates the Elevate request.
func (client *SavingsPlanOrderClient) elevateCreateRequest(ctx context.Context, savingsPlanOrderID string, options *SavingsPlanOrderClientElevateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}/elevate"
	if savingsPlanOrderID == "" {
		return nil, errors.New("parameter savingsPlanOrderID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{savingsPlanOrderId}", url.PathEscape(savingsPlanOrderID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// elevateHandleResponse handles the Elevate response.
func (client *SavingsPlanOrderClient) elevateHandleResponse(resp *http.Response) (SavingsPlanOrderClientElevateResponse, error) {
	result := SavingsPlanOrderClientElevateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignmentEntity); err != nil {
		return SavingsPlanOrderClientElevateResponse{}, err
	}
	return result, nil
}

// Get - Get a savings plan order.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - savingsPlanOrderID - Order ID of the savings plan
//   - options - SavingsPlanOrderClientGetOptions contains the optional parameters for the SavingsPlanOrderClient.Get method.
func (client *SavingsPlanOrderClient) Get(ctx context.Context, savingsPlanOrderID string, options *SavingsPlanOrderClientGetOptions) (SavingsPlanOrderClientGetResponse, error) {
	var err error
	const operationName = "SavingsPlanOrderClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, savingsPlanOrderID, options)
	if err != nil {
		return SavingsPlanOrderClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SavingsPlanOrderClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SavingsPlanOrderClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SavingsPlanOrderClient) getCreateRequest(ctx context.Context, savingsPlanOrderID string, options *SavingsPlanOrderClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.BillingBenefits/savingsPlanOrders/{savingsPlanOrderId}"
	if savingsPlanOrderID == "" {
		return nil, errors.New("parameter savingsPlanOrderID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{savingsPlanOrderId}", url.PathEscape(savingsPlanOrderID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SavingsPlanOrderClient) getHandleResponse(resp *http.Response) (SavingsPlanOrderClientGetResponse, error) {
	result := SavingsPlanOrderClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SavingsPlanOrderModel); err != nil {
		return SavingsPlanOrderClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List all Savings plan orders.
//
// Generated from API version 2022-11-01
//   - options - SavingsPlanOrderClientListOptions contains the optional parameters for the SavingsPlanOrderClient.NewListPager
//     method.
func (client *SavingsPlanOrderClient) NewListPager(options *SavingsPlanOrderClientListOptions) *runtime.Pager[SavingsPlanOrderClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SavingsPlanOrderClientListResponse]{
		More: func(page SavingsPlanOrderClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SavingsPlanOrderClientListResponse) (SavingsPlanOrderClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SavingsPlanOrderClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return SavingsPlanOrderClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *SavingsPlanOrderClient) listCreateRequest(ctx context.Context, options *SavingsPlanOrderClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.BillingBenefits/savingsPlanOrders"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SavingsPlanOrderClient) listHandleResponse(resp *http.Response) (SavingsPlanOrderClientListResponse, error) {
	result := SavingsPlanOrderClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SavingsPlanOrderModelList); err != nil {
		return SavingsPlanOrderClientListResponse{}, err
	}
	return result, nil
}
