//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// PoliciesServer is a fake server for instances of the armbilling.PoliciesClient type.
type PoliciesServer struct {
	// GetByBillingProfile is the fake for method PoliciesClient.GetByBillingProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetByBillingProfile func(ctx context.Context, billingAccountName string, billingProfileName string, options *armbilling.PoliciesClientGetByBillingProfileOptions) (resp azfake.Responder[armbilling.PoliciesClientGetByBillingProfileResponse], errResp azfake.ErrorResponder)

	// GetByCustomer is the fake for method PoliciesClient.GetByCustomer
	// HTTP status codes to indicate success: http.StatusOK
	GetByCustomer func(ctx context.Context, billingAccountName string, customerName string, options *armbilling.PoliciesClientGetByCustomerOptions) (resp azfake.Responder[armbilling.PoliciesClientGetByCustomerResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method PoliciesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, billingAccountName string, billingProfileName string, parameters armbilling.Policy, options *armbilling.PoliciesClientUpdateOptions) (resp azfake.Responder[armbilling.PoliciesClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateCustomer is the fake for method PoliciesClient.UpdateCustomer
	// HTTP status codes to indicate success: http.StatusOK
	UpdateCustomer func(ctx context.Context, billingAccountName string, customerName string, parameters armbilling.CustomerPolicy, options *armbilling.PoliciesClientUpdateCustomerOptions) (resp azfake.Responder[armbilling.PoliciesClientUpdateCustomerResponse], errResp azfake.ErrorResponder)
}

// NewPoliciesServerTransport creates a new instance of PoliciesServerTransport with the provided implementation.
// The returned PoliciesServerTransport instance is connected to an instance of armbilling.PoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPoliciesServerTransport(srv *PoliciesServer) *PoliciesServerTransport {
	return &PoliciesServerTransport{srv: srv}
}

// PoliciesServerTransport connects instances of armbilling.PoliciesClient to instances of PoliciesServer.
// Don't use this type directly, use NewPoliciesServerTransport instead.
type PoliciesServerTransport struct {
	srv *PoliciesServer
}

// Do implements the policy.Transporter interface for PoliciesServerTransport.
func (p *PoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PoliciesClient.GetByBillingProfile":
		resp, err = p.dispatchGetByBillingProfile(req)
	case "PoliciesClient.GetByCustomer":
		resp, err = p.dispatchGetByCustomer(req)
	case "PoliciesClient.Update":
		resp, err = p.dispatchUpdate(req)
	case "PoliciesClient.UpdateCustomer":
		resp, err = p.dispatchUpdateCustomer(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PoliciesServerTransport) dispatchGetByBillingProfile(req *http.Request) (*http.Response, error) {
	if p.srv.GetByBillingProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByBillingProfile not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policies/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetByBillingProfile(req.Context(), billingAccountNameParam, billingProfileNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Policy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PoliciesServerTransport) dispatchGetByCustomer(req *http.Request) (*http.Response, error) {
	if p.srv.GetByCustomer == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByCustomer not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers/(?P<customerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policies/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	customerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetByCustomer(req.Context(), billingAccountNameParam, customerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomerPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PoliciesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policies/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.Policy](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), billingAccountNameParam, billingProfileNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Policy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PoliciesServerTransport) dispatchUpdateCustomer(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateCustomer == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateCustomer not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers/(?P<customerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policies/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.CustomerPolicy](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	customerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdateCustomer(req.Context(), billingAccountNameParam, customerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomerPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
