//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// NodeReportsServer is a fake server for instances of the armautomation.NodeReportsClient type.
type NodeReportsServer struct {
	// Get is the fake for method NodeReportsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, nodeID string, reportID string, options *armautomation.NodeReportsClientGetOptions) (resp azfake.Responder[armautomation.NodeReportsClientGetResponse], errResp azfake.ErrorResponder)

	// GetContent is the fake for method NodeReportsClient.GetContent
	// HTTP status codes to indicate success: http.StatusOK
	GetContent func(ctx context.Context, resourceGroupName string, automationAccountName string, nodeID string, reportID string, options *armautomation.NodeReportsClientGetContentOptions) (resp azfake.Responder[armautomation.NodeReportsClientGetContentResponse], errResp azfake.ErrorResponder)

	// NewListByNodePager is the fake for method NodeReportsClient.NewListByNodePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByNodePager func(resourceGroupName string, automationAccountName string, nodeID string, options *armautomation.NodeReportsClientListByNodeOptions) (resp azfake.PagerResponder[armautomation.NodeReportsClientListByNodeResponse])
}

// NewNodeReportsServerTransport creates a new instance of NodeReportsServerTransport with the provided implementation.
// The returned NodeReportsServerTransport instance is connected to an instance of armautomation.NodeReportsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNodeReportsServerTransport(srv *NodeReportsServer) *NodeReportsServerTransport {
	return &NodeReportsServerTransport{
		srv:                srv,
		newListByNodePager: newTracker[azfake.PagerResponder[armautomation.NodeReportsClientListByNodeResponse]](),
	}
}

// NodeReportsServerTransport connects instances of armautomation.NodeReportsClient to instances of NodeReportsServer.
// Don't use this type directly, use NewNodeReportsServerTransport instead.
type NodeReportsServerTransport struct {
	srv                *NodeReportsServer
	newListByNodePager *tracker[azfake.PagerResponder[armautomation.NodeReportsClientListByNodeResponse]]
}

// Do implements the policy.Transporter interface for NodeReportsServerTransport.
func (n *NodeReportsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NodeReportsClient.Get":
		resp, err = n.dispatchGet(req)
	case "NodeReportsClient.GetContent":
		resp, err = n.dispatchGetContent(req)
	case "NodeReportsClient.NewListByNodePager":
		resp, err = n.dispatchNewListByNodePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NodeReportsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/nodes/(?P<nodeId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/(?P<reportId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	nodeIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("nodeId")])
	if err != nil {
		return nil, err
	}
	reportIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("reportId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, nodeIDParam, reportIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DscNodeReport, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NodeReportsServerTransport) dispatchGetContent(req *http.Request) (*http.Response, error) {
	if n.srv.GetContent == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContent not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/nodes/(?P<nodeId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/(?P<reportId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/content`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	nodeIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("nodeId")])
	if err != nil {
		return nil, err
	}
	reportIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("reportId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.GetContent(req.Context(), resourceGroupNameParam, automationAccountNameParam, nodeIDParam, reportIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Interface, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NodeReportsServerTransport) dispatchNewListByNodePager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListByNodePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByNodePager not implemented")}
	}
	newListByNodePager := n.newListByNodePager.get(req)
	if newListByNodePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/nodes/(?P<nodeId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		nodeIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("nodeId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.NodeReportsClientListByNodeOptions
		if filterParam != nil {
			options = &armautomation.NodeReportsClientListByNodeOptions{
				Filter: filterParam,
			}
		}
		resp := n.srv.NewListByNodePager(resourceGroupNameParam, automationAccountNameParam, nodeIDParam, options)
		newListByNodePager = &resp
		n.newListByNodePager.add(req, newListByNodePager)
		server.PagerResponderInjectNextLinks(newListByNodePager, req, func(page *armautomation.NodeReportsClientListByNodeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByNodePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListByNodePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByNodePager) {
		n.newListByNodePager.remove(req)
	}
	return resp, nil
}
