//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// DscCompilationJobStreamServer is a fake server for instances of the armautomation.DscCompilationJobStreamClient type.
type DscCompilationJobStreamServer struct {
	// ListByJob is the fake for method DscCompilationJobStreamClient.ListByJob
	// HTTP status codes to indicate success: http.StatusOK
	ListByJob func(ctx context.Context, resourceGroupName string, automationAccountName string, jobID string, options *armautomation.DscCompilationJobStreamClientListByJobOptions) (resp azfake.Responder[armautomation.DscCompilationJobStreamClientListByJobResponse], errResp azfake.ErrorResponder)
}

// NewDscCompilationJobStreamServerTransport creates a new instance of DscCompilationJobStreamServerTransport with the provided implementation.
// The returned DscCompilationJobStreamServerTransport instance is connected to an instance of armautomation.DscCompilationJobStreamClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDscCompilationJobStreamServerTransport(srv *DscCompilationJobStreamServer) *DscCompilationJobStreamServerTransport {
	return &DscCompilationJobStreamServerTransport{srv: srv}
}

// DscCompilationJobStreamServerTransport connects instances of armautomation.DscCompilationJobStreamClient to instances of DscCompilationJobStreamServer.
// Don't use this type directly, use NewDscCompilationJobStreamServerTransport instead.
type DscCompilationJobStreamServerTransport struct {
	srv *DscCompilationJobStreamServer
}

// Do implements the policy.Transporter interface for DscCompilationJobStreamServerTransport.
func (d *DscCompilationJobStreamServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DscCompilationJobStreamClient.ListByJob":
		resp, err = d.dispatchListByJob(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DscCompilationJobStreamServerTransport) dispatchListByJob(req *http.Request) (*http.Response, error) {
	if d.srv.ListByJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByJob not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/compilationjobs/(?P<jobId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streams`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	jobIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ListByJob(req.Context(), resourceGroupNameParam, automationAccountNameParam, jobIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobStreamListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
