//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappplatform_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Get.json
func ExampleDeploymentsClient_Get_deploymentsGet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDeploymentsClient().Get(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(true),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("pending"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.SourceUploadedUserSourceInfo{
	// 			Type: to.Ptr("Source"),
	// 			Version: to.Ptr("1.0"),
	// 			RelativePath: to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
	// 			ArtifactSelector: to.Ptr("sub-module-1"),
	// 		},
	// 		Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("S0"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Get_CustomContainer.json
func ExampleDeploymentsClient_Get_deploymentsGetCustomContainer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDeploymentsClient().Get(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(false),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("N/A"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.CustomContainerUserSourceInfo{
	// 			Type: to.Ptr("Container"),
	// 			CustomContainer: &armappplatform.CustomContainer{
	// 				Args: []*string{
	// 					to.Ptr("-c"),
	// 					to.Ptr("while true; do echo hello; sleep 10;done")},
	// 					Command: []*string{
	// 						to.Ptr("/bin/sh")},
	// 						ContainerImage: to.Ptr("myContainerImage:v1"),
	// 						ImageRegistryCredential: &armappplatform.ImageRegistryCredential{
	// 							Password: to.Ptr(""),
	// 							Username: to.Ptr("myUsername"),
	// 						},
	// 						LanguageFramework: to.Ptr("springboot"),
	// 						Server: to.Ptr("myacr.azurecr.io"),
	// 					},
	// 				},
	// 				Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 			},
	// 			SKU: &armappplatform.SKU{
	// 				Name: to.Ptr("S0"),
	// 				Capacity: to.Ptr[int32](1),
	// 				Tier: to.Ptr("Standard"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_CreateOrUpdate.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_deploymentsCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DeploymentResource{
		Properties: &armappplatform.DeploymentResourceProperties{
			DeploymentSettings: &armappplatform.DeploymentSettings{
				AddonConfigs: map[string]any{
					"ApplicationConfigurationService": map[string]any{
						"patterns": []any{
							"mypattern",
						},
					},
				},
				Apms: []*armappplatform.ApmReference{
					{
						ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
					}},
				EnvironmentVariables: map[string]*string{
					"env": to.Ptr("test"),
				},
				LivenessProbe: &armappplatform.Probe{
					DisableProbe:        to.Ptr(false),
					FailureThreshold:    to.Ptr[int32](3),
					InitialDelaySeconds: to.Ptr[int32](30),
					PeriodSeconds:       to.Ptr[int32](10),
					ProbeAction: &armappplatform.HTTPGetAction{
						Type:   to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
						Path:   to.Ptr("/health"),
						Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
					},
				},
				ReadinessProbe: &armappplatform.Probe{
					DisableProbe:        to.Ptr(false),
					FailureThreshold:    to.Ptr[int32](3),
					InitialDelaySeconds: to.Ptr[int32](30),
					PeriodSeconds:       to.Ptr[int32](10),
					ProbeAction: &armappplatform.HTTPGetAction{
						Type:   to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
						Path:   to.Ptr("/health"),
						Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
					},
				},
				ResourceRequests: &armappplatform.ResourceRequests{
					CPU:    to.Ptr("1000m"),
					Memory: to.Ptr("3Gi"),
				},
				TerminationGracePeriodSeconds: to.Ptr[int32](30),
			},
			Source: &armappplatform.SourceUploadedUserSourceInfo{
				Type:             to.Ptr("Source"),
				Version:          to.Ptr("1.0"),
				RelativePath:     to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
				ArtifactSelector: to.Ptr("sub-module-1"),
			},
		},
		SKU: &armappplatform.SKU{
			Name:     to.Ptr("S0"),
			Capacity: to.Ptr[int32](1),
			Tier:     to.Ptr("Standard"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(false),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			LivenessProbe: &armappplatform.Probe{
	// 				DisableProbe: to.Ptr(false),
	// 				FailureThreshold: to.Ptr[int32](3),
	// 				InitialDelaySeconds: to.Ptr[int32](30),
	// 				PeriodSeconds: to.Ptr[int32](10),
	// 				ProbeAction: &armappplatform.HTTPGetAction{
	// 					Type: to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
	// 					Path: to.Ptr("/health"),
	// 					Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
	// 				},
	// 			},
	// 			ReadinessProbe: &armappplatform.Probe{
	// 				DisableProbe: to.Ptr(false),
	// 				FailureThreshold: to.Ptr[int32](3),
	// 				InitialDelaySeconds: to.Ptr[int32](30),
	// 				PeriodSeconds: to.Ptr[int32](10),
	// 				ProbeAction: &armappplatform.HTTPGetAction{
	// 					Type: to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
	// 					Path: to.Ptr("/health"),
	// 					Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
	// 				},
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 			TerminationGracePeriodSeconds: to.Ptr[int32](30),
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("pending"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.SourceUploadedUserSourceInfo{
	// 			Type: to.Ptr("Source"),
	// 			Version: to.Ptr("1.0"),
	// 			RelativePath: to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
	// 			ArtifactSelector: to.Ptr("sub-module-1"),
	// 		},
	// 		Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("S0"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_CreateOrUpdate_CustomContainer.json
func ExampleDeploymentsClient_BeginCreateOrUpdate_deploymentsCreateOrUpdateCustomContainer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DeploymentResource{
		Properties: &armappplatform.DeploymentResourceProperties{
			DeploymentSettings: &armappplatform.DeploymentSettings{
				EnvironmentVariables: map[string]*string{
					"env": to.Ptr("test"),
				},
				LivenessProbe: &armappplatform.Probe{
					DisableProbe:        to.Ptr(false),
					FailureThreshold:    to.Ptr[int32](3),
					InitialDelaySeconds: to.Ptr[int32](30),
					PeriodSeconds:       to.Ptr[int32](10),
					ProbeAction: &armappplatform.HTTPGetAction{
						Type:   to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
						Path:   to.Ptr("/health"),
						Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
					},
				},
				ReadinessProbe: &armappplatform.Probe{
					DisableProbe:        to.Ptr(false),
					FailureThreshold:    to.Ptr[int32](3),
					InitialDelaySeconds: to.Ptr[int32](30),
					PeriodSeconds:       to.Ptr[int32](10),
					ProbeAction: &armappplatform.HTTPGetAction{
						Type:   to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
						Path:   to.Ptr("/health"),
						Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
					},
				},
				ResourceRequests: &armappplatform.ResourceRequests{
					CPU:    to.Ptr("1000m"),
					Memory: to.Ptr("3Gi"),
				},
				TerminationGracePeriodSeconds: to.Ptr[int32](30),
			},
			Source: &armappplatform.CustomContainerUserSourceInfo{
				Type: to.Ptr("Container"),
				CustomContainer: &armappplatform.CustomContainer{
					Args: []*string{
						to.Ptr("-c"),
						to.Ptr("while true; do echo hello; sleep 10;done")},
					Command: []*string{
						to.Ptr("/bin/sh")},
					ContainerImage: to.Ptr("myContainerImage:v1"),
					ImageRegistryCredential: &armappplatform.ImageRegistryCredential{
						Password: to.Ptr("myPassword"),
						Username: to.Ptr("myUsername"),
					},
					LanguageFramework: to.Ptr("springboot"),
					Server:            to.Ptr("myacr.azurecr.io"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(false),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			LivenessProbe: &armappplatform.Probe{
	// 				DisableProbe: to.Ptr(false),
	// 				FailureThreshold: to.Ptr[int32](3),
	// 				InitialDelaySeconds: to.Ptr[int32](30),
	// 				PeriodSeconds: to.Ptr[int32](10),
	// 				ProbeAction: &armappplatform.HTTPGetAction{
	// 					Type: to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
	// 					Path: to.Ptr("/health"),
	// 					Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
	// 				},
	// 			},
	// 			ReadinessProbe: &armappplatform.Probe{
	// 				DisableProbe: to.Ptr(false),
	// 				FailureThreshold: to.Ptr[int32](3),
	// 				InitialDelaySeconds: to.Ptr[int32](30),
	// 				PeriodSeconds: to.Ptr[int32](10),
	// 				ProbeAction: &armappplatform.HTTPGetAction{
	// 					Type: to.Ptr(armappplatform.ProbeActionTypeHTTPGetAction),
	// 					Path: to.Ptr("/health"),
	// 					Scheme: to.Ptr(armappplatform.HTTPSchemeTypeHTTP),
	// 				},
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 			TerminationGracePeriodSeconds: to.Ptr[int32](30),
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("N/A"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.CustomContainerUserSourceInfo{
	// 			Type: to.Ptr("Container"),
	// 			CustomContainer: &armappplatform.CustomContainer{
	// 				ContainerImage: to.Ptr("myContainerImage:v1"),
	// 				ImageRegistryCredential: &armappplatform.ImageRegistryCredential{
	// 					Password: to.Ptr(""),
	// 					Username: to.Ptr("myUsername"),
	// 				},
	// 				LanguageFramework: to.Ptr("springboot"),
	// 				Server: to.Ptr("myacr.azurecr.io"),
	// 			},
	// 		},
	// 		Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("S0"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Delete.json
func ExampleDeploymentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginDelete(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Update.json
func ExampleDeploymentsClient_BeginUpdate_deploymentsUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DeploymentResource{
		Properties: &armappplatform.DeploymentResourceProperties{
			Source: &armappplatform.SourceUploadedUserSourceInfo{
				Type:             to.Ptr("Source"),
				Version:          to.Ptr("1.0"),
				RelativePath:     to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
				ArtifactSelector: to.Ptr("sub-module-1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(true),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("pending"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.SourceUploadedUserSourceInfo{
	// 			Type: to.Ptr("Source"),
	// 			Version: to.Ptr("1.0"),
	// 			RelativePath: to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
	// 			ArtifactSelector: to.Ptr("sub-module-1"),
	// 		},
	// 		Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("S0"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Update_CustomContainer.json
func ExampleDeploymentsClient_BeginUpdate_deploymentsUpdateCustomContainer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginUpdate(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DeploymentResource{
		Properties: &armappplatform.DeploymentResourceProperties{
			Source: &armappplatform.CustomContainerUserSourceInfo{
				Type: to.Ptr("Container"),
				CustomContainer: &armappplatform.CustomContainer{
					Args: []*string{
						to.Ptr("-c"),
						to.Ptr("while true; do echo hello; sleep 10;done")},
					Command: []*string{
						to.Ptr("/bin/sh")},
					ContainerImage: to.Ptr("myNewContainerImage:v1"),
					ImageRegistryCredential: &armappplatform.ImageRegistryCredential{
						Password: to.Ptr("<myNewPassword>"),
						Username: to.Ptr("myNewUsername"),
					},
					Server: to.Ptr("mynewacr.azurecr.io"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentResource = armappplatform.DeploymentResource{
	// 	Name: to.Ptr("mydeployment"),
	// 	Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
	// 	SystemData: &armappplatform.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
	// 		CreatedBy: to.Ptr("sample-user"),
	// 		CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sample-user"),
	// 		LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
	// 	},
	// 	Properties: &armappplatform.DeploymentResourceProperties{
	// 		Active: to.Ptr(false),
	// 		DeploymentSettings: &armappplatform.DeploymentSettings{
	// 			Apms: []*armappplatform.ApmReference{
	// 				{
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
	// 			}},
	// 			EnvironmentVariables: map[string]*string{
	// 				"env": to.Ptr("test"),
	// 			},
	// 			ResourceRequests: &armappplatform.ResourceRequests{
	// 				CPU: to.Ptr("1000m"),
	// 				Memory: to.Ptr("3Gi"),
	// 			},
	// 		},
	// 		Instances: []*armappplatform.DeploymentInstance{
	// 			{
	// 				Name: to.Ptr("instance1"),
	// 				DiscoveryStatus: to.Ptr("N/A"),
	// 				StartTime: to.Ptr("2020-08-26T01:55:02Z"),
	// 				Status: to.Ptr("Running"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
	// 		Source: &armappplatform.CustomContainerUserSourceInfo{
	// 			Type: to.Ptr("Container"),
	// 			CustomContainer: &armappplatform.CustomContainer{
	// 				ContainerImage: to.Ptr("myNewContainerImage:v1"),
	// 				ImageRegistryCredential: &armappplatform.ImageRegistryCredential{
	// 					Password: to.Ptr(""),
	// 					Username: to.Ptr("myNewUsername"),
	// 				},
	// 				Server: to.Ptr("mynewacr.azurecr.io"),
	// 			},
	// 		},
	// 		Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
	// 	},
	// 	SKU: &armappplatform.SKU{
	// 		Name: to.Ptr("S0"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_List.json
func ExampleDeploymentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDeploymentsClient().NewListPager("myResourceGroup", "myservice", "myapp", &armappplatform.DeploymentsClientListOptions{Version: []string{}})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentResourceCollection = armappplatform.DeploymentResourceCollection{
		// 	Value: []*armappplatform.DeploymentResource{
		// 		{
		// 			Name: to.Ptr("mydeployment"),
		// 			Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
		// 			SystemData: &armappplatform.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
		// 				CreatedBy: to.Ptr("sample-user"),
		// 				CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sample-user"),
		// 				LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
		// 			},
		// 			Properties: &armappplatform.DeploymentResourceProperties{
		// 				Active: to.Ptr(true),
		// 				DeploymentSettings: &armappplatform.DeploymentSettings{
		// 					Apms: []*armappplatform.ApmReference{
		// 						{
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
		// 					}},
		// 					EnvironmentVariables: map[string]*string{
		// 						"env": to.Ptr("test"),
		// 					},
		// 					ResourceRequests: &armappplatform.ResourceRequests{
		// 						CPU: to.Ptr("1000m"),
		// 						Memory: to.Ptr("3Gi"),
		// 					},
		// 				},
		// 				Instances: []*armappplatform.DeploymentInstance{
		// 					{
		// 						Name: to.Ptr("instance1"),
		// 						DiscoveryStatus: to.Ptr("pending"),
		// 						StartTime: to.Ptr("2020-08-26T01:55:02Z"),
		// 						Status: to.Ptr("Running"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
		// 				Source: &armappplatform.SourceUploadedUserSourceInfo{
		// 					Type: to.Ptr("Source"),
		// 					Version: to.Ptr("1.0"),
		// 					RelativePath: to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
		// 					ArtifactSelector: to.Ptr("sub-module-1"),
		// 				},
		// 				Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
		// 			},
		// 			SKU: &armappplatform.SKU{
		// 				Name: to.Ptr("S0"),
		// 				Capacity: to.Ptr[int32](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_ListForCluster.json
func ExampleDeploymentsClient_NewListForClusterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDeploymentsClient().NewListForClusterPager("myResourceGroup", "myservice", &armappplatform.DeploymentsClientListForClusterOptions{Version: []string{},
		Expand: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentResourceCollection = armappplatform.DeploymentResourceCollection{
		// 	Value: []*armappplatform.DeploymentResource{
		// 		{
		// 			Name: to.Ptr("mydeployment"),
		// 			Type: to.Ptr("Microsoft.AppPlatform/Spring/apps/deployments"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myapp/deployments/mydeployment"),
		// 			SystemData: &armappplatform.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:16:03.944Z"); return t}()),
		// 				CreatedBy: to.Ptr("sample-user"),
		// 				CreatedByType: to.Ptr(armappplatform.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-11T03:17:03.944Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sample-user"),
		// 				LastModifiedByType: to.Ptr(armappplatform.LastModifiedByTypeUser),
		// 			},
		// 			Properties: &armappplatform.DeploymentResourceProperties{
		// 				Active: to.Ptr(true),
		// 				DeploymentSettings: &armappplatform.DeploymentSettings{
		// 					Apms: []*armappplatform.ApmReference{
		// 						{
		// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
		// 					}},
		// 					EnvironmentVariables: map[string]*string{
		// 						"env": to.Ptr("test"),
		// 					},
		// 					ResourceRequests: &armappplatform.ResourceRequests{
		// 						CPU: to.Ptr("1000m"),
		// 						Memory: to.Ptr("3Gi"),
		// 					},
		// 				},
		// 				Instances: []*armappplatform.DeploymentInstance{
		// 					{
		// 						Name: to.Ptr("instance1"),
		// 						DiscoveryStatus: to.Ptr("pending"),
		// 						StartTime: to.Ptr("2020-08-26T01:55:02Z"),
		// 						Status: to.Ptr("Running"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armappplatform.DeploymentResourceProvisioningStateSucceeded),
		// 				Source: &armappplatform.SourceUploadedUserSourceInfo{
		// 					Type: to.Ptr("Source"),
		// 					Version: to.Ptr("1.0"),
		// 					RelativePath: to.Ptr("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc"),
		// 					ArtifactSelector: to.Ptr("sub-module-1"),
		// 				},
		// 				Status: to.Ptr(armappplatform.DeploymentResourceStatusRunning),
		// 			},
		// 			SKU: &armappplatform.SKU{
		// 				Name: to.Ptr("S0"),
		// 				Capacity: to.Ptr[int32](1),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Start.json
func ExampleDeploymentsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginStart(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Stop.json
func ExampleDeploymentsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginStop(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_Restart.json
func ExampleDeploymentsClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginRestart(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_EnableRemoteDebugging.json
func ExampleDeploymentsClient_BeginEnableRemoteDebugging() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginEnableRemoteDebugging(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", &armappplatform.DeploymentsClientBeginEnableRemoteDebuggingOptions{RemoteDebuggingPayload: &armappplatform.RemoteDebuggingPayload{}})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemoteDebugging = armappplatform.RemoteDebugging{
	// 	Enabled: to.Ptr(true),
	// 	Port: to.Ptr[int32](5005),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_DisableRemoteDebugging.json
func ExampleDeploymentsClient_BeginDisableRemoteDebugging() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginDisableRemoteDebugging(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemoteDebugging = armappplatform.RemoteDebugging{
	// 	Enabled: to.Ptr(false),
	// 	Port: to.Ptr[int32](5005),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_GetRemoteDebuggingConfig.json
func ExampleDeploymentsClient_GetRemoteDebuggingConfig() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDeploymentsClient().GetRemoteDebuggingConfig(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemoteDebugging = armappplatform.RemoteDebugging{
	// 	Enabled: to.Ptr(true),
	// 	Port: to.Ptr[int32](5005),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_GetLogFileUrl.json
func ExampleDeploymentsClient_GetLogFileURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDeploymentsClient().GetLogFileURL(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogFileURLResponse = armappplatform.LogFileURLResponse{
	// 	URL: to.Ptr("https://spring.blob.core.windows.net/logs/110ec0c337154d45b1f01daf2196c0bf/b58b0cb4ecdea3c65311b4ca8833fe47b6ae0a7500f87a8eb31e8379d3fe48f1-2019081312-42b7b90c-f108-4c09-b33d-1ea134f57f23?sv=2018-03-28&sr=b&sig=example-signature&se=2019-08-14T09%3A43%3A52Z&sp=r"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_GenerateHeapDump.json
func ExampleDeploymentsClient_BeginGenerateHeapDump() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginGenerateHeapDump(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DiagnosticParameters{
		AppInstance: to.Ptr("myappinstance"),
		FilePath:    to.Ptr("/byos/diagnose"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_GenerateThreadDump.json
func ExampleDeploymentsClient_BeginGenerateThreadDump() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginGenerateThreadDump(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DiagnosticParameters{
		AppInstance: to.Ptr("myappinstance"),
		FilePath:    to.Ptr("/byos/diagnose"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/685aad3f33d355c1d9c89d493ee9398865367bd8/specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2023-12-01/examples/Deployments_StartJFR.json
func ExampleDeploymentsClient_BeginStartJFR() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappplatform.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDeploymentsClient().BeginStartJFR(ctx, "myResourceGroup", "myservice", "myapp", "mydeployment", armappplatform.DiagnosticParameters{
		AppInstance: to.Ptr("myappinstance"),
		Duration:    to.Ptr("60s"),
		FilePath:    to.Ptr("/byos/diagnose"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
