//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armapplicationinsights.ClientFactory type.
type ServerFactory struct {
	APIKeysServer                          APIKeysServer
	AnalyticsItemsServer                   AnalyticsItemsServer
	AnnotationsServer                      AnnotationsServer
	ComponentAvailableFeaturesServer       ComponentAvailableFeaturesServer
	ComponentCurrentBillingFeaturesServer  ComponentCurrentBillingFeaturesServer
	ComponentFeatureCapabilitiesServer     ComponentFeatureCapabilitiesServer
	ComponentQuotaStatusServer             ComponentQuotaStatusServer
	ComponentsServer                       ComponentsServer
	ExportConfigurationsServer             ExportConfigurationsServer
	FavoritesServer                        FavoritesServer
	MyWorkbooksServer                      MyWorkbooksServer
	ProactiveDetectionConfigurationsServer ProactiveDetectionConfigurationsServer
	WebTestLocationsServer                 WebTestLocationsServer
	WebTestsServer                         WebTestsServer
	WorkItemConfigurationsServer           WorkItemConfigurationsServer
	WorkbooksServer                        WorkbooksServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armapplicationinsights.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armapplicationinsights.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                      *ServerFactory
	trMu                                     sync.Mutex
	trAPIKeysServer                          *APIKeysServerTransport
	trAnalyticsItemsServer                   *AnalyticsItemsServerTransport
	trAnnotationsServer                      *AnnotationsServerTransport
	trComponentAvailableFeaturesServer       *ComponentAvailableFeaturesServerTransport
	trComponentCurrentBillingFeaturesServer  *ComponentCurrentBillingFeaturesServerTransport
	trComponentFeatureCapabilitiesServer     *ComponentFeatureCapabilitiesServerTransport
	trComponentQuotaStatusServer             *ComponentQuotaStatusServerTransport
	trComponentsServer                       *ComponentsServerTransport
	trExportConfigurationsServer             *ExportConfigurationsServerTransport
	trFavoritesServer                        *FavoritesServerTransport
	trMyWorkbooksServer                      *MyWorkbooksServerTransport
	trProactiveDetectionConfigurationsServer *ProactiveDetectionConfigurationsServerTransport
	trWebTestLocationsServer                 *WebTestLocationsServerTransport
	trWebTestsServer                         *WebTestsServerTransport
	trWorkItemConfigurationsServer           *WorkItemConfigurationsServerTransport
	trWorkbooksServer                        *WorkbooksServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "APIKeysClient":
		initServer(s, &s.trAPIKeysServer, func() *APIKeysServerTransport { return NewAPIKeysServerTransport(&s.srv.APIKeysServer) })
		resp, err = s.trAPIKeysServer.Do(req)
	case "AnalyticsItemsClient":
		initServer(s, &s.trAnalyticsItemsServer, func() *AnalyticsItemsServerTransport {
			return NewAnalyticsItemsServerTransport(&s.srv.AnalyticsItemsServer)
		})
		resp, err = s.trAnalyticsItemsServer.Do(req)
	case "AnnotationsClient":
		initServer(s, &s.trAnnotationsServer, func() *AnnotationsServerTransport { return NewAnnotationsServerTransport(&s.srv.AnnotationsServer) })
		resp, err = s.trAnnotationsServer.Do(req)
	case "ComponentAvailableFeaturesClient":
		initServer(s, &s.trComponentAvailableFeaturesServer, func() *ComponentAvailableFeaturesServerTransport {
			return NewComponentAvailableFeaturesServerTransport(&s.srv.ComponentAvailableFeaturesServer)
		})
		resp, err = s.trComponentAvailableFeaturesServer.Do(req)
	case "ComponentCurrentBillingFeaturesClient":
		initServer(s, &s.trComponentCurrentBillingFeaturesServer, func() *ComponentCurrentBillingFeaturesServerTransport {
			return NewComponentCurrentBillingFeaturesServerTransport(&s.srv.ComponentCurrentBillingFeaturesServer)
		})
		resp, err = s.trComponentCurrentBillingFeaturesServer.Do(req)
	case "ComponentFeatureCapabilitiesClient":
		initServer(s, &s.trComponentFeatureCapabilitiesServer, func() *ComponentFeatureCapabilitiesServerTransport {
			return NewComponentFeatureCapabilitiesServerTransport(&s.srv.ComponentFeatureCapabilitiesServer)
		})
		resp, err = s.trComponentFeatureCapabilitiesServer.Do(req)
	case "ComponentQuotaStatusClient":
		initServer(s, &s.trComponentQuotaStatusServer, func() *ComponentQuotaStatusServerTransport {
			return NewComponentQuotaStatusServerTransport(&s.srv.ComponentQuotaStatusServer)
		})
		resp, err = s.trComponentQuotaStatusServer.Do(req)
	case "ComponentsClient":
		initServer(s, &s.trComponentsServer, func() *ComponentsServerTransport { return NewComponentsServerTransport(&s.srv.ComponentsServer) })
		resp, err = s.trComponentsServer.Do(req)
	case "ExportConfigurationsClient":
		initServer(s, &s.trExportConfigurationsServer, func() *ExportConfigurationsServerTransport {
			return NewExportConfigurationsServerTransport(&s.srv.ExportConfigurationsServer)
		})
		resp, err = s.trExportConfigurationsServer.Do(req)
	case "FavoritesClient":
		initServer(s, &s.trFavoritesServer, func() *FavoritesServerTransport { return NewFavoritesServerTransport(&s.srv.FavoritesServer) })
		resp, err = s.trFavoritesServer.Do(req)
	case "MyWorkbooksClient":
		initServer(s, &s.trMyWorkbooksServer, func() *MyWorkbooksServerTransport { return NewMyWorkbooksServerTransport(&s.srv.MyWorkbooksServer) })
		resp, err = s.trMyWorkbooksServer.Do(req)
	case "ProactiveDetectionConfigurationsClient":
		initServer(s, &s.trProactiveDetectionConfigurationsServer, func() *ProactiveDetectionConfigurationsServerTransport {
			return NewProactiveDetectionConfigurationsServerTransport(&s.srv.ProactiveDetectionConfigurationsServer)
		})
		resp, err = s.trProactiveDetectionConfigurationsServer.Do(req)
	case "WebTestLocationsClient":
		initServer(s, &s.trWebTestLocationsServer, func() *WebTestLocationsServerTransport {
			return NewWebTestLocationsServerTransport(&s.srv.WebTestLocationsServer)
		})
		resp, err = s.trWebTestLocationsServer.Do(req)
	case "WebTestsClient":
		initServer(s, &s.trWebTestsServer, func() *WebTestsServerTransport { return NewWebTestsServerTransport(&s.srv.WebTestsServer) })
		resp, err = s.trWebTestsServer.Do(req)
	case "WorkItemConfigurationsClient":
		initServer(s, &s.trWorkItemConfigurationsServer, func() *WorkItemConfigurationsServerTransport {
			return NewWorkItemConfigurationsServerTransport(&s.srv.WorkItemConfigurationsServer)
		})
		resp, err = s.trWorkItemConfigurationsServer.Do(req)
	case "WorkbooksClient":
		initServer(s, &s.trWorkbooksServer, func() *WorkbooksServerTransport { return NewWorkbooksServerTransport(&s.srv.WorkbooksServer) })
		resp, err = s.trWorkbooksServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
