//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservice

// AccessProfile - Profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// Base64-encoded Kubernetes configuration file.
	KubeConfig []byte `json:"kubeConfig,omitempty"`
}

// AgentPool - Agent Pool.
type AgentPool struct {
	// Properties of an agent pool.
	Properties *ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersions - The list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	// REQUIRED; Properties of agent pool available versions.
	Properties *AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Id of the agent pool available versions.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the agent pool available versions.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the agent pool available versions.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersionsProperties - The list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// List of versions available for agent pool.
	AgentPoolVersions []*AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolListResult - The response from the List Agent Pools operation.
type AgentPoolListResult struct {
	// The list of agent pools.
	Value []*AgentPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AgentPoolProfile - Profile for the container service agent pool.
type AgentPoolProfile struct {
	// REQUIRED; Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// DNS prefix to be used to create the FQDN for the agent pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Ports number array used to expose on this agent pool. The default opened ports are different based on your choice of orchestrator.
	Ports []*int32 `json:"ports,omitempty"`

	// Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will
	// choose for you based on the orchestrator choice.
	StorageProfile *ContainerServiceStorageProfileTypes `json:"storageProfile,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; FQDN for the agent pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfile - The list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	// REQUIRED; Properties of agent pool upgrade profile.
	Properties *AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Id of the agent pool upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfileProperties - The list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// REQUIRED; Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
	OSType *OSType `json:"osType,omitempty"`

	// LatestNodeImageVersion is the latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
}

type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolUpgradeSettings - Settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// Count or percentage of additional nodes to be added during upgrade. If empty uses AKS default
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// AgentPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the AgentPoolsClient.BeginCreateOrUpdate
// method.
type AgentPoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginDeleteOptions contains the optional parameters for the AgentPoolsClient.BeginDelete method.
type AgentPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginUpgradeNodeImageVersionOptions contains the optional parameters for the AgentPoolsClient.BeginUpgradeNodeImageVersion
// method.
type AgentPoolsClientBeginUpgradeNodeImageVersionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientGetAvailableAgentPoolVersionsOptions contains the optional parameters for the AgentPoolsClient.GetAvailableAgentPoolVersions
// method.
type AgentPoolsClientGetAvailableAgentPoolVersionsOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetOptions contains the optional parameters for the AgentPoolsClient.Get method.
type AgentPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetUpgradeProfileOptions contains the optional parameters for the AgentPoolsClient.GetUpgradeProfile method.
type AgentPoolsClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientListOptions contains the optional parameters for the AgentPoolsClient.NewListPager method.
type AgentPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// BasicOrchestratorProfile - Profile for the container service orchestrator.
type BasicOrchestratorProfile struct {
	// REQUIRED; The orchestrator to use to manage container service cluster resources. Valid values are Kubernetes, Swarm, DCOS,
	// DockerCE and Custom.
	OrchestratorType *ContainerServiceOrchestratorTypes `json:"orchestratorType,omitempty"`

	// The version of the orchestrator to use. You can specify the major.minor.patch part of the actual version.For example, you
	// can specify version as "1.6.11".
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
}

// CloudError - An error response from the Container service.
type CloudError struct {
	// Details about the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Container service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type Components1Q1Og48SchemasManagedclusterAllof1 struct {
	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties `json:"properties,omitempty"`
}

type Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

type ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties struct {
	// The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ContainerService - Container service.
type ContainerService struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the container service.
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainerServicesClient.BeginCreateOrUpdate
// method.
type ContainerServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerServicesClientBeginDeleteOptions contains the optional parameters for the ContainerServicesClient.BeginDelete
// method.
type ContainerServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerServicesClientGetOptions contains the optional parameters for the ContainerServicesClient.Get method.
type ContainerServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerServicesClientListByResourceGroupOptions contains the optional parameters for the ContainerServicesClient.NewListByResourceGroupPager
// method.
type ContainerServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ContainerServicesClientListOptions contains the optional parameters for the ContainerServicesClient.NewListPager method.
type ContainerServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ContainerServicesClientListOrchestratorsOptions contains the optional parameters for the ContainerServicesClient.ListOrchestrators
// method.
type ContainerServicesClientListOrchestratorsOptions struct {
	// resource type for which the list of orchestrators needs to be returned
	ResourceType *string
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// CredentialResults - The list of credential result response.
type CredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult `json:"kubeconfigs,omitempty" azure:"ro"`
}

// CustomProfile - Properties to configure a custom container service cluster.
type CustomProfile struct {
	// REQUIRED; The name of the custom orchestrator to use.
	Orchestrator *string `json:"orchestrator,omitempty"`
}

// DiagnosticsProfile - Profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// REQUIRED; Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// KeyVaultSecretRef - Reference to a secret stored in Azure Key Vault.
type KeyVaultSecretRef struct {
	// REQUIRED; The secret name.
	SecretName *string `json:"secretName,omitempty"`

	// REQUIRED; Key vault identifier.
	VaultID *string `json:"vaultID,omitempty"`

	// The secret version.
	Version *string `json:"version,omitempty"`
}

// KubeletConfig - Kubelet configurations of agent nodes.
type KubeletConfig struct {
	// Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in *).
	AllowedUnsafeSysctls []*string `json:"allowedUnsafeSysctls,omitempty"`

	// Enable CPU CFS quota enforcement for containers that specify CPU limits.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`

	// Sets CPU CFS quota period value.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`

	// CPU Manager policy to use.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`

	// If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`

	// The percent of disk usage after which image garbage collection is always run.
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`

	// The percent of disk usage before which image garbage collection is never run.
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`

	// Topology Manager policy to use.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
}

// LinuxOSConfig - OS configurations of Linux agent nodes.
type LinuxOSConfig struct {
	// SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`

	// Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`

	// Transparent Huge Page defrag configuration.
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`

	// Transparent Huge Page enabled configuration.
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
}

// LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// REQUIRED; The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// REQUIRED; SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// ListResult - The response from the List Container Services operation.
type ListResult struct {
	// The list of container services.
	Value []*ContainerService `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of container service results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedCluster - Managed cluster.
type ManagedCluster struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties `json:"properties,omitempty"`

	// The managed cluster SKU.
	SKU *ManagedClusterSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAADProfile - AADProfile specifies attributes for Azure Active Directory integration.
type ManagedClusterAADProfile struct {
	// AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAPIServerAccessProfile - Access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// Authorized IP Ranges to kubernetes API server.
	AuthorizedIPRanges []*string `json:"authorizedIPRanges,omitempty"`

	// Whether to create the cluster as a private cluster or not.
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`

	// Private dns zone mode for private cluster.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`
}

// ManagedClusterAccessProfile - Managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// AccessProfile of a managed cluster.
	Properties *AccessProfile `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfile - A Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// REQUIRED; Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config,omitempty"`

	// READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfileIdentity - Information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ManagedClusterAgentPoolProfile - Profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// REQUIRED; Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`

	// Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user
	// pools and in the range of 1 to 100 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// Enable public IP for nodes
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// KubeletConfig specifies the configuration of kubelet on agent nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// LinuxOSConfig specifies the OS configuration of linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// Maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// Maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// Minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// AgentPoolMode represents mode of an agent pool
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified,
	// defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk
	// larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation.
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Version of orchestrator specified when creating the managed cluster.
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// Pod SubnetID specifies the VNet's subnet identifier for pods.
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal
	// value greater than zero or -1 which indicates default price to be up-to
	// on-demand.
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// Agent pool tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// AgentPoolType represents types of an agent pool
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; Version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the Agent Pool is Running or Stopped
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAgentPoolProfileProperties - Properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user
	// pools and in the range of 1 to 100 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// Enable public IP for nodes
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// KubeletConfig specifies the configuration of kubelet on agent nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// LinuxOSConfig specifies the OS configuration of linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// Maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// Maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// Minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// AgentPoolMode represents mode of an agent pool
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// Agent pool node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified,
	// defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk
	// larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation.
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Version of orchestrator specified when creating the managed cluster.
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// Pod SubnetID specifies the VNet's subnet identifier for pods.
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal
	// value greater than zero or -1 which indicates default price to be up-to
	// on-demand.
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// Agent pool tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// AgentPoolType represents types of an agent pool
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; Version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the Agent Pool is Running or Stopped
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAutoUpgradeProfile - Auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// upgrade channel for auto upgrade.
	UpgradeChannel *UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterIdentity - Identity for the managed cluster.
type ManagedClusterIdentity struct {
	// The type of identity used for the managed cluster. Type 'SystemAssigned' will use an implicitly created identity in master
	// components and an auto-created user assigned identity in MC_ resource group
	// in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The user identity associated with the managed cluster. This identity will be used in control plane and only one user assigned
	// identity is allowed. The user identity dictionary key references will be
	// ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagedClusterListResult - The response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	// The list of managed clusters.
	Value []*ManagedCluster `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedClusterLoadBalancerProfile - Profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// Desired number of allocated SNAT ports per VM. Allowed values must be in the range of 0 to 64000 (inclusive). The default
	// value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values must be in the range of 4 to 120 (inclusive). The default
	// value is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`

	// Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`

	// Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// Desired number of outbound IP created/managed by Azure for the cluster load balancer. Allowed values must be in the range
	// of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// A list of public IP prefix resources.
	PublicIPPrefixes []*ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPs - Desired outbound IP resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// A list of public IP resources.
	PublicIPs []*ResourceReference `json:"publicIPs,omitempty"`
}

type ManagedClusterPodIdentity struct {
	// REQUIRED; Information of the user assigned identity.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`

	// REQUIRED; Name of the pod identity.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`

	// READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the pod identity.
	ProvisioningState *ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type ManagedClusterPodIdentityException struct {
	// REQUIRED; Name of the pod identity exception.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`

	// REQUIRED; Pod labels to match.
	PodLabels map[string]*string `json:"podLabels,omitempty"`
}

type ManagedClusterPodIdentityProfile struct {
	// Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// User assigned pod identity settings.
	UserAssignedIdentities []*ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`

	// User assigned pod identity exception settings.
	UserAssignedIdentityExceptions []*ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

type ManagedClusterPodIdentityProvisioningInfo struct {
	// Pod identity assignment error (if any).
	Error *CloudError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// REQUIRED; Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Pool name.
	Name *string `json:"name,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// ManagedClusterProperties - Properties of the managed cluster.
type ManagedClusterProperties struct {
	// Profile of Azure Active Directory configuration.
	AADProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`

	// Access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`

	// Profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles,omitempty"`

	// Properties of the agent pool.
	AgentPoolProfiles []*ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`

	// Profile of auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`

	// DNS prefix specified when creating the managed cluster.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// ResourceId of the disk encryption set to use for enabling encryption at rest.
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`

	// (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th,
	// 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`

	// Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`

	// Identities associated with the cluster.
	IdentityProfile map[string]*ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties `json:"identityProfile,omitempty"`

	// Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`

	// Profile of network configuration.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// Name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// Profile of managed cluster pod identity.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// Profile for Windows VMs in the container service cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`

	// READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty" azure:"ro"`

	// READ-ONLY; Represents the Power State of the cluster
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPropertiesAutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	BalanceSimilarNodeGroups      *string   `json:"balance-similar-node-groups,omitempty"`
	Expander                      *Expander `json:"expander,omitempty"`
	MaxEmptyBulkDelete            *string   `json:"max-empty-bulk-delete,omitempty"`
	MaxGracefulTerminationSec     *string   `json:"max-graceful-termination-sec,omitempty"`
	MaxTotalUnreadyPercentage     *string   `json:"max-total-unready-percentage,omitempty"`
	NewPodScaleUpDelay            *string   `json:"new-pod-scale-up-delay,omitempty"`
	OkTotalUnreadyCount           *string   `json:"ok-total-unready-count,omitempty"`
	ScaleDownDelayAfterAdd        *string   `json:"scale-down-delay-after-add,omitempty"`
	ScaleDownDelayAfterDelete     *string   `json:"scale-down-delay-after-delete,omitempty"`
	ScaleDownDelayAfterFailure    *string   `json:"scale-down-delay-after-failure,omitempty"`
	ScaleDownUnneededTime         *string   `json:"scale-down-unneeded-time,omitempty"`
	ScaleDownUnreadyTime          *string   `json:"scale-down-unready-time,omitempty"`
	ScaleDownUtilizationThreshold *string   `json:"scale-down-utilization-threshold,omitempty"`
	ScanInterval                  *string   `json:"scan-interval,omitempty"`
	SkipNodesWithLocalStorage     *string   `json:"skip-nodes-with-local-storage,omitempty"`
	SkipNodesWithSystemPods       *string   `json:"skip-nodes-with-system-pods,omitempty"`
}

type ManagedClusterSKU struct {
	// Name of a managed cluster SKU.
	Name *ManagedClusterSKUName `json:"name,omitempty"`

	// Tier of a managed cluster SKU.
	Tier *ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClusterServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating
// Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`

	// The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	// REQUIRED; Properties of upgrade profile.
	Properties *ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Id of upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
}

// ManagedClusterWindowsProfile - Profile for Windows VMs in the container service cluster.
type ManagedClusterWindowsProfile struct {
	// REQUIRED; Specifies the name of the administrator account.
	// restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`

	// The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs.
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}

// ManagedClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedClustersClient.BeginCreateOrUpdate
// method.
type ManagedClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginDeleteOptions contains the optional parameters for the ManagedClustersClient.BeginDelete method.
type ManagedClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetAADProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetAADProfile
// method.
type ManagedClustersClientBeginResetAADProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetServicePrincipalProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetServicePrincipalProfile
// method.
type ManagedClustersClientBeginResetServicePrincipalProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRotateClusterCertificatesOptions contains the optional parameters for the ManagedClustersClient.BeginRotateClusterCertificates
// method.
type ManagedClustersClientBeginRotateClusterCertificatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStartOptions contains the optional parameters for the ManagedClustersClient.BeginStart method.
type ManagedClustersClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStopOptions contains the optional parameters for the ManagedClustersClient.BeginStop method.
type ManagedClustersClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginUpdateTagsOptions contains the optional parameters for the ManagedClustersClient.BeginUpdateTags
// method.
type ManagedClustersClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientGetAccessProfileOptions contains the optional parameters for the ManagedClustersClient.GetAccessProfile
// method.
type ManagedClustersClientGetAccessProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetOptions contains the optional parameters for the ManagedClustersClient.Get method.
type ManagedClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetUpgradeProfileOptions contains the optional parameters for the ManagedClustersClient.GetUpgradeProfile
// method.
type ManagedClustersClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListByResourceGroupOptions contains the optional parameters for the ManagedClustersClient.NewListByResourceGroupPager
// method.
type ManagedClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListClusterAdminCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterAdminCredentials
// method.
type ManagedClustersClientListClusterAdminCredentialsOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListClusterMonitoringUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterMonitoringUserCredentials
// method.
type ManagedClustersClientListClusterMonitoringUserCredentialsOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListClusterUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterUserCredentials
// method.
type ManagedClustersClientListClusterUserCredentialsOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListOptions contains the optional parameters for the ManagedClustersClient.NewListPager method.
type ManagedClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// MasterProfile - Profile for the container service master.
type MasterProfile struct {
	// REQUIRED; DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// REQUIRED; Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *Count `json:"count,omitempty"`

	// FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will
	// choose for you based on the orchestrator choice.
	StorageProfile *ContainerServiceStorageProfileTypes `json:"storageProfile,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes
	// service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`

	// The load balancer sku for the managed cluster.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// Network mode used for building Kubernetes network.
	NetworkMode *NetworkMode `json:"networkMode,omitempty"`

	// Network plugin used for building Kubernetes network.
	NetworkPlugin *NetworkPlugin `json:"networkPlugin,omitempty"`

	// Network policy used for building Kubernetes network.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`

	// The outbound (egress) routing method.
	OutboundType *OutboundType `json:"outboundType,omitempty"`

	// A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
}

// OperationListResult - The List Compute Operation operation response.
type OperationListResult struct {
	// READ-ONLY; The list of compute operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// OperationValue - Describes the properties of a Compute Operation value.
type OperationValue struct {
	// Describes the properties of a Compute Operation Value Display.
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Compute Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrchestratorProfile - Contains information about orchestrator.
type OrchestratorProfile struct {
	// REQUIRED; Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty"`
}

// OrchestratorVersionProfile - The profile of an orchestrator and its available versions.
type OrchestratorVersionProfile struct {
	// REQUIRED; Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty"`

	// REQUIRED; Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// Installed by default if version is not specified.
	Default *bool `json:"default,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The list of available upgrade versions.
	Upgrades []*OrchestratorProfile `json:"upgrades,omitempty"`
}

// OrchestratorVersionProfileListResult - The list of versions for supported orchestrators.
type OrchestratorVersionProfileListResult struct {
	// REQUIRED; The properties of an orchestrator version profile.
	Properties *OrchestratorVersionProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Id of the orchestrator version profile list result.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the orchestrator version profile list result.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the orchestrator version profile list result.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OrchestratorVersionProfileProperties - The properties of an orchestrator version profile.
type OrchestratorVersionProfileProperties struct {
	// REQUIRED; List of orchestrator version profiles.
	Orchestrators []*OrchestratorVersionProfile `json:"orchestrators,omitempty"`
}

// PowerState - Describes the Power State of the cluster
type PowerState struct {
	// Tells whether the cluster is Running or Stopped
	Code *Code `json:"code,omitempty"`
}

// PrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs. Either
// secret or keyVaultSecretRef must be specified.
type PrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`

	// Reference to a secret stored in Azure Key Vault.
	KeyVaultSecretRef *KeyVaultSecretRef `json:"keyVaultSecretRef,omitempty"`

	// The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource Id for private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// The collection value.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Update
// method.
type PrivateEndpointConnectionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`

	// The ID of the private link resource.
	ID *string `json:"id,omitempty"`

	// The name of the private link resource.
	Name *string `json:"name,omitempty"`

	// RequiredMembers of the resource
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - A list of private link resources
type PrivateLinkResourcesListResult struct {
	// The collection value.
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *ConnectionStatus `json:"status,omitempty"`
}

// Properties of the container service.
type Properties struct {
	// REQUIRED; Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`

	// REQUIRED; Profile for the container service master.
	MasterProfile *MasterProfile `json:"masterProfile,omitempty"`

	// REQUIRED; Profile for the container service orchestrator.
	OrchestratorProfile *BasicOrchestratorProfile `json:"orchestratorProfile,omitempty"`

	// Properties of the agent pool.
	AgentPoolProfiles []*AgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// Properties to configure a custom container service cluster.
	CustomProfile *CustomProfile `json:"customProfile,omitempty"`

	// Profile for diagnostics in the container service cluster.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs. Exact one of secret
	// or keyVaultSecretRef need to be specified.
	ServicePrincipalProfile *PrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// Profile for Windows VMs in the container service cluster.
	WindowsProfile *WindowsProfile `json:"windowsProfile,omitempty"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ResolvePrivateLinkServiceIDClientPOSTOptions contains the optional parameters for the ResolvePrivateLinkServiceIDClient.POST
// method.
type ResolvePrivateLinkServiceIDClientPOSTOptions struct {
	// placeholder for future optional parameters
}

// Resource - The Resource model definition.
type Resource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceReference - A reference to an Azure resource.
type ResourceReference struct {
	// The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// SSHConfiguration - SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// REQUIRED; The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - Contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// REQUIRED; Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SysctlConfig - Sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`

	// Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`

	// Sysctl setting fs.inotify.maxuserwatches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`

	// Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`

	// Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`

	// Sysctl setting net.core.netdevmaxbacklog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`

	// Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`

	// Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`

	// Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`

	// Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`

	// Sysctl setting net.ipv4.iplocalport_range.
	NetIPv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIPv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIPv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIPv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`

	// Sysctl setting net.ipv4.tcpfintimeout.
	NetIPv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveprobes.
	NetIPv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepalivetime.
	NetIPv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxsyn_backlog.
	NetIPv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxtw_buckets.
	NetIPv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`

	// Sysctl setting net.ipv4.tcp_rmem.
	NetIPv4TCPRmem *int32 `json:"netIpv4TcpRmem,omitempty"`

	// Sysctl setting net.ipv4.tcptwreuse.
	NetIPv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`

	// Sysctl setting net.ipv4.tcp_wmem.
	NetIPv4TCPWmem *int32 `json:"netIpv4TcpWmem,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveintvl.
	NetIPv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackbuckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackmax.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`

	// Sysctl setting vm.maxmapcount.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`

	// Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`

	// Sysctl setting vm.vfscachepressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

type UserAssignedIdentity struct {
	// The client id of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object id of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// VMDiagnostics - Profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// REQUIRED; Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`

	// READ-ONLY; The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty" azure:"ro"`
}

// WindowsProfile - Profile for Windows VMs in the container service cluster.
type WindowsProfile struct {
	// REQUIRED; The administrator password to use for Windows VMs.
	AdminPassword *string `json:"adminPassword,omitempty"`

	// REQUIRED; The administrator username to use for Windows VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
}
