!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeedit_put
  use cubetools_parameters
  use cubetools_structure
  use cubeedit_messaging
  use cubeheader_edit_tool
  use cubeedit_putdata
  !
  public :: put
  private
  !
  type :: put_comm_t
     type(option_t), pointer :: comm
     type(edit_comm_t)       :: head
     type(putdata_comm_t)    :: data
   contains
     procedure, public  :: register => cubeedit_put_comm_register
     procedure, private :: parse    => cubeedit_put_comm_parse
     procedure, private :: main     => cubeedit_put_comm_main 
  end type put_comm_t
  type(put_comm_t) :: put
  !
  type put_user_t
     character(len=varn_l) :: edid
     type(edit_user_t)     :: head
     type(putdata_user_t)  :: data
  end type put_user_t
  !
contains
  !
  subroutine cubeedit_put_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command PUT
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(put_user_t) :: user
    character(len=*), parameter :: rname='PUT>COMMAND'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call put%parse(line,user,error)
    if (error) return
    call put%main(user,error)
    if (error) return
  end subroutine cubeedit_put_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeedit_put_comm_register(comm,error)
    use cubedag_parameters
    !-------------------------------------------------------------------
    ! Register EDIT\PUT and its options
    !-------------------------------------------------------------------
    class(put_comm_t), intent(inout) :: comm
    logical,           intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: rname='PUT>COMM>REGISTER'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'PUT','[editedid]',&
         'Update header or data information for an edited cube',&
         'WARNING: there are no checks on the data or header&
         & modifications being done, proceed with care. If the header&
         & needs to be modified ina coherent way, please refer to&
         & command CUBE\MODIFY',&
         cubeedit_put_command,&
         comm%comm,&
         error)
    if (error) return
    call stdarg%register(&
         'editedid',&
         'Indentifier of the edited cube',&
         strg_id,&
         code_arg_optional,&
         error)
    if (error) return
    !
    call comm%head%register(error)
    if (error) return
    call comm%data%register(error)
    if (error) return
  end subroutine cubeedit_put_comm_register
  !
  subroutine cubeedit_put_comm_parse(comm,line,user,error)
    !-------------------------------------------------------------------
    ! Parse routine for command PUT
    !-------------------------------------------------------------------
    class(put_comm_t), intent(in)    :: comm
    character(len=*),  intent(in)    :: line
    type(put_user_t),  intent(out)   :: user
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='PUT>COMM>PARSE'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    user%edid = strg_star
    call cubetools_getarg(line,comm%comm,1,user%edid,.not.mandatory,error)
    if (error) return
    !
    call comm%head%parse(line,user%head,error)
    if (error) return
    call comm%data%parse(line,user%data,error)
    if (error) return
  end subroutine cubeedit_put_comm_parse
  !
  subroutine cubeedit_put_comm_main(comm,user,error)
    use cube_types
    use cubeedit_opened_types
    !-------------------------------------------------------------------
    ! Main routine for command PUT
    !-------------------------------------------------------------------
    class(put_comm_t), intent(in)    :: comm
    type(put_user_t),  intent(in)    :: user
    logical,           intent(inout) :: error
    !
    type(cube_t), pointer :: cube
    integer(kind=entr_k) :: ie
    character(len=*), parameter :: rname='PUT>COMM>MAIN'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call opened%get_cube_pointer(user%edid,cube,error)
    if (error) return
    !
    call put%head%main(user%head,cube%head,error)
    if (error) return
    call opened%get_cube_entry(user%edid,ie,error)
    if (error) return   
    call put%data%main(user%data,cube,ie,error)
    if (error) return
    call opened%set_cube_entry(user%edid,ie,error)
    if (error) return   
  end subroutine cubeedit_put_comm_main
end module cubeedit_put
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
