#include <string>
#include <vector>
#include <iostream>
using namespace std;
#include "ATMType.h"
#include "ATMTypeName.h"

namespace atm {
  
  // Constructors
  AtmType::AtmType(){  }  //type_ = type_default_;}
  AtmType::AtmType(Atmospheretype type):
    type_(type)
  {

    int    typ;
    int    xsize=20;
    
    typ = type_;
    if(type_==1){
      prLimit_=230.0;
    }else if(type_==2){
      prLimit_=198.0;
    }else if(type_==3){
      prLimit_=300.0;
    }else if(type_==4){
      prLimit_=311.0;
    }else if(type_==5){
      prLimit_=332.0;
    }
    
    //  cout << "in AtmType prLimit_=" <<  prLimit_ << endl;


    static const double hx[20]={ 9.225,10.225,11.225,12.850,14.850,16.850,18.850,
				 22.600,26.600,30.600,34.850,40.850,46.850,52.850,
				 58.850,65.100,73.100,81.100,89.100,95.600};


    static const double px[5][20]={
      {0.3190E+03,0.2768E+03,0.2391E+03,0.1864E+03,0.1354E+03,0.9613E+02,
       0.6833E+02,0.3726E+02,0.2023E+02,0.1121E+02,0.6142E+01,0.2732E+01,
       0.1260E+01,0.6042E+00,0.2798E+00,0.1202E+00,0.3600E-01,0.9162E-02,
       0.2076E-02,0.6374E-03},
      {0.3139E+03,0.2721E+03,0.2350E+03,0.1833E+03,0.1332E+03,0.9726E+02,
       0.7115E+02,0.3992E+02,0.2185E+02,0.1216E+02,0.6680E+01,0.2985E+01,
       0.1400E+01,0.6780E+00,0.3178E+00,0.1380E+00,0.4163E-01,0.9881E-02,
       0.2010E-02,0.5804E-03},
      {0.2892E+03,0.2480E+03,0.2124E+03,0.1649E+03,0.1206E+03,0.8816E+02,
       0.6433E+02,0.3558E+02,0.1901E+02,0.1014E+02,0.5316E+01,0.2255E+01,
       0.1022E+01,0.4814E+00,0.2206E+00,0.9455E-01,0.3000E-01,0.8729E-02,
       0.2332E-02,0.8164E-03},
      {0.3006E+03,0.2587E+03,0.2223E+03,0.1739E+03,0.1288E+03,0.9495E+02,
       0.7018E+02,0.3983E+02,0.2199E+02,0.1232E+02,0.6771E+01,0.3056E+01,
       0.1452E+01,0.7051E+00,0.3353E+00,0.1459E+00,0.4431E-01,0.1024E-01,
       0.1985E-02,0.5627E-03},
      {0.2731E+03,0.2335E+03,0.1995E+03,0.1546E+03,0.1130E+03,0.8252E+02,
       0.6017E+02,0.3314E+02,0.1751E+02,0.9306E+01,0.4826E+01,0.1988E+01,
       0.8645E+00,0.4000E+00,0.1819E+00,0.7866E-01,0.2639E-01,0.8264E-02,
       0.2364E-02,0.8439E-03}};

    static const double tx[5][20]={
      {0.2421E+03,0.2354E+03,0.2286E+03,0.2180E+03,0.2046E+03,
       0.1951E+03,0.2021E+03,0.2160E+03,0.2250E+03,0.2336E+03,
       0.2428E+03,0.2558E+03,0.2686E+03,0.2667E+03,0.2560E+03,
       0.2357E+03,0.2083E+03,0.1826E+03,0.1767E+03,0.1841E+03},
      {0.2403E+03,0.2338E+03,0.2273E+03,0.2167E+03,0.2157E+03, 
       0.2157E+03,0.2177E+03,0.2223E+03,0.2271E+03,0.2349E+03, 
       0.2448E+03,0.2596E+03,0.2740E+03,0.2727E+03,0.2603E+03, 
       0.2394E+03,0.2045E+03,0.1715E+03,0.1644E+03,0.1785E+03}, 
      {0.2239E+03,0.2196E+03,0.2191E+03,0.2183E+03,0.2173E+03,
       0.2163E+03,0.2153E+03,0.2152E+03,0.2152E+03,0.2178E+03,
       0.2275E+03,0.2458E+03,0.2637E+03,0.2633E+03,0.2531E+03,
       0.2407E+03,0.2243E+03,0.2072E+03,0.1991E+03,0.2091E+03},
      {0.2301E+03,0.2252E+03,0.2252E+03,0.2252E+03,0.2252E+03,
       0.2252E+03,0.2252E+03,0.2252E+03,0.2298E+03,0.2361E+03, 
       0.2468E+03,0.2648E+03,0.2756E+03,0.2763E+03,0.2662E+03,
       0.2392E+03,0.2023E+03,0.1681E+03,0.1609E+03,0.1770E+03},
      {0.2172E+03,0.2172E+03,0.2172E+03,0.2172E+03,0.2172E+03,
       0.2161E+03,0.2149E+03,0.2126E+03,0.2127E+03,0.2165E+03,
       0.2222E+03,0.2368E+03,0.2516E+03,0.2601E+03,0.2523E+03,
       0.2486E+03,0.2388E+03,0.2215E+03,0.2033E+03,0.2113E+03}};
    
    v_hx_.reserve(xsize);
    v_px_.reserve(xsize);
    v_tx_.reserve(xsize);
    for(int i=0; i<xsize; i++){
      v_hx_.push_back(hx[i]);
      v_px_.push_back(px[typ-1][i]);
      v_tx_.push_back(tx[typ-1][i]);
    }
  }
  AtmType::~AtmType(){}
  
  string          AtmType::getAtmosphereType(){
    return AtmosphereType::name(type_);
  }
  Atmospheretype  AtmType::getAtmospheretype(){return type_;}
  
  string  AtmosphereType::name(int n){
    if(n>4)return "";
    return type_[n];
  }
  
  string  AtmosphereType::name(Atmospheretype n){
    return type_[n-1];
  }
  
}


