module cfitsio_status
  use cfitsio_interfaces
  use cfitsio_messaging
  !---------------------------------------------------------------------
  ! Routines to manage CFITSIO status codes
  !---------------------------------------------------------------------
  !
  public :: cfitsio_errormsg
  private
  !
contains
  !
  subroutine cfitsio_errormsg(status)
    !---------------------------------------------------------------------
    ! Print the CFITSIO error message given the error status. Should
    ! probably be public.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: status
    ! Local
    character(len=*), parameter :: rname='CFITSIO'
    character(len=message_length) :: mess
    !
    call ftgerr(status,mess)
    !
    if (status.eq.0) then
      call cfitsio_message(seve%i,rname,mess)
    else
      call cfitsio_message(seve%e,rname,mess)
    endif
  end subroutine cfitsio_errormsg
  !
  subroutine cfitsio_translate_status(status,msg)
    !---------------------------------------------------------------------
    ! Convert a CFITSIO error status into an error string
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in)  :: status
    character(len=*), intent(out) :: msg
    !
    select case (status)
    case (0)
        msg = 'OK, no error'
    case (101)
        msg = 'Input and output files are the same'
    case (103)
        msg = 'Tried to open too many FITS files at once'
    case (104)
        msg = 'Could not open the named file'
    case (105)
        msg = 'Could not create the named file'
    case (106)
        msg = 'Error writing to FITS file'
    case (107)
        msg = 'Tried to move past end of file'
    case (108)
        msg = 'Error reading from FITS file'
    case (110)
        msg = 'Could not close the file'
    case (111)
        msg = 'Array dimensions exceed internal limit'
    case (112)
        msg = 'Cannot write to readonly file'
    case (113)
        msg = 'Could not allocate memory'
    case (114)
        msg = 'Invalid fitsfile pointer'
    case (115)
        msg = 'NULL input pointer to routine'
    case (116)
        msg = 'Error seeking position in file'
    !
    case (121)
        msg = 'Invalid URL prefix on file name'
    case (122)
        msg = 'Tried to register too many IO drivers'
    case (123)
        msg = 'Driver initialization failed'
    case (124)
        msg = 'Matching driver is not registered'
    case (125)
        msg = 'Failed to parse input file URL'
    !
    case (151)
        msg = 'Bad argument in shared memory driver'
    case (152)
        msg = 'Null pointer passed as an argument'
    case (153)
        msg = 'No more free shared memory handles'
    case (154)
        msg = 'Shared memory driver is not initialized'
    case (155)
        msg = 'IPC error returned by a system call'
    case (156)
        msg = 'No memory in shared memory driver'
    case (157)
        msg = 'Resource deadlock would occur'
    case (158)
        msg = 'Attempt to open/create lock file failed'
    case (159)
        msg = 'Shared memory block cannot be resized at the moment'
    !
    case (201)
        msg = 'Header already contains keywords'
    case (202)
        msg = 'Keyword not found in header'
    case (203)
        msg = 'Keyword record number is out of bounds'
    case (204)
        msg = 'Keyword value field is blank'
    case (205)
        msg = 'String is missing the closing quote'
    case (207)
        msg = 'Illegal character in keyword name or card'
    case (208)
        msg = 'Required keywords out of order'
    case (209)
        msg = 'Keyword value is not a positive integer'
    case (210)
        msg = 'Couldn''t find END keyword'
    case (211)
        msg = 'Illegal BITPIX keyword value'
    case (212)
        msg = 'Illegal NAXIS keyword value'
    case (213)
        msg = 'Illegal NAXISn keyword value'
    case (214)
        msg = 'Illegal PCOUNT keyword value'
    case (215)
        msg = 'Illegal GCOUNT keyword value'
    case (216)
        msg = 'Illegal TFIELDS keyword value'
    case (217)
        msg = 'Negative table row size'
    case (218)
        msg = 'Negative number of rows in table'
    case (219)
        msg = 'Column with this name not found in table'
    case (220)
        msg = 'Illegal value of SIMPLE keyword'
    case (221)
        msg = 'Primary array doesn''t start with SIMPLE'
    case (222)
        msg = 'Second keyword not BITPIX'
    case (223)
        msg = 'Third keyword not NAXIS'
    case (224)
        msg = 'Couldn''t find all the NAXISn keywords'
    case (225)
        msg = 'HDU doesn''t start with XTENSION keyword'
    case (226)
        msg = 'The CHDU is not an ASCII table extension'
    case (227)
        msg = 'The CHDU is not a binary table extension'
    case (228)
        msg = 'Couldn''t find PCOUNT keyword'
    case (229)
        msg = 'Couldn''t find GCOUNT keyword'
    case (230)
        msg = 'Couldn''t find TFIELDS keyword'
    case (231)
        msg = 'Couldn''t find TBCOLn keyword'
    case (232)
        msg = 'Couldn''t find TFORMn keyword'
    case (233)
        msg = 'The CHDU is not an IMAGE extension'
    case (234)
        msg = 'TBCOLn keyword value < 0 or > rowlength'
    case (235)
        msg = 'The CHDU is not a table'
    case (236)
        msg = 'Column is too wide to fit in table'
    case (237)
        msg = 'More than 1 column name matches template'
    case (241)
        msg = 'Sum of column widths not = NAXIS1'
    case (251)
        msg = 'Unrecognizable FITS extension type'
    case (252)
        msg = 'Unknown record; 1st keyword not SIMPLE or XTENSION'
    case (253)
        msg = 'END keyword is not blank'
    case (254)
        msg = 'Header fill area contains non-blank chars'
    case (255)
        msg = 'Illegal data fill bytes (not zero or blank)'
    case (261)
        msg = 'Illegal TFORM format code'
    case (262)
        msg = 'Unrecognizable TFORM datatype code'
    case (263)
        msg = 'Illegal TDIMn keyword value'
    case (264)
        msg = 'Invalid BINTABLE heap pointer is out of range'
    !
    case (301)
        msg = 'HDU number < 1 or > MAXHDU'
    case (302)
        msg = 'Column number < 1 or > tfields'
    case (304)
        msg = 'Tried to move to negative byte location in file'
    case (306)
        msg = 'Tried to read or write negative number of bytes'
    case (307)
        msg = 'Illegal starting row number in table'
    case (308)
        msg = 'Illegal starting element number in vector'
    case (309)
        msg = 'This is not an ASCII string column'
    case (310)
        msg = 'This is not a logical datatype column'
    case (311)
        msg = 'ASCII table column has wrong format'
    case (312)
        msg = 'Binary table column has wrong format'
    case (314)
        msg = 'Null value has not been defined'
    case (317)
        msg = 'This is not a variable length column'
    case (320)
        msg = 'Illegal number of dimensions in array'
    case (321)
        msg = 'First pixel number greater than last pixel'
    case (322)
        msg = 'Illegal BSCALE or TSCALn keyword = 0'
    case (323)
        msg = 'Illegal axis length < 1'
    !
    case (340:350)
        msg = 'Grouping function error'
    !
    case (360)
        msg = 'Malloc failed'
    case (361)
        msg = 'Read error from file'
    case (362)
        msg = 'Null pointer passed as an argument. Passing null pointer as a name of template file raises this error'
    case (363)
        msg = 'Line read seems to be empty (used internally)'
    case (364)
        msg = 'Cannot unread more then 1 line (or single line twice)'
    case (365)
        msg = 'Too deep include file nesting (infinite loop, template includes itself ?)'
    case (366)
        msg = 'Fopen() failed, cannot open template file'
    case (367)
        msg = 'End of file encountered and not expected'
    case (368)
        msg = 'Bad arguments passed. Usually means internal parser error. Should not happen'
    case (369)
        msg = 'Token not expected here'
    !
    case (401)
        msg = 'Bad int to formatted string conversion'
    case (402)
        msg = 'Bad float to formatted string conversion'
    case (403)
        msg = 'Can''t interpret keyword value as integer'
    case (404)
        msg = 'Can''t interpret keyword value as logical'
    case (405)
        msg = 'Can''t interpret keyword value as float'
    case (406)
        msg = 'Can''t interpret keyword value as double'
    case (407)
        msg = 'Bad formatted string to int conversion'
    case (408)
        msg = 'Bad formatted string to float conversion'
    case (409)
        msg = 'Bad formatted string to double conversion'
    case (410)
        msg = 'Illegal datatype code value'
    case (411)
        msg = 'Bad number of decimal places specified'
    case (412)
        msg = 'Overflow during datatype conversion'
    case (413)
        msg = 'Error compressing image'
    case (414)
        msg = 'Error uncompressing image'
    !
    case (420)
        msg = 'Error in date or time conversion'
    !
    case (431)
        msg = 'Syntax error in parser expression'
    case (432)
        msg = 'Expression did not evaluate to desired type'
    case (433)
        msg = 'Vector result too large to return in array'
    case (434)
        msg = 'Data parser failed not sent an out column'
    case (435)
        msg = 'Bad data encounter while parsing column'
    case (436)
        msg = 'Output file not of proper type'
    !
    case (501)
        msg = 'Celestial angle too large for projection'
    case (502)
        msg = 'Bad celestial coordinate or pixel value'
    case (503)
        msg = 'Error in celestial coordinate calculation'
    case (504)
        msg = 'Unsupported type of celestial projection'
    case (505)
        msg = 'Celestial coordinate keywords not found'
    case (506)
        msg = 'Approximate wcs keyword values were returned'
    !
    case default
        msg = 'Unknown error status'
    end select
  end subroutine cfitsio_translate_status
end module cfitsio_status
