!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Routines to manage GCFITSIO messages
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cfitsio_messaging
  use gbl_message
  use gpack_def
  !
  public :: cfitsio_message_set_id
  public :: cfitsio_message
  public :: seve,message_length  ! For convenience
  private  
  !
  ! Identifier used for message identification.
  integer :: cfitsio_message_id = gpack_global_id  ! Default value for startup message
  !
contains
  !
  subroutine cfitsio_message_set_id(id)
    !---------------------------------------------------------------------
    ! Alter library id into input id. Should be called by the library
    ! which wants to share its id with the current one.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: id
    ! Local
    character(len=message_length) :: mess
    !
    cfitsio_message_id = id
    !
    write (mess,'(A,I3)') 'Now use id #',cfitsio_message_id
    call cfitsio_message(seve%d,'cfitsio_message_set_id',mess)
  end subroutine cfitsio_message_set_id
  !
  subroutine cfitsio_message(mkind,procname,message)
    !---------------------------------------------------------------------
    ! @ private
    ! Messaging facility for the current library. Calls the low-level
    ! (internal) messaging routine with its own identifier.
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in) :: mkind     ! Message kind
    character(len=*), intent(in) :: procname  ! Name of calling procedure
    character(len=*), intent(in) :: message   ! Message string
    !
    call gmessage_write(cfitsio_message_id,mkind,procname,message)
  end subroutine cfitsio_message
end module cfitsio_messaging
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
