# GILDAS Syntax Highlighting

This extension provides TextMate grammars and language configuration
for GILDAS scripting languages.

## Supported programs

- SIC (`.sic`, `.pro`)
- GREG (`.greg`)
- ASTRO (`.astro`)
- CUBE (`.cube`)
- CLASS (`.class`, `.class77`)
- MRTCAL (`.cal`)
- CLIC (`.clic`)
- MAPPING (`.map`)
- MRTHOLO (`.holo`)

## Features

- Syntax highlighting for commands, keywords, operators, and built-in
  functions.
- Language prefixes (e.g., `SIC\`, `GREG1\`, `ASTRO\`) are recognized.
- Abbreviated commands (3+ letters) are supported.
- Comment lines use `!`.
- Folding/indent rules for `FOR` / `NEXT`, in addition to the usual
  `IF` and `BEGIN` / `END` blocks.

## Install locally in VS Code

1. In VS Code, run **Extensions: Install from Location...**
2. Select the folder `.../gildas-src-xxx/admin/syntax/TextMate`
3. Reload the window when prompted

## Notes

- Command matching is anchored to the start of a line and requires a
  space (or end-of-line) after the command.
- Continuation lines with trailing `-` are not parsed as a single
  logical line; highlighting is line-based.
