# GILDAS older news
_J. Pety & S. Bardeau, 18-may-2021_

Each section of these NEWS indicates the main changes between two monthly
releases. The section title is also the name of the monthly release where
all prior changes are incorporated.

## May21b

- Kernel (SIC and GREG)
    - The DEFINE FITS command was crashing when encountering HDUs with
      NAXIS=0.
    - The UVFITS reader (used in particular by procedure @
      fits_to_uvt) was raising a random error when GILDAS was compiled
      with the gfortran compiler.

- MAPPING
    - The UV_FILTER command was not filtering the last channel of the
      table when requested. This is fixed now.

## May21a

Not yet documented.

## Jul19b

- CLASS
    - Fixed reading observations when compiled with gfortran 9.1.0.

## Jul19a

Not yet documented.

## Jun19b

- MAPPING
    - The procedure "go uvextract" is fixed to use the new command
      UV_EXTRACT.

## Jun19a

Not yet documented.

## May19a

Not yet documented.

## Apr19a

Not yet documented.

## Mar19b

- Kernel (SIC and GREG)
   - The FITS filler now recognizes the SFL projection.
   - The new URLs to the CDMS classic database are now implemented in
     LINEDB/WEEDS.

- CLIC
   - Introduce the new three-digit identification for the correlator
     line units.

## Mar19a

Not yet documented.

## Feb19b

- Kernel (SIC and GREG)
   - The task RUN FIELD_STAT works again.

- ASTRO
   - The sensitivity estimator has been updated for the Summer 2019
     call for proposals.

- MAPPING
   - Command UVMAP was not behaving correctly when dealing with a
     limited range of channels (non-zero FIRST and LAST variables).
     This is fixed now.
   - The new command UV_FILTER is fixed when giving a width in
     frequency (option /WIDTH)
   - The new command UV_EXTRACT was not dealing correctly with the
     trailing columns in UV tables. This is fixed now.

## Feb19a

Not yet documented.

## Jan19b

- Kernel (SIC and GREG) + CLASS
   - LINEDB/WEEDS are fixed to support the new URLs to access the CDMS
     online database.

- MAPPING
   - Task UV_MERGE is fixed after transient bug introduced in
     jan18a. It is now able to correct for a given spectral index when
     merging two continuum uv tables. This can be used, e.g., to
     combine the continuum uv tables from the LSB and USB bands of
     NOEMA.
   - FIELDS is not anymore a valid keyword for command READ, and READ
     * will not try anymore to READ FIELDS. This fixes "go clean" on
     mosaics which invokes READ * but was stopping with error because
     READ FIELDS was enabled by the presence of a .fields file. WRITE
     FIELDS (and WRITE *) is still supported to save this information
     in a .fields file (for mosaics). This behavior is based on the
     fact that internally MAPPING needs a transposed version of the
     FIELDS file that is known as the PRIMARY buffer (file extension
     .lobe) while the visualization of the mosaic primary beams is
     easier with the ordering found inside the FIELDS file.

## Jan19a

Not yet documented.

## Dec18

Not yet documented.

## Oct18b

- Kernel (SIC and GREG)
   - Fixed execution error of tasks (and others) under MS Windows.
   - SIC\MFIT: default steps are reverted to their original defaults,
     fixing in particular the MFIT demo.

- CLIC
   - Fixed command TABLE /MOSAIC

## Oct18a

Not yet documented.

## Sep18

Not yet documented.

## Aug18b

- ASTRO
   - The NOEMA time-sensitivity estimator is fixed for the mosaic case.

## Aug18

Not yet documented.

## Jul18

Not yet documented.

## Jun18c

- CLIC
   - Fixed command TABLE for pre-POLYFIX data.

## Jun18a

Not yet documented.

## May18

Not yet documented.

## Apr18

No release.

## Mar18c

- ASTRO
   - Updated IF range in Band 6 to match ALMA Cycle 6 call for
     proposal.

## Mar18b

- ASTRO
   - Fixed bug in the time/sensitivity estimator (mosaic mode)

## Mar18a

Not yet documented.

## Feb18d

- ASTRO
   - Fixed bug in the time/sensitivity estimator (mosaic mode)

## Feb18c

- ASTRO
   - Fixed bug in the proposal setup commands.

## Feb18b

- ASTRO
   - Updated for next call for proposals.

## Feb18a

Not yet documented.

## Jan18

No release.

## Dec17a

Not yet documented.

## Nov17b

- Kernel (SIC and GREG)
    - A bug which was preventing to allocate memory in the task
      REPROJECT was fixed.

- CLASS
    - MINIMIZE command does not enforce anymore a baseline to be
      previously removed in case of the ABSORPTION method, as this
      method also fits the continuum level.
    - Setting initial guesses with the command LINES is now fixed for
      method ABSORPTION. The guess on line width was not correctly
      read, leading to further error regarding initial guess at the
      start of minimization.

- MAPPING
    - The task UV_FMODEL is improved to support images larger than
      4096x4096 pixels.

## Nov17a

Not yet documented.

## Oct17a

Not yet documented.

## Sep17a

Not yet documented.

## Aug17a

No release.

## Jul17c

- ASTRO
    - Updated for next call for proposals.

## Jul17b

- MAPPING
    - Fixed bug in OpenMP mode when dealing with mosaics.

## Jul17a

Not yet documented.

## Jun17

No release.

- CLASS
    - Class documentation promises that the hyperfine ratios can be
      described with a fraction (i.e., a math formula) but it was not
      working. This has been implemented. Nevertheless the delivered
      opacities are not identical depending on the shape of the input for
      the HFS relative weights. This of course means that something is
      incorrect.
    - The table output of the XPOL package was upgraded to deliver
      additional generic data about the observations (UTC, telescope,
      azimuth, etc...).

## May17c

- MAPPING
    - The short-spacing widget should work again. The problem came
      from the fact that CLIC is producing a uvt table with the scan
      number as 3rd column while UV_SHORT is producing a default uvt
      table with W as 3rd column type (even though W is not computed
      by UV_SHORT).

## May17b

- MRTCAL
    - Default is now to interpolate the nearest OFF subscans when
      calibrating an On-The-Fly scan.

## May17a

Incompletely documented.

- MRTCAL
   - The MRTCAL OdP is now able to handle pool sessions.
   - INDEX BUILD and INDEX UPDATE now address the very particular case when
     files appear during the index process. In this case, the buffer size
     (though automatic) may appear to be too small to actually index all
     the files found.
   - SPLINE interpolation of the calibration parameters as a function of
     frequency was implemented in addition to the standard linear
     interpolation.
   - A chapter describing the IMBFITS format used in MRTCAL was added in
     the developer documentation.

- CLASS
   - "SPECTRUM Yoffset" was bugged following the implementation of
     associated arrays. This is now fixed.
   - Mollweide and Norh Celestial Pole projections were added.

## Apr17

No release.

- ASTRO
   - Changing the observatory through the OBSERVATORY command now
     automatically recomputes for the last recorded UT the matrices
     required to compute coordinate transformations. This implies that when
     changing the OBSERVATORY, the user will not receive anymore the
     message:
       I*OBSERVATORY,  Time needs to be reset
     Else than this, this update should be transparent to end users.

- MRTCAL
   - The doppler correction (at least for OTF scans) is computed only at
     start of the scan and only for the direction of the projection
     center. The CLASS command MODIFY VDIRECTION is fixing the correction
     to the actual telescope direction. This makes consistent the spectral
     axis of OTF scans observed 6 months apart. MRTCAL now is able to make
     this correction at calibration time with the MSET OUTPUT VDIRECTION
     YES|NO tuning. The current implementation slows down
     the calibration time by about 50%. There are solutions to solve the
     speed issue but this requires work. It thus won't happen now.

- CLASS
   - The [/WEIGHT TIME|SIGMA|EQUAL|ASSOCIATED] keyword was added to the
     AVERAGE, STITCH, ... commands to allow the user to temporarily
     override the SET WEIGHT global behavior.
   - MODIFY BEAM_EFF /RUZE now computes the frequency dependency on the
     RUZE formula using the frequencies in the observatory frame. Before it
     was done on frequencies computed in the source frame.

## Mar17

No release.

- TELCAL
    - In case of submillimeter winter conditions, solving for the
      atmospheric water vapor amount was trying to search for negative
      amount. This causes ATM2009 (even worse for ATM2016) to deliver NaN,
      leading to blanked part in the spectra. This was fixed by forbidding
      the exploration of negative amount of water.

## Feb17d

- MRTCAL
    - MRTCAL was put in production at Pico Veleta on Feb. 14th, 2017.
    - MRTCAL is a new software to calibrate the 30m spectroscopic data will
      be delivered beginning of 2017. It will progressively replace MIRA.
    - Progresses are done on the comparison between MIRA and MRTCAL in
      order to completely understand the origin of the small
      discrepancies. A memo is being written.
    - The new calibration scheme for frequency switched spectra was
      implemented early February following section 4 of Winkel 2012
      http://cdsads.u-strasbg.fr/abs/2012A%26A...540A.140W

- MIRA
    - MIRA is now able to process symmetrical ONOFF for continuum backends.
    - Plotting procedures were failing because they called DRAW RELOATE
      instead of DRAW RELOCATE and GREG was made more strict on this point
      at end of 2016. This is now fixed.

- CLASS
    - The doppler correction (at least for OTF scans) is computed only at
      start of the scan and only for the direction of the projection center
      (SOURCE coordinates). The command MODIFY VDIRECTION is fixing the
      correction to the actual telescope direction. This makes consistent
      the spectral axis of OTF scans observed 6 months apart.

## Feb17d

Incompletely documented.

- ASTRO
    - The command UV_TRACKS was inversing shadowed vs shadowing
      antennas. This is now fixed.

- MAPPING
    - The ALMA cycle 5 configurations files were added for use in the ALMA
      simulator.

## Feb17c

Incompletely documented.

- ASTRO
    - The default observatory in the GILDAS distribution was swapped from
      PdBI to NOEMA.
    - The LINE command was obsolete but still present in the PICO
      language. It has been be removed. The users should use the EMIR
      command.
    - The ASTRO manual now points to the tutorial available on the web as
      long as a more formal description is available.
    - Some commands (eg, BACKEND) now also give the associated command
      (eg, EMIR) when they state that the user should first
      set a tuning frequency.

- MRTCAL
    - The HOT/COLD/SKY calibration was fixed in case of very low water
      vapour amount.

## Feb17b

Incompletely documented.

- ASTRO
    - POLYFIX setups for NOEMA uploaded in PMS were fixed.

## Feb17a

Incompletely documented.

- ASTRO
    - The size of the planets were updated to the most recent recommanded
      values by IAU.

## Jan17

Incompletely documented.

- CLASS
   - The frequency offset (R%HEAD%SPE%FOFF) is now removed from the
     spectroscopic section in memory (data format on disk not yet
     modified). Associated Sic variables and API also removed. If a
     non-zero offset is found in the section on disk at read time, the
     section is patched with a warning to reproduce the effect of the
     offset. This change will appear in the feb17 version of GILDAS.
     A memo describing this change is being prepared.
   - We added the velocity convention code in observation spectroscopic
     structure (R%HEAD%SPE%VCONV) in memory only. This element is NOT YET
     in the data format (on disk). Supported codes are optical, radio, and
     30m (which is different from the 2 others). At read time, when reading
     old and current data format, convention defaults to 30m for 30M
     observations (i.e., the doppler tracking is done with the optical
     convention, but the interpretation of the data in CLASS assumes the
     radio convention), and to unknown for other telescopes. In a near
     future, routines and commands to swap from the 30m convention to the
     full radio convention will be added.
   - "MODIFY BEAM_EFF /RUZE B0 Sigma" was modified so that B0 and Sigma can
     be omitted for 30m observations after 01-APR-2009 (roughly EMIR
     installation). In this case, default values measured at the 30m will
     be displayed and used.
   - An experimental command "BASE NEWSINUS Constant Period Amplitude" was
     added.  This command computes an analytic solution (least squares)
     without minimization. It fits the sum of a constant continuum (first
     parameter (* means that this parameter is free) and a sinusoidal
     function defined by Period and Amplitude (* means that these are free
     parameters). Right now the period must be fixed by the users. More
     work is needed to define the optimum period. The medium term goal is
     to replace the current BASE SINUS command that has difficulties to
     achieve its goal.

## Dec16b

Incompletely documented.

- MAPPING
    - Fixed compilation under 32 bits machines.

## Dec16a

Incompletely documented.

## Nov16b

Incompletely documented.

- Kernel (SIC and GREG)
    - Fixed a bug which precluded the correct of commands from the
      widgets.

- CLIC
    - STORE FLAG [FlagName] /RESET was resetting not only [FlagName]
      but all flags (spectral flags included), i.e. any previous flag
      that was stored in the .hpb file would be resetted. This is
      fixed now.

## Nov16a

Incompletely documented.

- ASTRO
   - Jeremie Boissier is now officially in charge of the ASTRO
     package.
   - The PLANET command used as input variable the BEAM SIC variable. The
     recent introduction in MAPPING of the BEAM SIC buffer to store the
     primary beam precluded the import of ASTRO. So the BEAM variable of
     ASTRO was removed and the syntax of the PLANET command was enriched
     with the "/BEAM value" option.
   - The syntax of the "SET LINES" command was simplified in order to
     enable to change the type of plot (straight lines, Gaussians, boxcar,
     etc...)  and the width in a single line. See "HELP SET LINES" for
     details.
   - "SET FREQUENCY MainAxis SecondAxis" allows the user to compare
     frequency axes when setting up EMIR. In particular, it enables to
     compare the source frame and the LSR frame, a feature extremely useful
     for high redshift targets. See "HELP SET FREQ" for details.

- CLASS
   - The TABLE command now allows one to write the spectra exactly in the
     source frame. Before there were a 2nd order approximation when the
     spectra in the current index were consistent, i.e., in this case, the
     doppler factor was not applied to the width of the channel (so the
     spectra was exactly in the source frame only for the LO-tracked
     frequency).
   - An experimental DIFF command was introduced to report differences
     between two observation headers.

## Oct16

Incompletely documented.

## Sep16b

Incompletely documented.

- Kernel (SIC and GREG)
    - The command PEN /COLOUR now accepts a large number of predefined
      colour names as argument. Type PEN /COLOUR ? for the exhaustive
      list or execute demonstration procedure:
        GREG> @ gag_demo:demo-pencolors.greg

- ASTRO
    - In the prospect of the delivery of POLYFIX, the NOEMA
      correlator, a new set of commands have been implemented in the
      NOEMA\ language (activated by command OBSERVATORY NOEMA) to
      prepare and visualize frequency setups:
        TUNING
        BASEBAND
        SPW
        PLOT
      These take into account the available frequency limits and
      correlator modes, and plot the covered frequency ranges together
      with known spectral lines, taking into account source velocities
      or redshifts. This new functionality is still under development
      and is likely to be upgraded in the future.
    - PLANET command: the SIC variables BEAM (custom beam, input) and
      PRIMBEAM (actual beam, output) are removed. Setting the input
      beam is now done with the /BEAM option. The output beam is
      available in the variable ASTRO%PLANET%BEAM.

## Sep16a

Incompletely documented.

- CLASS
    - The internal code of XY_MAP was refurbished to ensure that datasets
      larger than the available RAM memory can be processed by slicing the
      data in intervals of frequency. The command is now also able to read
      transposed input XY tables and/or to write transposed output VLM
      cubes. The latter feature is useful to easily reimport data when a
      2nd step of baselining is desired on the gridded data cube. The
      online help was upgraded (see in particular the output of "LAS> HELP
      XY_MAP MEMORY"). An IRAM memo to document the new functionality is
      being finalized.
    - There now is the possibility to write a weight array as an associated
      array and to use it in the AVERAGE and STITCH commands through SET
      WEIGHT ASSOCIATED. This is useful when the system temperature and
      thus the noise vary over the IF bandpass.

## Aug16

No release.

## Jul16c

Incompletely documented.

- ASTRO
    - The number of antennas is set to 8 in the sensitivity time
      estimator for the winter-2017 call for proposals.

## Jul16b

Incompletely documented.

- CLIC
    - Bug fixes following change of data format in memory.

## Jul16

Incompletely documented.

- ASTRO
    - EMIR frequency setups can now be prepared using a new set of
      commands in the PICO\ language (activated by command OBSERVATORY
      PICO):
        EMIR
        BASEBAND
        BACKEND
      These take into account the available frequency limits, band
      combinations, and spectrometers, and plot the covered frequency
      ranges together with known spectral lines, taking into account
      source velocities or redshifts. This new functionality is still
      under development and is likely to be upgraded in the future.
    - For the EMIR receivers, 2 different range of frequencies were
      introduced.  Now ASTRO accepts to tune EMIR at a frequency which is
      OUT of the frequency range announced in the call for proposal. In this
      case, a warning is output both in the shell and on the plot to make
      sure the user is aware that IRAM proposes this tuning only on a
      best-effort basis. The "wider" limits are currently set to 2GHz away
      from the Call for proposal limits.  This could be changed with a fixed
      offset or a precise value for each of the 8 limits (4 bands up and
      low)
    - The possibility to display lines from a catalog was enhanced through
      the SET LINES commands:
	 "SET LINES PLOT ON" will be displayed for all the forthcoming plots
	 "SET LINES PLOT OFF" does the opposite
      In addition, the lines can be plotted with a profile and a width
	  "SET LINES PROFILE BOXCAR|GAUSS"
	  "SET LINES WIDTH value", where value is in MHz (width of the
				   boxcar profile or FHWM of the Gaussian)
      Finally, the user can define the catalog where the molecular lines are
      read with the CATALOG command (that was used before only for source
      catalogs)
	  "CATALOG MyCata.lin" or "CATALOG MyCata /LINE" or "CATALOG
      MyCata.dat /LINE" all load the associated ASCII catalog. For the
      moment, only the ASTRO line catalog format is accepted, ie,
	  Freq(In GHz) 'LineName'
	  115.271      'CO (1*0)'
	  230.538      'CO (2*1)'

- CLASS
    - By default, the FOLD command now keeps the blank channels at the
      boundaries of the folded spectrum. In the past they were implicitly
      dropped, but this could lead to inconsistent CLASS indexes
      (inconsistent number of channels while input were consistent), and it
      was also impossible to FOLD a fully blanked spectrum (all channels
      dropped). This default behaviour can be customized anyway with FOLD
      /BOUNDARY KEEP|DROP.
    - The GO EXPLORE procedure had a very slow start-up on data-set
      containing a large number of scans. This was fixed by internally
      using LIST /TOC SCAN instead of a slow customed solution.
    - The LAS\PLOT command was starting by destroying all opened plot
      windows and recreating the GREG> window (implicit call to the
      "GTV\DESTROY ALL" command). Now it only erases the current window
      (implicti call the "GTV\CLEAR DIRECTORY").  This makes possible to
      draw and keep several plots in several windows in the same
      session. For instance
	 file in myfile
	 find
	 ! Plot GO WHERE in a dedicated window
	 g\create directory <WHERE
	 g\change directory <WHERE
	 go where
	 ! Plot the first spectrum in the <GREG window
	 g\change directory <GREG
	 get f
	 plot
    - On request from Sofia developers, the User Section internal buffer
      has no more internal limited size (previous limit was 2 kB). Now it
      will be transparently reallocated to the appropriate size.

## Jun16:

No release.

- ASTRO
    - The IFPROC command was renamed into BASEBAND command in order to get
      the same look and feel for both IRAM observatories.

## May16

Incompletely documented.

- MRTHOLO
    - It's a new package that enables IRAM staff to analyze 30m
      holographies.

- CLASS
    - Section "Frequency Switch" is renamed "Switching" because it can be
      used for other switching modes. The FORTRAN derived type obs%head%fsw
      is renamed obs%head%swi. This is a change in the Fortran API. No
      change to the SIC and Python end*user API for now. Next step is to
      rename the FORTRAN variables from French to English names.
    - AVERAGE now support associated arrays, i.e., it averages them using
      the usual floating point engine. Next step to improve the support of
      associated arrays is to change the data format so that the
      CONSISTENCY command can efficiently checks that the same associated
      arrays are present in all the observations of a given index.
    - SIC and CLASS specific functions are now documented online through
      the HELP FUNCTION command.
    - The "FITS WRITE /MODE SPECTRUM" was missing a zero*ification of the
      position angle, implying that a non*zero (random value) rotation
      matrix could be defined (CROTA3) and the CDELT2 and 3 increments were
      affected accordingly.
    - Support to use the new GDF telescope section in TABLE and LMV
      converged. The goal is to ensure that the telescope name and diameter
      is conserved in LMV cubes. Note: This still requires the activation
      of a new version of the GDF format that should happen before the
      summer vacation.

## Apr16

Not yet documented.

## Mar16b

Not yet documented.

## Mar16a

Incompletely documented.

- ASTRO
    - The first support for the visualization of the front-end / back-end
      combinaison of the EMIR receiver is now available. It contains the
      visualization of the EMIR front-end and FTS, WILMA, and VESPA. The
      flexibility of VESPA is not yet coded. But the code was deemed
      sufficiently useful to be released.
    - The NOEMA time estimator was upgraded to match the summer2016 call
      for proposal.
    - The ALMA configurations for cycle 4 were introduced.

- CLASS
   - SET MATCH documentation was stating that the default tolerance was 2"
     but it was coded as 10^-5 radian, ie, 2.06". The coding now reflects
     the documentation. This can have slight edge effects in existing
     procedures.
   - The /PEN option was added to the DRAW command.
   - The /LINE option was added to the LMV in order to input at the same
     time the spectra and the line associated array from the LMV cube and a
     cube of line mask. This allows the user to easily rebaseline its
     cube once there is an associated cube of mask.
   - The UV_TABLE command was fixed. It also now takes into account the
     weight mode, defined through the SET WEIGHT command.  NB: This command
     is now used in the GO UVSHORT procedure of MAPPING in the case where
     the single-dish and interferometric diameters matched.

## Feb16

- Kernel (SIC and GREG)
    - The SVG device for plot hardcopies works again.
    - The SIC\EXECUTE command was introduced to execute a SIC command line,
      possibly built by hand in a character string variable.

- CLASS
    - The possibility to change the scale of the Y axis from Jy/Beam to K
      and vice-versa was implemented through a "MODIFY SCALE unit" or "SET
      SCALE unit" commands. Currently this only works for imported cubes
      via the LMV command. This will be generalized to data stored in CLASS
      format.
    - The LMV command now accept to import 2D images as a set of single
      channel spectrum. This still requires that a coherent spectroscopic
      axis is defined in the 2D image header. This is, for instance, useful
      to import continuum images in CLASS.
    - The resolution section (MAJOR, MINOR, POSANG) was introduced to
      support the commands LMV and FILE IN VLM. This section is written in
      the CLASS data format when present in the observation header. The
      resolution is given at the rest frequency of the observation
      header. The command MODIFY FREQUENCY thus scales the beam. At some
      point, the 30m CLASS filler will be upgraded to write this section.
    - The option /NOCHECK BASELINE was added to the MINIMIZE and ITERATE
      commands in order to allow the user to fit a spectrum without
      removing first a baseline. This can be useful when importing
      interferometric data cubes.
    - The concept of Associated Arrays is added in the CLASS data
      format. It is an additional section that stores a set of data arrays
      whose spectral axis matches the brightness spectral axis, i.e.,
      one-to-one channel correspondance. At start, this is only used in two
      contexts. For Herschel/HIFI, it stores a logical array of blanked
      channels and a logical array to deffine the channels where the lines
      appear (see IRAM Memo 2015-3). At some point, it will be used at the
      IRAM-30m to store the results of the calibration scans, i.e., the sky
      counts in the RY array and the hot/cold counts, and the receiver,
      system, and calibration temperatures in a set of Associated
      Arrays. Details can be found here:
         http://iram-institute.org/medias/uploads/class-associated-arrays.pdf

- MAPPING
    - The CLEAN command is an alias for the HOGBOM, CLARK, MX, MRC, or MULTI
      commands. It calls the cleaning method defined in the SIC METHOD
      variable.
    - The self-cal procedure now allows the user to save the input
      parameters from one session to another. Work is being done to
      visualize the output in order to make the whole process less of a
      black box.

## Jan16

- Build
    - The apple LLMV C++ compiler is now supported as well as the GNU C++
      compiler.

- Kernel (SIC and GREG)
    - Plotting lines using the PNG device (command HARDCOPY) was optimized
      by up to a factor 40 in times.

- ASTRO
    - The LINE command is now used to choose tuning frequencies on the LO
      tuning grid (every 500MHz) as this should optimize the receiver
      performances. The /ONGRID option automatically choose the closest
      tuning frequency with a visualization of the other
      possibilities. LINE tries to avoid known RFI. The old behavior of the
      LINE command can be retrieved through the SELECT PDBI 2013
      command. The memo documented the non-obvious behavior is being
      written. The associated plot clearly state what is the used scheme
      (use or not of the LO tuning grid).

- CLASS
    - AVERAGE now produces the average of the elevation (instead of
      0). The azimuth of the average is still set to 0.

- CLIC
    - CLIC was adapted to only write the signal band, instead of both the
      signal and image band. Indeed, the rejection image sideband is
      excellent for NOEMA (because of the Walsh phase switching scheme),
      implying the only noise was recorded in the image sideband. Note that
      for sideband separated mixers (2SB), LSB and USB bands are both
      signal bands, each of them being associated to an image
      band. Avoiding to write the image sideband saves a factor two in the
      data file size.

- MAPPING
    - When self-calibrating, the possibility of specifying the reference
      antenna is required for test and for special cases. In particular,
      there currently are issues when deriving a selfcal solution from
      WIDEX 7 antennas and trying to apply it to the spectral line
      correlator with 6 antennas. This implied a minor change in the
      interfaces (task, go selfcal, and program itself).

## Dec15

- General
    - Sometimes the user gets
	"system: Cannot allocate memory"
      when he/she spawns shell commands from GILDAS software.
    - This seems random but in fact, the kernel team finally succeeded to
      reproduce it repeatedly:
	 SIC> $echo Hello
	 Hello
	 SIC> define real a[4,1024,1024,1024]
	 SIC> $echo Hello
	 system: Cannot allocate memory
      Indeed, on a system with 24 GB RAM, we try to allocate 16 GB (i.e., 8
      GB remain), and then all is broken for that tiny "echo" command.
    - The reason is that the SIC commands "$", SYSTEM, but also SIC DELETE,
      SIC RENAME, SIC OUTPUT and more make an internal call to the POSIX OS
      command "system()", that is suppose to execute a command line with
      /bin/sh. However, this is done with a forked process. And the fork()
      manual states that "fork() creates a new process by duplicating the
      calling process". This includes duplicating the memory! In other
      words, if the remaining memory is smaller than what your Gildas
      program currently uses, you CAN NOT fork the process.
    - This regularly happens on reduc machines where many people are
      running programs, i.e., free RAM memory is often small and in any case
      not controlled by the end users.
    - There is no obvious generic solution to this problem. Indeed, this
      problem happens in other applications, e.g, in python
	 >>> import os
	 >>> ier = os.system("echo Hello")
	 Hello
	 >>> print "Error code = ", ier
	 Error code =  0
	 >>>
	 >>> import numpy
	 >>> a = numpy.ones([4,1024,1024,1024],dtype='<i4')
	 >>>
	 >>> ier = os.system("echo Hello")
	 >>> print "Error code = ", ier
	 Error code =  -1
      An error occurred, the "echo" command was not executed.
    - Unsatisfying but working solutions are either to free memory in the
      current session, or to avoid using problematic commands. On the long
      term, the kernel team could ensure that SIC DELETE, SIC RENAME, SIC
      OUTPUT, ... do not use anymore "system()" but it requires some work to
      ensure the same functionality (i.e., possibility to use regular
      expressions). On the other end, there is probably no generic solution
      for "$" and SYSTEM.

- CLASS
    - In the GO WHERE command, the size of markers is now a log function of
      the nnumber of points (i.e. markers are smaller when there are more
      points). The option /COLOR [SCAN|SUBSCAN|OBSERVED|TELESCOPE] implies
      that the markers will have a different color when the named attribute
      differs (default to 1 color per scan).
    - In TABLE /NOGRID, the beam does not need anymore to be known (as we
      don't need to know the resolution because we don't set up a
      convolution kernel). If the beam is not known, the user has to
      provide the tolerance for guessing the X and Y increments (MAP%TOLE),
      else the tolerance will be set as a fraction of the beam.  This will
      avoid errors for users who import data with an unknown beam and/or
      the telescope.
    - The weight column created by the TABLE command is now computed
      according to SET WEIGHT or new option /WEIGHT, when present. Default
      is the same as before (i.e., time weighting). This option will help
      users with imported data (i.e., with zero-valued time, tsys and
      sigma) as they can now use TABLE /WEIGHT EQUAL.
    - FFT /KILL now displays the current FFT before invoking the cursor to
      define the kill windows. Before, the cursor was invoked without
      displaying the FFT.
    - The experimental command MEDIAN that computes the running Median and
      Median Absolute Deviation along the R spectrum was added.

- MAPPING
    - The possibility to image and deconvolve with different dirty beams as
      a function of frequency is now implemented in the UV_MAP
      command. Right now, the beam ``abruptly'' changes every so and so
      number of channels, specified by the MAP_BEAM_STEP sic varialble:
      Default is 0, meaning only 1 beam plane for all channels;  N (>0)
      indicates N consecutive channels will share the same dirty beam;  -1
      can be used to compute the number of channels per beam plane to ensure
      the angular scale does not deviate more than a fraction of the map
      cell at the map edge.  This fraction is controlled by the variable
      MAP_PRECIS (default 0.1).

## Nov15

- Build
    - The "-o sanitize" configuration now activates the gfortran sanitizer
      that provides: 1) Automatic detection of memory overflows
      (i.e. illegal access beyond array boundaries). This is robust with
      Gildas memory tricks (no known false positive). Programs stops with
      detailed report (location of the problem) as soon as an overflow is
      detected. 2) detection of memory leaks (a summary is printed at
      program exit). Effects on code speed is unknown. This requires a
      recent gfortran version.

- Kernel (SIC and GREG)
    - The /TRIM option was added to the DEFINE IMAGE|HEADER command.  It
      attempts to trim trailing degenerate dimensions up to the specified
      Rank.  If no Rank is given, it will trim all possible trailing
      degenerate dimensions. If Rank is positive, the defined header or
      image will have exactly Rank dimensions. An error occur if the
      corresponding file has non-degenerate dimensions beyond this rank.  If
      the file is of lower dimensionality than the specified Rank, its
      dimensionality is extended by adding degenerate dimensions up to
      Rank. If Rank is negative, trim all possible trailing degenerate
      dimensions, and return an error if the final dimensionality remains
      larger than Rank. Examples: Assuming that file.gdf contains a 3-D
      array of dimensions [Nx,Ny,1],
	DEFINE IMAG A file.gdf READ
	  will return the 3-D array A[Nx,Ny,1]
	DEFINE IMAG A file.gdf READ /TRIM 4
	  will return the 4-D array A[Nx,Ny,1,1]
	DEFINE IMAG A file.gdf READ /TRIM 1
	  will produce an error (same with /TRIM -1)
	DEFINE IMAG A file.gdf READ /TRIM -4
	  will return the 2-D array A[Nx,Ny]
	DEFINE IMAG A file.gdf READ /TRIM
	  will also return the 2-D array A[Nx,Ny]

- ASTRO
    - The LINE command was upgraded to reflect recent changes at Bure.

- CLASS
    - The /PLOT [Ipen] option was added to the WAVELET command to overplot
      on the current spectrum the baseline subtracted with "WAVE /BASE N".
      WAVELET is still experimental.
    - The "SET CHECK" and "SET NOCHECK" commands were introduced to be able
      to globally turn on and off some consistency checks. This is useful
      to avoid using everywhere the option /NOCHECK, e.g., /NOCHECK OFFSET
      for OTF data, and /NOCHECK POSITION for comet people. Default is
      still to check everything.
    - The MODEL command now uses the default blanking value -1000.0 instead
      of 0.0.

- MAPPING
    - It is now possible to use UV_TIME to average the ALMA visibility by
      groups of contiguous time to reduce the data processing time. Somehow,
      this can also be used as an approximated quicklook of the data.

## Oct15b

- MAPPING
    - The UV_CASA task now processes correctly single datasets observed on
      different days.

## Oct15

- ASTRO
    - The ATM binary format used when tabulating ATM results is now
      document under HELP ATM FORMAT.
    - The table loaded in memory by the ATM command is now also available
      under the SIC structure ATM%TABLE%. This allows the user to know the
      parameter space (frequencies, pressures, water amounts,...) used at
      the time the table was generated. This also enables an easy access to
      the table values (for, e.g., plots).
    - The atm-table-toc.astro procedure shows the table of contents of the
      current ATM table loaded in memory by the ATM
      command. The sampling of the parameter space is printed, and a plot
      of atmospheric emission as function of frequency is shown.

- MIRA
    - Galactic coordinates are now supported.

- CLASS
    - The support of the Herschel Herschel/HIFI FITS science archive format
      is now available in the LAS\FITS command. A HIFI specific header
      section was devised. Documentation is available here:
         http://www.iram-institute.org/medias/uploads/class-herschel-fits.pdf
    - Following the swap to CLASSIC, the oldest spectroscopic sections
      (with only 15 words) were not recognized anymore, preventing the
      reading of old data. This bug was fixed.

## Sep15

- CLIC
    - The CLIC format evolved to better monitor observations with NOEMA.

## Aug15b

- Build
    - Fixed linking against libpng library found in non-standard
      locations, e.g. under MacOSX using MacPorts.

- Kernel (SIC and GREG)
    - The ALMA simulator is works again.

## Aug15a

- General
    - Use of OpenMP is now supported at compilation time with
      "source admin/gildas-env.sh -o openmp". Up to now, it is mainly used
      in MAPPING gridding and deconvolution commands.

- Kernel (SIC and GREG)
    - Log files can be (de)activated by setting the SIC logical
      SIC_LOGFILES to YES or NO in the user's customization file:
      $HOME/.gag.dico
    - Optimizations for skipping re-triangulation and/or re-interpolation
      (gridding) of the RANDOM_MAP command are not anymore always
      active. The /SKIP option was added to enable skipping these
      operations under the user responsability.

- CLASS
    - The LMV command now uses the lmv-clean extension as a default when a
      file with such an extension exists. Else, it falls back to the lmv
      extension. Indeed, the lmv extension is the default for non
      deconvolved images from interferometers in MAPPING.

- MAPPING
    - The filler from the CASA UVFITs to the MAPPING uvt format is now able
      to catch cases where the velocity is high (high redshift
      observations) and it automatically computes the frequency axis as if
      it were observed with a 0 LSR velocity, as it should be in this case
      to get a correct velocity axis in the source frame.

## Jul15c

- ASTRO
    - The NOEMA time estimator of ASTRO was upgraded and documented to
      better handle the mosaic case. PMS will be modified to do the same
      computation.

## Jul15b

- MAPPING
    - The procedures GO UVSHIFT and GO UVSHORT work again.

## Jul15a

- Kernel (SIC and GREG)
    - In the FITS to GDF filler, NaN are now converted to a blanking value
      with the following heuristic:
	+ If NBIT < 0, convert NaN to a default blanking. It is set to
   	  -1.23456E38 and 0 tolerance to allow grey scale contouring to work
	  as much as possible.
	+ If the Keyword BLANK is found in FITS header, it is used to set
          the blanking value. For NBIT > 0, this must be scaled with BSCAL
          and BZERO, though.

- CLASS
    - The command SET WINDOW has been improved as follows.
        + SET WINDOW DEFAULT will revert to the default status, i.e.
          no signal window defined, BASE will return an error.
        + SET WINDOW NONE will define 0 window, i.e. BASE will fit all
          channels, assuming there is no signal at all in the spectrum.
        + SET WINDOW AUTO will reuse the previous windows as found in
          the current base section in the R buffer.
        + SET WINDOW /POLYGON (used in PLOT /INDEX mode) accepts now
          complicated polygons shapes resulting in more than 1 window
          per polygon.

- CLIC
    - The NOEMA calibration pipeline now successfully handles in parallel
      up to 7 antennas with the WIDEX backend and up to 6 antennas with the
      narrow band correlator.

- MAPPING
    - The handling of the blanking in the deconvolution of mosaics was
      broken after some code refurbishment. It is now working again.

## Jun15

- CLASS
    - The support of different projection systems in CLASS was
      completed, i.e., the PLOT and HEADER commands now also display
      the projection kind and angle. We note that this support
      implied a change of data format (modification of the position
      section of the header). This implies that data written with
      recent version of GILDAS (after apr15) can not be read by older
      version of CLASS (in contrast, newer CLASS is obviously able to
      read old CLASS format).  The documentation about the improved
      support of coordinate projections in CLASS is now available
      here:
      http://www.iram-institute.org/medias/uploads/class-projection.pdf

## May15

- CLASS
    - After 5 years of obsolescence, the old averaging engine (AVERAGE
      /2010) is removed.
    - The CLASS FITS reader did not convert UT and ST from second to
      radian, implying a wrong recomputation of the Doppler factor, when
      needed. This was fixed.
    - The possibility to store 2D arrays in the USER section was added after
      a request from the SOFIA observatory.
    - The LMV command now correctly imports ALMA data cubes produced by CASA
      into CLASS as we now enforce that Voff and Restf are aligned on the
      spectral reference channel.

- MAPPING
    - The ALMA cycle 3 configurations files were added for use in the ALMA
      simulator.

## Apr15b

- CLASS
    - The command LMV now imports correctly LMV cubes with 3rd axis as
      Frequency, in particular the ones imported in Greg from CASA
      through FITS.

## Apr15

- Kernel (SIC and GREG)
    - The "HELP TASK" command now lists all the available tasks and the
      "HELP RUN TASKNAME" displays the help of the task named TASKNAME.
    - The SIC variable SIC%RAMSIZE now contains the total RAM size
      available on the system. It's an experimental feature that only works
      under Linux and Mac OSX.
    - The MODIFY command now consistently modifies the spectroscopic axis
      of a lmv cube or a Sic structure of type IMAGE, HEADER, or UVTABLE,
      according to the user-provided rest frequency and/or systemic
      velocity.

- CLASS
    - A null value was introduced for the image frequency. This enables to
      deal with the case were the image frequency axis becomes irrelevant,
      i.e., when stitching spectrum with different LO tunings.
    - FILE IN was enhanced to support the direct reading of a VLM
      cube. This is a test to see whether we can avoid duplicating the data
      through the LMV command.
    - Support to modify the projection was added. This has two-fold
      consequences:
        + We introduced the "MODIFY PROJECTION Type [A0 D0 [Angle]]"
   	  command to modify the projection and offset coordinates of the
   	  current R buffer. All projections supported by GILDAS are
   	  understood (NONE, GNOMONIC, ORTHOGRAPHIC, AZIMUTHAL,
   	  STEREOGRAPHIC, LAMBERT, AITOFF, RADIO, SFL). In particular, some
   	  of these projections support a projection angle.
        + When using XY_MAP on 30m data, the default projection, e.g.,
    	  RADIO, is used. Up to now, when the map%angle is not 0 and
    	  map%shift is true, the RADIO projection was kept and the
    	  coordinates just rotated in 2 dimensions. However, this raised
    	  problems because the notion of projection angle is not supported
    	  in the RADIO projection. The new behavior is to keep the RADIO
    	  projection when map%angle is zero valued, and to switch to
    	  AZIMUTH projection with a projection angle equal to the value of
    	  map%angle (when this value is not 0).
    - The header position section was revised. We removed the unused
        real(kind=8)      :: sl0p       ! [rad] lambda of descriptive system
        real(kind=8)      :: sb0p       ! [rad] beta   of descriptive system
        real(kind=8)      :: sk0p       ! [rad] angle  of descriptive system
      and we added
        real(kind=8)      :: pang       ! [rad] The position angle associated to the current projection
      This finalizes the support of the projection that handles an angle.

## Mar15c

- Kernel (SIC and GREG)
    - The "RUN CIRCLE" task was debugged.
    - When "extending" the last dimension of a Gildas file
      (e.g. DEFINE TABLE Var[Ldim] File EXTEND), the data just before
      the extended area could have been lost.

- CLASS
    - The column DELTAV (velocity resolution) was incorrectly exported
      into FITS as km/s instead of m/s when using the command FITS
      WRITE /MODE INDEX if (and only if) the resolutions were not
      identical for all spectra (if they are identical, the resolution
      was correctly exported as a unique FITS card in the header).

- MAPPING
    - The command CLEAN\MODIFY recognizes again the UV tables with a
      UV axis named "UV-RAW".

## Mar15b

- Kernel (SIC and GREG)
    - The experimental command SIC\MODIFY does not support yet the UV
      tables.

## Mar15

- Kernel (SIC and GREG)
    - The default size of the buffers defined by the SIC logical
      SPACE_GILDAS was increased from 128 to 1024 MB.
    - "SHOW LIMITS ABSOLUTE" now lists the coordinates of the middle of the
      rectangular box sides in order to be consistent with the expected
      syntax for the "LIMITS ABSOLUTE" command.

- CLASS
    - A bug in the handling of the data format was fixed. It happened when
      there was user section. This was reported by SOFIA. In particular, it
      does not affect the 30m, HIFI, or APEX.
    - Implementation of the direct reading of the standard HIFI FITS format
      is completed to 75%.
    - The FFT command now defines the SIC variables R%FFT%X and R%FFT%Y that
      maps the FFT of the current spectrum.
    - XY_MAP does not handle blanking values for efficiency purposes. It is
      advised to use the UNBLANK command on the input table before using
      XY_MAP.

## Feb15

- From PdBI to NOEMA
    - With the advent of the 7th antenna, the PdBI observatory officially
      becomes the NOEMA observatory.
    - We started to upgrade the GILDAS web page and documentation.
       + All old memos will keep the PdBI name.
       + New memos will have to use the NOEMA name.
       + The PdBI name will be kept to refer to the old interferometer
         configuration.
       + The document "Introduction to NOEMA" (formerly "Introduction to
         PdBI") has been revised for the summer 2015 call for proposals.

- Build
    - ifort 14 is now supported.
    - Under ifort, the temporary arrays are now allocated on the HEAP
      instead of the STACK memory. Indeed, the STACK memory has a limited
      size, implying ``random'' crashes when dealing with large
      datasets. This changes ensures that the only limitation is now the
      RAM physical size. The drawback is that the HEAP memory has longer
      access time, implying potential efficiency losses (to be
      confirmed). Hence, we introduced a specific configuration of
      compilation that will revert the allocation of the temporary arrays
      to the STACK memory. This configuration can be switched through
         source admin/gildas-env.sh -o stackarrays
    - HPUX, OSF, Solaris, SunOS, Alpha, VMS, ULTRIX are officially not
      supported anymore: Associated code was cleaned out.

- Kernel (SIC and GREG)
    - The SIC interpreter now understands sub-strings of any string
      variable with the syntax STRING[begin:end] where begin and end are
      integer values. As a consequence, the "COMPUTE EXTRACT" command to
      extract a substring of a string is now replaced by
      "LET SUBSTRING 'STRING[begin:end]'".
    - The SYMBOL command now rejects trailing arguments, e.g., "SYMBOL NAME
      Value Other" is now an error. This is intended to catch weird
      behaviour when using values containing blanks. The previous behaviour
      was to ignore the trailing arguments.
    - Inside a SIC procedure the SIC PRO%NAME variable is set at run time
      to the name of the procedure (full path to the support file on disk).
      This is similar to what can be found in argv[0] in many other
      languages.
    - The "POLYGON varname /VARIABLE" now supports the SIC structure format
      created as output of the POLYGON command, i.e., one can re-inject the
      output variable as input. This is useful to inject in the POLYGON
      command the result of the new MAPPING SUPPORT command.
    - The "COMPUTE nlines LINES filename" computes the number of lines of
      the filename. This is similar to the unix "wc -l" command, but it is
      portable.  The "/BLANK" option implies that empty and comment lines
      (starting with the ! character) are ignored in the computation.
    - GO VIEW was optimized to faster handle cubes with a large number of
      channels.
    - The size of the buffers defined by the SIC logical SPACE_GILDAS was
      increased from 128 to 1024 MB.
    - Python version 2.5 and lower are not supported anymore. This enables
      the support of python 3.

- ASTRO
    - The EMIR/HERA time/sensitivity estimator was upgraded:
       + The range of EMIR RF frequencies were adapted to match the call
         for proposals.
       + The Trec of pixels 4 and 9 of HERA2 was largely increased to
         reflect that these pixels are dead.
    - The NOEMA time estimator was updated to match the call for proposals,
      in particular, to deal with 7 antennas when using the WIDEX
      correlator and 6 antennas when using the NARROW BAND correlator.
    - The UV_TRACK command is now able to correctly display configurations
      with more than 6 antennas.
    - The Bure solar avoidance radius was changed from 35 to 32 degree to
      agree with the new NOEMA policy.
    - The change of name from PdBI to NOEMA has some specific impact into
      ASTRO:
        + The NOEMA observatory (command SET OBSERVATORY) is already
          recognized.
        + The PdBI language to setup the frontend/backend spectral
          configuration is kept. Before the advent of the new correlator,
          this will be the default to setup the NOEMA observatory spectral
          configuration. A new NOEMA language to setup the spectral
          configuration of the new correlator will be tuned and hooked to
          the NOEMA name when the thinking about the software adaptations
          to the new correlator will start. The old PdBI language will then
          be kept to be able to check the spectral configuration of WIDEX
          and the NARROW BAND correlators.
       + The time estimator was renamed from PdBI to NOEMA.
    - The XML parser of the ALMA OT setups was upgraded. Following this
      upgrade, the ACA setups cannot be read anymore because the ALMA and
      ACA correlators have different characteristics.

- CLASS
    - The EPOCH field of the CLASS data format was renamed into
      EQUINOX. Indeed, the equinox refers to the date at which the
      equatorial referential is defined, while the epoch refers to the date
      where the observations are actually done (this is important for
      objects with large proper motion). The associated SIC variables were
      also renamed. NB: CLASS do not deals with proper motion, i.e., we did
      not create another field, named EPOCH in addition to the EQUINOX
      field.
    - The procedures to handle polarimetry at IRAM-30m, known as the x-pol
      extension, were added in the distribution of CLASS.
    - The AVERAGE and STITCH commands where bugged when the blanking value was
      zero (case of SOFIA/GREAT spectra). This was fixed, and SOFIA/GREAT
      class filler changed its blanking value.
    - While the averaging engine stubbornly forbid oversampling, it now
      allows it when the user explicitely asks for it. In other word, we now
      assume that if the user asks for it, he knows what he does.
    - SET WINDOW /POLY now accept to interpret vertices defined on the right
      or left side (i.e., outside) of the plotting window.
    - The output format of the "ANA\GREG /FORMATTED [Format]" command can
      now be customized by the user, e.g, to get more or less precision.
    - The new FIT\RESULT command replaces the observation in the current R
      buffer by the fitted model. This is a similar behavior to the
      FIT\RESIDUALS command that replaces the observation in the R buffer
      by the difference between the data and the fitted model.
    - The PLAIT task was debugged (problem of integer kind in the dimension
      of the cube).
    - XY_MAP was segfaulted when trying to grid large OTF datasets with a
      small intermediate buffer. This was fixed.
    - WEEDS\LID will now display the lines sorted by frequency. There was
      previously no sorting. Lines were already sorted most of the time,
      but for custom databases built by hand (USE OUT + several INSERT)
      they were not.

- CLIC
    - The daily version of CLIC was adapted to cope with 6 or 7 antennas.
      In particular, the VARIABLE SIZE command now defines the MAXANT and
      MAXBASE sic variables defining the theoretical maximum number of
      antenna and baselines for which CLIC was compiled.

- MAPPING
    - The "VIEW CCT" command now enables to plot the CLEAN convergence
      curves for all channels in a single panel, while GO CCT plots one
      channel convergence curve per panel.
    - The polygon defined by the CLEAN\SUPPORT command is now different
      from the polygon defined by the GREG\POLYGON command. In particular,
      this solves the problem that the deconvolution result depended on the
      use of the "GO VIEW" command in a given MAPPING session.
    - A bug in the short-spacings processing introduced when the interface
      of GILDAS FFT was changed from REAL to COMPLEX was fixed. It affected
      multi-channel cubes.

## Jan15

No release.

## Dec14

No release.

## Nov14

No release.

## Oct14

No release.

## Sep14

No release.

## Aug14

No release.

## Jul14c

- CLASS (for details see the NEWS of Feb15)
    - The AVERAGE now produces a valid output spectrum when using
      SOFIA spectra.
    - The command SET WINDOW /POLYGON is fixed regarding polygons
      overlapping the PLOT edges.
    - RUN PLAIT is fixed.

## Jul14b

- MAPPING
    - The task RUN UV_FIT will display the flux results (on screen)
      using an adaptative unit. Units in the output table is
      unchanged.

## Jul14a

- Kernel (SIC and GREG)
    - When "SIC FIND" does not find any file, the value of the
      DIR%NFILE is now set to 0, and not -1 anymore.
    - The GTV%DEVICES variable is now always present, while it was
      before only created when the first device was loaded. In order
      to test whether a device is loaded or not, the user has now to
      check the value of the new SIC variable GTV%DEVICE: It is NONE
      in no-window mode.
    - The "RUN LIST" task is now able to list an arbitrary number of
      columns.
    - The new PARSE command allows the user to parse the calling
      sequence of a procedure as if it was a standard command, i.e.,
      with options and arguments. The parsed result is stored in the
      PRO structure. See HELP PARSE for details.

- ASTRO
    - It is now possible to IMPORT ASTRO into CLASS, and vice-versa.

- CLASS
    - The /MATH option of the TABLE command is now able to parse
      several mathematical expressions on the same command line. The
      produced table has one column per mathematical expression. This
      allows the user to grid several derived products in a single
      data cube with the XY_MAP command.
    - The "SET MODE X lowfreq highfreq" command was sometimes using one or
      two channels more than plotted on the screen when computing the
      baselines. This was due to rounding rules different in both
      cases. This is now fixed, i.e., we have a more WYSIWYG behavior of
      the BASELINE command.

- CLIC
    - The CLIC data format (V1) showed various limitations that need to be
      overcome with the advent of the NOEMA project (size of an observation
      limited to 8 GB, size of a file limited to 1 TB, ...). To remove
      these limitations, we had to produce a new CLIC data format (V2). The
      swap to this new data format happened at Bure in June 2014. It means
      that CLIC now writes both IPB and HPB files using the V2 version of
      the CLIC data format. CLIC is still able to read the V1 version of
      its data format.

## Jun14

- Kernel (SIC and GREG)
    - Added HARDCOPY /DEVICE PNG NOBLANK: blanked pixels will not be drawn,
      i.e., they will use the background color (white, black, or
      transparent) or they will let you see previous drawings made
      behind. Default is to draw them, i.e., what you see in the X window is
      what you get.
    - The "LUT LUT" command, used re-defined the color Look-Up-Table,
      ensures that the user can also redefine the Blanking color.

- CLASS
    - The "COMMENT READ|WRITE" command that allows the users to store a
      comment on the current observation is now reimplemented.
    - The command "SET OBSERVATORY Name Longitude Latitude Altitude" was
      introduced to enable CLASS to compute the doppler correction for
      observatory CLASS does not know when the doppler correction is not
      provided by the observatory. The default is "SET OBSERVATORY *",
      which means that CLASS tries to guess the observatory from the first
      few letters of the TELESCOPE field.
    - YEBES was added as a known telescope. Any spectrum with a TELESCOPE
      field started with "OAN-" will be recognized as coming from YEBES.

- CLIC
    - The convention to name Bure projects was changed in May 2014. In
      particular, this impacts the HPB and IPB file names. Short file names
      now follow the YYMMDDPPPPPPPP.IPB convention, and long file names
      follow the dd-mon-yyyy-pppppppp.ipb convention. The letters that
      tagged the project itself follow TYYPPSSS, where type T is
        + S or W for the summer or winter semesters for regular projects;
        + L or M for the summer or winter semesters for large projects;
	+ D or E for the summer or winter semesters for directorial time;
      PP are the two project letters, and SSS are the three subproject
      numbers. The old file name convention is still supported to ensure
      backward compatibility.
    - The tracking of parasites was improved in the pipeline.

- MAPPING
    - A new version of the phase self-calibration procedure and widget is
      available. It now enables multi-iterations to handle the case of
      complex sources.
    - The imaging and deconvolution tasks are able to handle datasets
      larger than the available RAM memory. Right now the MAPPING program
      assumes that the full dataset fits in memory. Work is being completed
      to ensure that the mapping library use the the same engines as the
      mapping tasks. This should allow users to process their data by
      chunks, using the MAPPING commands in addition to the MAPPING tasks.

## May14

No release.

## Apr14c

- CLASSIC bit container
    - Much work was done in the last 2 years to separate (and factorize)
      the code which reads/writes the bits of a CLASS/CLIC file, from the
      code which decodes the meaning of the bits (the semantic). A new
      library for the former code was created and named CLASSIC. It's a bit
      container.
    - The first version of the bit container (CLASSIC V1) used mostly the
      old CLASS/CLIC code, implying that it kept all the limitations: size
      of an observation limited to 8 GB, size of a file limited to 1 TB,
      ....
    - Hardware developments implied to remove these constraints. We thus
      developed a 2nd version of this bit container (CLASSIC V2). The
      change of the CLASS data format from V1 to V2 is mainly a change of
      the bit container version from CLASSIC V1 to CLASSIC V2.
    - Extensive documentation is available at the following URL:  
	http://www.iram-institute.org/medias/uploads/classic-data-container.pdf

- CLASS
    - The CLASS data format (V1) showed various limitations that need to be
      overcome with the advent of multi-beams and large bandwidth receivers
      (size of an observation limited to 8 GB, size of a file limited to 1
      TB, ...). To remove these limitations, we had to produce a new CLASS
      data format (V2).
    - Since April 22nd, the 30m acquisition system has writen CLASS files
      using this new data format.  Starting with this version of GILDAS,
      CLASS both reads and writes the version 2 of the CLASS data
      format. The reading of the version 1 of the CLASS data format will be
      maintained forever to ensure backward compatibility, but the writing
      of V1 is not offered anymore. We thus advise all the CLASS users to
      upgrade their GILDAS version to apr14c or a more recent version of
      GILDAS.
    - As only the bit container changed, but not the semantics, this change
      is mostly transparent to the end user. The versions of GILDAS older
      than dec13 will refuse to read the new CLASS format, but all the old
      CLASS procedures should still work with gildas versions newer than
      apr14b that use the CLASS format V2. Moreover, the FITS import/export
      of CLASS spectra did not change.

## Apr14

- General
    - The program option '-nl' (e.g., "sic -nl") was introduced in order to
      completely disable the creation of log files (i.e., .log and .mes
      files).

- Kernel (SIC and GREG)
    - A new language, named LINEDB, generalize the interface to the JPL and
      CDMS online databases, previously introduced in the WEEDS extension of
      CLASS.

- CLASS
    - The WEEDS extension was mostly rewritten to use the new possibilities
      offered by the new LINEDB language.
    - A filler is now offered for external teams writing the Class Data
      Format (e.g., APEX). A Fortran API and a Python overlay (provided as
      a Python module) are available. The documentation is available at the
      following URL http://www.iram-institute.org/medias/uploads/class-filler.pdf

- MAPPING
    - The VIEW command was introduced to deliver the GO VIEW
      functionalities on the internal buffers.

## Mar14

No release.

## Feb14

- Build
    - Cygwin is now again supported.

- Kernel (SIC and GREG)
    - "SIC LOGICAL" without argument will now list the current values of
      all the logical variables, in a compact and alphabetically ordered
      view. "SIC LOGICAL Pattern" allows the user to search for a logical
      name using wildcards.
    - The "SIC RANDOM_SEED" command was introduced to give to the user a
      fine control of the random seed to the user. The default is now a
      random seed based on current date and time (before it was depending
      on the compiler behavior).

- CLASS
    - Two changes happened when making the header of an averaged or
      stitched spectra: 1) the telescope name is now made of the common
      intersection of all the spectra telescope name. For instance, when we
      averaged 30ME0VLI-V01 and 30ME0HLI-V02, the result will be
      30ME0-LI-V0-. 2) DOBS is now set to the new date of all the averaged
      spectra.
    - The X label ("Rest Frequency") position now takes into account the
      G\SET EXPAND factor.

## Jan14d

- ASTRO
    - The PdBI sensitivity estimator was upgraded to take into account the
      0.8mm receivers.

## Jan14

- CLASS
    - The "SET VARIABLE section WRITE" was fixed, as a SWAP command was
      transfering the variable states from RW to RO following an internal
      rewritting of the code supporting the R and T buffers in December
      2013.

## Dec13

- MIRA
    - It was adapted to support the new 2SB capabilities of the 2mm band
      of the EMIR receiver.

- CLASS
    - XY_MAP can now write cube in LMV or VLM order.
    - DSB deconvolution code for Herschel was updated.
    - Starting with this version, CLASS will accept to read transparently
      Class Data Format V2 files. Writing default remains V1 for the
      moment. This will be changes simultaneously in GILDAS distributions
      and at the 30m in a few months from now.

- CLIC
    - The flux and position of our main secondary flux calibrator, MWC349,
      were reviewed.
    - A new secondary flux calibrator, LkHa101, whose LST visibility nicely
      complements the MWC349 one, was introduced.
    - The monitoring of the phase shift due to change of cable length was
      improved.
    - The detection of parasites in the bandpass calibration was
      introduced.
    - The fact that the quasars used as calibrators can be polarized
      sources were taken into account to improve the amplitude calibration

- MAPPING
    - Mosaic of more than 99 fields are now supported.
    - Several tasks working on UV tables (UV_AVERAGE, UV_EXTRACT, UV_NOISE)
      now accept the definition of a subset of the frequency/velocity axes
      in channel, frequency, or velocity units.
    - The ALMA cycle 2 configurations files were added for use in the ALMA
      simulator.

## Nov13

- Kernel (SIC and GREG)
    - Synchronisation problems (hanging keyboard) under MACOSX were fixed.
    - The SIC language was enriched with the FLOOR and CEILING functions in
      addition to the INT and NINT existing ones.
    - SIC sort is now able to sort arrays of 1) strings, and 2) long
      integer, i.e., INTEGER(kind=8).
    - Typing V in the channel or area image of the GO VIEW facility will
      now give the coordinates at the cursor location.
    - In the mode where the image axes are automatically defined, the
      REPROJECT task now ensures that 1) the value at reference pixel is
      0.0 (i.e., on the center of projection), and 2) the reference pixel
      is an integer value so that the grid is aligned on the projection
      center instead of the left edge of the output image.

- ASTRO
    - The frequency plan associated to the new NOEMA LO system was
      upgraded.

- CLASS
    - NEW_DATA behavior was changed. It now only waits for new data and
      return when it appeared in the input file. There is no more
      time-out. The user has to spawn a FIND command so that he fully
      controls how to upgrade the current index. For instance, FIND
      NEW_DATA will only find the new data, according to all other
      selection rules of the FIND command.
    - LIST /TOC /VAR varname is now putting the table of content into the
      varname SIC structure instead of the default TOC% SIC structure. This
      varname SIC structure is a global structure. It's the user
      responsability to remove it when it is not useful anymore. This gives
      an easy way to keep in memory a given table of content even when a
      new LIST /TOC command is spawned.

## Oct13

- Kernel (SIC and GREG)
    - The "SIC DEBUG PYTHON" command displays the python version which
      was used to compile GILDAS and the one used at run time. Different
      versions mean troubles.

- CLASS
    - The AVERAGE engine was incorrectly saying that an index was
      consistent in case only the first and last spectrum of the index were
      consistent. This happened rarely in practice. This is now fixed.

## Sep13 Only minor updates because of summer vacations

## Aug13

- Build
    - gfortran version 4.6 is now rejected by gildas-env.sh. This version
      has a bug that leads to wrong (non-minimized) fits in CLASS.

- CLASS
    - The spectroscopic section is now REAL(8) in memory (still REAL(4) on
      disk). This ensures backward compatibility while it enables to make
      more precise computation in memory. As all the computation are anyway
      done in double precision, there is no lost of computing efficiency.
    - The "VARIABLE /INDEX" command will read (from file) and save (in
      memory) in Sic arrays the named sections of all entries in the current
      index. The Sic arrays will be available in the structure IDX%HEAD%,
      under each named section.  Any further call to FIND, DROP, and
      NEW_DATA (i.e. commands which modify the current index) will destroy
      the Sic arrays. For efficiency purpose, they are not recreated
      implicitly, the command VARIABLE /INDEX must be called again instead.
      The command is experimental. In particular, it is unclear whether the
      command name is good and we may change it in coming months.

## Jul13

- Kernel (SIC and GREG)
    - The "GTV\REFRESH" command was introduced to force to redraw all or
      some windows, i.e., it resurrects the behavior of the obsolete
      "GTV\ZOOM REFRESH".
    - "COMPUTE Modification_Date DATE Filename" now returns the file date
      as the number of nanoseconds since 1970, Jan. 1st. This enables a
      much finer file date comparison on OSes and filesystems which allow
      such a granularity. For other OSes and/or filesystems, the number of
      nanoseconds is rounded to their filetime precisions.
    - The global variable GTV%FITPAGE was added to implicitely force the
      option /FITPAGE of the HARDCOPY command. The header of encapsulated
      postscript files now contains a LANDSCAPE or PORTRAIT marker to guide
      the postscript viewers.
    - To conform to the FITS standard, GILDAS now converts blanked values
      to NaN when writing floating point values (BITPIX=-32).

- CLASS
    - MODIFY BEAM now also scales the associated header parameters (e.g.,
      Tsys, sigma) in addition to scaling the spectrum.
    - FITS READ is now working again when the output file is of type
      MULTIPLE.

- ASTRO
    - UV_TRACK is not anymore limited by the number of opened files.

- CLIC
    - The detection of the parasites in the pipeline is being improved.

- MAPPING
    - The new task UV_ADDNOISE adds thermal noise to a model UV table.

## Jun13

- Build
    - Python 3 is now rejected by gildas-env.sh. This is a temporary steps,
      needed as long as the GILDAS kernel does not fully support it.

- Kernel (SIC and GREG)
    - Tasks GAUSS_2D, HISTO_CLOUD, and REGRESSION work again.

- ASTRO
    - can now parse the ALMA Observing Tool files (.aot) and plot the
      frequency setup.

- MAPPING
    - The "/TRIM ALL/ANY" option was added to the READ UV command to enable
      to filter at read time (instead of at uv_mapping time) flagged
      visibilities. This is almost all useful for ALMA UV table, which may
      contain lot's of flagged visibilities. For PdBI data, CLIC filters out
      flagged visibilities when creating the UV table.
    - The task to apply the gain (UV_CAL) is not anymore assuming anything
      about the ordering of the gain table with respect to the ordering of
      the data.

## May13c (10-oct-2013)

- Kernel
    - Fixed reading/writing binary data (including e.g. Class files)
      which may have been done incorrectly on some systems.

## May13b

- Kernel (SIC and GREG)
    - The "GTV\REFRESH" command was introduced to force to redraw all or
      some windows, i.e., it resurrects the behavior of the obsolete
      "GTV\ZOOM REFRESH".
    - The global variable GTV%FITPAGE was added to implicitely force the
      option /FITPAGE of the HARDCOPY command. The header of encapsulated
      postscript files now contains a LANDSCAPE or PORTRAIT marker to guide
      the postscript viewers.

- CLASS
    - MODIFY BEAM now also scales the associated header parameters (e.g.,
      Tsys, sigma) in addition to scaling the spectrum.
    - FITS READ is now working again when the output file is of type
      MULTIPLE.

## May13

- Kernel (SIC and GREG)
    - The command "SIC TIMER [Time [HOURS|MINUTES|SECONDS]]" allows the
      user to customize the inactivity time that will enforce to exit the
      SIC interpreter. SIC TIMER 0 desactivates this timer.

- MIRA
    - The skydip reduction now enables to fit either the opacity and the
      forward efficiency together or only the opacity.

- CLASS
    - "WRITE 0" indicates to CLASS that it should automatically choose the
       next unused observation number in the output file. This avoids to
       inadvertently write a different version of an already existing
       spectrum.
    - "AVERAGE/ACCUMULATE/STITCH" now sets the observation number to 0 in
       RAM memory so that CLASS will automatically choose the next unused
       observation number in the output file, when writing the spectrum
       (see previous point).

## Apr13

- General
    - Numpy 1.7 & 1.8 are now supported. Support for Numeric is
      obsolescent, i.e. it will be removed in a near future.

- CLASS
    - It is now possible to copy a frequency subset of a given index
      through the following command sequence:

	LAS> file out coucou single
	LAS> file in file1
	LAS> find
	LAS> extract 97000 97100 f /index
	LAS> file in file2
	LAS> find
	LAS> extract 97000 97100 f /index
	...
      This is useful for instance when trying to reduce OTF observations of
      the same source observed several days in a row.
    - The GET command was speed up significantly by a combination of two
      actions: 1) The access to SIC variables was made more efficient and
      2) the redefinition of SIC variables associated to CLASS internal
      arrays now happens only when needed.
    - The files necessary to read the SOFIA user section have been
      made available in any new GILDAS version. Up to now, they were
      available only in the may12 version.

- MAPPING
    - The UV_BASELINE command was introduced to subtract a continuum from a
      line UV data set, by fitting a baseline for each visibility.

## Mar13

- Kernel (SIC and GREG)
    - "SET AXIS EXPO Z" enforces the exponential notation when labelling the
      intensity scale in color look up tables (e.g., through the WEDGE
      command).
    - "SHOW LIMITS ABS" now displays the current limits in absolute
      coordinates.

- CLASS
    - The Arizona Radio Observatory SubMillimeter Telescope (SMT) is
      now recognized in Class (support improved, in particular for
      Doppler computations).

- CLIC
    - CLIC is now backward compatible with data older than 2007 (previous
      receiver generation). It means that clic07 is obsolete, i.e., nor
      supported neither distributed anymore.

## Feb13b (08-feb-2013)

- CLASS
    - The conversion from a FITS file to a CLASS file (kind multiple)
      is fixed (command LAS\FITS READ).

## Feb13a

- CLASS
    - The Herschel/HIFI instrument is now recognized by the TABLE and
      XY_MAP commands.
    - The logic of definition/usage of the telescope HPBW was clarified in
      the TABLE and XY_MAP commands. See the online help for details.

## Jan13

- Kernel (SIC and GREG)
    - The MAP_SUM task was fixed (broken since may12 release).

- CLASS
    - Command LOAD now ignores inconsistent offsets: It implicitly implies
      a /NOCHECK OFFSETS.
    - A message will display the average flux used by the command "BASE
      /CONTINUUM [Flux]", in order to avoid dividing by a value close to
      zero.

- MAPPING
    - The UV_SPLITPOLAR task reorganizes ALMA data (converted in UVT with
      the FITS command) so that the two polarizations of ALMA can be
      handled by mapping. Please, check the on-line help for more
      information. N.B.: The ALMA tables must first be filled in a GILDAS
      uv table by the FITS command. See news of Dec12 release.
    - Phase antenna-based self-calibration tasks were debugged. They are
      working now giving good results on small objects with flux larger
      than about 20 mJy. Amplitude self-calibration still to be debugged.
    - UV_EXTRACT user interface was enlarged to accept a velocity and/or a
      frequency range but the help still needs to be updated.
    - The default weight column returned to the middle of the bandwidth,
      probably following a wrong commit. It was put back to 1/3rd of the
      bandwidth.
    - MODIFY FREQUENCY enables to change the rest frequency for all the
      mapping related tables and cubes (dirty, clean, etc...). More tests
      are needed.

## Dec12

- Build
    - Only GFORTRAN versions newer than 4.4 are now supported.

- CLASS
    - The new handling of the frequency/velocity axes is now officially the
      default in CLASS. This implies some changes of behavior of the
      CONSISTENCY, TABLE, AVERAGE and RESAMPLE commands.
    - For instance, the /NEW option of the AVERAGE command was removed, the
      new behavior being made the default. The /2010 option was added to
      keep the old behavior in case of need (remember that the old behavior
      is not correctly handling the frequency/velocity axis for very wide
      bandwidth spectra). The online help is up-to-date.
    - The TABLE command was brokened since may12 when trying to produce a
      table on a subset of frequency/velocity. It is fixed, starting with
      this version (the fix was backported to the may12??? version).
    - The syntax of the STAMP command was generalized. The new behavior is
      documented in the online help.
    - Two experimental commands were added: 1) UNBLANK which replaces
      blanking values in tables which serve as input to the XY_MAP
      commands.  2) The SUBTRACT command which computes T-R and puts the
      result in the R buffer.

- MAPPING
    - The FITS command now recognizes the CASA UVFITS style.
    - The ALMA simulator now is able to process mosaics of up to 256
      fields.
    - Obsolete task UV_SINGLE was definitely removed. It is replaced by
      task UV_SHORT.

## Nov12

- Build
    - The GILDAS administrative scripts were made POSIX compliant.

- Kernel (SIC and GREG)
    - Minor bug fixes in the REPROJECT and CORRELATE tasks.
    - Command "G\SET LABEL EXPO|NOEXPO [X|Y]" (see news of may12a) is
      renamed "G\SET AXIS EXPO|NOEXPO [X|Y]", as this is a more consistent
      placeholder for this functionality.
    - Added the [Offset] option to the "LABEL /X [Offset] and /Y [Offset]"
      in order to fine tune the position of the label. "SET LABEL X|Y
      [Offset]" was also added to obtain a persistent effect.
    - The /VARIABLE option of the RANDOM command enables it to work on any
      variable. The default remains to work on the X, Y, Z variables.
    - The /ONLY option of the RGMAP /GREY command enables to select the
      (positive or negative) levels, which should be filled.

- ASTRO
    - The PDBI\ and ALMA\ languages were separated, although they share
      some common commands. Each language is activated when the proper
      observatory is selected. The HELP has been restructured accordingly.

- CLASS
    - The command "AVERAGE /NEW" now keeps the part of the telescope name
      which is common between the averaged spectra. This ensures that the
      telescope can be found afterward in, e.g., the TABLE+XY_MAP
      combination.

- CLIC
    - Many minor changes to improve the calibration pipeline.

- MAPPING
    - The /PLANE option of READ command was fixed for images.
    - The task UV_HYBRID is now protected against blanking values.

## Oct12

- Generic
    - '-v' and '-h' are again recognized options in the calling sequence of
      any GILDAS program.

- Kernel (SIC and GREG)
    - The dash style are now correctly displayed when a large zoom factor
      is applied.

- ASTRO
    - The italian MEDICINA telescope is now recognized.

- CLASS
    - The following CLASS defaults have changed: SET PLOT is now HISTO,
      SET FORMAT is LONG and SET UNIT is FREQ VELO. The last one
      is to ensure that naive users of the IRAM-30m don't think that their
      data is wrong because they see lines at velocity far from the LSR
      velocity they input in the setup!

- MAPPING
    - The task UV_MODEL is working again after a change for GDF V2.

## Sep12

- Kernel (SIC and GREG)
    - Port of the GILDAS python binding to python 3 started. This implies
      that support of python 2.4 will stop.
    - The line thickness of the PNG device was made more WYSIWIG.
    - The rotation angle (deduced from CD matrix) was lost when converting
      from FITS to GDF after the changes for GDF V2. It is now back.
    - The task BLANKING is working again after a change for GDF V2.

- CLIC
    - A major upgrade of CLIC happened. This ensures 1) simplification of
      the bookkeeping of the atmospheric calibration (including
      polarimetry), and 2) full backward compability with data taken before
      January 2007.

## Aug12

No release.

## Jul12b 2012-jul-03

- ASTRO
    - ALMA Cycle 1 correlator modes description have been added.

## Jul12a

- Kernel (SIC and GREG)
    - The package widgets now have a demo menu which enables to launch
      procedures demonstrating a subsets of the package capabilities.
    - The useless HELP button was replaced by a useful menu which points to
      all the documentation available in GILDAS.
    - The commands which are able to fill part of the screen (POLYGON,
      ELLIPSE, HISTOGRAM) are now able to fill with hatches through the
      /HATCH option.

- ASTRO
    - UV_TRACK can now be used with the ALMA configuration files.
    - The Atacama Compact Array (ACA) was added as an observatory to get
      the correct antenna diameter and the correct shadowing tests in
      uv_track.

## Jun12

- Kernel (SIC and GREG)
    - Additional operations on complex numbers were added in the COMPUTE
      command (COMPUTE CMPADD|CMPSUB|CMPDIV).

- CLASS
    - GET ZERO now rewinds the internal index counter to zero. The next GET
      NEXT command will thus returns the first spectrum of the index.
    - Now SET MODE X can be called even when the R buffer is empty.
    - SET MODE X|Y|Z CURRENT now sets the limits of the plots to the last
      plotted limits. This is useful when the user tries to overlay
      spectrum with the same X and Y scales.
    - The color used to plot a spectrum can now be defined in the command
      line through the "/PEN ipen" option of the SPECTRUM command.
    - The EXPERIMENTAL\ language was added to group new commands in
      development. The name, options, syntax, and behavior of the commands
      in this language are expected to evolve. Some commands will at some
      point join another stable language, some will disappear. This
      language currently holds the WAVELET, RMS and FILTER commands.
    - The elevation and azimuth of an observation are now converted in
      degrees when exported to FITS in the INDEX mode. This breaks backward
      compatibility with previously written FITS, but this is consistant
      with the behavior at import and export times (SPECTRUM mode) and
      import time (INDEX mode).

## May12b 02-jul-2012

- CLASS
    - The files necessary to read the SOFIA user section have been
      made available.

## May12a

- General
    - Small bugs were regularly found after the first beta release of
      GILDAS with the GDF-V2 support (see jan12 news). These were fixed as
      soon as known. The may12 version of GILDAS is now stable: 1) As of
      today, there are no known bugs. 2) All potential GDFV2-related bug
      fixes will be backported to this version.  The may12 version of
      GILDAS will be used online at the 30m and Bure.
    - As a consequence monthly releases will restart with the may12
      version.

- Kernel (SIC and GREG)
    - GILDAS hypercubes can now have up to 7 dimensions.
    - The TRANSPOSE command now supports all possible kinds of
      transposition of a 3D cube.
    - A protection against integer overflow has been added in SIC, e.g.
          SIC>  define integer i
          SIC>  let i 1/1.e-12
          E-MATH,  Value 1000000000000 is too large to accomodate in an INTEGER*4
      The limit for standard integers is 2**31-1 (about 2e+9). Older
      versions of SIC were just accepting transparently overflowed
      (and thus wrong) values. If one of your procedures raises this
      error, you should try the following steps:
      1) Does the variable really need to be integer? Can it be
         replaced by a single or double precision floating point
         variable?
      2) What computation raises the error? Can it be protected
         against extreme values (e.g. almost-zero division) which
         probably does not make much sense in this context?
    - SIC\SORT can now also sort character arrays.
    - Command G\SET LABEL EXPO|NOEXPO [X|Y] is added. It allows the user to
      control the use of the linear or exponential notation when labelling
      an axis.
    - PostScript header produced by the HARDCOPY command now also contains
      the GILDAS release name which was used to generate it.
    - In the MOMENTS task, the velocity range will be automatically
      computed if the input range is 0 AND 0, and not anymore if one or the
      other is 0.
    - png produced by the HARDCOPY command can now fit exactly the Greg
      plot through "HARD /DEV PNG CROPPED".

- ASTRO
    - Nobeyama was added in the list of known observatories.
    - The 30m time/sensitivity estimators were upgraded to reflect the
      change of EMIR receivers from SSB to 2SB mixers.

- CLASS
    - In the framework of the correct handling of the frequency/velocity
      axes, engines 1) to check the index consistency and 2) to resample
      are being factorized between CONSISTENCY, TABLE, AVERAGE and
      RESAMPLE.
    - This implies that the calibration and the offsets consistency are
      also checked by default. A tolerance was added on all header
      parameters which can vary a bit for the consistency check. For
      instance, a tolerance of 10mas is accepted for the projection center
      coordinates. Type HELP CONSISTENCY for detailed information.
    - For the RESAMPLE command, if the x-axis unit is frequency, the
      frequency resolution (Xinc) is assumed to be given in the rest frame,
      and it is implicitely converted to the observatory frame. = is the
      wildcard to reuse the previous resolution in the observatory frame.
    - FIT\LINES now enables to put the parameters on the command line (on
      string in quotation per line parameters). The limit is the size of
      the command line (2048 characters). This limit can easily be reached
      in automatic scripts. So the recommandation is to still use ASCII
      files in automatic scripts. Moreover, the /SHOW option was added to
      the FIT\LINES command to show what initial guesses have just been
      defined by the command.

- CLIC
    - SET POLARIZATION EACH was added to the usual SET POLARIZATION
      V|H|BOTH to be able to do actions on both polarizations separately
      with single commands.
    - There are tests to correct the visibilities for the source shapes of
      a number of known objects (MWC349, CRL618,...) using 2D models of
      these sources. This is to improve the flux calibration when the
      primary calibrators are resolved. The weights are modified at the
      same time as the amplitude.

## Apr12

No release.

## Mar12

No release.

## Feb12

No release.

## Jan12 **** BETA release ****

- Important warning
     - The size of the datasets produced by the current and future
       radio-instruments experience a tremendeous increase (because of
       multi-beam receivers, wide bandwidth receivers, spectrometers with
       thousands of channels, and/or new observing mode like the
       interferometric on-the-fly). After improving the visualization of
       GILDAS (project known as GREG2011), a large upgrade of the GILDAS
       Data Format (project known as GDF-V2) was introduced in 2011 to
       support arrays of more than 2 giga elements (the limit that an
       INTEGER*4 can encode).
     - This change was done so that GILDAS will still be able to read the
       version 1 of the GDF format (backward compatibility). However, this
       implies a change of the associated fortran type which will not be
       fully compatible with the current code (the array dimension will be
       changed from INTEGER*4 to INTEGER(kind=index_length) with
       index_length =8). The documentation is being written.
     - To avoid mixing problems, the usual GILDAS release policy was
       temporarily changed: The kernel team skipped many releases in
       2011. Instead, important changes of GILDAS were ported in successive
       release fixes of the Apr11 version. After extensive tests at IRAM,
       the GILDAS development version can be safely released as beta, i.e.,
       we encourage our users to test it and to report any bugs to
       gildas@iram.fr.
     - Please note that:
        - the SIC image structure changed
            I%DIM    is now a long integer array,
            I%MINLOC and I%MAXLOC array coordinates in the datacube replace
                     the I%WHERE[1] and I%WHERE[2] "flat" values resp.,
        - in the context of UV tables, the following variables are now
          available:
            I%NCHAN    integer, number of channels
            I%NVISI    long,  number of visibilities
            I%NSTOKES  integer, number of Stokes states
            I%NATOM    integer, size of visibility
            I%BASEMIN  real, minimum baseline
            I%BASEMAX  real, maximum baseline
        - HEADER /EXTREMA computes BASEMIN et BASEMAX for a UV table
          (while it computes extrema values and positions for a
          standard image).

- Build
     - Only GTK+-3.0 is supported.

- Kernel (SIC and GREG)
     - The kernel team think to have fixed the bug which randomly prevented
       the reading of binary files (e.g. CLASS files). The diagnostic
       command "SIC DEBUG GFORTRAN" command (see the Aug10 NEWS for a
       detailed description) should always return the following output
         I-SIC DEBUG,  No problem during the IEEE to EEEI conversion
       Please send an email to gildas@iram.fr if this is not the case.
     - The REPROJECT task now returns an error when the user provides a
       non-zero angle with the RADIO AND AITOFF projections.
     - The default size of the HARDCOPY /DEV PNG command was increased from
       600x420 to 800x560.

- ASTRO
     - Planet names are correclty read after the HORIZON /PLANET
       command.

- CLASS
     - The algorithm to check the spectroscopic consistency was revised to
       be more generic. The signal frequency and velocity axes are now
       checked to be correctly aligned to a given tolerance, taking into
       account the Doppler factor. In details, the channels at the edges of
       the spectrum must be aligned to better than a fraction of the
       channel width (default is 10%). The image frequency axis is not
       checked.
     - The array of present sections was added in the R%HEAD structure
       under the name R%HEAD%PRESEC. The sections codes are delivered in
       the CLASSCODES structure.
     - "MODIFY BEAM_EFF /RUZE B0 Sigma" was introduced to modify the beam
       efficiency of large bandwidth spectra using a physical background,
       namely the Ruze's equation, which relates the beam efficiency to the
       surface accuracy of the antenna (Sigma):  Beeff(freq) =
       B0*exp(-(4*pi*Sigma*freq/clight)**2) If the beam efficiency
       previously had a non zero value, a rescale factor is evaluated for
       each channel and it is applied to the intensities. The new beam
       efficiency is currently set to the beam efficiency value at the
       center of the spectrum.  Otherwise, only the beam efficiency is set
       to this new value. In a future version, B0 and sigma will be stored
       in the spectra header.
     - WEEDS starts to be able to use different databases in the same
       session. In particular, WEEDS\LID prints the name of the database in
       which the line was found and WEEDS\MODSOURCE can use a different
       database for each species.
     - DECONVOLVE, which implements DSB deconvolution, was upgraded and
       backported into apr11.

- MAPPING
     - The new UV_FIT-PROPER task fits the source proper motion in addition
       to a source model. Documentation still to be upgraded.
     - The UVSHIFT widget works again.
     - The (preliminary) cycle 1 configurations were added to the ALMA
	simulator under the names aca-cycle1.cfg (6 antennas)
	alma-cycle1-*.cfg (32 antennas, 9 configurations).

## Dec11

No release.

## Nov11

No release.

## Oct11 **** BETA release ****

- Kernel (SIC and GREG)
     - A major effort happens to be able to read/write/process arrays of
       more than 2 giga-elements.
     - The /BLC and /TRC options were added to the VECTOR\FITS command 
       in order to enable the reading of a contiguous subcube of a FITS
       cube.
     - The VECTOR\FITS command is now able to write/read data cubes in a
       compatible way with CASA.
     - The maximum length of arguments of the SAY command is increased
       from 256 to 1024 characters.
     - "GO GOLOR" calling sequence was changed following the GREG2011
       project (see the Feb11 news). The new calling sequence is now "GO
       COLOR threshold" where threshold is the color scale range in
       percentage over which is modified to "hide" noise around 0.

- CLASS
     - Renamed the /SEARCH option of the WEEDS\LGET command into /INDEX for
       consistency with other CLASS commands.
     - The WEEDS\SCANFIND command now works in VELOCITY unit.
     - The "12M-" string inside the TELESCOPE field now points to the
       KITTPEAK ARO 12m telescope.
     - A detailed description of the shell fitting method is now available
       in the PDF documentation.
     - The LMV command now correctly fills the coordinates of the
       projection center.
     - "FIND /SECTION section-name" now selects all the observation which
       contains the section-name section (e.g. the optional base section).

- MAPPING
     - The new MODIFY FREQUENCY command enables to consistently recompute
       the velocity scale of all data files (UV, Dirty, Clean, ...) to
       the desired value.
     - The new UV_STAT HEADER command now computes the minimum and maximum
       baseline and store them in the UV_BMIN and UV_BMAX SIC variables.

## Sep11

No release.

## Aug11

No release.

## Jul11

No release.

## Jun11

No release.

## May11

No release.

## Apr11i 11-jan-2012

- Kernel (SIC and GREG)
     - Labelling of the equatorial system is desambiguized (minutes are now
       displayed when needed).

- MIRA
     - The reference channel of the HERA backends is correct again.
     - The support for the upgrade of the EMIR band 2 and 3 is now
       available.
     - MIRA now uses the standard GILDAS initialization system.

- CLASS
     - The GET command correctly update again the coordinate system
       according to the SET SYSTEM request.
     - The TABLE command will not complain anymore when the spectroscopy
       axis is inconsistent as it anyway enforces automatic resampling.
       The TABLE OLD (used to append spectra to a old table) was fixed to
       avoid loosing the last spectrum of the old table.
     - The GREG /FORMATTED command now correctly translate offset
       frequencies to absolute frequencies for the image axis.
     - The LAS\FITS WRITE command now writes 32 bits real by default
       (instead of 16 bits real) to increase precision (in case of high
       dynamic spectra).
     - The /FFT option of the RESAMPLE command works again.
     - The SOFIA user section was upgraded.

- MAPPING
     - GO SETUP is now working for mosaics under all operating systems.

## Apr11h 7-sep-2011

- Build
     - The MS/WINDOWS binaries are now built using the native WINDOWS
       system libraries with MINGW.

- Kernel (SIC and GREG)
     - The SVG filler is now disabled (as it was not working anymore
       following the GREG2011 project, see NEWS for the Feb11 beta
       release).

- MIRA
     - For 2SB receivers, the reference channel of the spectra belonging to
       the untuned band (i.e. the band for which no frequency is stopped by
       the LO) was corrected for the doppler factor. As the sideband
       separation of the E0 mixers is 12.5 GHz, this correction amounts up
       to 0.5 MHz.

## Apr11g 29-jul-2011

- Build
     - gfortran is now the default FORTRAN compiler (even under MAC OSX).

- Kernel (SIC and GREG)
     - The EXAMINE command displays again variable values for all
       structure components but arrays. This behavior was mistakenly
       removed during some code cleaning a while ago.

- MIRA
     - The support of the Broad Band Continuum backend was added.

- CLASS
     - GO BROWSE was extended to be able to overlay a line ASCII catalog
       (when only when the current X unit if F or I). The default ASCII
       catalog is the ASTRO one. Its user interface also evolves to be
       closer to user needs.
     - The EXTRACT command now enable to extract a given number of channels
       from the current spectrum in the R buffer.
     - The /IMAGE option of the STITCH command allows the user to stitch
       the spectra in the current index using the IMAGE frequency axis
       (useful for DSB spectra). The user can now specify the LINE and
       TELESCOPE field in the STITCH command, e.g. "STITCH /LINE 3MM-SURVEY
       /TELESCOPE IRAM-30M".
     - In order to answer the request to output instrument-specific
       parameters in the CLASS data format (e.g. SOFIA\GREAT), a generic
       user section mechanism was introduced. The documenation is available
       at the following URL:
	   http://www.iram.fr/IRAMFR/GILDAS/doc/pdf/class-user.pdf
       It is unclear whether this mechanism will be efficient. So its use
       should be carefully thought and tested.

## Apr11f 29-jun-2011

- Build
     - Fixed the 32bit compilation for MAC OSX.

- Kernel (SIC and GREG)
     - The main menu is back under the Unity window manager (available with
       ubuntu).

## Apr11e 1-jun-2011

- ASTRO
     - The APEX coordinates and the IRAM-PdBI sun avoidance limit were
       upgraded.

## Apr11d 12-apr-2011

- MAPPING
    - The ALMA simulator now contains the official configurations of the
      ALMA early science (cycle 0).
    - The short-spacings processing (GO UVSHORT) is fixed.

## Apr11c 7-apr-2011

- kernel (SIC and GREG)
    - Fixed the dashed pattern of the DRAW LINE command.

## Apr11b 4-apr-2011

- Build
    - Fixed compilation.

## Apr11a

- Important message
    - The Apr11 gildas release if the first stable release including the
      changes linked to the GREG2011 project (see NEWS for the Feb11
      beta release).
    - Starting with this release, the Linux, MacOSX and Windows version of
      GILDAS share the same source codes. They thus should work equally
      well.

- Kernel (SIC and GREG)
    - The "PENCIL /COLOR -1" was introduced to invert the underlying image
      color. This works only with the PNG or IMAGE devices for the
      moment. The other devices (PS and SVG) will use the foreground color
      (0) instead.
    - The new GTVL\LENS command calls the interactive lens. This lens can
      also be called through the middle mouse button when the mouse pointer
      is inside the plotting window.

- CLASS
    - The TABLE command now returns an error if the number of elements is
      larger than 2**31-1 (maximum size currently allowed in the Gildas
      Data Format).
    - The LMV command now accepts interruption through CTRL-C.
    - "FIND /SECTION Foo" select all observations for which the given
      section is defined.
    - The display of the following velocity types, Observatory and Earth,
      was fixed in the HEADER and PLOT commands.

- CLIC
    - The calibration pipeline is now able to output intermediate files in
      a subdirectory.

## Mar11 **** BETA release ****

- Kernel (SIC and GREG)
    - Many bug fixes linked to the GREG2011 project (see NEWS for the Feb11
      beta release).
    - As part of the modernization of the GILDAS kernel, the X/Y/Z image
      commons were replaced by instanciations of the equivalent GILDAS
      fortran type.
    - The task SPECTRUM will now complain (instead of crash) when the user
      wants to extract a position off the cube.

- CLASS
    - The LMV command now transfers the projection information (center and
      angle) from the cube header to the output observations.

- MAPPING
    - MAPPING does not crash anymore when no primary beam was given in
      mosaic modes.

## Feb11b **** BETA release ****

- Kernel (SIC and GREG)
    - Several bug fixes of the beta version.

## Feb11 **** BETA release ****

- Important warning
     - The size of the datasets produced by the current and future
       radio-instruments experience a tremendeous increase (because of
       multi-beam receivers, wide bandwidth receivers, spectrometers with
       thousands of channels, and/or new observing mode like the
       interferometric on-the-fly). Visualizing these datasets in a fluent
       way is a challenge, which requires the best use of the available
       hardware and operating systems (multi-cores processors and
       multi-window environments). This prompted a large rewriting of the
       part of the GILDAS kernel in charge of the interface between the
       plotting facilities and the system (project known as GREG2011).
     - The main guidelines of this rewriting were 1) the backward
       compatibility when possible, 2) the use of modern standards as the
       multi-threading or the GTK+ toolkit, 3) the factorization of the
       source code for different OS (Linux, Mac OSX and MS Windows), 4) the
       implementation of new facilities like a PNG output or an interactive
       lens. Everything is fully documented here
         http://www.iram-institute.org/medias/uploads/greg-2011.pdf
     - After extensive tests at IRAM, this version can be safely released
       as beta, i.e., we encourage our users to test it and to report any
       bugs to gildas@iram.fr.
     - Please note that:
          1. We do *not* support anymore older versions of the gildas
             kernel.
	  2. The new version of the gildas kernel implies different
   	     system dependencies:
                + The MOTIF widget toolkit is replaced by the GTK+ toolkit.
                + Only GFORTRAN (versions >= 4.4.6, 4.5.2 and 4.6.0) and
		  IFORT (version >= 11.0) fluently supports multi-threading
		  (g95 seems to be dying:  No activity on the web page
		  since August 2010).

- MIRA
     - Reading of 'gzip' compressed IMBFITS is now possible.
     - Lot's of work to support the FTS (speed benchmark, chunkwise
       calibration).

- CLASS
     - The LMV command now knows how to handle MULTIPLE files (files
       enabling multiple version of a given spectra).
     - The XY_MAP task was removed: It was an old scory. The XY_MAP
       command replaces it advantageously (e.g. more features). The
       XY_MAP documentation was upgraded to better explain how to
       change the convolution kernel (e.g. the MAP%RESO parameter).

- MAPPING
     - First steps to support continuum imaging for very broad band data
       (commands UV_FILTER, GO FILTER, and UV_CONT). The current method is
       simple. It will need tuning and variants, but it works well to
       remove the birdies and strong lines.

## Jan11

No release.

## Dec10c

- CLASS
     - Fixed the sign of the correction on the image frequency axis in the
       MODIFY VELOCITY command. This is very useful for DSB spectra (e.g.,
       some of the HIFI receivers).

## Dec10b

- MAPPING
     - Fixed a segmentation fault in the UV_MAP task used (in particular)
       in the ALMA simulator.

## Dec10

- CLASS
     - SHOW SCAN and SHOW SUBSCAN are now available.
     - Error when reading from the prompt the inputs of the LINES command
       is not fatal anymore.

- MAPPING
     - "READ UV file /PLANE first last" is working again.

## Nov10

- Kernel (SIC and GREG)
    - The new /OUTPUT option of the TYPE command now allows the users to
      redirect the typed commands of the current session into a user
      defined output file.
    - The gildas FITS converter now better handle the header of the gdf
      images, i.e., a round-trip (gdf->fits->gdf) do not loose information
      anymore.

## Oct10

- CLASS
    - It is now possible to select all the spectra of a files whose
      frequency axis intersect a given frequency range with either the
         SET FREQUENCY Freq1|* [Freq2|*] [SIGNAL|IMAGE]
      or the
         FIND /FREQUENCY Freq1|* [Freq2|*] [SIGNAL|IMAGE]
      Refer to the online help for a full description of the command
      behavior.
    - The possibility to output the result of "LIST /TOC" to a file
      (through the "/OUTPUT file" option) was added.
    - "SET CURSOR ON|OFF" is now obsolete. It is kept with a warning
      for backward compatibility). The cursor is automatically called when
      there is no arguments to the "SET WINDOW" and "SET MASK" commands.
    - "BASE /PLOT" now uses the pen #1 (i.e. red) to plot the fitted
      baseline. "BASE /PLOT Ipen" allows to use another pen.
    - Updated documentation of the data format (SINGLE vs MULTIPLE files).

- CLIC
    - "HEADER /PLOT" now also works for WIDEX.

## Sep10

- Kernel (SIC and GREG)
    - Keyboard history was fixed.

- ASTRO
    - After the change of the PdBI LO system during summer, the new LO
      settings are now the default. Old LO settings can be enforced with
      the "SET PDBI year" command.
    - Changes were done to support the ALMA correlator. As part of this
      work, some improvement of the PdBI correlator setups were done.

- CLASS
    - Solar velocity in the Kinematic LSR frame is set to 20.0 km/s instead
      of 19.5 km/s to be consistent inside IRAM. This affects only the
      happy few who convert their spectra from LSR to Helio frame and
      vice-versa inside CLASS. N.B.: The value of 20.0 km/s is the one used
      today in most radio-observatories.
    - New sections of the R buffer (NH3 and HFS) are being matched in the R
      SIC structure (R%HEAD%NH3% and R%HEAD%HFS%).
    - A misalignment of keyword/value pairs when invoking SHOW ALL, which
      appeared in the jul10 version, was fixed.
    - BASE SINUS was protected against its use with spectra having
      different number of channels.
    - MEMORY|RETRIEVE was made robust.
    - The interactive mode of SET MASK and SET WINDOW now understand mouse
      clicing in addition to keyboard pushing.

- MAPPING
    - Thanks to F.Levrier (from LERMA), the most recent ALMA configurations
      were updated in the ALMA simulator.

- CLIC
    - Many minor bug fixes in the WIDEX support.

## Aug10

- Build
    - The Mac/OSX version is using gfortran (GNU fortran compiler) as
      default compiler. Some gfortran versions have bugs, which prevent the
      reading of binary files (e.g. CLASS files). The "SIC DEBUG GFORTRAN"
      command was introduced to diagnose the problem. Working version of
      gfortran will imply the following output
         I-SIC DEBUG,  No problem during the IEEE to EEEI conversion
      while problematic versions of gfortran will give an output similar to
         E-SIC DEBUG,  Call to subroutine IEI4EI with single I/O variable failed:
           Input:    2147483647  (int4) =    -1   -1   -1  127  (4 int1)
           Output:           -1  (int4) =    -1   -1   -1   -1  (4 int1)
      Please send the output of the command and the version of gfortran
      (obtained with "shell-prompt> gfortran -v") to gildas@iram.fr if you
      encounter the problem.

- ASTRO
    - New 30m time/sensitivity estimators for EMIR, HERA and MAMBO.

- MAPPING
    - The overlay of the fitted curve over the UV data was fixed for the "GO
      UVSHOW" command.

## Jul10

- Build
    - Under Mac/OSX, the use of shared (instead of static) libraries
      enforced in Apr10 and later versions implied instabilities, which are
      now solved. Mac users should upgrade their GILDAS version through
      FINK.

- ASTRO
    - The EMIR, HERA and MAMBO time/sensitivity estimators were fully
      rewritten and documented.

- CLASS
    - CLASS77 is officially obsolete.
    - Following recent improvements in the SET MODE X command, a bug has
      been fixed when the x axis unit is frequency. jul10 and apr10
      releases have been fixed.
    - The R%HEAD SIC structure now matches the header of the spectrum in
      the R buffer. "SET VAR Section" now creates SIC aliases to the SIC
      variables in "R%HEAD%Section%".
    - Single-version class files can not be opened in BOTH input and write
      mode. However, it should be possible to use the TAG and UPDATE
      commands which rewrites the spectrum in the R buffer in place (for
      instance, if the user just want to update the LINE name). The
      single-version class files can now be opened in UPDATE mode for this
      purpose, i.e.  FILE UPDATE single-version-filename.

- MAPPING
    - WRITE CLEAN is now working also under compilers, which do not enforce
      variable initializations, e.g. g95 and gfortran.

## Jun10

- MIRA
    - Now MIRA can process data subscan wise for all kinds of backends. This
      is useful to process and to check long scans (e.g. pointing, OTF) at
      intermediate steps.

- ASTRO
    - The potential parasites of the current receiver/spectrometer system
      of the Bure interferometer are now automatically displayed when
      setting up the observing procedure.

- CLASS
    - FIND /LINE and FIND /SOURCE (respectively SET LINE and SET SOURCE)
      now accept the "*" wildcard anywhere in the input pattern.
    - Introduced the SET%LAS SIC structure, which stores (most of) the
      global control values of CLASS, i.e. the one showed by the SHOW
      command.
    - The maximum number of masks, defined through the SET MASK command and
      used by the MINIMIZE command, was increased from 5 to 100. SET MASK
      now also accepts the /VAR option to read the mask boundaries from an
      input array.
    - An annoying, erratic bug in the reading of FITS file (in particular
      from Herschel/HIFI) was fixed.
    - WEEDS now better handles the JPL data base. A /BACKGROUND option was
      added to the MODSOURCE command in order to select a background
      temperature (default 2.73). In addition the model was modified so
      that the continuum is not substracted from the predicted antenna
      temperature anymore.

## May10

- CLASS
    - SET UNIT is now working again for all combinations of lower and upper
      axe units. A first attempt to fix SET UNIT with one of the axis being
      in image unit broke several other combinations. This affected apr10a
      and may10a releases. apr10c and may10d are now fixed.

- CLIC
    - Many tunings to support WIDEX.
    - The calibration procedures and the calibration pipeline were adapted
      to WIDEX.

## Apr10

- Build
    - Version 0.90 and lower of g95 are not supported anymore because
      version 0.90 is known to compute erroneous values in a 'where'
      fortran statement used at least in CLASS AVERAGE

- Generic
    - '-v' and '-h' are now recognized options in the calling sequence of
      any GILDAS program.

- Kernel (SIC and GREG)
    - The "COMPUTE MEDIAN" command was fixed when the input SIC array was
      of DOUBLE kind.
    - The @ command now accepts absolute path unprotected by double quotes.
    - Users can now define their own language in SIC (and/or PYTHON) with
      the DEFINE LANGUAGE command.

- MIRA
    - MIRA now works under 64 bits machine in full 64 bits mode (i.e. it
      does not need to be compiled in 32 bits compatibility mode).

- CLASS
    - First release of WEEDS (an interface to line databases and line
      modelling). It is automatically loaded into CLASS, *if* a recent
      version of PYTHON (>= 2.6) and the associated NUMPY are available.
    - Opening as input a file of type 'single' closes it for output (if
      it was), since it can not be both input and output.
    - The LMV command which read a spectra cube (FITS or GDF in whichever
      order, ie LMV, VLM,...) is now operational.
    - The frequency resampling is now back (only velocity resampling was
      accepted up to now).
    - SET UNIT IMAGE is now fixed (the plot axis was wrong).
    - PRINT AREA is fixed in many small ways.
    - When stitching different spectra of a line survey into a single
      spectra, AVERAGE was using the doppler factor of the last spectra
      resulting in a incorrect frequency scale. Now the doppler factor of
      the stitched spectra is set to zero.

- CLIC
    - jan07 is not supported anymore. To reduce data older than 2007,
      users should instead use the clic07 version distributed in any new
      GILDAS release.
    - Channel dependent RF calibration is working again.
    - Basic functionalities have been adapted to support WIDEX, the new
      broadband correlator of PdBI.

- MAPPING
    - The READ and WRITE command now enable the use of the * wildcard to
      read/write all the files associated to a single data set, eg
      "READ * FILENAME" and "WRITE * FILENAME" capabilities.
    - The PRIMARY tasks enables again the multiplication of a data set by
      a Gaussian primary beam by setting the beam size to a negative value.

## Mar10

No release.

## Feb10

- Kernel (SIC and GREG)
    - Reprojecting an image in Equatorial projection onto a reference image
      in Galactic projection is now supported by the REPROJECT task.

- CLASS
    - The position of spectra has been fixed in the MAP command.

## Jan10

- CLASS
    - In interactive cursor mode, the commands SET WINDOW and SET MASK now
      display in real time the selected values. A warning is raised if a
      window is only half-defined.

- MAPPING
    - Changed the way the weight associated to the pseudo-visibilities are
      computed in the UV_SHORT task.
    - The computation of the short-spacings weight relative to the
      interferometric weight is now done independently for each field of a
      mosaic.

## Dec09

- Kernel (SIC and GREG)
    - Slight changes to the search through the keyboard history (see nov08
      news for details): 1) The up/down arrows search first in the history
      for a match of the already typed string. If no match exists, go back
      to the usual mode of up/down arrows, i.e. go back/forward in history
      by one element. 2) The space characters at beginning of line are
      ignored in the search.
    - "RUN MAP_INTER" now enables the possibility to have an output axis
      wider than the input axis. For the time being, the channels which
      are not integrated/interpolated, are set to 0. It would be best to
      set them to the blanking value.
    - "SIC LOCK [LockFile]" creates the LockFile file. Trying to create a
      lock file which already exists is a fatal error. Lock files owned by
      the current program session are implicitely deleted when exiting.
    - Command "PROJECTION A0 D0 Angle" now correctly reads the angle.
    - SIC nested structures are now correctly imported in python.

- ASTRO
    - HORIZON /SOURCE now prints the sun avoidance period for all sources.
    - Introduce UV_TRACK /WEIGHT UNIFORM|AIRMASS to write a more
      realistic weight in the uv tables created by UV_TRACK. Weight is
      proportional to AIRMASS^-2 ie to sin(EL)^2. UNIFORM is still the
      default.
    - The HERA derotator tool were deactivated in favor of the tool
      available in MIRA, which is the one to be used by the observers at
      Pico.

- MIRA
    - MIRA now can use ATM2009 to calibrate the data.

## Nov09b release fix

- ASTRO
    - Minor bug fix in LINE command.

## Nov09

- Build
    - A config -o 32 bits is available to make 32 binaries under
      64 bits Linux. g95 and ifort supported (not gfortran)

- Kernel (SIC and GREG)
    - Introduced Python method 'getlogical' which translates a SIC
      logical.

- ASTRO
    - Sun avoidance limit of the 30m was changed from 5 to 1 degree.

- CLASS
    - "FFT /KILL" now interpolates real and imaginary parts instead of
      amplitude and phase.

## Oct09

- Kernel (SIC and GREG)
    - "GTV\LUT ?" now displays the list of available color look-up tables.
    - "COMPUTE GAG_DATE" is now able to convert a string date into a "radio
      Julian date" (integer value), or vice-versa depending. This is useful
      when playing with the CLASS and CLIC data format at SIC level.
    - One minor bug of "ACCEPT /LINE" was fixed.

- ASTRO
    - The 30m time estimator has been removed from ASTRO. It is recommended
      to use the web version available on the IRAM 30m web page.
    - The LINE and PLOT commands were upgraded to cope with the WIDEX
      correlator, which should arrive at Bure end of 2009, beginning of 2010.
    - "PLOT /ATMOSPHERE water" plots the atmopsheric transmission onto the
      frequency bands. This should be useful for the future PdBI 0.8 mm
      receivers.

- MIRA
    - Because of the change of receiver optics, the signs for polarimetry
      calibration have been fully reviewed.
    - When trying to calibrate large amount of data (e.g. OTF observing
      mode with lot's of VESPA and WILMA units), the SIC logical SIC_MAXVAR
      should be largerly increased from its default value (10,000) in the
      ~/.gag.dico file before starting the MIRA program.
    - MIRA can now write OTF data without OFF references to CLASS so that
      the OFF position can be removed later in CLASS by selecting the dumps
      without signal. This should be used with caution.

- MAPPING
    - "RUN MAKE_MOSAIC" is working again. A side effect is that "GO UVMAP"
      is working again for mosaics.

## Sep09

No release.

## Aug09a/b/c

- Kernel (SIC and GREG)
    - The conversion of "LET /SEXAGESIMAL [D|H|R]" is now working both
      ways, i.e. converting a sexagesimal expression into a numerical
      variable (historical feature) or converting a numerical value into a
      sexagesimal notation stored in a character variable. For both ways
      and both operands, the command assumes by default degrees
      angles. However, the user can specifies that the input and output are
      in radian (R) or hour angle (H).
    - The EXAMINE command now accepts 1) more than one variable as argument
      (e.g. EXA YES NO PI) and 2) the * wildcard at any place in the
      variable name.
    - "COLUMN /FILE" has no more limits on the number of readable columns
      while at most the 100th column could previous be read.
    - User can now customize the maximum number of SIC variables through
      the SIC logical SIC_MAXVAR defined in its ~/.gag.dico. The default
      value of SIC_MAXVAR is 10,000.

- ASTRO
    - The sun avoidance limit for PdBI antenna has been decreased from 45
      to 35 degrees.

- CLASS
    - A memo describing the detailed behavior of the AVERAGE command
      (including the recent bug fixes) is available here:
      http://www.iram-institute.org/medias/uploads/class-average.pdf

- CLIC
    - The default version of CLIC can process data from the new generation
      receivers (>2007) of the Plateau de Bure interferometer. To
      (re)process data with the old generation of receivers (<2007), is now
      recommended to use the CLIC07 package which is shipped in each GILDAS
      distribution. This way, our users won't have to compile a dedicated
      version of GILDAS to handle old receiver data. NB: The recognized
      extension of the CLIC07 package is .clic07 instead of .clic.

- MAPPING
    - The FIT_THRESHOLD SIC variable can be used to adjust the beam
      fit. This should be used only for "nasty" beams.

## Jul09

- Kernel (SIC and GREG)
    - The header of the output of the tasks SPECTRUM and SPECTRUM_SUM are
      now consistent with the fact that the output is a table, i.e. the rank
      of the output table is now 2 (e.g. [nplanes,2]). In other words, the
      extra degenerated dimension has been removed. Moreover, the default
      output extension is now '.tab' instead of '.lmv' to avoid confusion.
    - Two minor bugs of "ACCEPT /COLUMN" were fixed.

- MIRA
    - First round of changes to support polarimetry with the new EMIR
      receivers.

- CLASS
    - Minor bugs in the AVERAGE command were fixed.

- MAPPING
    - Following some MAPPING maintenance actions, the ALMA simulator was
      broken. It now works again.

## Jun09

- MAPPING
    - It is now possible to set the field-of-view to be imaged in
      UV_MAP. The control variable is MAP_FIELD. The default value is 0,
      implying the usual behavior. Now, if MAP_FIELD is set by the user,
      both the map size and the map cell are computed whatever the MAP_SIZE
      and MAP_CELL values are. A side effect is that an additional input
      parameter (MAP_FIELD$) was added in the UV_MAP task.

## May09

- Build
    - Gildas has been available for several months as a Fink package
      (http://pdb.finkproject.org/pdb/package.php/gildas). Thanks to the
      feedback of several users, it's has been tested on both Mac
      architectures (Intel and PPC) computers, and OS versions (10.4 and
      10.5). This is now the recommended method to install Gildas on a Mac;
      the binary version, which have caused various compatibility problems
      in the past, are neither updated nor supported anymore.

- Kernel (SIC and GREG)
    - Gildas-Python binding now supports Python 2.6.
    - Gildas-Python binding is now available under native MS-Windows
    - From now on, we will try to have a monthly release of the MS-Windows
      binaries synchronized with the gildas source releases.

- ASTRO
    - A recent version of ATM (by J.R.Pardo) is now interfaced to
      GILDAS. This version of ATM have been included in GILDAS CVS
      repository in the legacy directory to ensure that the user will have
      the possibility to recalibrate their data at home in the same
      conditions as at the telescope. The old GILDAS interface to ATM is
      emulated. 2 different versions of ATM can coexist: ATM1985 (the
      current default), and ATM2009. They can be swapped in ASTRO through
      SET ATM 1985|2009. SET ATM OLD refer to ATM1985 and SET ATM NEW to
      ATM2009. On medium term (i.e. after some testing), ATM2009 should
      become the default.

- MIRA
    - First round of changes to support the new EMIR receivers.

- CLASS
    - FIND /TELESCOPE and SET TELESCOPE now accept wildcards
      anywhere in the telescope/backend name, e.g. NAM*, N*ME or
      N*M*. '*' matches 0 or more characters.

## Apr09

- Kernel (SIC and GREG)
    - Increased default size of several GILDAS buffers (values of the SIC
      logical SPACE_GILDAS, SPACE_CLIC, SPACE_MAPPING and SPACE_CLASS) from
      64 to 128 MBytes.
    - The maximum value of allocatable memory in GILDAS is now 2GB under 32
      bits architecture and 8 GB under 64 bits machines.
    - When reading a FITS file, the number of axes is automatically
      decreased to ignore the trailing degenerated axes (i.e. of dimension
      1).
    - By default, UV tables can now be opened only through DEFINE UVT,
      i.e. trying to open them through DEFINE IMAGE will fail. However, the
      ensure backwards compatibility with older procedures, the
      SIC%DEFINE_STRICT variable was introduced: the old behavior will be
      authorized when it is .FALSE..

- CLASS
    - The LMV command was introduced. It converts a gildas LMV data cube
      into a set of class spectra. The ommand name and calling sequence
      might still change.
    - The CUBE command, which was used to produce a spectrum cube from a
      set of spectra observed on a regular grid (e.g. rasters), is now
      replaced by the combination of TABLE and "XY_MAP /NOGRID" commands in
      order to factorize source code. As a consequence, the CUBE is
      obsolete, i.e. it raises an error when called.
    - XY_MAP now enables to change the center of projection at griding
      time. The user can define the new center through the MAP%RA and
      MAP%DEC variables or through the MAP%LIKE field.
    - The spectro section of an observation header changed when moving from
      class77 to class90. In the old section, there were 18 words the last
      ones being SKYFR and VTELES. In the new section, there are 17 words,
      the last one being DOPPLER. This proved to be a problem for CSO data
      which until recently used the old section format.  A patch (for CSO
      data older than February 4, 2009 UTC) now detects the old section
      format when its size is 18 words and computes DOPPLER from SKYFR and
      RESTF. Rewriting such a spectrum writes the new spectro section. This
      is currently done only for CSO data.
    - In some exotic cases, class file of kind SINGLE (i.e. each spectrum
      has one and only one version) could write two different spectra under
      the same observation number (implying that the second one was
      considered a different version of the first one). This was fixed.

- CLIC
    - SET FLUX is now case-insensitive: 3c454.3 and 3C454.3 are the same
      source.

## Mar09

No release.

## Feb09c

- ASTRO
    - A file was missing for the 30m estimator. It is now added in
      this new release.

## Feb09b

- ASTRO
    - A new 30m sensitivity/time estimator for the EMIR new generation of
      receivers arriving at the telescope at end of the winter is now
      available in ASTRO, either through the main menu or by typing
         ASTRO> @ 30m-time-estimator

## Feb09

- Kernel (SIC and GREG)
    - The code of the widget has been rewritten in preparation for the use
      of modern toolkit libraries like GTK. As a consequence, the look and
      feel of the gildas widget changed slightly.
    - The /FORMAT option has been added to MESSAGE command, using the same
      syntax as in the SAY command.
    - Mix of real, dummy and character variables are enabled again in the
      ACCEPT /COLUMN command.
    - The task COMBINE is working again.
    - COMPUTE HISTO has been fixed in the case where the SIC input
      variables were of type real and the SIC output variable was of type
      double.

- ASTRO
    - Introduced the number of polarizations in the pdbi sensitivity
      estimator.
    - The 2008, December 31st leap second has been introduced.

- MIRA
    - When calibrating OTF scans, CAL /MASK enable to use dumps without
      signal as OFF positions.
    - The solution for heterodyne wobbler pointing is now working.

- CLIC
   - When writing continuum UV tables, the equivalent continuum bandwidth
     (used to compute the weights) now takes into account the possible
     overlap of two correlator windows and possible holes between
     correlator windows.
   - The new generation of receivers at PdBI is mostly SSB. As a
     consequence, when writing UV tables, SET SELECTION SSB|AUTO has been
     added to SET SELECTION DSB. SET SELECTION SSB selects the signal
     band only. SET SELECTION AUTO selects either just the signal band
     (SSB mode) or both bands (DSB mode) depending on the measured
     rejection: This is done independently for the two input because
     the rejection varies quickly at band edges. In addition SET SELECTION
     DSB now raises an error if the tuning was clearly SSB.

## Jan09

No release.

## Dec08b

- Completed release dec08
    - In complement to the new command "MODIFY DOPPLER" (see dec08 NEWS),
      a procedure named "fix-doppler-sign" is available. It performs
      the doppler correction on the input file only when needed. Calling
      sequence is:
         LAS90> go fix-doppler-sign input-file output-file

## Dec08

- Build
    - gfortran (version >= 4.3.0) is now a compiler supported by gildas.

- Kernel (SIC and GREG)
    - Introduce SIC DEBUG MESSAGE, which toggles the debugging messages.
    - The -d switch at the command line (i.e. "shell-prompt> gildas-pack
      -d") switches on debugging messages for the initialization of the
      package.

- ASTRO
    - The documentation has been updated.

- MIRA
    - LIST /FLUX has been extended to heterodyne frontend/backend
      combinations to enable monitoring of continuum level in polarimetry
      experiments.

- MIRA/CLASS interface
    - Description: While the internal convention of CLASS for the doppler
      field of the spectro section is doppler = -Vobs/clight, with Vobs > 0
      for recessing object, the 30m data was written with the right value
      but the opposite sign from jun-2006 to 29-oct-2008.
    - Consequences: Some modifications (i.e. MODIFY FREQUENCY and MODIFY
      BAND) of the frequency/velocity axis of lines which are not exactly at
      the IF center implied slightly wrong corrections, which appeared as
      apparent velocity shifts varying with time (as the Earth rotates
      around the Sun). The velocity offset is proportional to the difference
      between the IF frequency and the IF center. The offset is even larger
      for lines in the image sideband, as the relevant frequency difference
      to control the magnitude is then the IF frequency.
    - Diagnotisc and fix: A new CLASS command, named "MODIFY DOPPLER", has
      been written to diagnostic and fix the problem. Its behavior is the
      following one: "MODIFY DOPPLER" recomputes the value of the doppler
      factor with the class sign convention and warn if the difference
      between this value and the value stored in the data format is more
      than a given precision. "MODIFY DOPPLER SIGN" swap the sign of the
      spectra currently in the R buffer. This two step procedures is needed
      because 1) we want to change the sign without changing the value and
      2) OTF data are taken at the 30m telescope with a constant doppler
      factor during the (sub)scan duration. Hence OTF data must be checked in a
      particular way. The CLASS team tries to write a (clever) procedure
      to do the correction only when needed.

- CLASS
     - The MODEL command has been enhanced with the following options 
       [/FREQUENCY LineName RestFreq] and [/XAXIS Xref Xval Xinc Unit].
     - Following our change of the syntax of the FILE OUT command (see the
       oct08 news), we clarified the error message when invoking the
       obsolete syntax "FILE OUT File NEW".
     - Following the bug fix in the virtual memory of CLASS (see the
       release fix of the nov08 news), the "SET VIRTUAL CHECK|NOCHECK"
       command has been introduced to help users to decide whether their
       data reduction is correct.
     - The command AVERAGE could produce a wrong result in exotic
       configurations. All cases have now systematically been checked and
       fixed when needed. The following configuration (in particular the
       default) were correct:
          + ALIGN CHANNEL INTERSECT, WEIGHT TIME, BAD OR (default)
          + ALIGN CHANNEL INTERSECT, WEIGHT SIGMA|TIME, any BAD
          + ALIGN CHAN|VELO|FREQ INTERSECT, WEIGHT SIGMA|TIME, BAD OR

- MAPPING
    - MYCLEAN%MASK is a SIC logical which controls the use of a mask or a
      polygon to define the support where to search for CLEAN components in
      the deconvolution.
    - Several minor bugs of the ALMA simulator have been fixed.

## Nov08

- Release fix
    - All CLASS90 releases from May 2006 to Oct 2008 (a bug fix is being
      processed into Nov 2008) have a potential problem in the data
      reading.
        + Description: CLASS is caching the data in an internal buffer for
          efficiency reasons. If the memory size of a set of consecutively
          red spectra is exactly (au byte pres) the size of the internal
          buffer region (by default: 786432 bytes but this value depends on
          the SPACE_CLASS value using the following formula:
          3*SPACE_CLASS/256), then the next red spectra intensities
          overwrite the previous spectra intensities while the headers are
          correctly stored.
        + Diagnostic: The problem is particularly difficult to identify,
          because 1) It does not affect the header; 2) It only occurs for
          particular combination of number of spectra and channel numbers;
          3) The combinations depend on the value of SPACE_CLASS, a SIC
          logical variable that the user may change. The bug could manifest
          itself by changing results in operations like AVERAGE, or a
          mere re-display of the same spectrum, as the memory cache was
          occasionally overwritten.
        + Occurence: The occurence of this problem is small because:
            o The online writting of data at telescope is not affected as
              this operation does not use the mechanism of memory cache.
            o Every "FILE IN" command reset the internal buffer.
            o The first reading is correct because the spectra values then
              directly comes from the harddisk file. Only the subsequent
              reading of the same unmodified spectra between two "FILE IN"
              commands could be affected.
            o The size of the set of spectra must be a power of specific
              values. We will check what the different 30m backend deliver
              to assess the probability here.
        + We advise to reprocess your data with the nov08b (still to be
          done) release of CLASS in case of doubt.
        + It is possible to by-pass the buffering with the CLASS command
          "SET VIRTUAL OFF".
        + The class team is working on the possibility to toggle ON a check
          so that the user can verify whether his data reduction is correct
          (see news for the dec08 release).
    - As this is an annoying bug, the bug fix has been introduced in
      gildas-src-nov08b.tar.gz. Users are advised to get the correct
      gildas-src-nov08b.tar.gz (or later) version.

- Kernel (SIC and GREG)
    - New /OVERWRITE option of the HARDCOPY command which overwrite the
      Post-Script file when it already exists instead of raising an error.
    - COMPUTE MAX MIN MEAN RMS SUM PRODUCT MEDIAN HISTOGRAM now
      also works on input integer arrays.
    - Files larger than 2GB under 32 bits architecture are now detected by
      the EXIST() function.
    - MFIT now enables fully SIC compatible syntax for mathematical
      expressions in the /STEP and /START arguments.
    - Keyboard history has been improved:
       + SIC history has not be changed. Commands TYPE and RECALL have
         exactly the same behavior as before and the
         ~/.gag/logs/<package>.log is exactly the same.
       + However, keyboard history has been revised and some features are
         back and other are added (at the same time as the transfer of the
         keyboard and main processes as two threads of the same process):
            o Keyboard history now stores only and exactly was is typed on
              keyboard, up to 1000 lines: abbreviations are not completed,
              erroneous commands are also stored.
            o The SIC command typed on the shell command line is also
              logged in the keyboard history, e.g. for "shell-prompt>
              MAPPING @ ALMA", "@ ALMA" will be logged.
            o As said above TYPE and RECALL have access to the SIC history
              and not to the keyboard history. However, the keyboard
              history can be easily browsed with up and down arrows.
            o When browsing command history, contiguous commands which are
              equal appear once only (e.g. to avoid to have 10 types QUIT
              in a raw). In addition, typing the first characters of the
              command and then up and down arrows will recall only the
              commands starting with these characters. User can increase
              the number of letters typed during the search to avoid
              ambiguities.
            o When leaving a session, history is stored in the file named
              ~/.gag/logs/<package>.hist. When entering a session, previous
              history stored in the file named ~/.gag/logs/<package>.hist
              is reloaded and can be browsed.
    - Bug fix: LET /WHERE (broken since the sep08 release with g95 or
      gfortran under 64 bits architectures) is now working again.

- CLASS
    - Bug fix: MODEL is now protected again memory overflows.
    - Bug fix: RESAMPLE now correctly resamples spectra with opposite sign
      of the velocity/frequency increment before and after resampling.
    - The XY_MAP command has two new options:
         + The /PLACE option which makes the data placed instead of
           gridded. This is the first step to get a successor to the
           CUBE command while benefit from code factorization.
         + The /SIGMA option which uses the last baseline rms instead of
           the tsys and integration time to compute the weights used in the
           gridding.

- MAPPING
    - After so many years, now ROBUST and UNIFORM have the same meaning
      (i.e. robust weighting) in the interface of the UV_MAP command.

## Oct08

No release.

- Build
    - The installation (make install) of the python binding is now fixed.
    - gildas-env.sh is now compatible again with the Bourne shell (it
      avoids the recent bash shell syntax: =~).

- General
    - All FORTRAN sources of GILDAS now use the free syntax.

- Documentation
    - The PdBI cookbook is now up-to-date.

- Kernel (SIC and GREG)
    - "DEFINE STRUCTURE OUT /LIKE IN" defines the SIC structure OUT with
      the same tree of members (variable names and types) as in the IN SIC
      structure.
    - When an error occurs in a procedure, SIC now gives the correct line
      number.

- MIRA
    - Calibration of OTF scans along curves (e.g. Lissajou) is being
      implemented.

- CLASS
    - CLASS spectra writing was optimized for large data files (larger than
      100000 spectra). The FILE command syntax changed. It is now
            FILE OUT filename [SINGLE|MULTIPLE] [/CONVERT] [/OVERWRITE]
      Data files may be of two types: SINGLE or MULTIPLE, indicating
      whether versions of spectra are allowed or not in the file.
    - "LIST /TOC" command was enhanced.

- CLIC
    - The modeled flux of the primary calibrator MWC349 was increased by
      16%.

- MAPPING
    - Easy mosaicing (through GO UVMAP and GO CLEAN) works again.
    - The new command UV_RESTORE creates a Clean image from the UV data set
      and the Clean Component list.  The Clean Components are subtracted
      from the UV data set, and these residuals are gridded and Fourier
      transformed to compute the Residual image. This Residual image is
      added to the Gaussian beam convolved image of the sum of Clean
      components. The results are similar to those of MX, since only the
      residual are aliased. This command can be used after HOGBOM, CLARK,
      SDI, MULTI, but not MRC which has no notion of Clean Components.

## Sep08

- General
    - The handling of strings in the FORTRAN code of the kernel has been
      cleaned.

- Kernel (SIC and GREG)
    - The handling of the GTV directories has been cleaned.
    - The python binding now supports python version 2.5.2.

- ASTRO
    - The SOURCE command now defines the SIC ASTRO%SOURCE structure with
      the source position and velocity information.
    - The PLANET command now updates the values of the SIC LAMBDA and BETA
      variables.

- CLIC
    - RF calibration channel per channel works again.

## Aug08

- Kernel (SIC and GREG)
    - The FITS command now knows how to handle the CDi_j FITS keyword for
      rotated images.
    - When opening a read-only file in read-write mode, the DEFINE command
      now produces an error while an error was previously raised only at
      DELETE (writing) time.
    - The computation of the derivative and integral of a 1d array were
      added in the COMPUTE command ("COMPUTE Out DERIVATIVE In" and
      "COMPUTE Out INTEGRAL In").
    - DEFINE UVTABLE TUV FILENAME.TUV now defines the TUV%U and TUV%V
      variables.
    - Nested FOR /WHILE loops in FOR loops do not randomly delete SIC
      variables.
    - HEADER FILE correctly returns again when FILE does not exist on
      disk.
    - Nested SIC structures are now correctly handled in the python
      binding.
    - The gildas.xml file of the GILDAS distribution introduces the
      Kate/Kwrite (KDE editors) highlighting file for Gildas procedures. It
      provides: 1) recognition and highlight for various keywords and
      contexts, 2) blocks recognition, 3) comment/uncomment shortcut.

- CLASS
    - The spectral axis of the table produced by the TABLE command is now
      always expressed in velocity unit irrespective of the current class
      unit (set by "SET UNIT ...").

- CLIC
    - A user defined RF calibrator (through the SIC BAND_SOURCE variable)
      is now stored and restored when pushing again the SELECT button.
    - Ozone lines are now displayed in the RF band calibrations.

- MAPPING
    - The plot of the fitted curve in GO UVSHOW is working again.
    - The FITS command knows again how to read AIPS UVFITS data.
    - The computation of the default pixel size has been optimized in GO
      UV_MAP.
    - The writing of clean component tables for a subset of channels now
      works.
    - The EXIT behavior for unsaved buffer is now more intuitive.
    - Added the /PLANE option to the WRITE CLEAN command to write a subset
      of channels.

## Jul08

- General
    - Introduce keyboard history directly in the keyboard thread/process.
      In multi-threads configuration, history is saved across session in
      the gag_log:<module>.hist file.

- Build
    - Compilation of the python binding can be disabled by setting the "-o
      no_python" switch of the gildas-env.sh script.

- Kernel (SIC and GREG)
    - Bug fix: when copying a file, open destination file with O_TRUNC
      flag, which truncates its length to 0. Without this flag, last
      bytes were preserved during copy if input file was shorter.

- ASTRO
    - The outputs of the PLANET command are now stored in the SIC
      ASTRO%PLANET% structure.

- CLASS
    - SET LEVEL is now marked as obsolete. SET LEVEL calls should be
      replaced by the more general SIC MESSAGE command.
    - LIST OUT has been fixed.

- MAPPING
    - The imaging and deconvolution widget is now documented.

## Jun08b

- Kernel (SIC and GREG)
    - Bug fix: When introducing the PROPER_MOTION section in GDF
      format, a bug implied a wrong definition of the RA and DEC
      fields of SIC variables defined through DEFINE IMAGE or DEFINE
      UVTABLE. This bug has been introduced on May 18th and fixed on
      June 12th.

- MAPPING
    - The UV_FIT-S task (using the free SLATEC minimization library) has
      been renamed UV_FIT. The former task UV_FIT (using the expansive NAG
      minimization library) has been removed.
    - The UV_FIT task is now able to fit an elliptical ring.

## Jun08

- General
    - New kernel libraries architecture. In order to better separate kernel
      functionalities, we have introduced 2 new generic libraries:
        o gcore: inter-process communications, threads, errors
        o gui: dialog, keyboard, terminal
      gwidget has been renamed gmotif and the Windows specific code of
      gwidget has been moved to the new gwindows library. The generic X11
      features of gwidget and gtv has been moved to the new gx11 library.
    - Refreshing of the plotting window has been fixed.

- Kernel (SIC and GREG)
    - System, user and elapsed times retrieved by the SIC CPU command are
      now stored in a structure of real variables, named SIC%CPU, instead
      of symbols.
    - Introduce SIC WHICH command. It prints the full path of the
      procedure which would be executed if given as argument to @
      command. This is useful when you have in your procedure path
      (MACRO#DIR:) several procedures with exactly the same name.
    - COMPUTE HISTOGRAM now knows how to handle a data array where all the 
      values are equal.

- ASTRO
    - Add CARMA to the list of known observatories with rough coordinates
      only (from their web site).

- MAPPING
    - The new task UV_PROPER_MOTION applies the proper motions to a uv
      table UV in order to bring all the visibilities to the same common
      date. This common date is that of the Equinox specified in the Source
      Position information, usually J2000.0
    - GO SETUP now prints the antenna diameters. It also now takes into
      account the possibility to uv_shift the data.
    - The single-dish data needed for the short-spacing processing may now
      be in Jy/Beam.

- CONTRIB
    - The GLENS task has been debugged under 64 bit architectures.

## May08

- General
    - First effort to port GILDAS under MAC/OSX on INTEL 64 bits
      processors.

- Kernel/CLASS/CLIC/MAPPING
    - Fixed loss of command history.

- Kernel (SIC and GREG)
    - A bug fix to ensure the possibility of multiple conversions from FITS
      to GDF.
    - Task AZIMUTH_AVERAGE has been fixed so that when only one plane is
      selected, the result is now correctly stored into the first plane
      instead of the iplane plane.

- CLASS
    - The partial derivative with respect to vexp has been fixed in the
      SHELL fitting method.
    - The new /NOMATCH option for the AVERAGE command enables the user to
      turn off position matching.
    - Bug fixes in drift continuum fitting.

## Apr08

- Kernel (SIC and GREG)
     - Some GILDAS packages are importable in Python as 'pyfoo' modules
       (e.g. pygreg, pyclass, pymapping, ...). Python binding is still in a
       beta status.
     - GTVL\IMPORT and GTVL\EXPORT have been replaced by GTVL\METACODE
       IMPORT|EXPORT. The IMPORT command enable to interactively load
       packages.
     - The Post-Script files created by the HARDCOPY commands do *not*
       produce anymore the extra white page when printed.

- ASTRO
     - Ensured that the front-end/back-end commands of the PdBI setups can
       be tested directly in ASTRO without any edition.

- MIRA
     - Introduced the possibility to calibrate spectra channel by channel.

- MAPPING
     - The associated library has been renamed from libmap to libmapping.

## Mar08

- General
    - New program initialization sequence:
        o Goal: Being able to load the different packages (SIC, GREG,
          ASTRO, CLASS, CLIC, etc...) from the same master (e.g. python).
        o Consequence: The initialization sequence of GILDAS packages is being
          standardized.
    - A new centralized messaging facility is now distributed by the kernel
      with the following 4 arguments:
        o pack_id
        o severity
        o calling subroutine
        o message
      The possible severity will be:
        F)atal: Program must end now.
                o A fatal error (in the PROGRAM sense) occured.
                o The error can not be safely recovered
                o The program is in an unstable status and should not go on
                o A required initialization of the program could not occur
              Additionaly, program is expected to exit (sysexi) right after.
        E)rror: Command or action could not be executed to its end.
                o Denotes an attempt to do something not allowed or not
                  implemented in the command.
                o Command can not run to the end as it will not produce the
                  expected result.
                o Such errors can be recovered, and program can continue to run
                  safely.
        W)arning: Command or action will go on executing without an error, but
                o The user must be warned about a strange behavior.
                o A result is produced, but user must be careful with the
                  results.
        R)esult: Information directly requested by the user.
                o Concerns all the results the active command returns.
                o This should be understand as:
                  - "You asked for this, as a result, that happened"
                  - "This was created/changed accordingly to your request"
                  - "Here is what you asked for (some values,...) "
        I)nfo: Additional information not directly expected by the user when he
               runs the command.
                o Gives annex informations on current actions.
                o Concerns more or less the result, the processes conducting to
                  it, but are not the result itself.
        D)ebug: High level debugging, e.g. follow the steps of complex
                computation.
                o By default, should not be printed to the user.
                o We will ask the user to activate the Debug messages if
                  strange nonofatal behavior happens.
        T)race: Lowolevel debugging, e.g. track the program execution.
                o May produce thousands of messages in a row (for example, in
                  loops)
                o Can be kept in source code for future developments
                o We will ask the user to activate the Trace messages in case
                  of unforeseen fatal behavior.
        U)nknow: Do not use.
                o Reserved for migration from old GAGOUT to new GAG_MESSAGE
                o Used when GAG_MESSAGE support routine encounters a bad
                  severity kind.
      The screen and/or logfile output will be selectable by the user through
      the following command:
        SIC MESSAGE
           (nothing done, just print active filters)
        SIC MESSAGE Pack1 [ [S|L|A][-|=|+]F|E|W|R|I|D|T ] [Pack2 [[S|L|A][-|=|+]F|E|W|R|I|D|T ] ]
           (update and print considered package(s) filters)

        SIC MESSAGE can tune the messaging rules used by the programs.

        Messages are usually printed on screen (STDOUT) and to a logfile.  De-
        pending on its kind, a message may be printed or not to one of these
        outputs. 7 kinds are defined. These 7 kind of messages can be printed
        to the output thanks to a filter mechanism, which can be tuned using
        the following syntax:

          o Use  A,  S  and/or  L as first argument(s) to modify All, Screen, or
            Logfile messaging filter rules. This is optional, default is  Screen
            only.
          o Use +, - or = as second argument to add to, remove from, or redefine
            messaging filter rules. This operator must be unique, but is option-
            al: default is +.
          o Use  F, E, W, R, I, D and/or T as last argument(s) to modify messag-
            ing filter rules on Fatal, Error, Warning, Result,  Info,  Debug  or
            Trace.
        There  must  be  no  space  between these characters. With no arguments,
        SIC MESSAGE displays the current filter rules.

        Simple examples:
          GREG> sic message
          R-MESSAGE,  greg on-screen activated messages: FEWRI--U
          R-MESSAGE,  greg logfile   activated messages: FEWRIDTU
          GREG> sic message global greg
          R-MESSAGE,  global on-screen activated messages: FE------
          R-MESSAGE,  global logfile   activated messages: FEWRIDTU
          W-MESSAGE,  global filters are INACTIVE
          R-MESSAGE,  greg on-screen activated messages: FEWRI--U
          R-MESSAGE,  greg logfile   activated messages: FEWRIDTU
          GREG> sic message greg s+d
          R-MESSAGE,  greg on-screen activated messages: FEWRID-U
          R-MESSAGE,  greg logfile   activated messages: FEWRIDTU
          GREG> sic message greg l-dt
          R-MESSAGE,  greg on-screen activated messages: FEWRID-U
          R-MESSAGE,  greg logfile   activated messages: FEWRI--U
          GREG> sic message greg a=fewr
          R-MESSAGE,  greg on-screen activated messages: FEWR----
          R-MESSAGE,  greg logfile   activated messages: FEWR----

- ASTRO
    - The PdBI sensitivity estimator now comes in two flavors: 1) a
      proposal one which reuses the call-for-proposal formula and 2) a
      standard, more versatile version.
    - The PRINT command now prints in an output ASCII file the PdBI
      correlator setup as needed by the observing setup procedure.

- CLASS
    - The cube2class procedure enables to write an index of CLASS spectra
      from an LMV data cube.

- CLIC
    - A segmentation fault bug linked to the format reading has been fixed.

## Feb08

- Build
     - The file "login" produced at installation time for (t)csh user is
       now again correctly setting the GAG_PATH variable.

- General
     - CTRL-Z is back.

- Kernel (SIC and GREG)
     - The TYPE command now displays the SIC command history with the
       command number after a "!" after the command and not anymore before
       the command. This enables an easy copy/paste of the TYPE output.
     - SIC is now able to allocate up to 8 GB of memory in a single SIC
       array.

- ASTRO
     - When loading a line catalog through the "PLOT /MOLECULE" command,
       the content of the catalog is now stored into the ASTRO%LINE SIC
       structure.
     - DUT1 has been set to -0.3.

- CLASS/CLASS77/CLASS90
     - class90 is now the default version of class, meaning that the user
       will have the following behavior:
          shell-prompt> class     => Call class90
          shell-prompt> class77   => Call old default version of class
          shell-prompt> class90   => Command not found
     - class77 is still distributed in gildas just as a comparison
       point. Nevertheless, it is obsolescent, i.e. it is not maintained
       anymore: for instance, several bugs known in class77 will never
       be fixed in class77 (the class90, new default version of class has
       obviously been fixed).

- CLIC
     - Data reduction procedures and widgets have been adapted to take care
       of the new 2mm receivers of Plateau de Bure Interferometer.

## Jan08

- General
     - The gag.dico.gbl and gag.dico.lcl gildas configuration files are now
       only searched in the GAG_PATH environment variable (i.e. not
       searched anymore in the PATH environment variable).
     - Maximum number of SIC logical names has been increased from 150 to
       500.

- Kernel (SIC and GREG)
     - The BLANKING section is now always defined in memory. If this
       section is missing in the input file, then EVAL is set to -1.
       BVAL is replaced by 1.23456E+34 if it is NaN in the input file
       (common in modern FITS files).
     - The deprecated "blocked" FITS keyword has been suppressed from the
       SIC FITS interpretor. The old "mm/dd/yy" has been replaced by the
       current FITS standard.

- CLASS90
     - Minor bug fix in the CUBE command.
     - SET VELOCITY and SET SYSTEM now changes the spectrum at load time
       (GET command) while the spectrum was changed only at write time
       before (WRITE command).

## Dec07

- General
     - All the code used to handle projections (WCS related aspects) has
       been factorized into the gwcs library. The SFL projection has been
       added.

- Build
     - Introduced the "integ-clean" target which recursively removes the
       "built" directories wherever it is called. It also removes the
       $gagsrcdir/integ directory when called from $gagsrcdir. It should be
       used with caution as the user can loose several hours of
       compilation...

- MAPPING
     - The READ MASK and SUPPORT /MASK commands now enable the definition 
       of disconnected deconvolution supports through the use of bitmap
       instead of polygons.
     - SUPPORT /RESET now resets the definition of the current support to
       empty space.
     - MAPPING now accepts to treat mosaic of up to 999 fields.

- Contrib
     - GAUSSCLUMP now works under 64 bits machines. It is now part of the
       standard GILDAS compilation.

## Nov07

- Build
     - A major overhaul of the gildas build system has been implemented to
       add the following functionalities:
         o Being able to compile exactly the same sources:
              = Under different systems (eg pc-redhat9-ifort, pc-redhat9-g95,
                x86_64-fedora6-ifort,...).
              = With different compilation options, eg standard options,
                debug options, profiling options, using SYSV, using POSIX,
                etc...
           This way, you can check the modifications you are doing on the
           sources on different systems available to you without having to
           commit first.
         o Put libraries, binaries and other compilation products in a
           small number of directories to simplify the changes of some
           environment variables (PATH, LD_LIBRARY_PATH, etc...) and to
           simplify the reading of the make output.
         o Get a cleaner separation between sources and compilation
           products, eg when you update your working copy, you will not be
           annoyed anymore by files unknown to the cvs repository.
         o Enable the compilation of a particular package against an
           already compiled version of GILDAS.
     - This implied the following changes: 
        o The default is now to link executables against shared libraries
          even though both static and shared libraries will be
          produced. The possibility to link all gildas executables with
          static libraries is maintained. To do this, just use the
          following commands
                    shell-prompt> source admin/gildas-env.sh -o staticlink
                    shell-prompt> make
        o The foo_pro: (e.g. greg_pro:, astro_pro:, class_pro:) have been
          replaced by:
             = Empty string when dealing with procedure name (e.g. "@
               greg_pro:p_load.greg" has been replaced by "@ p_load.greg"),
               the resolution of the absolute name being done with the
               macro#dir: path.
             = gag_pro: when dealing with help files and init files (e.g.
               "run extrema greg_pro:extrema.init" has been replaced by
               "run extrema gag_pro:extrema.init").
        o The gag.dico.gbl has been simplified so that all the file
          positions will depend only of two environment variables
          "GAG_ROOT_DIR" and "GAG_EXEC_SYSTEM".
        o The compilation products will not be anymore in the current
          source directory. Instead they will be gathered in a directory
          tree named $gagsrcdir/integ (integ stands here for
          integration). This directory tree has a structure almost
          identical to the executable (installation) tree.
        o Compilation intermediate products (eg preprocessed files) are
          stored in local subdirectories named "built/machine-os-compiler".
     - Everything else did not change. In particular:
        o Standard users outside IRAM, who compile themselves GILDAS, should not
          either be affected.
        o The executable tree structure.
        o The commands to compile:
            shell-prompt> source admin/gildas-env.sh
            shell-prompt> make
            shell-prompt> make install

- Kernel (SIC and GREG)
     - The Post-Script files produced by GILDAS were misinterpreted by
       recent printer drivers (e.g. the ones shipped with Fedora Core 5 and
       6). This produced oversized prints. This has been fixed with the
       side effect of printing an additional blank page... To be followed.
     - Improved the behavior of the SIC\SORT command to enable sorting a
       complete 2-D table in just one command: SORT T[XCOL] T will sort the
       2-D T variable according to column XCOL. More than one table can be
       sorted on the same command line if needed.
     - Added the /CLIP option to the DRAW TEXT X Y "Text" command to avoid
       writing the text if the (X,Y) point is out of the box. The idea is
       that DRAW TEXT /CLIP will be used to annotate markers plotted (or
       not) by DRAW MARKER.  It could be blindly used to designate sources
       in a field by their names, without knowing if their position is
       within or not the current limits (e.g. DRAW TEXT Ra Dec "Source"
       /USER ABS /CLIP).

- ASTRO
     - Introduce SET PDBI 1995|2000|2006 command, that selects the PdBI
       frontend/backend status corresponding to years 1995 (old receivers,
       500 MHz bandwidth), 2000 (580 MHz bandwidth), 2006 (new receivers
       and new IF processor). Default is 2006.
     - The behaviour of the LINE command now depends on this year:
         o 1995, 2000: 'old' LINE command;
         o 2006: 'new' LINE, NARROW, SPECTRAL, PLOT commands.

- MAPPING
     - Fixed the previously incorrect printout of the baseline length in
       Kwavelength. It included a factor 2*pi which was put to compute
       pixel size.
     - GO SETUP now uses A0 and D0 to compute the phase center instead of
       RA and DEC previously. This avoids resetting the phase center
       (A0,D0) each time from the pointing position (RA,DEC).
     - LET MYCLEAN%SHOW NO avoids on-the-fly plots when deconvolving with
       GO CLEAN
     - The new widget interface has been largely improved.

## Oct07

- Kernel (SIC and GREG)
     - On-line help has been completed.

- ASTRO
     - Adaptated to take into account the new 2mm receivers for Plateau de
       Bure Interferometer.

- MIRA
     - Introduced rotated G3 for polarimetry.
     - Added view /derot.

- CLASS90
     - Add an option /METHOD to command FIT\DISPLAY to allow a display of
       the fit results of the given method without having to change the
       minimization METHOD.

- CLIC
     - Now writes one visibility per correlator input (or IF) for both line
       and continuum, instead of an average when the frequency setup was
       identical on each correlator input. The reason is that two IFs will
       have different Tsys, hence different weights (continuum and line).

## Sep07

- Kernel (SIC and GREG)
     - The /FORMAT option of the SAY command now is able to format arrays.

- CLIC
     - Implement PDBI\PLOT /SPURIOUS to plot the location of possible
       spurious lines (3 and 4 times FLO1REF), sometimes observed on Rec 1
       on some antennas.

- MAPPING
     - Tasks uv_fit.f and uv_fit-s.f no longer re-use existing .uvfit files.
       This avoids problems of inconsistent headers of the .uvfit files
       when changing the number of fitted functions.

- MIS
     - Fixed UV_FIDELITY and AZIMUTH_AVERAGE crashes under g95 due to
       forgotten initialization.

## Aug07

- General
     - The following include files have been renamed from
         ./kernel/include/gbl_convert.par                 to ./kernel/include/gbl_convert.inc
         ./packages/class/lib/class_version.par           to ./packages/class/lib/class_version.inc
         ./packages/class/lib/structure.pat               to ./packages/class/lib/structure-t.inc
         ./packages/class/lib/structure.par               to ./packages/class/lib/structure-r.inc
         ./packages/clic/lib/clic_version.par             to ./packages/clic/lib/clic_version.inc
         ./packages/clic/lib/clic_procedure.par           to ./packages/clic/lib/clic_proc_par.inc
         ./packages/clic/lib/clic_procedure.inc           to ./packages/clic/lib/clic_proc_com.inc
         ./packages/otfcal/lib/cal_version.par            to ./packages/otfcal/lib/cal_version.inc
         ./packages/pako/lib/inc/commands/pakoVersion.par to ./packages/pako/lib/inc/commands/pakoVersion.inc
       and ./packages/class/lib/convert.par has been removed because it was
       unused anymore.
     - Removed ULTRIX, VMS and G77 (obsolete) specific code.

- Kernel (SIC and GREG)
     - The task MOMENTS now correctly handle input file names which include
       a directory.
     - "GO AREA" now also works when FIRST=LAST=0.

- MIRA
     - An ambiguity in raw data file sorting has been removed when both
       100khz and 1mhz connected.

- CLASS90
     - Minor bug fix of the PLAIT task.

- CLIC
     - Fixed the definition of the observatory frequency when creating UV
       tables for the new generation receiver. For information, the
       previous definition had a negligible effect (even though is was not
       exact).

- MAPPING
     - Fixed the definition and use of supports in the new window interface.
     - Fixed deconvolution of a mosaic in the new window interface.

## Jul07

- Build
     - MIRA is now part of the default compilation.

- Kernel (SIC and GREG)
     - Better support of the frequency and velocity information when
       reading FITS files of data cubes.
     - The private include files of the kernel have been transferred into
       F90 modules. If this affect your program compiled against GILDAS,
       please contact us at gildas@iram.fr.
     - The E, G and D descriptors are now recognized in the "LET /FORMAT"
       command.
     - The arguments of a procedure are now stored in the PRO SIC
       structure.
     - The "$ command line" is now forbidden in loops: please, use the
       SYSTEM "command line" equivalent.

- MIRA
     - A warning is now issued when trying to calibrate a
       front-end/back-end combination with calibration data obtained with
       another front-end/back-end combination.
     - The OVERRIDE command now affects the whole MIRA session and not
       anymore just the next calibration (to be used with precautions).

- CLASS90
     - Apex backend started with "AP-" are now automatically recognized.
     - Bug fix of the extended FITS support.
     - Maximum file name length is now set by a single variable currently
       set to 512 characters.
     - The GREG command has been debugged in CLASS90.

- CLIC
     - On-line documentation has been updated to take into account changes
       made to support the new generation of PdBI receiver.
     - New calibration scheme of the Water Vapor Radiometer has been
       implemented.
     - Some work to ensure compatibility of the current version of CLIC
       (fitted to the new generation of PdBI receivers) with data from
       the old generation of receivers (<2007).

- MAPPING
     - "GO UVCIRC" produces circularly averaged uv tables both for single
       dish and mosaics.
     - The conversion from radian to sexagesimal notations have been fixed
       for |dec| < 1 deg.

## Jun07

- Kernel (SIC and GREG)
     - The possibility to make variable aliases has been introduced:
          DEFINE ALIAS A B
       makes A an alias of the B variable.
          DELETE /VAR B
       removes both A and B. But
          DELETE /VAR A
       removes only alias A.
          HELP DEFINE ALIAS
       for more help.
     - Conversion to sexagesimal coordinates has been fixed to avoid that
       the second and minute fields reach 60.
     - It is now possible to group buttons in menus in widgets.
     - Every new instance of a menu bar which already exists now destroys
       the previous instance.
     - "GO FFT" computes the spatial Fourier transform and modulus of a
        spectra cube.
     - The AZIMUTH_AVERAGE task now also works on spectra cubes instead of
       just one plane of a spectra cube.

 - CLASS90
     - The reading of the input files used to setup the fit parameters has
       been fixed.

 - CLIC
     - The flagging of a large number of data is now working again implying
       the possibility to use the tool to assess the quality of the
       calibrated visibility data.
     - This version of CLIC is almost stable for the data produced by the
       new generation of PdBI receivers.

 - MAPPING
     - The creation and merge of the short-spacings have been fixed into
       the new window interface.

## May07 (skipped release to tune the new interprocess communication)

- General
     - Introduction of a new library called libgwidget which regroup all
       the platform specific code (e.g. MOTIF or WINDOWS widgets). This
       means that linking outside programs against gildas may require to
       add -lgwidget to the list of libraries.

 - Kernel (SIC and GREG)
     - "GO VIEW" now also displays information about the studied data cube
       (file name, source name, line name, etc...)
     - Character fonts are now customizable under unix/linux by the
       standard resource mechanism. For instance, to change the fonts used
       by Gildas:
          shell-prompt> xlsfonts | grep-v [-]
          ... Long list of simple fonts ...
          shell-prompt> emacs ~/.Xdefaults
          ... You add the following lines to change the font to the 9x15 font
                gag_menu*fontList: 9x15
                gag_toolbar*fontList: 9x15
                *gag_dialog*fontList: 9x15
                *gag_file*fontList: 9x15
                *gag_choice*fontList: 9x15
                *gag_help*fontList: 9x15
                *gag_popup_menu*fontList: 9x15
          shell-prompt> xrdb-load ~/.Xdefaults
          shell-prompt> greg
       From this point on, the menu will always use the indicated font
       unless you change again the content of the ~/.Xdefaults file.
     - Suppression of command syntax checking when creating a procedure by
       BEGIN procedure / END procedure. This is (in particular) to enable
       definition of command symbol inside a BEGIN/END procedure.
     - Some bug fixes in the new interprocess communication introduced in
       Apr07.

 - TELCAL
     - TELCAL is now working under 64 bits machine when compiled in 64 bits
       mode.

 - CLASS90
     - "DUMP /SECTION section" enables to dump only the content of a
       particular section.
     - DUMP now also displays the doppler factor in the SPECTROSCOPIC
       section.

 - CLIC
     - Debugging of this version of CLIC adapted to the new generation of
       PdBI receiver.

 - MAPPING
     - "SUPPORT /RESET" removes the current support.
     - The UV_FLAG task now only changes the sign of the weights while it
        was putting the whole visibility spectrum to zero.
     - Introduction of the UV_PROPER_MOTION task which corrects position
       (and thus phases) to take into account source proper motion and
       bring the reference to J2000.
     - A fully new interface has been introduced for mapping and
       deconvolution with the following goals:
        o Having the same functionalities through commands, procedures and
          widgets. In particular, ensure that what is available through
          widgets is available through procedures (eg short-space
          processing).
        o Being able to process single-field and mosaic observations in
          similar way.
        o Ensure that widgets guide new-comers through good imaging and
          deconvolution practices.
        o Ensure that minimum consistency checks are done (in particular
          when producing the short-spacings.)
       It is still a beta version that will be fully debugged in the coming
       months (see above).

## Apr07 (skipped release to tune the new interprocess communication)

 - General
     - The GRAPHIC program is removed from the GILDAS distribution. The
       user should use GREG for operation related to lmv cubes and MAPPING
       for operation related to uv tables (imaging and deconvolution). The
       .GRAPHIC extension is still recognize by GREG and MAPPING but this
       functionality may disappear in the future.
     - The NIC program is removed from the GILDAS distribution. MOPSIC is
       the recommended program to reduce bolometric data from the IRAM-30m
       telescope.
     - Introduction of a fully new interprocess communication (POSIX
       complient). This should be transparent for the users except for
       possible remaining bugs. As a major consequence, widgets are now
       available under the CYGWIN operating system.

 - Build
     - The python binding is now automatically activated under linux 32
       bits machine if both python and numeric or numpy are found.

 - Kernel (SIC and GREG)
     - Fix of a minor bug concerning the superimposition of contours and
       images.
     - The "HSV control widget" to interactively tune the color look-up
       table is back under linux.

 - CLIC
     - Debugging of this version of CLIC adapted to the new generation of
       PdBI receiver.

 - MAPPING
     - The WIPE interface has been factorized.
         o All variables are now part of the WIPE sic structure.
         o WIPE is now the only command with INFO|APER|BEAM|ERROR|SOLVE
           as 1st argument.
     - The uvfit interface has been changed:
         o Introduced uvfit structure to prefix all the variables
           associated with the uv fitting.
         o "go uvfit" is now calling the UV_FIT-S task by default. You need
           to type "go uvfit nag" to get the obsolescent NAG version.
         o Now both the task uv_fit-s and the procedure p_uvfit.map are able
           to fit a linear combination of up to 4 functions but the widget
           takes input for only 2.
         o Changed the way the kinds and ranges of the fitted parameters are
           input into p_plotfit.map. Now uvfit%xtype and uvfit%ytype are
           strings arrays of dimension 6, each string should read like "kind
           min max", e.g. "velo * *". The number of plotted parameters are
           uvfit%nx and uvfit%ny. The number of functions plotted are
           uvfit%np and the order in which they are plotted is stored in
           uvfit%order.
     - Introduced the UVCOV button in the "UV action widget".
     - The FITS command is now able to read the UVFITS format produce by
       MIRIAD. There are still minor problems in exporting UVFITS to
       MIRIAD.

## Mar07

 - Build
     - It is now possible to compile GILDAS under MACOSX/intel processor
       with the ifort compiler.

 - Kernel (SIC and GREG)
     - The MASK task has been debugged.

 - CLASS90
     - The "SET WINDOW" command now takes effect without any call to the
       PLOT command.

 - CLIC
     - Debugging of this version of CLIC adapted to the new generation of
       PdBI receiver.
     - "HEADER /PLOT" plots the spectral/correlator configuration
       of the current scan.

## Feb07

 - Kernel (SIC and GREG)
     - Bug fix in the handling of the loop variable. This bug implied the
       removal of other SIC variables.

 - CLASS90
     - Introduction of the difference between the natural telescope
       resolution (MAP%BEAM parameter) and the wanted gridded resolution
       (MAP%RESO parameter) of the XY_MAP gridding command.
     - The MODEL command now works even when no previous observation has
       been loaded: the X axis is computed (irrespective of the existence
       or not of previous R buffer, or of the presence of new supplied X
       array).
     - "FITS WRITE" do not produce anymore a segmentation fault when the
       output file is already existing.
     - Fixed the list of spectra which is kept in the AVERAGING command.
     - Line fitting has been debugged.

 - CLIC
     - Major upgrade of CLIC to be able to treat data coming from the new
       generation of PdBI receivers. This version is not yet stable and the
       backward compatibility has not been fully tested. So we advise to
       use the Jan07 release of GILDAS to reduce data acquired before 2007.

 - External contributions
     - GAUSSCLUMPS documentation has been written.

## Jan07

 - Kernel (SIC and GREG)
     - Now the REPROJECT task is able to use a template image that has a
       different velocity/frequency axis. A side effect is that the header
       of the template image is not anymore (wrongly) fully copied into the
       output image.

 - TELCAL
     - Minor changes to enable convergence with negative amounts of water
       vapor.

 - CLASS90
     - Now the unit of the output cube will be either "K (Ta*)" or "K
        (Tmb)" in the XY_MAP command.
     - The resolution section is now only filled in when the telescope
        name is known in the XY_MAP command.
     - Added UASO as synonym for KITT (USAO is the new name for the 12m
       Kitt-Peak telescope).
     - New optional argument ANGLE to the "DRAW LOWER UPPER MOLECULE"
       command.
     - The documentation of the internal CLASS format has been updated.
     - The new command MERGE merges several irregularly continuum drifts
       into a single drift, without resampling nor averaging. The
       integration time is the sum of each int_time. Tsys and tau are
       time-weighted averages. No consistency check is done for the moment:
       you can merge drifts from any TELESCOPE...  A new type of plot,
       namely SET PLOT P, draws the R buffer with the current marker.

## Dec06

 - Build
     - Now the paper size (A4 by default) may be changed by exporting
       GAG_PAPER_SIZE=US_LETTER before sourcing gildas-env.sh.

 - Kernel (SIC and GREG)
     - The command "SIC\SORT VarKey [Var1 ... VarN]" reorder N+1 variables
       according to the order of variable VarKey. Accordingly, the
       particular case GREG1\SORT is now obsolescent. Please, do not use it
       anymore.
     - "COMPUTE Loc LOCATION Array Value" find from a sorted array Array
       the integer array Loc[2] so that:
              Array[Loc[1]] < Value < Array[Loc[2]]
              Loc = 1 if Value < Array[1] & Loc = n if Value > Array[n]

 - CLASS90
     - Added the /REDUCED and /OBSERVED keywords to the FIND command.
     - The AVERAGE command is now able to add frequency switch folded
       spectra to position switch spectra.

 - CLIC
     - The production of the report is now using LaTeX2e.

## Nov06

 - Kernel (SIC and GREG)
     - Implemented variable communication between SIC and PYTHON.
     - First introduction of the PYTHON command.
     - PYTHON functions can be called directly from SIC, e.g. "SIC> LET A
       BESSEL(2)" will call the python Bessel function if it exists and the
       python process has been started from SIC.
     - "CHANGE LUT STATIC" make the LUT command change the color look-up
       table of the to-be-drawn images to enable the possibility of having
       several color look-up tables on the same plot. "CHANGE LUT DYNAMIC"
       enables to get back to the current default, i.e. a LUT command
       modifies the color look-up table of the whole display whenever it is
       called in a procedure.

 - CLASS90
     - "SET MODE ALL" is now also working for the Z axis.
     - "GO ALIGNMENT" and "GO EFFICIENCY" commands are replacement of the
       old "@ ALI_CHECK" and "@ TEL_CHECK" procedures.
     - Debugging of the case of an irregularly sampled frequency axis.

## Oct06

 - Kernel (SIC and GREG)
     - LOGICAL variables can now be output with the "SAY /FORMAT" command.
     - The $ character is not anymore allowed in variable names to ensure
       variable name compatibility with PYTHON variables.  As a
       consequence, the SIC$... GTV$... GREG$... and POLY$... have been
       replaced by the structures SIC%... GTV%... GREG%... and POLY%...

## Sep06

 - Outside contributions
     - A gravitational lensing simulation task GLENS is now available in the
       $gagsrcdir/contrib directory.

 - ASTRO
     - The PdBI sensitivity estimator has been upgraded for the new
       generation of receivers.
     - The definition of the spectral setup (RF, IF and correlator) has
       been rewritten for the new generation of receivers.

 - CLASS90
     - Reordered initialization to avoid creating the log and messages
       files before the creation of the $HOME/.gag directory tree.

 - MAPPING
     - Serious bug fix in the ALMA simulator: In the mosaic case, only
       snapshot were simulated whatever the integration time. All the
       known past and present users have been notified. The
       implications for the results of the ALMA memos using this simulator
       is negligible because all the simulations were snapshot simulations
       anyhow.

## Aug06

 - CLIC
     - Since ??, the weights of the visibilities computed by the TABLE
       command were wrong when no resampling was applied. This was only a
       scaling factor (=number of channels in the spectral unit), so all
       maps were correct. But the absolute values of the weights were
       wrong, giving a wrong rms in the map headers.

## Jul06

 - Build
     - GILDAS can now be compiled under MacOSX with an Intel processor.

 - Kernel (SIC and GREG)
     - "LET I /INDEX H H2 H+" now correctly resolve the ambiguity between
        H, H2 and H+.
     - Protect against NaN in bitmap.

 - CLASS90
     - Added FCRAO (14m dish) in the list of known observatories.
     - The RESAMPLE command now avoids an infinite loop when searching for
       blanked values at spectrum edges
     - BASE LAST is working again for sinusoidal baselines.

## Jun06

 - Kernel (SIC and GREG)
     - The EXAMINE command now display variable values for all
       structure components but arrays. Recursive behavior is available.
       For instance:
         SIC> exa struct
         STRUCT         ! Structure GLOBAL
         SIC> exa struct%
         STRUCT%        ! Structure LOCAL  1
         STRUCT%SUB%REALVAR =    0.000000             ! Real    LOCAL  1
         STRUCT%SUB     ! Structure LOCAL  1
         STRUCT%REALARRAY is a real array of dimensions      2
         STRUCT%STRINGVAR       ! Character*   16 LOCAL  1
         STRUCT%INTEVAR  =            0               ! Integer LOCAL  1
         STRUCT%REALVAR  =    0.000000                ! Real    LOCAL  1
       Only the first 15 characters of a string are displayed with trailing
       dots if needed.
     - First try to use the external FFTW library.

 - CLASS90
     - GO WHERE is a quick way to plot the spatial coverage of the spectra
       belonging to the current index.
     - The BASE command has been speed up by a factor 4 after profiling.
     - The new COPY command copies the whole index from INPUT to OUTPUT
       file.

 - CLIC
     - New solvers for antenna base pointing and focus have been
       implemented. They enable a better estimation of the error bars.

## May06

 - Kernel (SIC and GREG)
     - Support for NaNs and Infs has been fixed for SUN machines.
     - NaNs, Infs and blanking values are now supported in COMPUTE command
     - New support of "virtual" images and headers, i.e. SIC variables like
       images and headers, but not associated to a disk file. The syntax is
       "DEFINE IMAGE Name[dim,...] * Status", where "*" instead of a
       filename indicates the "virtual" status of the image.
     - Improved display of structure content by the EXAMINE
       command.

 - CLASS90
     - The GREG command is again available.
     - The FITS class format has been extended to handle variable length
       arrays in binary tables and extensions.
     - XY_MAP now enables griding in a rotated frame compare to
       EQUATORIAL or GALACTIC.

## Apr06

 - Release fix
     - A bug in the axis labeling has been introduced in
       gildas-src-apr06a.tar.gz. Users are advised to get the correct
       gildas-src-apr06b.tar.gz (or later) version.

 - Legacy
     - In LAPACK, avoid optimizing DLAMC3 which is used to test machine
       precision.

 - Kernel (SIC and GREG)
     - COLUMN
     - MFIT has been rewritten to enable the use of more fitting methods
       and to feed back the estimation of the uncertainties.

 - ASTRO
     - Added an extremely simple sensitivity estimator for PdBI in ASTRO
       menu.

 - TELCAL
     - Implementation of a new interface for pointing with a finer
       granularity, e.g. possible access subscan per subscan.
     - Implementation of double beam fitting.

 - CLASS/CLASS90
     - SOURCE, LINE and TELESCOPE search-filters are now case insensitive.

 - CLIC
     - The TABLE command is not crashing anymore under 64 bits machines.
     - The translation table of the logical vs physical antenna number is
       now clearly printed when using "SET ANTENNA|BASELINE" or "SHOW
       ANTENNA|BASELINE". The plot antenna labeling is by default
       logical unless "PLOT /PHYSICAL" is typed.

## Mar06

 - Build
     - GILDAS now supports the ifort compiler (version 9.0 and higher) in
       full 64 bit mode under x86_64 machines (ie AMD64 compatible
       processors).

 - Kernel (SIC and GREG)
     - "COMPUTE med MEDIAN array" now set the median of array into med.
     - "CLEAR ALPHA" is not working anymore under the gnome window manager
       (named metacity) shipped with fedora core 4. This is *not* a bug of
       gildas. GILDAS is correctly sending to X the XRaiseWindow
       command. However, this request is now ignored by metacity (but this
       is a general tendency of window manager to ignore these
       requests). This is a collateral damage of the idea that new
       applications should not steal the focus. For instance, if you
       launch many applications when you log in and then you start working
       in an xterm. If the applications take time to popup, the focus will
       stay in your xterm where you are working. The focus stealing
       prevention may be disabled under KDE but not under the version of
       metacity shipped with fedora core 4. The XRaiseWindow is just a
       request. Nothing in the X standard says it should be honored. For
       more information:
         http://lists.freedesktop.org/archives/xorg/2006-January/012420.html
         http://mail.gnome.org/archives/desktop-devel-list/2004-December/msg00306.html
         http://www.motifdeveloper.com/tips/tip18.html

 - MAPPING
     - "WRITE CCT" has been fixed. It now writes "niter" components (the
       user set limit of clean components) instead of the found number of
       clean component of the last deconvolved velocity plane.
     - "GO CCT" now plots cumulative flux as a function of clean components
       only up to the last found component instead of the last written
       component. This is useful when the deconvolution stops before
       reaching the number of clean component limit (niter).

## Feb06

 - General
     - An annoying bug appeared at exit of GILDAS programs (namely an
       incorrect cleaning of the semaphore resources) in
       gildas-src-feb06a.tar.gz. Users are advised to get the correct
       gildas-src-feb06b.tar.gz (or later) version.

 - Build
     - GILDAS was compiled with success on a SUN opteron (64 bits
       intel-like architecture) with solaris 10, in restricted 32 bits
       mode.

 - Kernel (SIC and GREG)
     - NaNs and Infs are now supported in LOG, SQRT and other mathematical
       operations.
     - "DEFINE FITS" is now able to understand HIERARCH keywords.

 - TELCAL
     - The beta release of TELCAL, a GILDAS library implementing focus and
       pointing fitting is now introduced in the GILDAS main compilation.
       This library is now used by MIRA.

 - CLASS90
     - The beta release of CLASS90, version of CLASS fully rewritten in
       FORTRAN90 with improved OTF support is now introduced in the GILDAS
       main compilation. Standard users will thus been able to use CLASS90
       by just typing

             shell-prompt> class90

       Old CLASS is still available through its standard name

             shell-prompt> class

       For more information, please look at

             http://www.iram.fr/GENERAL/reports/class-evol1.pdf

 - ASTRO
     - Added the leap second of 2006 January 1 from Bulletin C 30 of IERS.

 - CLIC
     - The RESAMPLE option of the TABLE command has been improved to avoid 
       blank channels at the edges between two contiguous correlator
       windows.

 - MAPPING
     - New UV_RESAMPLE command and tasks that enable velocity/frequency
       resampling of a UV table.
     - "GO UVALL" error bars have been fixed. Note that the error bars are
       correct for real and imaginary part but just approximate for
       amplitude (i.e. amplitude is a positive measure whose probabilistic
       behavior is NOT Gaussian, see Thomson et al. for more details). In
       the same process, "go uvall" structure has been clarified. Moreover,
       "LET DO%TRACK YES" will try to colorize the visibilities depending
       on the track they belong to (up to 7 colors/tracks available). The
       algorithm currently works only on unsorted tables but happily enough
       MAPPING does not write the sorted tables without you explicitly
       requesting it.
     - "GO UVCOV" will plot the uv coverage of the first channel without
       having to input "let first 1; let last 1; let xtype u; let ytype v;
       go uvall". "go uvcov" even tries not to modify your current "go
       uvall" input (ie first, last, xtype, ytype).

## Jan06

 - Kernel (SIC and GREG)
     - Bug fix: Typing end does not crash anymore GILDAS programs.

 - ASTRO
     - The SOURCE command now ignores all unsupported keywords instead of
       issuing an error message.

 - CLIC
     - Internal changes for a better support of g95.

## Dec05

 - ASTRO
     - Positions of the new stations on the NS and EW track extensions
       (doubling the largest baseline to almost 800 m) have been inserted.

 - CLIC
     - New configurations (to accommodate extended baselines) have been
       introduced. First observations using the new configuration started
       in November 2005. New names are 6Aq, 6Bq, 6Cq, 6Dq, where 'q' stands
       for 2006 (ipb filename convention). Old configurations used since
       2002 are 6Ap, 6Bp, 6Cp, 6Dp.

## Nov05

 - Build
     - GILDAS now supports the g95 compiler in full 64 bit mode under
       x86_64 machines (ie AMD64 compatible processors).

 - Kernel (SIC and GREG)
     - Integrated spectrum velocity scale is now correct even when the
       velocity increment is negative.

## Oct05

 - ASTRO
     - Now the ASTRO language has priority over other languages to resolve
       ambiguities of ASTRO\HEADER and ASTRO\CONVERT with VECTOR\HEADER and
       GREG\CONVERT.
     - The tool to find the PdBI calibrators now uses the correct name of
       the calibrator catalog.

 - MAPPING
     - "go cct" now correctly plots the header.

## Sep05

 - General
     - Just set the SIC_INITWINDOW logical variable to NO in your
       $HOME/.gag.dico file to suppress the automatic popup of the plotting
       window and program widget menu. Then typing "@ define" at the
       program prompt will pop both of them up at your own will.
     - Now the GILDAS bash_profile or login files output the selected
       version *only* when there exists a prompt (i.e. the shell is
       interactive). This is to avoid problems with secure remote shell
       commands.

 - Kernel (SIC and GREG)
     - "go view" key controls have been changed as follow:  1) "E" now exit
       instead of extract. 2) "X" now extract a subcube.  3) "C" is now
       window dependent, i.e. it toggles from absolute to relative
       coordinates either in the images or the spectra, not both
       anymore. 4) "P" now make an color EPS file in a "ha" subdirectory.
     - SIC now enables the definition of up to 32 languages and 1024 commands.

 - ASTRO
     - Updated dut1 according to IERS recommendation.
     - The GAG_ASTRO_OBS logical name was introduced. When the OBSERVATORY
       command is given without argument, the GAG_ASTRO_OBS logical is
       translated to obtain the observatory name.
     - GAG_ASTRO_OBS is set by default to "BURE" in the gag.dico.gbl
       file. To override this default at compilation time, users have to
       "export GAG_OBSERVATORY=USER-OBS-NAME" just before sourcing
       gildas-env.sh.
     - The "astro_local.astro" procedure now calls the ASTRO/OBSERVATORY
       command without argument. The procedure behavior then depends on the
       fact the chosen observatory is BURE or VELETA.

 - MAPPING
     - The UV_AVERAGE task now uses the correct reference frequency in all
       cases.

## Aug05

 - Build
     - Removed the g95 "-std=f95" switch to avoid problems with equivalence
       statements.
     - Minor modifications to ensure correct compilation under
       sparc-solaris-f90.

 - Legacy code
     - Suppression of some redundant routines between blas, lapack and
       slatec.

 - Kernel (SIC and GREG)
     - Bug fixes for port to 64 bit machines in particular the plotting of
       images.

 - ASTRO
     - APEX has been added to the list of known observatories.

 - CLIC
     - Increased to 20 the maximum number of files that can appear in the
       "Open Raw Data File Widget".

## Jul05

 - Kernel (SIC and GREG)
     - All SIC variable started with "GTV$" has been put into the structure
       "GTV%". For instance, GTV$NOFAIL is now called GTV%NOFAIL.
     - Update documentation of "go bit", "go map", "go lmv" and "go nice".

 - OTFCAL
     - Major synchronization between GILDAS and 30m versions of
       OTFCAL. From now on the 30m is using the GILDAS version of OTFCAL.

 - CLASS
     - The (user-defined) descriptive coordinate system is now better
       described in the header of spectra. This is the first step toward a
       better use of this kind of coordinate system.

 - MAPPING
     - Debugged the definition of the synthesized beam by the user when the
       user does not trust the MAPPING default.

## Jun05

 - General
     - First round of documentation of the previously undocumented tasks.
     - Lot's of cleaning to prepare for new features in future releases.

 - MAPPING
     - UV_ASCAL, UV_SELFCAL and UV_MCAL tasks have been respectively
       renamed to UV_REF_POINT, UV_REF_GAUSS and UV_REF_MODEL.
     - Antenna-based calibration inside the UV_GAIN task is working again.

## May05

 - MAPPING
     - Bug fix (starting with gildas-src-may05c.tar.gz): in apr05 release,
       global SIC variables BLC and TRC were incorrectly set to a non-zero
       value when cleaning. This lead to strange behaviors when changing
       the size of the dirty image in the same MAPPING session. MAPPING
       does not change these values anymore as it should be.

 - NIC
     - Bug fix: ONOFF command is working again.

## Apr05

 - General
     - Unfinished developments to improve the fitting routines of CLIC
       accidentally arrived in gildas-src-apr05a.tar.gz. Users are advised
       to get the correct gildas-src-apr05c.tar.gz version.

 - Build
     - Compilation success with g95 under MAC OSX. This version passed
       minimum tests currently available.
     - Compilation success with ifort under linux on an AMD 64-bits
       processor.

 - Kernel (SIC and GREG)
     - Better cleaning of allocated memory to avoid memory leaks.
     - Command RGDATA fixed when fed with 3 arrays of identical size.
     - "SIC SEARCH" is marked as obsolescent, i.e. user can still use it
       but it will disappear in the future. Message indicates possible
       replacement inside GILDAS.
     - There is NO more limitation in the number of file lines that a 
       single COLUMN command is able to load.
     - The widget associated to REPROJECT now correctly states the
       possibility to change the Epoch of equatorial coordinates.
     - Variables associated to GREG3 commands (IMAGE, KILL, SPECTRUM)
       are now defined only at first call of one of those commands.

 - ASTRO
     - Fixed the ATM [INTERPOLATE|MAKE|SAVE] command.

 - CLASS
     - Plait algorithm for OTF data is now available as the PLAIT task.
     - Now polygons may be used to define baseline windows for OTF data.
     - Fixed behavior of ACCUMULATE when R and T have different spectral
       resolutions and the weights are equal.

 - CLIC
     - First step implemented to work with the "new" ATM library developed
       by J.Pardo at CSIC.

## Mar05

skipped.

 - General
    - Some in-depth changes were needed in the kernel to avoid memory leak.
      Testing time is required before releasing those changes. It has thus
      been decided to skip Mar05 release.

## feb05

 - General
     - Following some late minute changes, a bug happened on exit for the
       gildas-src-feb05a.tar.gz version. Users are advised to get the fixed
       gildas-src-feb05c.tar.gz version.

 - ASTRO
     - Parallactic angle now also computed for planets.

 - CLIC
     - Added histograms in the visibility quality assessment.

## jan05

 - Build
     - Fixed compilation with IBM xlf under MAC OSX.
     - First compilation success with g95 under MAC OSX. However, there
       still are some problems at run-time.

 - Kernel (SIC and GREG)
     - New priority mechanism among languages to avoid undue ambiguities
       (e.g. to enable that the SPECTRUM command inside CLASS will call
       by default the CLASS\SPECTRUM and not the GREG3\SPECTRUM). For more
       details, HELP SIC PRIORITY.

 - ASTRO
     - Fixed a minor bug in the "LINE /SPECTRAL".

 - CLIC
     - Fixed normalization of RF bandpass calibration (antenna-based, per
       channel, for continuum units).

## dec04

 - General
     - There is a new GILDAS release under MS Windows! It is named
       gildas-win-dec04a.exe. It is much closer to the standard UNIX/Linux
       version than the previous release (i.e. gildas-win-jun04a.exe). For
       complete instructions, please look at install-gildas-on-windows.txt
       on the usual GILDAS download area.

 - Kernel (SIC and GREG)
     - Task GAUSS_2D fixed.
     - Improvements of MVIEW task.

 - CLIC
     - Normalized integration time to the number of baselines in CLASS FITS
       file written by the CLIC\FITS command. This enable correct time
       weighting of spectra inside CLASS when the spectra were obtained
       with a different number of antennas.

## nov04

 - Build
     - Support of G95 under linux.
     - Partial support of G95 under Cygwin.
     - Better support of the SUN platform.

 - ASTRO
     - Behavior change: The beam used in computation is now available
       through the READONLY SIC variable PRIMBEAM (in arcsec). User may
       override the default used beam size by setting the BEAM SIC variable
       to a non-zero value (in arcsec).

## oct04

 - ASTRO
     - There now is a basic but useful PdBI time and/or sensitivity
       estimator.

 - CLIC
     - Changes in the main calibration widget: new AUTOFLAG button and
       replacement of the EFF button by FLUX1 and FLUX2 buttons.
     - Improvement of the "self-calibration on point source" processing.
     - Cleaning of the 22GHz procedures.

## sep04

 - General
     - Removed reference to all previous email addresses (in particular
       nic@iram.fr and alma-simulation@iram.fr). Users should now use
       the gildas mailing list for bugs, comments and questions.

 - CLASS
     - User can now smooth up to 50 continuous channel (maybe useful for
       cosmological CO detection).

 - CLIC
     - Bug fix in the writing of the ALMA-TIFITS format.
     - Major cleaning of the procedures used for calibration of PdBI
       standard observing modes.

 - MAPPING
     - Worked around a ifort compiler which made the uv_fit-s task crash.

## aug04

 - Build
     - Updated first-hand documentation: AUTHORS, INSTALL, PROBLEMS,
       README, WISHES.
     - Definitely removed G77 support.

 - Kernel (SIC and GREG)
     - Polygons may now have up to 500 gons.

 - CLIC
     - Holography bug fixes.
     - Implementation of on-line 22 GHz atmospheric phase correction
       (Continued).
     - Major upgrade of on-line help.

## jul04

 - Build
     - Compilation under MACOSX 10.3 (32 bits) is now fully debugged.
     - Fedora Core 2 Linux distribution now supported.
     - General include files are now correctly copied to the executable
       branch enabling "easy" compilation of outside program against GILDAS
       general libraries.
     - Improvement in documentation compilation. In particular, HTML
       documents now correctly reference each others. Content must still be
       fully updated.

 - Kernel (SIC and GREG)
     - PS output is now fully EPS compliant (in principle).
     - DEFINE UVTABLE now enables creation of uv table from SIC.

 - ASTRO
     - New visibility and wind plot for Bure.

 - CLASS
     - Debugged and documented the CLASS\FITS command.
     - Added draft documentation of CLASS format.

 - NIC
     - Works again under Windows.

 - MAPPING
     - New version of the addition of short-spacing has been added in the
       main menu. Be careful: still in test.
     - A bit of cleaning of uv modelization tasks.

 - CLIC
     - Implementation of on-line 22 GHz atmospheric phase correction.

## jun04

 - Build
     - Debian and Suse Linux distribution now supported.

 - Kernel (SIC and GREG)
     - Exploration procedures of LMV data cube like "go bit", "go view",
       etc... now works almost in any GILDAS programs (in particular
       CLASS).

 - NIC
     - Minimum maintenance for use with recent data.

 - Alma simulator
     - Does not bug anymore at computation start.

## may04

 - Kernel (SIC and GREG)
     - On-line HTML help (set on with the "SIC HELP HTML" command) is
       working again.
     - Implemented new naming convention for the on-line help file:
       doc-help-language.nroff where program is the name of the doc where
       the hard-copy (PDF,HTML) equivalent of the on-line help will appear,
       and language is the name of the documented language (i.e.
       sic-help-gui.nroff).
     - Now the 3rd argument of SIC_LOAD is the signed number of commands
       and options (negative means library only mode). This enables the
       user to have on-line help on command like TASK\REAL.
     - Added the possibility to plot box with relative coordinates in
       arcsec in the p_box.greg procedure.

 - OTFCAL
     - First inclusion into the GILDAS distribution.

 - Mapping
     - "go snr" computes mosaic noise and SNR maps from signal and weight
        files.
     - Reinserted the forgotten uvsort tasks under uv_sort name.

## apr04

  - Major bug fix in interferometric noise estimation
      - Modification to transparently implement a change of interpretation
        of the GILDAS_UVDATA format. The old format was named
        "GILDAS_UVDAT", and contained an error in the interpretation of the
        weights of the UV tables.  The new format is named "GILDAS_UVFIL"
        and enables a correct direct estimate of the noise. All tasks or
        code creating UV Tables has been modified to use the new
        GILDAS_UVFIL format. GILDAS_UVDAT can no longer be written, so any
        code which would be using UV Tables OUTSIDE of this ensemble will
        no longer work if recompiled without modification. This is a
        precaution to avoid inconsistencies.  Appropriate scaling is done
        on-the-fly when reading old data. Old data cannot be modified,
        though. Only new data is being written in the new format. So, if an
        old UV table must be appended, please use the USER\UVT_CONVERT
        command introduced in GREG and MAPPING to easily convert from UVDAT
        to UVFIL formats.

  - Build
      - Implemented automatic GILDAS releases in the daily and monthly IRAM
        build.
      - Introduced a useful set of bash functions for GILDAS/USERS
        interaction at IRAM Grenoble.
      - Major upgrade of the GILDAS building system. In particular, it does
        not require anymore to be under bash (i.e. any Bourne-compatible
        shell is OK).
      - Successful compilation under sparc-solaris-f90, rs6000-aix-xlf.

  - Kernel (SIC and GREG)
      - Now correctly handle empty BUNIT keyword when creating a FITS file
        from a LMV cube.
      - Re-enable last procedure or task to be called again when "go" is
        called alone.
      - "go bit", "go lmv", "go map", "go nice" prompt for the "name" and
        "type" variables when they are equal to " ".
      - Transfered GreGPLOT shell script content directly into hard.fpp as
        a simplification. Introduced new logical variable GAG_LPR which
        defines the printing command. Changed printer logical variable name
        from "GAG_PLOTTER" to "GAG_PRINTER" for coherency.

  - ASTRO
      - Support of the /LOW_ELEVATION option for HORIZON command.

  - CLIC
      - Introduced SET WEIGHT BANDPASS ON|OFF command to enable application
        of bandpass calibration applied to weights in output UV table.
      - Better message for mis-match of source or position in creation of
        UV tables.

  - MAPPING
      - The "dummy" UV point at 7.5m has been suppressed, and replaced by
        the value of the primary beam size as "MAJOR axis" of the
        RESOLUTION section in the UV table. This primary beam size is used
        by UV_MAP and siblings to specify the default field of view, but
        not propagated further.

## mar04

  - General
      - Implemented new GILDAS standard behavior, i.e. the default opening
        of the program menu and of one plotting window. User can use the
        "-nw" or "-niw" switches to bypass this default. GILDAS manpages
        should be written.
      - Removed obsolescent equivalent statements between BYTE and
        CHARACTERS using the CHTOBY and BYTOCH new subroutines.

  - Build
      - Dirty patches to support rs6000-aix-xlf and powerpc-darwin-xlf.
      - First verification that the GILDAS dependencies are available 
        on the compilation system.

  - Kernel (SIC and GREG)
      - Added Xform, XML and PNG support.
      - On-the-fly conversion from simple FITS to GDF formats in command
        like "image" or "define image" is back again as a subroutine
        (i.e. not an independent program anymore).
      - The SIC procedures used to implement "go" and "input" are now
        shared by GREG and MAPPING.
      - Changes in processing of language ambiguities: 1) A fully typed
        command which raises ambiguity for other commands is now used
        without any message (i.e. FIT and FITS); 2) A message is now output
        when two (or more) identical commands exist in different languages.
      - GAG_EDIT and GAG_PLOTTER are respectively set to the $EDITOR and
        $PRINTER shell environment variables. This is the job of the user
        to ensure that they are correctly defined.

  - CLIC
      - Debugged widget support. In particular, added missing widget help
        files from a very old GILDAS version.

  - MAPPING
      - Fixed error bars in "go uvall". 
      - Now the STATISTIC command includes a guard band to decrease the
        effect of increased noise at map edges.

## feb04

  - General
      - Removed obsolescent BYTE statements.

  - Kernel (SIC and GREG)
      - Introduced "go vy" and "go xv" to make easy position-velocity
        plots.
      - Introduced the "center" variable in addition to the "size" variable
        to be able to position the zoom in "go bit" like procedures.
      - The file of the GREG font definition is now a portable binary file
        (i.e. it is translated on-the-fly from IEEE to EEEI and vice
         versa).
      - Introduced the GTV$NOFAIL logical variable. When set to .TRUE. it
        allows hard-copies to made regardless of whether the output file
        already exists or not.
      - MVIEW task is back.
      - Default hard-copy type changed from "ps fast" to "eps color" because
        only the eps device is fully compliant with the PostScript norm.

  - CLASS
      - Introduced cube2class.class to create a CLASS file from a spectra
        cube in GDF format.

  - CLIC
      - Lot's of work to get back pipeline modifications done at Bure
        during work on new gildas into the CVS repository.

## jan04

  - Build
      - Support of ifort, the new version of the Intel FORTRAN90 compiler.
      - Now produce a GILDAS environment file for bash and csh users.

  - Kernel (SIC and GREG)
      - All images are now deleted in a CLEAR TREE action. This raised the
        number of SIMULTANEOUSLY displayed images to 4096.
      - Debugged the histo_cross task.
      - Introduce a Cartesian to polar coordinate transformation procedure
        called car2pol.greg.
      - Now output the task log file to screen after the task end when the
        sic$tee variable is set to false. Default sic$tee value is OS
        dependent because the tee return status is bugged under Linux.
      - New rank (2d instead of 1d) of the SIC "size" variable used to zoom
        in "go bit" like commands.

## dec03

  - Build
      - Improved the building and administration of concurrent GILDAS
        versions: 1) Introduction of the gagadmdir gagsrcdir and gagexedir
        environment variables; 2) Introduction of the define-version.sh and
        define-system.sh scripts; 3) Clearer separation of the gag and go
        script functionalities.
      - Introduced support of the Portland compiler under Linux.

  - Kernel (SIC and GREG)
      - Adapted SIC demo procedure to GILDAS standards.
      - Implemented easy over-plotting capabilities through the "go over"
        command.
      - Almost fully rewritten "go over" procedure to take into account: 1)
        blanking values, 2) rectangular images, 3) zoom possibilities, 3)
        sub-cube extraction, 4) pixel killing/unkilling.  Logics inside the
        loop procedure tries to be simple (instead of clever) for
        readability.
      - The CAR(tesian) projection is now recognized by the GILDAS data
        format.

  - MAPPING
      - New tasks to calibrated visibilities on a uv model.

## nov03

  - General
      - Added the admin/gildas.el to enable correct font colorization of
        the GILDAS files under Emacs.
      - Standardization of each packages main menu. Verification that help
        files are correctly called.
      - Added the section about the release policy into the FAQ.
      - Adaptations for an experimental proof-of-concept of the python port
        of greg and clic.

  - Build
      - Support to build and release monthly version at IRAM.
      - Added protection against used of the building scripts under the csh
        shell.
      - Introduced the "build" script to easily (re)build GILDAS from the
        CVS repository.
      - Added support of alpha-osf-f90. Build support of 64 bits processor
        in the makefile system to do this.
      - Introduced the "make doc" and "make install-doc" to create and
        install PDF documentation from LaTeX source files.
      - Introduced the "show-path" script to enable easy viewing of long
        path environment variables.
      - Added support for end-user environment customization at end of
        installation procedure.
      - Now GILDAS tries hard to make the executable tree at the same level
        as the source tree. For instance, if your source tree is called
        $HOME/gildas-src or $HOME/gildas, the executable tree will be
        called $HOME/gildas-exe.

  - Kernel (SIC and GREG)
      - Fixed problem with terminal definitions.
      - Fixed string length problem in search of help files.
      - No longer any significant differences between Unix and MS-Windows
        for the handling of environment variables and logical name
        definition files.
      - Improved FITS handling routines.
      - Debugged a complete mis-behavior of LIMITS .. .. .. .. ABSOLUTE
        and PROJECTION commands.

  - ASTRO
      - Built in support for the new ATM library.

  - NIC
      - Translated NIC help from .hlp to .nroff format for standardization
        purpose.

  - MAPPING
      - Recreated an obsolescent GRAPHIC program for compatibility
        reasons.

From the first import to CVS (05-jun-2003) to first monthly release in new
system (i.e. Oct03, 01-oct-2003):

  - Build
      - Adapted doc to LaTeX 2e and PDF standards.  
      - Added many missing task help files.
      - Added possibility to automatically make ChangeLog files from CVS
        repository.

  - Kernel (SIC and GREG)
      - Update of SIC on-line help.
      - Introduction of the 1 ENDOFHELP convention to indicate the end of a
        help file. This avoids to have lots of dummy spaces at the end of
        the .hlp files.
      - Support of the back quotes to translated a Logical name.  For
        instance, assuming SPACE_CLIC is a Logical name with translation
        128, then SIC SAY `SPACE_CLIC` will be expanded to SIC SAY 128.
      - Support of multiple default extensions for the Procedures.  
        The syntax is simply
                SIC EXTENSION [.]Ext1 [[.]Ext2 [[.]Ext3 ....]]]
        It enables generic procedures to be given a generic extension, and
        called in cascade by specific programs.
      - Now automatically create the $HOME/.gag/ directory tree if it does
        not exists.
      - Replaced obsolete GFITS language by a VECTOR\FITS command.

  - ASTRO
      - The VSOP87 ephemerids file now is a portable binary file (i.e. it
        is translated on-the-fly from IEEE to EEEI and vice versa).

  - CLASS
      - Replaced obsolete CFITS language by a CLASS\FITS command.

  - CLIC
      - Common alignment is now checked at run time.
      - Debugged memory allocation problems to trim the memory size to its
         strict minimum.
      - Merged tifits inside clic.  
      - Added support for 64 antennas.  

Before the first import to CVS:

  - One year (part-time) of efforts to
      - Replace the old home-made preprocessor (fpre) by the standard cpp;
      - Devise a new GILDAS tree and sort the old sources in it;
      - Devise a new makefile system.
      - Configure CVS.

  - The major changes being
      - The obsolescence of GRAPHIC; its features have been transfered to
        GREG and/or MAPPING; old GRAPHIC procedures should still work in
        GREG and/or MAPPING.
      - The renaming of GILDAS libraries and general include.

Before that: 20 years of history, i.e. 20 years of experience to produce
well tailored softwares!
