# NEWS

## Index

### 2026

[Feb26b](#feb26b) · [Feb26](#feb26) · [Jan26](#jan26)

### 2025

[Dec25](#dec25) · [Nov25](#nov25) · [Oct25c](#oct25c) · [Oct25b](#oct25b) ·
[Oct25](#oct25) · [Sep25](#sep25) · [Aug25](#aug25) · [Jul25b](#jul25b) ·
[Jul25](#jul25) · [Jun25](#jun25) · [May25](#may25) · [Apr25b](#apr25b) ·
[Apr25](#apr25) · [Mar25](#mar25) · [Feb25b](#feb25b) · [Feb25](#feb25) ·
[Jan25](#jan25)

### 2024

[Dec24](#dec24) · [Oct24](#oct24) · [Sep24](#sep24) · [Aug24](#aug24) ·
[Jul24b](#jul24b) · [Jul24](#jul24) · [Jun24b](#jun24b) · [Jun24](#jun24) ·
[May24c](#may24c) · [May24b](#may24b) · [May24](#may24) · [Apr24](#apr24) ·
[Mar24](#mar24) · [Feb24](#feb24)

### 2023

[Nov23c](#nov23c) · [Nov23b](#nov23b) · [Nov23](#nov23) · [Oct23d](#oct23d) ·
[Oct23c](#oct23c) · [Oct23b](#oct23b) · [Oct23](#oct23) · [Sep23](#sep23) ·
[Aug23](#aug23) · [Jul23](#jul23) · [Jun23](#jun23) · [May23](#may23) ·
[Apr23](#apr23) · [Mar23b](#mar23b) · [Mar23](#mar23) · [Feb23](#feb23) ·
[Jan23b](#jan23b) · [Jan23](#jan23)

### 2022

[Dec22b](#dec22b) · [Dec22](#dec22) · [Nov22b](#nov22b) · [Nov22](#nov22) ·
[Oct22b](#oct22b) · [Oct22](#oct22) · [Sep22](#sep22) · [Aug22](#aug22) ·
[Jul22c](#jul22c) · [Jul22b](#jul22b) · [Jul22](#jul22) · [Jun22](#jun22) ·
[May22](#may22) · [Apr22](#apr22) · [Mar22](#mar22) · [Feb22b](#feb22b) ·
[Feb22](#feb22) · [Jan22](#jan22)

## Feb26b

- ASTRO
    - Improved interface with OMS through the OMS and PROPOSAL commands.

## Feb26

- Build
    - GTK3 is now the default when available; use "-o gtk2" to force
      GTK2. GTK3 support requires version 3.24 or newer.

- Kernel (SIC and GREG)
    - GREG lens tool now behaves correctly under GTK3 when dragging.
    - SIC command line: word-wise navigation (Ctrl/Alt arrows), Home/End,
      DEL, and Alt+Backspace are now supported.
    - HELP TYPE, HELP LIMITS /XLOG|/YLOG, and HELP LET improved.

- CLIC
    - Added BLANK /ANTENNA and per-antenna blanking counts.
    - LIST /FLAG now shows receiver number.
    - Added CORRECTION /RECEIVER option for OBS (DBR).

## Jan26

- Kernel (SIC and GREG)
    - GTK3 HSV control ported and GUI rendering fixes.
    - Improved zoom, focus, and pointer handling in GREG windows.
    - LUT list sorted with a default entry; demos refreshed.

- ASTRO
    - EMIR HELP formatting corrected and E2/E3 LO edge fixed.
    - Receiver tables updated.

- CUBE
    - FITS export now supports CAR and NCP projections.

- CLIC
    - Pipeline corrections improved for RF calibration and masks.
    - Added SPW line selection and clearer warnings.

## Dec25

- Build
    - Added GTK2/GTK3 build selection (ggtk2 default, "-o gtk3").
    - On MacOS with GTK3, GDK_RENDERING is set to "image".

- Kernel (SIC and GREG)
    - Fixed precedence of unary minus vs power in SIC arithmetic.
    - The "sec" variable definition moved from GREG to SIC.
    - GUI tools updated during GTK2/GTK3 migration.

- ASTRO
    - ASTRO\SOURCE: added flux and spectral index in
      ASTRO%SOURCE%FLUX(1:2) with improved parsing and HELP.
    - ASTRO\SOURCE and ASTRO\HORIZON: fixed NULL velocity handling.

- CUBE
    - Updated the legacy l-old-beam procedure.

- MRTCAL
    - Improved MJD split around midnight for CLASS spectra.

- PAKO
    - displayPako scripts ported to Python 3.

- CLIC
    - FIND: added /CORRELATOR 1|2 option for Polyfix correlators.

## Nov25

- Kernel (SIC and GREG)
    - gag_mdate and sic_c_datetime_from_raw now store seconds in I*8.
    - POLYGON /RESET supported; BIT avoids reusing temp polygons.
    - CDMS access now falls back to TLSv1.2.

- CUBE
    - Avoid region_t when input cubes have different spectral
      resolutions.
    - ERODE: default erosion size set to 1 pixel.
    - VERIFY also checks for FREQRESO keyword.

- MRTCAL
    - @ plot-azel: added /commanded and azel%fast%.

- PAKO
    - Improved robustness and updated EMIR band offsets.

- CLIC
    - Added message when getting/storing BP solutions in memory.

- MIS
    - Updated NOEMA configuration files.

## Oct25c

- CUBE
    - Export spectral resolution as FREQRESO or WAVERESO in FITS.
    - LOAD/GET frequency, wavelength, velocity, and redshift return
      resolution in the right unit.

## Oct25b

- Build
    - Fixed compilation under MacOS and ifort 14.0.

- Kernel (SIC and GREG)
    - Date parsing now rejects mispelled dates (e.g. 01-SEPT-2025).

- ASTRO
    - Updated station position file and phase-pdb.sou.

- CUBE
    - Refactored spectral and header editing around header_interface.
    - Implemented SET\OUTPUT /RADIO2SFL and new spectral helpers.
    - Reworked DAG/list internals and history index I/O.
    - Added ROTATE, XY2PP, PPV2XYV /WEIGHT, and WEIGHT noiseid.
    - COLLECT: added /FORMAT and improved output handling.

- CLASS
    - FIND /OBSERVED: added missing error check.

- CLIC
    - Minor fixes in line tables and printing.

## Oct25

- Kernel (SIC and GREG)
    - HELP TIMER and HELP SIC TIMER updated.
    - sic_ambigs now raises errors for overlong arguments.
    - GUI\PANEL: avoid overflow when building large widgets.

- ASTRO
    - Introduced 2025 station positions.
    - PICO\EMIR: improved baseband choice handling and HELP.

- CUBE
    - FITS headers: long-string support and VO header improvements.
    - VERIFY rejects non-FITS N-D cubes.

- CLASS
    - UNBLANK preserves XYW columns when writing new tables.

- MRTCAL
    - ODP plots use F units; SET TYPE LINE resets default units.
    - Updated tracking plots and pipeline tools.

- CLIC
    - Pipeline updates for mixer-problem handling and user input.
    - System commands now run in bash for newer Python setups.

## Sep25

- Kernel (SIC and GREG)
    - EXAMINE: avoid crash on arbitrary-length strings.
    - G\MEAN: fixed polygon edge case when ray hits a vertex.

- ASTRO
    - ASTRO\UV_TRACKS: improved display and /FRAME handling.
    - ASTRO\OBSERVATORY,HORIZON: corrected typo and message severity.

- CLASS
    - GET: sanity checks and CLASS_GET_FORCE for unexpected sizes.
    - GET NEXT: fixed end-of-index handling.
    - AVERAGE: preserve calibration value when constant.

- MAPPING
    - UV_FIT: improved formatting for long flux error values.

## Aug25

- Build
    - Added AlmaLinux system detection in admin/define-system.sh.

- Kernel (SIC and GREG)
    - GO VIEW <VSIDE: display absolute coordinates at cursor position.
    - <VSIDE layout adjusted for added information.

- ASTRO
    - Updated phase-pdb.sou.

- MRTCAL
    - INDEX CONVERT /FILE converts old index versions in pipelines.
    - Added MDX%HEAD%SCI% and MDX%HEAD%CAL% structures.
    - Added @ plot-azel /derivative and plot-azel procedure.
    - MCOPY improved for index copying.

- CLIC
    - Updated pipeline data tables.

## Jul25b

- ASTRO
    - PROPOSAL and PROPOSAL /FEBE: stop when no source is defined.
    - NOEMAOFFLINE\PLOT: selected basebands available for SPW.
    - FEBE LOAD: plot and baseband selection updated.

## Jul25

- Kernel (SIC and GREG)
    - HARD /DEV SVG: fixed crash when exporting clipped images.

- ASTRO
    - ASTRO\SOURCE: hour angle constrained to [-pi,+pi].
    - ASTRO\PLANET: updated HELP and output method information.
    - NOEMAONLINE\BASEBAND: corrected mode numbers in HELP.
    - PICO\EMIR: fixed LO limit handling (including band E0 USB).
    - SHOW OBSERVATORY: corrected altitude formatting for >10 km.

- CLASSIC
    - classic-dump: added Python 3 decoding examples.

- CLIC
    - ngr-x_calib_verify: fixed flagging for 1-scan intervals.

## Jun25

- Build
    - INSTALL: update Fedora example to Fedora 42.
    - Debian/Ubuntu: document python-dev-is-python3 when using
      python-is-python3.

- ASTRO
    - Added hour angle to ASTRO%SOURCE (ASTRO%SOURCE%HOUR_ANGLE).

- CLASS
    - HELP MAP: clarified natural beamwidth derivation.

- MAPPING
    - HELP CLEAN PRIMARY and CLEAN UV__MAP: removed obsolete BeamSize
      argument.
    - HELP XY_MAP TUNING: fixed typo.

## May25

- Build
    - GCC 15: fix C23-related unprototyped function warnings.
    - Numpy headers now located via numpy.get_include() for Numpy >= 2.

- Kernel (SIC and GREG)
    - PyGildas: handle Unicode arrays with Numpy 2.
    - SIC listeners: fixed function pointer casts for GCC 15.

- ASTRO
    - ASTRO\SOURCE: added sun distance to ASTRO%SOURCE structure.

- CLIC
    - Updated 2025 baseline models and pipeline handling.

- MAPPING
    - UV_CAL: fixed allocation failure when processing tables in blocks.

## Apr25b

- Kernel (SIC and GREG)
    - SYSTEM: fixed PS1 when entering interactive bash.

- ASTRO
    - Updated phase-pdb.sou.

- CUBE
    - Introduced the UV language and TABLE2CUBE template.
    - Added PRIMARY command and header-interface list improvements.
    - FITS import/export: handle missing values as NaN and better
      wavelength axis support.
    - HISTO/HISTO1D: added NaN and overflow guards.
    - CUBESET PANEL and iterator handling refactors.

## Apr25

- Build
    - Fixed compilation under Mac OS X.

- Kernel (SIC and GREG)
    - PEN /DASH: invalid values rejected.
    - SIC\PYTHON: clearer error when script is missing.

- TELCAL
    - Pointing processing: cross-pointing support and drift checks.

- ASTRO
    - Updated dichroic Trec figures and documentation.

- CLASSIC
    - LIST /TOC engine now uses numerical keyword identifiers.

- CUBE
    - Refactored format handling around format_t and libcubeformats.
    - HISTORY /DIGRAPH generates a PDF of cube parents.

- CLASS
    - MFIND /FRONTEND and MLIST /TOC enriched; HELP updated.

- MRTCAL
    - Reworked pointing sections and results tables.
    - Added MSET SOLVE POINTING and MLIST /POINTING columns.

- CLIC
    - Pipeline corrections updated for baseline/time adjustments.

## Mar25

- Build
    - Fixed staticlink compilation.

- Kernel (SIC and GREG)
    - FOR: fixed error recovery when a nested FOR raises an error at
      compilation time.

- ASTRO
    - NOEMA sensitivity estimator memo updated (dual-band and frequency
      cycling); NOEMA\TSYS updated.

- CLIC
    - Added support for holo IMB-FITS file names.

- MAPPING
    - HELP UV_FILTER: documented /RANGE.

## Feb25b

- Kernel (SIC and GREG)
    - GTV\LUT /BLANK: added named color option and replaced the
      blanking-color procedure.
    - GTV: l-ctrl slave action now restores <greg directory.

- CUBE
    - APERTURE refactor and spatial-ellipse types.
    - CIRCLE: corrected axis handling and fullset access.
    - COMPRESS: allow axes down to 1 pixel/channel.
    - TEMPLATE: added ONECHAN and renamed SPEC2CHAN.
    - DAG paths now stored relative to the DAG file.

## Feb25

- Build
    - INSTALL: updated Python and Mac notes.
    - Admin scripts detect python3 when python is missing.

- Kernel (SIC and GREG)
    - Added R_DMLAMP in variable modifiers; HELP SET VARIABLE updated.

- ASTRO
    - ASTRO\PLANET: added giant-planet brightness models and docs.

- CUBE
    - EXTRACT /LIKE and header-interface sanity checks.
    - SLICE access fixes and task iterator improvements.

- CLIC
    - SOLVE HOLO: added /THRESHOLD option (30m/NOEMA).
    - Calibration safeguards for SET BB/IF/SUB/SPW.

## Jan25

- Kernel (SIC and GREG)
    - SIC: ^C at the terminal prompt is caught before executing a new
      command.

- ASTRO
    - ASTRO%SOURCE now stores computation time.
    - NOEMAOFFLINE\TUNING and PICO\EMIR tuning updates.

- CUBE
    - Introduced MASK language and new masking commands.
    - IMPORT/EXPORT and DAG handling improved.
    - DIR /RAW supports semicolon-separated lists of paths.

- CLIC
    - Pipeline updates and HELP TABLE /MOSAIC.

- MAPPING
    - RESAMPLE and STICH: missing resampled channels set to NaN.

## Dec24

- Kernel (SIC and GREG)
    - SIC FIND handles non-existing directories consistently.
    - Python binding now requires Python 3.6+ and exposes SIC%PYTHON.
    - Python 2 scripts ported to Python 3.

- ASTRO
    - PICO\BASEBANDS: fixed baseband display on sideband plots.

- CUBE
    - EXPORT /FILENAME: revised heuristic for file name extension.

- CLASS
    - SET VARIABLE: HFS keyword recognized; HELP updated.

- PAKO
    - Minor robustness updates.

- CLIC
    - FIND: added /SWITCHING option.

- MAPPING
    - RESAMPLE and STICH: missing resampled channels set to NaN.
    - FITS-to-GDF: improved CD/PC matrix handling.
    - UV_CAL: optional use of nearest non-zero gains.

- Contrib
    - WEEDS: added CDMS line visualization support.

## Oct24

- Build
    - IFX compiler is rejected for default users.

- Kernel (SIC and GREG)
    - gag_isodate2mjd no longer crashes on invalid ISO strings.

- ASTRO
    - Minor updates to calibration handling.

- CUBE
    - VERIFY no longer requires NOISETHE/NOISEMEA in headers.

- CLIC
    - PROPOSAL now checks correlator consistency for cycling setups.
    - clic_virtual arrays made allocatable.

- MRTHOLO
    - Added procedures to grid holography spectra and export to CDF.

## Sep24

- Kernel (SIC and GREG)
    - Obsolete options now carry dates and raise clearer errors.

- ASTRO
    - CDMS line decoding fixed for NH3-wHFS alignment.

- CUBE
    - COLLECT help updated; obsolete options error handling improved.

- CLASS
    - Minor support updates.

- MIRA
    - OpenMP can be disabled via OPENMP_PRESENT=no.
    - Linking adjusted to resolve OpenMP dependencies.

- MRTCAL
    - Minor updates to calibration indexing.

- FLUX
    - Added missing fitting functions.

- POINT
    - Minor updates to pointing helpers.

- CLIC
    - Minor updates to data handling.

- MAPPING
    - UV_FIT: added missing fitting functions in menus.

- MRTHOLO
    - Minor updates to holography utilities.

## Aug24

- Build
    - Added MOD_POST_SETUP hook for Python module installation.

- Kernel (SIC and GREG)
    - Improved HELP ON ERROR.
    - Added helper to draw labels with current orientation.

- ATM
    - ATM 2009 PATH: warning now shown only once.

- ASTRO
    - Fixed source lambda/beta values.

- CLASS
    - Low-resolution handling adjusted in CRALL.

- MRTCAL
    - Filled azimuth/elevation values for each subscan.

- CLIC
    - MODIFY PHASE help updated and NEW_DATA error clarified.
    - WVR phase handling and tracking updates.

- MRTHOLO
    - Minor updates to holography tools.

## Jul24b

- ASTRO
    - NOEMAOFFLINE\PROPOSAL: improved PMS tagging and validation.
    - NOEMAOFFLINE\SPECSWEEP: refactored for FEBE types and /ADD_FEBE.
    - NOEMAOFFLINE\FEBE: added HELP and argument checks.

## Jul24

- Build
    - Python-disabled builds now compile cleanly.
    - gildas-env.sh ensures Python install directory exists.

- Kernel (SIC and GREG)
    - Python master/slave exit behavior improved.
    - Added fallback PyGILState_Check for Python 3.4.

- ASTRO
    - NOEMA\TSYS: added /DBR and linear Trec option.
    - NOEMAOFFLINE\PLOT: BANDCHECK added for PMS validation.

- MAPPING
    - HELP SELECT: wildcard search documented.

- MRTHOLO
    - Minor updates to holography support.

- Contrib
    - WEEDS demo updated for CDMS line rename.

## Jun24b

- CUBE
    - Added COMPRESS command with /FACTOR option.
    - FITS disk-mode reads handle oversized buffers safely.

## Jun24

- Build
    - Default system library path no longer prepended to LD_LIBRARY_PATH.

- Kernel (SIC and GREG)
    - DATETIME: fixed memory leak.
    - LUT: added colorcet.com look-up tables (HELP LUT CET).

- ASTRO
    - CALGRID polarization now provides HH and VV.

- CUBE
    - CLEAN: fixed random crash in parallel mode.

- CLASS
    - NOISE: improved guess-value formatting.

- MRTCAL
    - Minor calibration updates.

- CLIC
    - Added delay-fit variables and reference delay handling.

- MAPPING
    - CLEAN: fixed crash with uninitialized mosaic method.

- MRTHOLO
    - Build fixes after MRTCAL changes.

## May24c

- Build
    - Python 3.5.3 uses legacy python-config scheme.

- MRTCAL
    - INDEX /DATE parsing fixed for A TO B BY C syntax.

## May24b

- Kernel (SIC and GREG)
    - FITS reader now supports PC matrix.

## May24

- Kernel (SIC and GREG)
    - GTV and SIC help updated; line database Python tools refreshed.

- ASTRO
    - Minor updates to observing configuration data.

- CUBE
    - Maintenance updates to data handling.

- CLASS
    - Minor updates to help and formatting.

- MRTCAL
    - Tracking error plots and reporting refinements.

- CLIC
    - New pipeline_tools and pipeline_corrections procedures.
    - Updated verification, warnings, and polarisation handling.

## Apr24

- Build
    - Updated define-system handling for compiler sensitivity.

- Kernel (SIC and GREG)
    - SIC\PYTHON reports missing scripts clearly.

- ASTRO
    - Minor updates to base-fitting support.

- CLASS
    - ANALYSE\DRAW and ANALYSE\FFT help clarified.

- CLIC
    - SOLVE BASE /COS and PRINT BASELINE /FILE added.
    - PLOT /NOSORT option documented.

## Mar24

- Build
    - Mac OS GAG_ENV_NAME detection fixed.

- Kernel (SIC and GREG)
    - Added SIC%REVISION%DATE.

- ASTRO
    - Minor updates to calibration handling.

- CUBE
    - FITS read/write: SPECSYS and VELREF handled consistently.
    - Rest-frequency and velocity offset handling improved.

- CLASS
    - Stokes leakage normalization updated.

- CLIC
    - Calibration widget help and notes improved.

- MAPPING
    - MAP%PTYPE allows output projection customization.
    - HELP XY_MAP TUNING updated.

## Feb24

- Build
    - Added GAG_ENV_NAME and improved GAG_EXEC_SYSTEM on MacOS.

- Kernel (SIC and GREG)
    - SIC\SIC now reports OS kind/name/version and compiler details.
    - SIC%OS% and SIC%COMPILER structures added.

- ASTRO
    - Minor updates to observing utilities.

- CUBE
    - Large maintenance update.

- CLASS
    - Minor fixes and updates.

- MRTCAL
    - Added tracking error plots and antenna slow-trace shifts.

- CLIC
    - Maintenance updates and fixes.

- MAPPING
    - Large maintenance update.

- MRTHOLO
    - Compilation fixed after MRTCAL changes.

## Nov23c

- Kernel (SIC and GREG)
    - PATH_MAX handling fixed for MacOS and gcc 13 builds.

## Nov23b

- Build
    - gfortran release builds no longer pass -w to avoid allocation
      failures.

## Nov23

- Kernel (SIC and GREG)
    - Orthographic projection: fixed North pole definition when the
      reference point is on the Equator.
    - G\SET MARKER N now sets the correct marker side count.

- CLASS
    - LAS\FITS: import/export SPECSYS, VELREF, RADESYS, and BMAJ/BMIN/BPA
      when available.

- CUBE
    - Internal updates and fixes across core commands and data handling.

- CLIC
    - Mosaic patch ranges extended for affected periods.

- MAPPING
    - CLEAN and imaging code updates and fixes.

## Oct23d

- CLIC
    - _delay and _phase now compute data modifiers for both LR and HR
      data while only modifying LR data.

## Oct23c

- Kernel (SIC and GREG)
    - Descriptor sizing fixes for sic_mapgildas and desc_nword().

- MAPPING
    - Spergel half-light radius fixed.

## Oct23b

- Build
    - Removed unsupported -commons use_dylibs for Xcode 15 on MacOS.

- Kernel (SIC and GREG)
    - GDF header read guard fixed for non-section VOID checks.

## Oct23

- Kernel (SIC and GREG)
    - GREG /READ now supports 1024-character lines.
    - V\HEADER improved for SIC header variables.

- CLIC
    - SET STOKES, SOLVE RF, and STORE RF help updated for polarization.
    - NOEMAOFFLINE\PLOT: SPW edge protection and other fixes.

- CUBE
    - GDF header consistency checks now catch corruption earlier.

- ASTRO
    - Minor updates and fixes.

- MIS
    - Minor updates and fixes.

## Sep23

- CUBE
    - ROTATE now reuses REPROJECT engine and registers output cubes.
    - STITCH and SUM register outputs; resampling crash fixed.
    - XY_MAP naming and spectrum axis associations fixed.

- CLIC
    - RF calibration and widget handling fixes.

- CLASS
    - Minor updates and fixes.
## Aug23

- Kernel (SIC and GREG)
    - SIC PARALLEL now reports current thread count.
    - OpenMP enabled/disabled feedback added.

- CUBE
    - Stereographic and Aitoff projection handling fixed.
    - Radio-projected maps now export as SFL with proper reference.
    - XY_MAP handles radio-to-azimuthal conversion.

- CLIC
    - Baseline calibration and validation fixes.

- MAPPING
    - deconv tools noise handling corrected.

- CLASS
    - Minor updates and fixes.

## Jul23

- MAPPING
    - Added UV_STACK and UV_RMS commands.
    - GO TELES now auto-runs GO CONVERT when needed.
    - Minimum map size enforced at 64 pixels.

- CLIC
    - Calibration scripts updated for parasite handling.

- Kernel (SIC and GREG)
    - Minor updates and fixes.

## Jun23

- CLIC
    - Major pipeline acceleration using low-resolution data paths.
    - RF calibration flow updated and additional flags added.
    - Added si-pipeline.dat.

- CUBE
    - Internal updates and fixes across core tools.

- ASTRO
    - Minor updates and fixes.

- MAPPING
    - CLEAN: fixed random crash in parallel mode.

## May23

- Build
    - Updated ifort option to -nofor-main.

- CUBE
    - V\FITS FROM: fixed polarisation UV table export to UVFITS.
    - Large arrays moved to heap allocation.

- CLIC
    - store_pass_scan call sequence fixes.

- MAPPING
    - Default CLEAN parameters adjusted (fres=0, niter=500).

## Apr23

- Kernel (SIC and GREG)
    - SIC TIMER disabled by default in programs.
    - HELP SIC FIND typo fixed.

- CLIC
    - Index capacity increased to 1,000,000 entries.

## Mar23b

- Build
    - Fixed missing libraries at link time.

- CUBE
    - HEADER /FORMAT VO expanded with JSON output and new metadata
      fields.

- CLASS
    - Minor updates and fixes.

- MAPPING
    - Minor updates and fixes.

## Mar23

- Build
    - Public repository access now uses https.

- Kernel (SIC and GREG)
    - Added sic_descriptor_getval array support and conversions.
    - DEFINE FITS now exports keywords without EXTNAME reliably.
    - Added gwcs_observatory_exists helper.

- CLIC
    - STORE PHA /SELF fixed for spectral index amplitude.

- MAPPING
    - XY_MAP block-size overflow fixed for large memory limits.

- MRTHOLO
    - Added tools for 30m gravitational files and data-type checks.

## Feb23

- Kernel (SIC and GREG)
    - GO VIEW: zoom spectra intensity scale with right click.

- ASTRO
    - UV_TRACKS help and messages improved.

- CLIC
    - Internal cleanups and fixes.

- MIS
    - Updates to configuration data.

- CLASS
    - Minor updates and fixes.

- MAPPING
    - Minor updates and fixes.

## Jan23b

- CUBE
    - FREE: fixed history cleanup regression.
    - IMPORT: fixed crash when no data are imported.

## Jan23

- Build
    - Documented Git-based source retrieval.
    - CVS sources no longer supported by go.

- Kernel (SIC and GREG)
    - HISTOGRAM /BASE Z plotting fixed with /FILL and /HATCH.

- ASTRO
    - ASTRO\SOURCE /CURSOR fixed and documented.

- CUBE
    - Array allocations moved away from fixed-size limits.

- CLIC
    - NOEMAOFFLINE warnings for out-of-range LO tunings.

- CLASS
    - Minor updates and fixes.

## Dec22b

- CUBE
    - FREE now releases history entries to avoid invalid DAG snapshots.

## Dec22

- Build
    - Missing python-config disables Python support with a warning.
    - Suggested python-dev-is-python3 for Debian/Ubuntu builds.

- Kernel (SIC and GREG)
    - Removed deprecated sic_get_foreign after long obsolescence.

- ASTRO
    - FIND_CALIB widget now tolerates empty fields and uses local
      catalogs.
    - UV_TRACKS fixes antenna-size handling and point-count limits.
    - Line catalog tab spacing allows kHz frequencies to parse.

- CUBE
    - HISTORY /CUBE added to list cube ancestry and parent links.
    - UNDO accepts a range of command IDs.
    - IMPORT no longer accepts DAG files directly.

- CLASS
    - STRIP: improved lambda/beta heuristic and SET MATCH tolerance.

- MRTCAL
    - plot-loads auto Y limits now include all beam-switching loads.
    - Continuum drift append mode no longer inserts an empty first
      chunk.
    - Added a tool to display beam-switching loads during drifts.

- PAKO
    - Removed obsolete pako.f F77 source.
    - Skip Python subdirectory when Python support is disabled.

- CLIC
    - Baseline tables now cover >1000 m and supplementary stations.
    - RF+spidx calibration now accounts for RF blanking.
    - Increased max_rf_file for larger RF file sets.

- MAPPING
    - RUN UV_FIT now deallocates buffers to avoid sanitizer errors.

## Nov22b

- Kernel (SIC and GREG)
    - HELP DRAW revised to clarify key bindings.

- ASTRO
    - Line catalog tab spacing fixed to read kHz frequencies.

- CUBE
    - Added BROWSE command in GO\ for spectrum inspection with zoom.
    - Running-median baselining added for spectra.

- MAPPING
    - READ COVERAGE now reports clearer errors for unsupported READ.

## Nov22

- Build
    - python-config-ldflags.py now derives flags from python-config.
    - Documentation files moved to UTF-8 encoding.

- Kernel (SIC and GREG)
    - ISNUM() added for numeric argument checks in scripts.
    - FFT routines now handle larger array sizes.

- ASTRO
    - Updated NOEMA configuration files.

- CLASS
    - MODIFY VCONVENTION/VDIRECTION now refreshes spectral metadata.

- MRTCAL
    - Continuum drift chunks now carry positions, angles, and offsets.
    - Beam-switching mode added with chunk append support.

- CLIC
    - LOWRES mode keeps LR/HR RF spectra and uses lband_original.

- MAPPING
    - UV_SHORT now guards NaN/Inf inputs and frees buffers on exit.
    - UV_SHORT proposes reprojection when SD maps are mis-centered.

## Oct22b

- CUBE
    - SIC\IMPORT CUBE now supported through the pycube module.
    - IMPORT now handles the new format_t file kinds.
    - STITCH and SUM commands replace STITCH2 and SUM2.

## Oct22

- Kernel (SIC and GREG)
    - GO NOISE stores histogram files relative to current directory.

- ASTRO
    - NOEMAOFFLINE/PLOT and PROPOSAL drop the 250 kHz warning.

- MRTCAL
    - Added pointing obs_type and safer empty-index handling.
    - Backend plots now adapt to variable part counts and show BAND.

- CLIC
    - Added stations E122/E148/E161 and corrected E059 coordinates.
    - LOWRES mode limits spw selection by bb/if/pol.
    - WideX backward-compatibility restored.

- MIS
    - UV_TRACKS B config typo fixed.

## Sep22

- Kernel (SIC and GREG)
    - HELP SHOW LIMITS expanded.
    - ifort 14 compilation issue fixed in IMBFITS headers.

- ASTRO
    - New station coding (E100-E199) and updated 12A/12B/12C configs.
    - SOURCE and HORIZON no longer use unnecessary global variables.

- CLASS
    - Scan number formatting widened for large values.

- MRTCAL
    - OFF/ON subscan list now distinguishes track vs OTF offsets.

- CLIC
    - Station coding and EVA formats updated for new configs.

- MIS
    - UV_TRACKS configuration files updated for NOEMA changes.

## Aug22

- Kernel (SIC and GREG)
    - SIC\DIFF now accepts matching element counts with degenerate
      dimensions.

- ASTRO
    - UV_TRACKS updated for new NOEMA station naming (E068 style).
    - SOURCE parallactic-angle sign fixed.

- CLASSIC
    - Dropped legacy non-Fortran-2003 code path.

- CLASS
    - Dropped legacy non-Fortran-2003 code path.

- CLIC
    - SET MODE FULL|LOWRES introduced for low-resolution workflows.
    - Lowres initialization and buffer sizing refined.

- MAPPING
    - Avoid extra blank lines at MAPPING startup.

## Jul22c

- ASTRO
    - UV_TRACKS updated for new NOEMA station naming (E068 style).

- MIS
    - NOEMA configuration files updated for new station naming.

## Jul22

- Build
    - CUBE now requires CFITSIO and is skipped if it is missing.

- Kernel (SIC and GREG)
    - G\DRAW VALUE now reports coordinates down to 0.1 mas precision.
    - PLOT /SCALING LOG avoids failures on negative extrema.

- ASTRO
    - NOEMAOFFLINE/PLOT optimized for 250 kHz mode display.
    - UV_TRACKS cleanup prepares for longer station names.

- CUBE
    - FITS IMAGE I/O now handles >2^31 elements via new CFITSIO calls.
    - CUBE\STITCH/AVERAGE index handling and history tracking refined.
    - ADM\IMPORT reports timings for large directory imports.

- MRTCAL
    - IMBF derotation tables now ignore missing zero-sized arrays.

- PAKO
    - displayPako.py forced to Python 2 for compatibility.

- CLIC
    - corrmode detection now uses r_lband SPW range.

- MAPPING
    - UV_RESAMPLE now expresses resampling in channels, not pixels.
    - UV_FLAG accepts multiple antennas and works without a display.
    - Selfcal tool cleanup and updated documentation.

- MIS
    - RUN UV_CCMODEL no longer crashes on missing allocations.

## Jun22

- Kernel (SIC and GREG)
    - FFTW3 support added for OpenMP builds and SIC FFT syntax.
    - LET /FORMAT now handles ifort internal-string limitations.
    - SIC MESSAGE /COLOR enables colored message output.

- ASTRO
    - SPECSWEEP fixed 250 kHz handling and SPW sorting.
    - NOEMAOFFLINE NEWVEL/TUNING now handle grid shifts correctly.

- CLIC
    - Plot/list SPW for different modes when BB modes match.

## May22

- Kernel (SIC and GREG)
    - SIC MESSAGE /COLOR controls message coloring.
    - DEBUG /MESSAGES shows command name prefixes.

- ASTRO
    - External ASTRO plot API keeps user-defined labels.

- CLASSIC
    - TOC engine supports longer equivalence classes and widths.

- CUBE
    - CUBE\MERGE can merge headers, projections, and telescope lists.
    - BIT /HEADER displays header summaries and adds help.

- CLIC
    - SET X VLBI_MASER added for GPS maser plots.

## Apr22

- ASTRO
    - UV_TRACKS includes updated NOEMA configurations and W47 coords.

- CLIC
    - Bandpass now handles complex data correctly.

- MRTCAL
    - IMB-FITS 2.20 handling fixed for holography reads.

- MIS
    - UV_TRACKS includes noema-12[a,c,d] configs for simulations.

- MRTHOLO
    - Holography subscan timestamps and format handling fixed.

## Mar22

- Kernel (SIC and GREG)
    - SAY /FORMAT now evaluates expressions consistently.
    - G\CONNECT handles infinite values correctly.

- ASTRO
    - BASEBAND PLOT warning clarified for 250 kHz mode.
    - HELP CATALOG /LINE updated for comment syntax.

- CLIC
    - Pipeline supports baseline-based calibration and RF warnings.
    - Calibration logs include flux reference scaling in time.

- MAPPING
    - GO SNR now computes mosaic SNR from weights.
    - deconv-tools now accounts for blanking in CLEAN maxima.

## Feb22b

- ASTRO
    - NOEMAOFFLINE\BASEBAND PLOT warning updated for 250 kHz mode.

## Feb22

- Kernel (SIC and GREG)
    - DEFINE FITS now handles UVFITS keyword ordering correctly.
    - FITS export adds BUNITj and corrects CUNITj handling.

- CLIC
    - RF calibration now supports spectral-index corrections.
    - Pipeline RF plots use bandpass scan metadata.

- MAPPING
    - MRC CLEAN widget now updates the smoothing ratio reliably.

## Jan22

- Build
    - Python bindings now use setuptools instead of distutils.
    - Python 2.6 support dropped.

- Kernel (SIC and GREG)
    - FITS images now zero-pad trailing blocks as required.
    - UV column shifts now work in both compression and extension.

- CLASS
    - WRITE with mixed switching sections now expects 0 phases.

- CLIC
    - Added antenna 12 and updated 12A/12C/12D configurations.
