# Installation Guidelines

## Table of contents

- [I - RELEASE NOTES](#i---release-notes)
- [II - DOWNLOAD](#ii---download)
  - [1 - Sources from homepage](#1---sources-from-gildas-homepage)
  - [2 - Sources from GIT repository](#2---sources-from-git-repository)
  - [3 - Documentation from homepage](#3---documentation-from-gildas-homepage)
- [III - REQUIREMENTS](#iii---requirements)
  - [1 - Supported systems](#1---supported-systems)
  - [2 - Material](#2---material)
  - [3 - Tools to build executables](#3---needed-tools-to-build-executables-from-sources)
  - [4 - Tools to build documentation](#4---needed-tools-to-build-the-documentation)
- [IV - INSTALL UNDER MACOS](#iv---install-under-macos)
  - [1 - Prerequisites](#1---prerequisites)
  - [2 - MacPorts package](#2---macports-package)
  - [3 - Installation from sources](#3---installation-from-sources)
  - [4 - Troubleshooting](#4---troubleshooting)
- [V - INSTALL UNDER LINUX](#v---install-under-linux)
  - [1 - Dependencies](#1---dependencies)
  - [2 - Compile and install (binaries)](#2---compile-and-install-binaries)
  - [3 - Post-installation (binaries)](#3---post-installation-binaries)
  - [4 - Compile/install documentation](#4---compile-andor-install-documentation)
  - [5 - Troubleshooting](#5---troubleshooting)
- [VI - INSTALL UNDER MS WINDOWS](#vi---install-under-ms-windows)
- [VII - UNINSTALL](#vii---uninstall)
  - [1 - Under Linux](#1---under-linux)
  - [2 - Under MacPorts](#2---under-macports)

---

## I - RELEASE NOTES

Release notes are available in NEWS.md

## II - DOWNLOAD

### 1 - Sources from GILDAS homepage

Linux/OSX versions of GILDAS are distributed only as sources because
binaries are not portable (due to the many different possible
combinations of processors, operating system and compilers). Fetch
the sources from the [download area](https://www.iram.fr/~gildas/dist/).
You have to pick a tarball named `gildas-src-mmmyyv.tar.xz`. Some
hints:

- **VERSION**: the basic rule to pick up a release is to download and
  install the latest monthly release available in this area. Daily
  releases are there just as a convenience for beta testers. We
  strongly discourage standard users to get them.
- **LABELLING**: the suffix `a`, `b`, `c` and so on indicates that an
  important bug fix or feature has been added during the month and
  this could not wait for the new release at the beginning of next
  month. Such new releases include only these modifications, and not
  all the on-going developments. Check the NEWS section for details on
  the augmented release.
- **STABILITY**: Developers usually stabilize (if needed) Gildas before
  each release. Nevertheless, some developments take time and in such a
  case monthly releases may be skipped. From time to time some releases
  are suffixed `beta`: this indicates that important developments were
  done and this version is a candidate for a stable release. It is
  "stable as far as we know", but not tested enough.
- **REFERENCE VERSION**: Finally, the may25 release (May 2025) is a
  particular version used at the telescopes. If a newer version is
  available, standard users should not install the may25 one, unless
  they have been told to. There are bug fixes, improvements, and
  features which have been added in the latest releases, but which
  won't be in the may25 release because they do not affect the
  operations at the telescopes.

### 2 - Sources from GIT repository

Get the last monthly version from the
[public GIT repository](https://git.iram.fr/gildas/gildas):

```
git clone \
  -b ryy-mmm https://git.iram.fr/gildas/gildas.git gildas-src-mmmyy
```

This command creates the sources of GILDAS in a new
`gildas-src-mmmyy` directory. The `-b ryy-mmm` switch enables you to
choose the monthly release you need. Be careful, you here need only the
3 first letters of the current month and the last two digits of the
current year. No letter is required: you will automatically end up with
the last bug fix of this monthly release.

In practice, if you want to fetch the December 2022 sources, just
type:

```
git clone \
  -b r22-dec https://git.iram.fr/gildas/gildas.git gildas-src-dec22
```

It is also possible to update this clone at any moment:

```
cd gildas-src-dec22
git pull  # Fetch the last commits in the current branch
```

If new monthly versions have been released, you should be able to check
them out after `git pull`, e.g.

```
git checkout r23-jan  # Fetch January 2023 release
```

Do not forget to completely clean and rebuild GILDAS after an update
(`make distclean && make`).

### 3 - Documentation from GILDAS homepage

Compiled documentation are also distributed as tarballs in the
[download area](https://www.iram.fr/~gildas/dist/). You have to
pick a tarball named `gildas-doc-mmmyy.tar.xz`.

## III - REQUIREMENTS

### 1 - Supported systems

GILDAS compiles successfully and is (at least minimally) tested on:

| Processor             | Operating system | Environment |
| --------------------- | ---------------- | ----------- |
| x86_64                | Linux            | Native      |
| x86_64 (Intel)        | macOS            | Native      |
| x86_64 (Intel)        | macOS            | MacPorts    |
| arm64 (Apple Silicon) | macOS            | Native      |
| arm64 (Apple Silicon) | macOS            | MacPorts    |

The reference system at IRAM is Debian 12 (x86_64) with Intel Fortran
2021 and gfortran 12.2.0.

### 2 - Material

- Building the GILDAS binaries under Linux or Mac OSX requires about
  300 MB of temporary disk space (compilation) and 100 MB of permanent
  disk space (installation).
- The gfortran compiler might require up to 5-6 GB of RAM when compiling
  GILDAS sources. At run time, GILDAS executables require about 1 MB at
  startup, but then consume as much memory as data created or loaded in
  memory.

### 3 - Needed tools to build executables from sources

Successful building of GILDAS binaries on a UNIX/Linux/OSX system
minimally requires:

- Bourne compatible shell (sh, ksh, bash, etc...) for build purpose
  only. The end-users can then use the GILDAS programs from csh-like or
  Bourne-like shells.
- NROFF for on-line help building.
- Perl for automatic interface extraction during compilation process.
- A C compiler (either GCC or the native C compiler).
- GNU make:
  The current building system is using the GNU make facility which has
  some desirable but non-portable features (i.e. including makefiles,
  conditions). This does not seem a strong limitation as it is easy to
  install GNU make for your system. In fact, GNU make is the default
  for linux boxes. For others OS, just try to type `gmake` instead of
  `make`: it is probably already installed.
- A FORTRAN 90/95/2003/2008/2013 compiler:
  Latest GNU Fortran (gfortran >= 9.0) and Intel Fortran Compiler
  (ifort > 11.1) are supported.
- GTK >= 3.24 development tools for graphic and widget support. GTK2
  support is obsolescent.
- Python >= 3.6 and its array module Numpy if you plan to use the
  Gildas-Python binding, including the Weeds package in CLASS.
- CFITSIO if you plan to use MRTCAL or CUBE.

### 4 - Needed tools to build the documentation

Successful building of PDF/HTML documentation minimally requires recent
versions of:

- ps2epsi
- epstopdf
- latex (version 2e with makeidx, graphicx and html package)
- latex2html
- pdflatex

For your convenience, we distribute compiled PDF/HTML documentation in
case you do not have those tools. See the distribution section of the
GILDAS web page:

`https://www.iram.fr/~gildas/dist/`

## IV - INSTALL UNDER MACOS

Gildas and its dependencies can be installed as a
[MacPorts](https://ports.macports.org/port/gildas/) package.

### 1 - Prerequisites

Both installation methods 2 and 3 below require the installation of:

- Xcode, needed by MacPorts. Get it from
  https://developer.apple.com/xcode/ with an Apple identifier (more
  than 1 GB to be downloaded from the app store). See e.g. the Xcode
  installation guidelines suited for MacPorts at
  www.macports.org/install.php
- Xquartz, needed for Gildas plots (www.xquartz.org). XQuartz is
  successfully installed if the command `xclock` is available and opens
  a clock in a small graphical window. If not, start Xquartz from
  Applications > Utilities > XQuartz.
- [MacPorts](https://www.macports.org), a package manager, is needed to
  retrieve and install transparently Gildas and its dependencies.
  Follow MacPorts
  [installation guidelines](https://www.macports.org/install.php).
  MacPorts is successfully installed when e.g. the command `port help`
  is available.

### 2 - MacPorts package

Gildas is available as a standard package in the MacPorts distribution.
Unless you are an advanced user (see below: Installation from sources),
this is the recommended way to install Gildas under Mac OS. Once
MacPorts and XQuartz are installed, Gildas installation is
straightforward. Type:

```
sudo port install gildas
```

The parallelization is enabled by default. The Gildas programs are
ready to use right after (type e.g. `greg` in a terminal prompt).
Usually the package is updated a few days after a source release (every
month), so that the latest enhancements or bug fixes in Gildas are
quickly available to Mac users. Updating to the newest release is done
with the command:

```
sudo port upgrade gildas
```

You might need to update MacPorts itself first:

```
sudo port selfupdate
```

### 3 - Installation from sources

As an alternate solution, it is possible to compile Gildas by yourself.
You have to use MacPorts to install first the Gildas dependencies.

- Installing the dependencies:

```
sudo port install gcc14
sudo port select gcc # show available arguments
sudo port select gcc mp-gcc14  # Choose the desired one
sudo port install gtk3
sudo port install pkgconfig
sudo port install groff
```

- CFITSIO is needed for CUBE (position-position-velocity cube analysis)
  and MRTCAL (the 30m calibration software). Have a look at:

```
sudo port variants cfitsio
```

Then install the correct "variant" e.g.

```
sudo port install cfitsio +gcc14
```

- Finally you can follow the standard Linux steps to compile Gildas
  from the sources (see below).

### 4 - Troubleshooting

- If you have problem with rsync when running `sudo port selfupdate`,
  you can modify the file
  `/opt/local/etc/macports/sources.conf` by replacing the line:

```
rsync://rsync.macports.org/release/ports/ [default]
```

with:

```
#rsync://rsync.macports.org/release/ports/ [default]
https://www.macports.org/files/ports.tar.gz [default]
```

and run `sudo port sync` instead of `sudo port selfupdate`.

```
sudo port install gcc14
sudo port install gtk3
sudo port select gcc # show available arguments
sudo port select gcc mp-gcc14
```

- Mac OSX 10.7 (Lion) users: if possible, try to avoid to install
  Python from MacPorts. If installed, you might experience this bug
  when the Gildas-Python binding is started at runtime. If so, you
  should configure your system to prefer the Apple-Python rather than
  the MacPorts-Python:

```
port select python python27-apple
```

However, note that this may break other Python-related applications
installed with MacPorts.

- If the Gildas installation fails and the log file shows the
  following error:

```
:info:build FATAL:/opt/local/bin/../libexec/as/x86_64/as:
I don't understand 'm' flag!
```

This problem is described here:
https://trac.macports.org/ticket/56919
In short, the assembler program (`as`) which is used is not the correct
one. Type:

```
sudo port install cctools +xcode
```

to switch to the correct version. Then you can resume the Gildas
installation.

- If the Gildas installation fails and the log file shows the
  following error:

```
:info:build ld: unexpected token: !tapi-tbd-v3 file
'/System/Library/Frameworks//CoreFoundation.framework/CoreFoundation.tbd'
for architecture x86_64
```

This problem is described here:
http://mac-os-forge.2317878.n4.nabble.com/linker-errors-ld-unexpected-token-tapi-tbd-v3-file-td363061.html#a363073
In short, you should type:

```
sudo port install ld64 +ld64_xcode
```

Then you should retry Gildas installation. You should clean the
previous attempt first:

```
sudo port clean gildas
```

Then proceed:

```
sudo port install gildas + any option if needed
```

- If the program won't open any graphical window and shows this
  warning instead:

```
Gtk-WARNING **: xx:xx:xx.xxx: cannot open display
```

check that XQuartz server is installed and running (see Prerequisites
section above).

- If you observe this message when opening a Gildas program, please
  see the same TROUBLESHOOTING section for Linux:

```
Gtk-WARNING **: Locale not supported by C library.
                Using the fallback 'C' locale.
```

- GREG hardcopies to PDF are ensured through system utilities ps2pdf
  and epstopdf. They can be installed thanks to the following ports:

```
sudo port install texlive-basic      # provides ps2pdf
sudo port install texlive-fontutils  # provides epstopdf
```

## V - INSTALL UNDER LINUX

### 1 - Dependencies

Linux version of GILDAS are distributed only as sources because binaries
are not portable (due to the many different possible combinations of
processors, operating system and compilers). We thus tried to ease
building as much as possible.

In addition to the standard developer tools (make, gcc, nroff, etc),
the following dependencies must be installed. Root privileges are
required here.

- Fedora 42 (or redhat-like distributions):
  - Required: `dnf install gcc-gfortran gcc-c++ gtk3-devel`
  - Recommended:
    `dnf install python-devel python-setuptools numpy \
                 libpng-devel cfitsio-devel openssl-devel \
                 texlive-epstopdf`
  - Optional: `dnf install fftw-devel`
  - Install: follow installation steps at paragraph 2

- Ubuntu 24.04 (or debian-like distributions):
  - Required: `sudo apt install gfortran g++ libgtk3.0-dev`
  - Recommended:
    `sudo apt install python3-dev python3-numpy python3-setuptools \
                     libcfitsio-dev libssl-dev texlive-font-utils`
    If you choose to install the package `python-is-python3` for your
    convenience, you have to install `python-dev-is-python3` for
    consistency.
  - Optional: `sudo apt install libfftw3-dev`
  - Install: follow installation steps at paragraph 2

### 2 - Compile and install (binaries)

Building the binaries should just need the following sequence of
commands. Gildas itself does not need root privileges for installation
and execution: it can be unzipped anywhere and installed by any user
for its own needs.

```
unxz gildas-src-mmmyya.tar.xz
tar -xf gildas-src-mmmyya.tar
```

or even simpler, let tar uncompress the archive by itself (automatic
detection from the file extension):

```
tar -xf gildas-src-mmmyya.tar.xz
cd gildas-src-mmmyya
```

At this stage, if you are not under a sh-compatible shell, you have to
switch to e.g. bash. Then load the compilation environment:

```
source admin/gildas-env.sh
```

You can optionally add the compiler to be used with the option `-c`
(e.g. `source admin/gildas-env.sh -c gfortran`). Read carefully the
messages and warnings returned by the command. If everything seem
correct, then compile and install Gildas:

```
make
make install
```

Finally, follow the instructions at the end of the `make install`
process. Installation is successful if you can start the programs
`greg` or `class` from a new terminal.

### 3 - Post-installation (binaries)

After the installation is successful, you can optionally remove the
sources and compilation directory (`gildas-src-mmmyy`). This is useful
only to save disk space. On the other hand, this means that in case of
update (e.g. for GIT-based downloads) you will have to recompile
everything again from scratch.

### 4 - Compile and/or install (documentation)

- From the tarball archive (easiest):

```
mv gildas-doc-mmmyya.tar.xz gildas-exe-mmmyya/
cd gildas-exe-mmmyya/
tar -xf gildas-doc-mmmyya.tar.xz
```

- Directly from the sources:
  Compilation of documentation is not done by default when compiling
  executables because: i) it requires special tools (see requirements)
  and ii) it takes time.
  To compile and install the PDF documentation, type:

```
make doc
make install-doc
```

To compile and install the HTML documentation, please type:

```
make html
make install-html
```

### 5 - Troubleshooting

- This message can be displayed when starting a Gildas program:

```
Gtk-WARNING **: Locale not supported by C library.
                Using the fallback 'C' locale
```

This is not a GILDAS issue. This means that your locale settings (type
`locale` in a terminal) indicate one or more locales that are not
installed on your system (type `locale -a` in a terminal for the full
list). You should fix your environment variables in order to use an
installed locale (e.g. `export LANG=en_US.utf8`, beware this may change
your programs behavior regarding language), or install the missing
locale(s).

- Conflict with Anaconda: when installed from the downloadable
  installer, Anaconda comes with a lot of development tools and
  libraries which override the default system ones, but not in a
  consistent way. This is proved to break software compilation and/or
  execution (Gildas and others). For example:

```
astro: /home/user/anaconda/lib/libstdc++.so.6: version
       `GLIBCXX_3.4.21' not found (required by /home/user/
       gildas-exe-jan17a/x86_64-ubuntu16.04-gfortran/lib/libatm.so)
```

This happens because Anaconda gives precedence to its own binaries and
include files (duplicate but different versions of system ones) in the
user's environment. There are several ways out of this issue:
  - a) Install Anaconda from your OS repositories (instead of custom
       installation in the user account). This way, there should be a
       correct integration of Anaconda within the OS.
  - b) Keep Anaconda in the user account, but "hide" it during Gildas
       installation and execution. In other words, you have to ensure
       that there is no reference to Anaconda installation paths in the
       environment variables `$PATH` and `$LD_LIBRARY_PATH`. You most
       likely have to edit your `~/.bashrc`. Once this is done recompile,
       install, and try executing Gildas. If it runs fine, a permanent
       solution could be to use a shell function which loads Anaconda
       environment only when needed, e.g.

```
function anaconda() {
    export PATH=...
    export LD_LIBRARY_PATH=...
    anaconda
}
```

  - c) The next time you install Anaconda, you should answer "No" to the
       question: "Do you wish the installer to prepend the
       Anaconda<2 or 3>install location to PATH...?". Then use a function
       like the above example to get it working
       ([reference](https://www.anaconda.com/docs/getting-started/working-with-conda/reference/faq#should-i-add-anaconda-to-the-macos-or-linux-path)).

## VI - INSTALL UNDER MS WINDOWS

MS Windows binaries are not available. If you need to run GILDAS under
a MS Windows computer, you can install a Linux virtual machine and
follow the installation instructions as explained in the previous
section.

## VII - UNINSTALL

### 1 - Under Linux

- Except if you want to save disk space, you have no need to uninstall
  any previous Gildas installation. Each version goes into its own
  `gildas-src-XXX` and `gildas-exe-XXX` directories. The default
  version used is ruled by the environment variable `$GAG_ROOT_DIR`
  that is set in user's `~/.bash_profile`. You can modify it as you
  want to point to the desired version.
- Remember to start a new terminal each time you modify your
  `~/.bash_profile`.
- For a complete uninstall of Gildas, just remove the directories
  `gildas-src-XXX` and `gildas-exe-XXX`, and suppress the lines related
  to Gildas in your `~/.bash_profile`.

### 2 - Under MacPorts

- MacPorts keeps older Gildas versions when you install a new one. At
  some point you might want to clean all the useless versions. You can
  check for all installed version with:

```
sudo port installed gildas
```

You will see a list of versions with a `@` name, e.g.

```
gildas @201808b_0+gcc7
gildas @201808b_0+gcc7+openmp
gildas @201809a_0+gcc7+openmp (active)
```

Uninstalling a single version can be done with e.g.

```
sudo port uninstall gildas @201808b_0+gcc7
```

Uninstalling several versions can be done with:

```
sudo port uninstall gildas
```

Answer at the prompt which versions are to be uninstalled.

- If you wish to completely uninstall MacPorts and Gildas, check
  [the MacPorts recommendations](https://guide.macports.org/chunked/installing.macports.uninstalling.html).
