subroutine clic_blank(line,error)
  use gkernel_interfaces
  !-------------------------------------------------------------------------
  ! CLIC\BLANK c1 c2  /SPW /RESET /ANTENNA
  !-------------------------------------------------------------------------
  character(len=*) :: line
  logical          :: error
  !-------------------------------------------------------------------------
  ! Global:
  include 'clic_parameter.inc'
  include 'clic_display.inc'
  !-------------------------------------------------------------------------
  ! Local:
  integer          :: c1, c2, ispw, lc
  integer          :: nant, iant(mnant), i, j, k
  logical          :: all_ant
  character*128    :: chain
  !-------------------------------------------------------------------------
  ! Code:
  error = .false.
  if (sic_present(3,0)) then
    imask = 1
  endif
  if (sic_present(4,0)) then
    imask = 0
  endif
  if (.not.sic_present(1,0)) then
    if (.not.sic_present(3,0).and..not.sic_present(4,0)) then
      call message(6,3,'CLIC_BLANK','/SPW is mandatory')
      error = .true.
    endif
    return
  endif
  call sic_i4(line,1,1,ispw,.true.,error)
  if (error) then
    call message(6,3,'CLIC_BLANK','Error reading spw')
    return
  endif
  call get_antennas(line,5,nant,iant,.false.,error)
  if (error) return
  all_ant = nant.eq.mnant
  ! 
  ! Reset
  if (sic_present(2,0)) then
    if (all_ant) then
      write (chain,'(a,i0)') 'Resetting spw ',ispw
    else
      write (chain,'(a,i0,a)') 'Resetting spw ',ispw,   &
        ' for selected antennas'
    endif
    lc = len_trim(chain)
    call message(6,1,'CLIC_BLANK',chain(1:lc))
    if (all_ant) then
      do i=1, mnant
        nmask(ispw,i) = 0
      enddo
    else
      do j=1, nant
        nmask(ispw,iant(j)) = 0
      enddo
    endif
    return
  endif  
  !
  call sic_i4(line,0,1,c1,.true.,error)
  if (error) then
    call message(6,3,'CLIC_BLANK','Error reading first argument')
    return
  endif
  call sic_i4(line,0,2,c2,.true.,error)
  if (error) then
    call message(6,3,'CLIC_BLANK','Error reading first argument')
    return
  endif
  if (all_ant) then
    do i=1, mnant
      if (nmask(ispw,i).ge.mmask) goto 90
    enddo
  else
    do j=1, nant
      if (nmask(ispw,iant(j)).ge.mmask) goto 90
    enddo
  endif
  do j=1, nant
    nmask(ispw,iant(j)) = nmask(ispw,iant(j)) + 1
    k = nmask(ispw,iant(j))
    cmask(1,k,ispw,iant(j)) = c1
    cmask(2,k,ispw,iant(j)) = c2
  enddo
  if (all_ant) then
    write (chain,'(a,i0,a,i0,a,i0)') 'Masking spw ',ispw,   &
      ', channels ',c1,' to ',c2
  else
    write (chain,'(a,i0,a,i0,a,i0,a)') 'Masking spw ',ispw,   &
      ', channels ',c1,' to ',c2,' for selected antennas'
  endif
  lc = len_trim(chain)
  call message(6,1,'CLIC_BLANK',chain(1:lc))
  return
90 call message(6,3,'CLIC_BLANK','Maximum number of ranges reached')
  error = .true.
  return
end subroutine clic_blank
