/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.DriverDescriptorEntry;
import org.catacombae.io.ReadableRandomAccessStream;

public class DriverDescriptorRecord {
    public static final short DDR_SIGNATURE = 17746;
    private final byte[] sbSig = new byte[2];
    private final byte[] sbBlkSize = new byte[2];
    private final byte[] sbBlkCount = new byte[4];
    private final byte[] reserved1 = new byte[2];
    private final byte[] reserved2 = new byte[2];
    private final byte[] reserved3 = new byte[4];
    private final byte[] sbDrvrCount = new byte[2];
    private final DriverDescriptorEntry[] entries;
    private final byte[] ddPad;

    public DriverDescriptorRecord(ReadableRandomAccessStream llf, long offset) {
        this(DriverDescriptorRecord.readData(llf, offset), 0);
    }

    public DriverDescriptorRecord(byte[] data, int offset) {
        int i;
        System.arraycopy(data, offset + 0, this.sbSig, 0, 2);
        System.arraycopy(data, offset + 2, this.sbBlkSize, 0, 2);
        System.arraycopy(data, offset + 4, this.sbBlkCount, 0, 4);
        System.arraycopy(data, offset + 8, this.reserved1, 0, 2);
        System.arraycopy(data, offset + 10, this.reserved2, 0, 2);
        System.arraycopy(data, offset + 12, this.reserved3, 0, 4);
        System.arraycopy(data, offset + 16, this.sbDrvrCount, 0, 2);
        int numEntries = Util.unsign(this.getSbDrvrCount());
        if (numEntries > 31) {
            numEntries = 31;
        }
        this.entries = new DriverDescriptorEntry[numEntries];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new DriverDescriptorEntry(data, offset + 18 + DriverDescriptorEntry.length() * i);
        }
        int padOffset = offset + 18 + DriverDescriptorEntry.length() * i;
        this.ddPad = new byte[DriverDescriptorRecord.length() - padOffset];
        System.arraycopy(data, padOffset, this.ddPad, 0, this.ddPad.length);
    }

    private static byte[] readData(ReadableRandomAccessStream llf, long offset) {
        byte[] data = new byte[DriverDescriptorRecord.length()];
        llf.seek(offset);
        if (llf.read(data) != data.length) {
            throw new RuntimeException("Could not read enough bytes from LowLevelFile!");
        }
        return data;
    }

    public static int length() {
        return 269;
    }

    public short getSbSig() {
        return Util.readShortBE(this.sbSig);
    }

    public short getSbBlkSize() {
        return Util.readShortBE(this.sbBlkSize);
    }

    public int getSbBlkCount() {
        return Util.readIntBE(this.sbBlkCount);
    }

    public short getReserved1() {
        return Util.readShortBE(this.reserved1);
    }

    public short getReserved2() {
        return Util.readShortBE(this.reserved2);
    }

    public int getReserved3() {
        return Util.readIntBE(this.reserved3);
    }

    public short getSbDrvrCount() {
        return Util.readShortBE(this.sbDrvrCount);
    }

    public DriverDescriptorEntry[] getDriverDecriptorEntries() {
        DriverDescriptorEntry[] result = new DriverDescriptorEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public byte[] getDdPad() {
        return Util.createCopy(this.ddPad);
    }

    public String getSbSigAsString() {
        return Util.toASCIIString(this.sbSig);
    }

    public boolean isValid() {
        int driverCount = Util.unsign(this.getSbDrvrCount());
        return this.getSbSig() == 17746 && driverCount <= 31 && this.entries.length == driverCount;
    }

    public byte[] getData() {
        byte[] result = new byte[DriverDescriptorRecord.length()];
        int offset = 0;
        System.arraycopy(this.sbSig, 0, result, offset, this.sbSig.length);
        System.arraycopy(this.sbBlkSize, 0, result, offset += this.sbSig.length, this.sbBlkSize.length);
        System.arraycopy(this.sbBlkCount, 0, result, offset += this.sbBlkSize.length, this.sbBlkCount.length);
        System.arraycopy(this.reserved1, 0, result, offset += this.sbBlkCount.length, this.reserved1.length);
        System.arraycopy(this.reserved2, 0, result, offset += this.reserved1.length, this.reserved2.length);
        System.arraycopy(this.reserved3, 0, result, offset += this.reserved2.length, this.reserved3.length);
        System.arraycopy(this.sbDrvrCount, 0, result, offset += this.reserved3.length, this.sbDrvrCount.length);
        offset += this.sbDrvrCount.length;
        for (DriverDescriptorEntry dde : this.entries) {
            byte[] tmp = dde.getData();
            System.arraycopy(tmp, 0, result, offset, tmp.length);
            offset += tmp.length;
        }
        System.arraycopy(this.ddPad, 0, result, offset, this.ddPad.length);
        if ((offset += this.ddPad.length) != DriverDescriptorRecord.length()) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " sbSig: \"" + this.getSbSigAsString() + "\"");
        ps.println(prefix + " sbBlkSize: " + this.getSbBlkSize());
        ps.println(prefix + " sbBlkCount: " + this.getSbBlkCount());
        ps.println(prefix + " reserved1: " + this.getReserved1());
        ps.println(prefix + " reserved2: " + this.getReserved2());
        ps.println(prefix + " reserved3: " + this.getReserved3());
        ps.println(prefix + " sbDrvrCount: " + this.getSbDrvrCount());
        ps.println(prefix + " entries (" + this.entries.length + " elements):");
        for (int i = 0; i < this.entries.length; ++i) {
            ps.println(prefix + "  entries[" + i + "]: ");
            this.entries[i].print(ps, prefix + "   ");
        }
        if (this.entries.length == 0) {
            ps.println(prefix + "  <empty>");
        }
        ps.println(prefix + " ddPad: {" + this.ddPad.length + " bytes...}");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "DriverDescriptorRecord:");
        this.printFields(ps, prefix);
    }
}

