/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

SELECT	PARENT.TABLE_CATALOG AS "PKTABLE_CAT", PARENT.TABLE_SCHEMA AS "PKTABLE_SCHEM", PARENT.TABLE_NAME AS "PKTABLE_NAME",
          PARENT.COLUMN_NAME AS "PKCOLUMN_NAME", CHILD.TABLE_CATALOG AS "FKTABLE_CAT", CHILD.TABLE_SCHEMA AS "FKTABLE_SCHEM",
          CHILD.TABLE_NAME AS "FKTABLE_NAME", CHILD.COLUMN_NAME AS "FKCOLUMN_NAME",
          CHILD.ORDINAL_POSITION AS "KEY_SEQ",
          1 AS "UPDATE_RULE", -- 1 = importedKeyRestrict
          1 AS "DELETE_RULE", -- 1 = importedKeyRestrict
          CONSTRAINTS.CONSTRAINT_NAME AS "FK_NAME", CONSTRAINTS.UNIQUE_CONSTRAINT_NAME AS "PK_NAME",
          7 AS "DEFERRABILITY" -- 7 = importedKeyNotDeferrable
FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS CONSTRAINTS
         INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE CHILD  ON
                 COALESCE(CONSTRAINTS.CONSTRAINT_CATALOG, '')=COALESCE(CHILD.CONSTRAINT_CATALOG, '')
             AND CONSTRAINTS.CONSTRAINT_SCHEMA= CHILD.CONSTRAINT_SCHEMA
             AND CONSTRAINTS.CONSTRAINT_NAME= CHILD.CONSTRAINT_NAME
         INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE PARENT ON
                 COALESCE(CONSTRAINTS.UNIQUE_CONSTRAINT_CATALOG, '')=COALESCE(PARENT.CONSTRAINT_CATALOG, '')
             AND CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA=PARENT.CONSTRAINT_SCHEMA
             AND CONSTRAINTS.UNIQUE_CONSTRAINT_NAME=PARENT.CONSTRAINT_NAME
             AND PARENT.ORDINAL_POSITION=CHILD.POSITION_IN_UNIQUE_CONSTRAINT
WHERE UPPER(COALESCE(PARENT.TABLE_CATALOG, '')) LIKE ?
  AND UPPER(PARENT.TABLE_SCHEMA) LIKE ?
  AND UPPER(PARENT.TABLE_NAME) LIKE ?
ORDER BY CHILD.TABLE_CATALOG, CHILD.TABLE_SCHEMA, CHILD.TABLE_NAME, CHILD.ORDINAL_POSITION
